/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.ethprotocolconfig_r6c02.mstp;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TECreatePGBean
extends TECommonWriteLogBean {
    private Definitions definitions = null;
    private static final int INVALID_VALUE = 255;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.operationList = new ArrayList();
        this.outputData = new Datainterface();
        BussinessParams businessparams = inputData.getBussinessParams();
        try {
            this.definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
        }
        this.getCreatePGOper(businessparams);
        if (null == this.operationList || this.operationList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        int result = this.sendMessage(neid);
        if (result == 0) {
            this.handleMessage(neid, this.operationList, subFunc);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private void getCreatePGOper(BussinessParams bussinessparams) {
        RowParams rowparams = null;
        Operation oper = this.definitions.getOperation("NSCMD_PTN_ADD_MSTPPORTGROUP");
        Input input = oper.getInput();
        input.setPartValue("idFlag", "0");
        input.setPartValue("portGroupID", "0");
        rowparams = bussinessparams.getRowParams(0);
        input.setPartValue("portNumber", rowparams.getParam("portNumber").getValue());
        rowparams = bussinessparams.getRowParams(1);
        input.setPartValue("slotid", rowparams.getParam("slotid").getValue());
        input.setPartValue("subslotid", rowparams.getParam("subslotid").getValue());
        input.setPartValue("port", rowparams.getParam("port").getValue());
        int len = bussinessparams.getRowParamsCount();
        for (int i = 2; i < len; ++i) {
            rowparams = bussinessparams.getRowParams(i);
            Part part = new Part();
            part.setLength(2);
            part.setName("slotid");
            part.setType("int");
            part.setValue(rowparams.getParam("slotid").getValue());
            input.addPart(part);
            part = new Part();
            part.setLength(1);
            part.setName("subslotid");
            part.setType("byte");
            part.setValue(rowparams.getParam("subslotid").getValue());
            input.addPart(part);
            part = new Part();
            part.setLength(2);
            part.setName("port");
            part.setType("int");
            part.setValue(rowparams.getParam("port").getValue());
            input.addPart(part);
        }
        this.operationList.add(oper);
    }

    public String getDetailInfo(RowParams[] rParamsArr) {
        String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
        String MSTP_RES = "ptn" + File.separator + "res" + File.separator + "ethprotocolconfig" + File.separator + "MSTP_" + LANGUAGE + ".ini";
        TEResourceUtil resourceUtil = TEGetFilePath.getResource((int)this.neid, (String)MSTP_RES);
        StringBuffer operDesc = new StringBuffer();
        operDesc.append(resourceUtil.getString("port")).append(":");
        RowParams rowparams = null;
        TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
        int size = rParamsArr.length;
        for (int i = 1; i < size; ++i) {
            rowparams = rParamsArr[i];
            int slotid = Integer.parseInt(rowparams.getParam("slotid").getValue());
            int boardType = configurDataMgr.getBoardType(this.neid, slotid);
            String boardName = configurDataMgr.getBoardTypeName(this.neid, boardType);
            int subslotid = Integer.parseInt(rowparams.getParam("subslotid").getValue());
            if (255 != subslotid) {
                int subboardType = configurDataMgr.getSubboardType(this.neid, slotid, subslotid);
                String subboardName = configurDataMgr.getBoardTypeName(this.neid, subboardType);
                String port = rowparams.getParam("port").getValue();
                String portName = configurDataMgr.getPortName(this.neid, slotid, boardType, Integer.parseInt(port));
                operDesc.append(slotid).append("-").append(boardName).append("-").append(subslotid).append("-").append(subboardName).append("-").append(portName).append(" ");
                continue;
            }
            String port = rowparams.getParam("port").getValue();
            String portName = configurDataMgr.getPortName(this.neid, slotid, boardType, Integer.parseInt(port));
            operDesc.append(slotid).append("-").append(boardName).append("-").append(portName).append(" ");
        }
        return operDesc.toString();
    }

    public List<TELogInfo> getLogInfoList(Datainterface inputData) {
        return this.getSingletonLogInfo(inputData);
    }
}

