/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.ethprotocolconfig.mstp_u2kv1r2c00;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;

public class TEQueryBridgePortBean
extends TENEExplorerBean {
    private Definitions definitions = null;
    private ArrayList rowErrorList = new ArrayList();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.operationList = new ArrayList();
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        String portGroupID = inputData.getBussinessParams().getRowParams(0).getParam("portGroupID").getValue();
        try {
            this.definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
            int result = this.getQueryBridgePortOper(portGroupID);
            if (result != 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                int size = this.rowErrorList.size();
                for (int i = 0; i < size; ++i) {
                    RowParams rParam = new RowParams();
                    RowErrors rError = (RowErrors)this.rowErrorList.get(i);
                    rParam.addRowErrors(rError);
                    this.outputData.getBussinessParams().addRowParams(rParam);
                }
                if (this.isNeedOperationlog()) {
                    this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
                }
                return this.outputData;
            }
            if (null == this.operationList || this.operationList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            result = this.sendMessage(neid);
            if (result == 0) {
                this.handleMessage(neid, this.operationList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
        }
        return this.outputData;
    }

    private int getQueryBridgePortOper(String portGroupID) {
        Part part = null;
        Operation oper = this.definitions.getOperation("NSCMD_PTN_GET_MSTPPORTGROUP");
        Input input = oper.getInput();
        input.setPartValue("portGroupID", portGroupID);
        this.operationList.add(oper);
        int result = this.sendMessage(this.neid);
        if (0 != result) {
            return result;
        }
        Operation tmpOper = (Operation)this.operationList.get(0);
        this.operationList.clear();
        for (Output output : tmpOper.getOutput()) {
            for (Fault fault : output.getFault()) {
                int code = Integer.parseInt(fault.getCode());
                if (code == 0) continue;
                TELogFactory.getNormalLogger().info(TEErrorResourceUtil.getErrCodeResWithDot((int)this.neid, (int)code));
                RowErrors rowError = new RowErrors();
                Param errorParam = new Param("errorBbj", this.neid + "Query Port Group");
                rowError.addParam(errorParam);
                rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)code));
                this.rowErrorList.add(rowError);
                return 2;
            }
            part = Definitions.getParam((Part[])output.getPart(), (String)"portInfo");
            byte[] bValue = part.getValue().getBytes();
            int stepLength = 8;
            int startIndex = 0;
            while (startIndex + stepLength <= bValue.length) {
                oper = this.definitions.getOperation("NSCMD_PTN_GET_MSTPADMINEDGEPORT");
                input = oper.getInput();
                input.setPartValue("portGroupID", portGroupID);
                byte[] bTmp = new byte[4];
                System.arraycopy(bValue, startIndex + 0, bTmp, 0, 4);
                int slotid = IOStreamConvertor.readPositiveInt((byte[])bTmp, (int)0);
                input.setPartValue("slotid", slotid + "");
                bTmp = new byte[2];
                System.arraycopy(bValue, startIndex + 4, bTmp, 0, 2);
                int subslotid = IOStreamConvertor.readPositiveShort((byte[])bTmp, (int)0);
                input.setPartValue("subslotid", subslotid + "");
                bTmp = new byte[4];
                System.arraycopy(bValue, startIndex + 6, bTmp, 0, 4);
                int port = IOStreamConvertor.readPositiveInt((byte[])bTmp, (int)0);
                input.setPartValue("port", port + "");
                this.operationList.add(oper);
                oper = this.definitions.getOperation("NSCMD_PTN_GET_MSTPOPERDGEPORT");
                input = oper.getInput();
                input.setPartValue("portGroupID", portGroupID);
                input.setPartValue("slotid", slotid + "");
                input.setPartValue("subslotid", subslotid + "");
                input.setPartValue("port", port + "");
                this.operationList.add(oper);
                oper = this.definitions.getOperation("NSCMD_PTN_GET_MSTPADMINPTOP");
                input = oper.getInput();
                input.setPartValue("portGroupID", portGroupID);
                input.setPartValue("slotid", slotid + "");
                input.setPartValue("subslotid", subslotid + "");
                input.setPartValue("port", port + "");
                this.operationList.add(oper);
                oper = this.definitions.getOperation("NSCMD_PTN_GET_MSTPOPERPTOP");
                input = oper.getInput();
                input.setPartValue("portGroupID", portGroupID);
                input.setPartValue("slotid", slotid + "");
                input.setPartValue("subslotid", subslotid + "");
                input.setPartValue("port", port + "");
                this.operationList.add(oper);
                oper = this.definitions.getOperation("NSCMD_PTN_GET_MSTPTRANSMITLIMIT");
                input = oper.getInput();
                input.setPartValue("portGroupID", portGroupID);
                input.setPartValue("slotid", slotid + "");
                input.setPartValue("subslotid", subslotid + "");
                input.setPartValue("port", port + "");
                this.operationList.add(oper);
                startIndex += stepLength;
            }
        }
        return 0;
    }
}

