/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.ethprotocolconfig.mstp;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.List;

public class TESetMappingListBean
extends TENEExplorerBean {
    private Definitions definitions = null;
    private static final int TIME_OUT = 200;
    private static final int COM_NUM_EACH_BATCH = 50;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        BussinessParams businessparams = inputData.getBussinessParams();
        if (businessparams.getRowParamsCount() < 3) {
            return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
        }
        if (null == businessparams.getRowParams(2).getParam("vlanID")) {
            return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
        }
        this.operationList = new ArrayList();
        this.outputData = new Datainterface();
        try {
            this.definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
        }
        this.getSetMappingListOper(businessparams);
        if (null == this.operationList || this.operationList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        int lenArry = this.operationList.size();
        ArrayList operationListPart = new ArrayList();
        int endIndex = 0;
        int i = 0;
        while (i * 50 < lenArry) {
            int n = endIndex = (i + 1) * 50 > lenArry ? lenArry : (i + 1) * 50;
            if (null != operationListPart) {
                operationListPart.clear();
            }
            operationListPart.addAll(this.operationList.subList(i * 50, endIndex));
            int result = this.sendMessage(neid, operationListPart);
            if (result != 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                break;
            }
            this.handleMessage(neid, operationListPart, subFunc);
            ++i;
        }
        if (null != operationListPart) {
            operationListPart.clear();
            this.operationList.clear();
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    public int sendMessage(int neid, ArrayList operationListPart) {
        int retCode = 0;
        OperationResult result = TENECommMgr.getInstance().sendCommand(neid, (List)operationListPart, 200);
        if (null != result) {
            retCode = result.retCode;
        }
        return retCode;
    }

    private void getSetMappingListOper(BussinessParams bussinessparams) {
        if (bussinessparams.getRowParamsCount() > 1) {
            Operation oper = this.definitions.getOperation("NSCMD_PTN_SET_MSTPVLANMAPMODULO");
            Input input = oper.getInput();
            RowParams rowparams = bussinessparams.getRowParams(1);
            input.setPartValue("idFlag", "0");
            input.setPartValue("portGroupID", rowparams.getParam("portGroupID").getValue());
            input.setPartValue("mappingModel", rowparams.getParam("mappingModel").getValue());
            this.operationList.add(oper.clone());
        }
        RowParams rowparams = null;
        Operation oper = this.definitions.getOperation("NSCMD_PTN_SET_MSTPMSTIMAP");
        Input input = oper.getInput();
        int len = bussinessparams.getRowParamsCount();
        for (int i = 2; i < len; ++i) {
            rowparams = bussinessparams.getRowParams(i);
            ArrayList vlanidArray = this.paresVlan(rowparams.getParam("vlanID").getValue());
            int lenArry = vlanidArray.size();
            for (int j = 0; j < lenArry; ++j) {
                input.setPartValue("idFlag", "0");
                input.setPartValue("portGroupID", rowparams.getParam("portGroupID").getValue());
                input.setPartValue("vlanID", vlanidArray.get(j).toString());
                input.setPartValue("mstiID", rowparams.getParam("mstiID").getValue());
                this.operationList.add(oper.clone());
            }
        }
    }

    private ArrayList paresVlan(String vlan) {
        ArrayList<String> resultList = new ArrayList<String>();
        if ("".equals(vlan) || "-".equals(vlan)) {
            return resultList;
        }
        String[] strArr = vlan.split(",");
        int len = strArr.length;
        for (int i = 0; i < len; ++i) {
            int b = strArr[i].indexOf("-");
            if (0 < b) {
                String[] range = strArr[i].split("-");
                int rangeStart = Integer.parseInt(range[0]);
                int rangeEnd = Integer.parseInt(range[1]);
                for (int j = rangeStart; j <= rangeEnd; ++j) {
                    resultList.add(resultList.size(), "" + j);
                }
                continue;
            }
            resultList.add(resultList.size(), strArr[i]);
        }
        return resultList;
    }
}

