/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.ethprotocolconfig.mstp;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;

public class TEQueryCistPortBean
extends TENEExplorerBean {
    private Definitions definitions = null;
    private boolean isDoubleByte = true;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        String neVersion = ne.getHostVersion();
        if (neVersion.indexOf("58.01") >= 0 || neVersion.indexOf("59.01") >= 0) {
            this.isDoubleByte = false;
        }
        this.operationList = new ArrayList();
        this.outputData = new Datainterface();
        String portGroupID = inputData.getBussinessParams().getRowParams(0).getParam("portGroupID").getValue();
        try {
            this.definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
        }
        int result = this.getQueryCistPortOper(portGroupID);
        if (result != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
            return this.outputData;
        }
        if (null == this.operationList || this.operationList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        result = this.sendMessage(neid);
        if (result == 0) {
            this.handleMessage(neid, this.operationList, subFunc);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private int getQueryCistPortOper(String portGroupID) {
        Part part = null;
        int doubleByte = 0;
        if (this.isDoubleByte) {
            doubleByte = 2;
        }
        Operation oper = this.definitions.getOperation("NSCMD_PTN_GET_MSTPPORTGROUP");
        Input input = oper.getInput();
        input.setPartValue("portGroupID", portGroupID);
        this.operationList.add(oper);
        int result = this.sendMessage(this.neid);
        if (0 != result) {
            return result;
        }
        Operation tmpOper = (Operation)this.operationList.get(0);
        this.operationList.clear();
        for (Output output : tmpOper.getOutput()) {
            Fault[] faultArr = output.getFault();
            int len2 = faultArr.length;
            for (int j = 0; j < len2; ++j) {
                byte[] bValue;
                part = Definitions.getParam((Part[])output.getPart(), (String)"portInfo");
                try {
                    bValue = part.getValue().getBytes();
                }
                catch (Exception e) {
                    return 2;
                }
                int stepLength = 8 + doubleByte;
                int startIndex = 0;
                while (startIndex + stepLength <= bValue.length) {
                    oper = this.definitions.getOperation("NSCMD_PTN_GET_MSTPCISTPORT");
                    input = oper.getInput();
                    input.setPartValue("portGroupID", portGroupID);
                    byte[] bTmp = new byte[2 + doubleByte];
                    System.arraycopy(bValue, startIndex + 0, bTmp, 0, 2 + doubleByte);
                    int slotid = 0;
                    slotid = this.isDoubleByte ? IOStreamConvertor.readPositiveInt((byte[])bTmp, (int)0) : IOStreamConvertor.readPositiveShort((byte[])bTmp, (int)0);
                    input.setPartValue("slotid", slotid + "");
                    bTmp = new byte[2];
                    System.arraycopy(bValue, startIndex + 2 + doubleByte, bTmp, 0, 2);
                    int subslotid = IOStreamConvertor.readPositiveShort((byte[])bTmp, (int)0);
                    input.setPartValue("subslotid", subslotid + "");
                    bTmp = new byte[4];
                    System.arraycopy(bValue, startIndex + 4 + doubleByte, bTmp, 0, 4);
                    int port = IOStreamConvertor.readPositiveInt((byte[])bTmp, (int)0);
                    input.setPartValue("port", port + "");
                    this.operationList.add(oper);
                    startIndex += stepLength;
                }
            }
        }
        return 0;
    }
}

