/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.ethprotocolconfig.mstp;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.io.File;
import java.util.ArrayList;

public class TEConfigPGBean
extends TENEExplorerBean {
    private Definitions definitions = null;
    private static final int INVALID_VALUE = 255;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.operationList = new ArrayList();
        this.outputData = new Datainterface();
        BussinessParams businessparams = inputData.getBussinessParams();
        try {
            this.definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
        }
        this.getCreatePGOper(businessparams);
        if (null == this.operationList || this.operationList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        int result = this.sendMessage(neid);
        if (result == 0) {
            this.handleMessage(neid, this.operationList, subFunc);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private void getCreatePGOper(BussinessParams bussinessparams) {
        String portGroupID = bussinessparams.getRowParams(0).getParam("portGroupID").getValue();
        RowParams rowparams = null;
        int len = bussinessparams.getRowParamsCount();
        for (int i = 1; i < len; ++i) {
            rowparams = bussinessparams.getRowParams(i);
            String operateFlag = rowparams.getParam("operateFlag").getValue();
            if ("addPorts".equals(operateFlag)) {
                Operation addPortOper = this.definitions.getOperation("NSCMD_PTN_ADD_MSTPPORTMEMBER");
                Input addPortOperInput = addPortOper.getInput();
                addPortOperInput.setPartValue("idFlag", "0");
                addPortOperInput.setPartValue("portGroupID", portGroupID);
                addPortOperInput.setPartValue("slotid", rowparams.getParam("slotid").getValue());
                addPortOperInput.setPartValue("subslotid", rowparams.getParam("subslotid").getValue());
                addPortOperInput.setPartValue("port", rowparams.getParam("port").getValue());
                this.operationList.add(addPortOper);
                continue;
            }
            Operation deletePortOper = this.definitions.getOperation("NSCMD_PTN_DEL_MSTPPORTMEMBER");
            Input deletePortOperInput = deletePortOper.getInput();
            deletePortOperInput.setPartValue("portGroupID", portGroupID);
            deletePortOperInput.setPartValue("slotid", rowparams.getParam("slotid").getValue());
            deletePortOperInput.setPartValue("subslotid", rowparams.getParam("subslotid").getValue());
            deletePortOperInput.setPartValue("port", rowparams.getParam("port").getValue());
            this.operationList.add(deletePortOper);
        }
    }

    public String getDetailStr(RowParams rowparams) {
        String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
        String MSTP_RES = "ptn" + File.separator + "res" + File.separator + "ethprotocolconfig" + File.separator + "MSTP_" + LANGUAGE + ".ini";
        TEResourceUtil resourceUtil = TEGetFilePath.getResource((int)this.neid, (String)MSTP_RES);
        StringBuffer operDesc = new StringBuffer();
        operDesc.append(resourceUtil.getString("port")).append(":");
        TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
        int slotid = Integer.parseInt(rowparams.getParam("slotid").getValue());
        int boardType = configurDataMgr.getBoardType(this.neid, slotid);
        String boardName = configurDataMgr.getBoardTypeName(this.neid, boardType);
        int subslotid = Integer.parseInt(rowparams.getParam("subslotid").getValue());
        if (255 != subslotid) {
            int subboardType = configurDataMgr.getSubboardType(this.neid, slotid, subslotid);
            String subboardName = configurDataMgr.getBoardTypeName(this.neid, subboardType);
            String port = rowparams.getParam("port").getValue();
            String portName = configurDataMgr.getPortName(this.neid, slotid, boardType, Integer.parseInt(port));
            operDesc.append(slotid).append("-").append(boardName).append("-").append(subslotid).append("-").append(subboardName).append("-").append(portName).append(" ");
        } else {
            String port = rowparams.getParam("port").getValue();
            String portName = configurDataMgr.getPortName(this.neid, slotid, boardType, Integer.parseInt(port));
            operDesc.append(slotid).append("-").append(boardName).append("-").append(portName).append(" ");
        }
        return operDesc.toString();
    }
}

