/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.e2etask.bfd;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_common.QAsnUniResIDList;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_model.QAsnBfdBindIpLink;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_model.QAsnBfdBindVrfIp;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_model.QAsnBfdInfo;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_model.QAsnBfdInfoEx;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_model.QAsnBfdInfoList;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_op.QAsnAddBfdRpt;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_op.QAsnBfdRefreshSessionReq;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_op.QAsnBfdRefreshSessionRsp;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_op.QAsnCreateBfdReq;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_op.QAsnCreateBfdRsp;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_op.QAsnDeleteBfdReq;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_op.QAsnDeleteBfdRpt;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_op.QAsnDeleteBfdRsp;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_op.QAsnModifyBfdReq;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_op.QAsnModifyBfdRpt;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_op.QAsnModifyBfdRsp;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.event.Event;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.f_interface.portfdn.AsnPTNCommonPort;
import com.huawei.nglct.nemgr.ptn.bfdmanagement.mooperation.TEBFDPoOperationUtil;
import com.huawei.nglct.nemgr.ptn.bfdmanagement.mooperation.TEVrfResultObject;
import com.huawei.nglct.po.embeddednemgrmo.ptn.bfd.TEPTNBfdContainerMOPO;
import com.huawei.nglct.po.embeddednemgrmo.ptn.bfd.TEPTNBfdSessionObjMOPO;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.wnemgrprocess.TEWNEMgrBussinessProcess;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class TEBfdSessionTaskHandler {
    private static TEBfdSessionTaskHandler instance = null;
    private static final Logger logger = TELogFactory.getNormalLogger();
    private final TEBFDPoOperationUtil bfdOpertUtil = TEBFDPoOperationUtil.getInstance();
    private static final int INVALID_PORTID = 0;
    private static final int DEFAULT_ID = -1;
    private static final int QUERYFLAG = 0;
    private static final int CREATEFLAG = 1;
    private static List BINDTYPELIST = null;
    private static List<Integer> MODIFYMASKLIST = null;

    private TEBfdSessionTaskHandler() {
    }

    public static synchronized TEBfdSessionTaskHandler getInstance() {
        if (null == instance) {
            instance = new TEBfdSessionTaskHandler();
        }
        return instance;
    }

    public int handleAddBfdSessionReq(QAsnCreateBfdReq req, QAsnCreateBfdRsp rsp, TaskMgr taskMgr) {
        logger.info(TEAsn1Util.getAsn1String((Object)req));
        if (null == req || req.lstBfdDetailInfo.isEmpty()) {
            return 0;
        }
        QAsnBfdInfoList asnBfdList = req.lstBfdDetailInfo;
        ArrayList<QAsnBfdInfo> bfdList4Rpt = new ArrayList<QAsnBfdInfo>();
        rsp.lstBfdDetailInfo = new QAsnBfdInfoList();
        QAsnBfdInfo bfdInfo = null;
        QAsnBfdBindIpLink bfdIpLink = null;
        QAsnBfdBindVrfIp vrfIp = null;
        AsnPTNCommonPort commPort = null;
        ArrayList<BfdOpertObj> bfdOpertObjList = new ArrayList<BfdOpertObj>();
        BussinessParams busParams = null;
        RowParams rowParams = null;
        HashSet<Integer> neIDSet = new HashSet<Integer>();
        int failBfdNum = 0;
        int userId = req.iUserID;
        BfdOpertObj bfdOpertObj = null;
        TEVrfResultObject vrfRetObj = null;
        Iterator iter = asnBfdList.iterator();
        while (iter.hasNext()) {
            bfdOpertObj = new BfdOpertObj();
            bfdInfo = (QAsnBfdInfo)iter.next();
            bfdInfo.poOperResult = this.bfdOpertUtil.getAsnRet(0, "");
            rsp.lstBfdDetailInfo.add((Object)bfdInfo);
            int neID = bfdInfo.neID;
            neIDSet.add(neID);
            rowParams = new RowParams();
            busParams = new BussinessParams();
            if (!this.verifyCreateBfdInfo(bfdInfo)) {
                ++failBfdNum;
                continue;
            }
            int sessionType = this.bfdOpertUtil.getQxSessionType(bfdInfo.iSessionType);
            int bindServiceType = bfdInfo.poBfdBindService.iBindServiceType;
            if (1 == bindServiceType) {
                bfdIpLink = bfdInfo.poBfdBindService.poBfdBindIpLink;
                rowParams.addParam("srcport", this.convert2IPString(bfdIpLink.poSourceIp));
                rowParams.addParam("endport", this.convert2IPString(bfdIpLink.poRemoteIp));
                if (1 == sessionType) {
                    rowParams.addParam("slotid", "65535");
                    rowParams.addParam("port", "65535");
                } else {
                    commPort = this.bfdOpertUtil.getPortByFdnReq(neID, bfdIpLink.poOutInfFdn);
                    if (null == commPort.portID || 0 == commPort.portID.intValue()) {
                        bfdInfo.poOperResult = this.bfdOpertUtil.getAsnRet(1107329312, this.bfdOpertUtil.getBfdResByKey(neID, "FDN2PORTFAILED"));
                        ++failBfdNum;
                        continue;
                    }
                    bfdOpertObj.setCommPort(commPort.portID.intValue());
                    rowParams.addParam("slotid", String.valueOf(commPort.slotID));
                    rowParams.addParam("port", String.valueOf(this.bfdOpertUtil.getPortID(commPort.portID.intValue())));
                }
                rowParams.addParam("vrfindex", "4294967295");
            } else if (2 == bindServiceType) {
                vrfIp = bfdInfo.poBfdBindService.poBfdBindVrfIp;
                rowParams.addParam("srcport", this.convert2IPString(vrfIp.poSourceIp));
                rowParams.addParam("endport", this.convert2IPString(vrfIp.poRemoteIp));
                long vrfId = Long.parseLong(this.bfdOpertUtil.getVrfIdFromFDN(bfdInfo.poBfdBindService.poBfdBindVrfIp.strVrfFdn));
                vrfRetObj = this.bfdOpertUtil.getVrfIndexById(userId, neID, vrfId);
                if (0 != vrfRetObj.getErrorCode()) {
                    bfdInfo.poOperResult = this.bfdOpertUtil.getAsnRet(TEErrorResourceUtil.getErrorMessage((int)vrfRetObj.getErrorCode()));
                    ++failBfdNum;
                    continue;
                }
                if (0xFFFFFFFFL == vrfRetObj.getVrfIndex()) {
                    bfdInfo.poOperResult = this.bfdOpertUtil.getAsnRet(1107329312, this.bfdOpertUtil.getBfdResByKey(neID, "INVALIDVRFINDEX"));
                    ++failBfdNum;
                    continue;
                }
                rowParams.addParam("vrfindex", String.valueOf(vrfRetObj.getVrfIndex()));
                rowParams.addParam("slotid", "65535");
                rowParams.addParam("port", "65535");
            }
            rowParams.addParam("sessiontype", String.valueOf(sessionType));
            this.setBasicParamsForAdd(rowParams, bfdInfo);
            busParams.addRowParams(rowParams);
            bfdOpertObj.setBfdInfo(bfdInfo);
            bfdOpertObj.setBusParams(busParams);
            bfdOpertObj.setNeID(neID);
            bfdOpertObjList.add(bfdOpertObj);
        }
        this.handleLoginNE(neIDSet);
        Datainterface outputData = null;
        Datainterface inputData = null;
        SubFunc subFunc = null;
        int neID = -1;
        try {
            for (BfdOpertObj var : bfdOpertObjList) {
                neID = var.getNeID();
                bfdInfo = var.getBfdInfo();
                if (null == TENEListMgr.getInstance().getNE(neID)) {
                    bfdInfo.poOperResult = this.bfdOpertUtil.getAsnRet(1107329312, this.bfdOpertUtil.getBfdResByKey(neID, "NENOTEXIST"));
                    ++failBfdNum;
                    continue;
                }
                inputData = new Datainterface();
                inputData.setBussinessParams(var.getBusParams());
                subFunc = TEBFDPoOperationUtil.getSubFuncObj(neID, TEBFDPoOperationUtil.getCreateBfdQxCmd());
                outputData = this.bfdOpertUtil.callLctDomainModule(neID, inputData, subFunc, false);
                if (!this.setErrorForAddOperation(neID, outputData, var, 1)) {
                    ++failBfdNum;
                    continue;
                }
                if (this.checkSetBfdPara(inputData)) {
                    inputData.getBussinessParams().getRowParams()[0].addParam("sessionIndex", String.valueOf(var.getSessionIndex()));
                    subFunc = TEBFDPoOperationUtil.getSubFuncObj(neID, TEBFDPoOperationUtil.getModifyBfdQxCmd());
                    outputData = this.bfdOpertUtil.callLctDomainModule(neID, inputData, subFunc, false);
                    if (!this.setErrorForAddOperation(neID, outputData, var, -1)) {
                        ++failBfdNum;
                    }
                }
                inputData = new Datainterface();
                busParams = new BussinessParams();
                rowParams = new RowParams();
                rowParams.addParam("neid", String.valueOf(neID));
                rowParams.addParam("isauto", "0");
                rowParams.addParam("sessionIndex", String.valueOf(var.getSessionIndex()));
                busParams.addRowParams(rowParams);
                inputData.setBussinessParams(busParams);
                subFunc = TEBFDPoOperationUtil.getSubFuncObj(neID, TEBFDPoOperationUtil.getQueryBfdQxCmd());
                outputData = this.bfdOpertUtil.callLctDomainModule(neID, inputData, subFunc, false);
                if (!this.setErrorForAddOperation(neID, outputData, var, 0)) continue;
                bfdInfo.poSessionID = (int)var.getSessionId();
                rowParams = outputData.getBussinessParams().getRowParams(0);
                TEBFDPoOperationUtil.updateByCommPort(bfdOpertObj.getCommPort(), rowParams);
                this.bfdOpertUtil.saveBfdInfo2DB(neID, rowParams, 255, true);
                bfdList4Rpt.add(bfdInfo);
            }
        }
        catch (Exception e) {
            ++failBfdNum;
            logger.error("[QAsnCreateBfdReq]create bfd from weblct exception" + neID, (Throwable)e);
        }
        this.sendRpt(bfdList4Rpt, req.poTaskFlag, 65651);
        rsp.oResult = this.bfdOpertUtil.getAsnRet(0 == failBfdNum ? 0 : 1107329312, "");
        logger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    private void setBasicParamsForAdd(RowParams rowParams, QAsnBfdInfo bfdInfo) {
        rowParams.addParam("neid", String.valueOf(bfdInfo.neID));
        rowParams.addParam("isauto", "0");
        rowParams.addParam("sessionid", "0");
        rowParams.addParam("locallabel", "0");
        rowParams.addParam("remotelabel", "0");
        rowParams.addParam("childid", "255");
        if (this.isValidIntParam(bfdInfo.iDetectMult)) {
            rowParams.addParam("localmultplier", String.valueOf(bfdInfo.iDetectMult));
        }
        if (this.isValidIntParam(bfdInfo.iMinRxInterval)) {
            rowParams.addParam("receiveinterval", String.valueOf(bfdInfo.iMinRxInterval));
        }
        if (this.isValidIntParam(bfdInfo.iMinTxInterval)) {
            rowParams.addParam("sendinterval", String.valueOf(bfdInfo.iMinTxInterval));
        }
        if (this.isValidIntParam(bfdInfo.iAdminStatus)) {
            rowParams.addParam("sessionstatus", String.valueOf(this.bfdOpertUtil.transE2EAdminStatus(bfdInfo.iAdminStatus)));
        }
        rowParams.addParam("isRPT", "0");
        rowParams.addParam("isLogFlag", "0");
    }

    private void sendRpt(List bfdList4Rpt, byte[] poTaskFlag, int rptCmd) {
        if (null == bfdList4Rpt || bfdList4Rpt.isEmpty()) {
            return;
        }
        QAsnAddBfdRpt rptObj = null;
        if (65651 == rptCmd) {
            QAsnAddBfdRpt addRpt = new QAsnAddBfdRpt();
            addRpt.lstBfdDetailInfo.addAll((Collection)bfdList4Rpt);
            addRpt.poTaskFlag = poTaskFlag;
            rptObj = addRpt;
        } else if (65663 == rptCmd) {
            QAsnModifyBfdRpt modifyRpt = new QAsnModifyBfdRpt();
            modifyRpt.lstBfdDetailInfo.addAll((Collection)bfdList4Rpt);
            modifyRpt.poTaskFlag = poTaskFlag;
            rptObj = modifyRpt;
        } else {
            QAsnDeleteBfdRpt delRpt = new QAsnDeleteBfdRpt();
            delRpt.lstBfdInfoEx.addAll((Collection)bfdList4Rpt);
            delRpt.poTaskFlag = poTaskFlag;
            rptObj = delRpt;
        }
        Event event = new Event(rptCmd, (Object)rptObj);
        this.bfdOpertUtil.createBfdRptEvent(event);
    }

    private boolean checkSetBfdPara(Datainterface inputData) {
        RowParams rowParams = inputData.getBussinessParams().getRowParams(0);
        int adminStatus = null != rowParams.getParam("sessionstatus") ? Integer.parseInt(rowParams.getParam("sessionstatus").getValue()) : -1;
        int sendInterval = null != rowParams.getParam("sendinterval") ? Integer.parseInt(rowParams.getParam("sendinterval").getValue()) : -1;
        int recvInterval = null != rowParams.getParam("receiveinterval") ? Integer.parseInt(rowParams.getParam("receiveinterval").getValue()) : -1;
        int detectMutil = null != rowParams.getParam("localmultplier") ? Integer.parseInt(rowParams.getParam("localmultplier").getValue()) : -1;
        return this.isValidIntParam(adminStatus) || this.isValidIntParam(sendInterval) || this.isValidIntParam(recvInterval) || this.isValidIntParam(detectMutil);
    }

    public int handleModifyBfdSessionReq(QAsnModifyBfdReq req, QAsnModifyBfdRsp rsp, TaskMgr taskMgr) {
        logger.info(TEAsn1Util.getAsn1String((Object)req));
        if (null == req || req.lstBfdDetailInfo.isEmpty()) {
            return 0;
        }
        rsp.lstBfdDetailInfo = new QAsnBfdInfoList();
        ArrayList<QAsnBfdInfo> bfdList4Rpt = new ArrayList<QAsnBfdInfo>();
        ArrayList<QAsnBfdInfo> errorBfdInfoList = new ArrayList<QAsnBfdInfo>();
        HashMap<Integer, BussinessParams> ne2BusMap = new HashMap<Integer, BussinessParams>();
        HashMap ne2BfdOpertMap = new HashMap();
        RowParams rowParams = null;
        TEPTNBfdContainerMOPO bfdContainerPo = null;
        BussinessParams bus = null;
        int neID = -1;
        QAsnBfdInfo bfdInfo2 = null;
        BfdOpertObj bfdOpertObj = null;
        try {
            for (QAsnBfdInfo bfdInfo2 : req.lstBfdDetailInfo) {
                neID = bfdInfo2.neID;
                if (!ne2BfdOpertMap.containsKey(neID)) {
                    ne2BfdOpertMap.put(neID, new ArrayList());
                }
                if (null != bfdInfo2.poOperMask && -1 == bfdInfo2.poOperMask) continue;
                rsp.lstBfdDetailInfo.add((Object)bfdInfo2);
                if (!this.validateModifyMask(bfdInfo2)) {
                    bfdInfo2.poOperResult = this.bfdOpertUtil.getAsnRet(1107329312, this.bfdOpertUtil.getBfdResByKey(neID, "QINPUTPARAMERROR"));
                    errorBfdInfoList.add(bfdInfo2);
                    continue;
                }
                bfdOpertObj = new BfdOpertObj();
                bfdOpertObj.setBfdInfo(bfdInfo2);
                ((List)ne2BfdOpertMap.get(neID)).add(bfdOpertObj);
            }
            Iterator entryIter = ne2BfdOpertMap.entrySet().iterator();
            while (entryIter.hasNext()) {
                Map.Entry entry = entryIter.next();
                neID = (Integer)entry.getKey();
                List bfdOpertList = (List)entry.getValue();
                if (null == TENEListMgr.getInstance().getNE(neID)) {
                    for (BfdOpertObj var : bfdOpertList) {
                        bfdInfo2 = var.getBfdInfo();
                        bfdInfo2.poOperResult = this.bfdOpertUtil.getAsnRet(1107329312, this.bfdOpertUtil.getBfdResByKey(neID, "NENOTEXIST"));
                        errorBfdInfoList.add(bfdInfo2);
                    }
                    entryIter.remove();
                    continue;
                }
                bfdContainerPo = this.bfdOpertUtil.getBfdContainer(neID, true);
                if (null == bfdContainerPo || bfdContainerPo.getBfdList().isEmpty()) {
                    for (BfdOpertObj var : bfdOpertList) {
                        bfdInfo2 = var.getBfdInfo();
                        bfdInfo2 = this.bfdOpertUtil.getDefaultBfdInfo(neID, var.getSessionId(), "NOTFOUNDBFD");
                        errorBfdInfoList.add(bfdInfo2);
                        rsp.lstBfdDetailInfo.add((Object)bfdInfo2);
                    }
                    entryIter.remove();
                    continue;
                }
                Iterator bfdOpertIter = bfdOpertList.iterator();
                while (bfdOpertIter.hasNext()) {
                    bfdOpertObj = (BfdOpertObj)bfdOpertIter.next();
                    bfdInfo2 = bfdOpertObj.getBfdInfo();
                    String bfdIdStr = this.bfdOpertUtil.getBfdIdFromFDN(bfdOpertObj.getBfdInfo().bfdFdn);
                    boolean flagFind = false;
                    Iterator bfdPoIter = bfdContainerPo.getBfdList().iterator();
                    while (bfdPoIter.hasNext()) {
                        TEPTNBfdSessionObjMOPO bfdPo = (TEPTNBfdSessionObjMOPO)bfdPoIter.next();
                        if (bfdPo.getBFDSessionID() != Long.parseLong(bfdIdStr)) continue;
                        flagFind = true;
                        bfdOpertObj.setSessionIndex(bfdPo.getBFDIndex());
                        rowParams = new RowParams();
                        this.addParam2RowParams(rowParams, "neid", String.valueOf(neID), false);
                        this.addParam2RowParams(rowParams, "isauto", "0", false);
                        this.addParam2RowParams(rowParams, "sessionIndex", String.valueOf(bfdPo.getBFDIndex()), false);
                        this.addParam2RowParams(rowParams, "sessionid", bfdIdStr, false);
                        this.addParam2RowParams(rowParams, "subslotid", String.valueOf(neID), false);
                        this.setParamByBitSet(bfdInfo2, rowParams);
                        rowParams.addParam("isRPT", "0");
                        rowParams.addParam("isLogFlag", "0");
                        rowParams.addParam("poTaskFlag", new String(req.poTaskFlag));
                        if (!ne2BusMap.containsKey(neID)) {
                            bus = new BussinessParams();
                            ne2BusMap.put(neID, bus);
                        }
                        ((BussinessParams)ne2BusMap.get(neID)).addRowParams(rowParams);
                        bfdPoIter.remove();
                        break;
                    }
                    if (flagFind) continue;
                    bfdInfo2.bfdFdn = this.bfdOpertUtil.getBfdFdn(neID, Long.parseLong(bfdIdStr));
                    bfdInfo2.poOperResult = this.bfdOpertUtil.getAsnRet(1107329312, this.bfdOpertUtil.getBfdResByKey(neID, "NOTFOUNDBFD"));
                    errorBfdInfoList.add(bfdInfo2);
                    bfdOpertIter.remove();
                }
            }
        }
        catch (Exception e) {
            logger.info("[QAsnDeleteBfdReq]error happens when handleDeleteBfdSessionReq", (Throwable)e);
        }
        this.handleLoginNE(ne2BusMap.keySet());
        boolean flagExcept = false;
        List bfdOpertLst = null;
        try {
            for (Map.Entry entry : ne2BusMap.entrySet()) {
                neID = (Integer)entry.getKey();
                bus = (BussinessParams)entry.getValue();
                if (0 == bus.getRowParamsCount()) continue;
                SubFunc subFunc = TEBFDPoOperationUtil.getSubFuncObj(neID, TEBFDPoOperationUtil.getModifyBfdQxCmd());
                Datainterface outputData = null;
                Datainterface inputData = new Datainterface();
                inputData.setBussinessParams(bus);
                outputData = TEWNEMgrBussinessProcess.performWNEMgrBussinessProcess((int)neID, (SubFunc)subFunc, (Datainterface)inputData, null, null, null, (int)1);
                bfdOpertLst = (List)ne2BfdOpertMap.get(neID);
                this.setErrorForModify(outputData, bfdOpertLst, errorBfdInfoList);
                for (BfdOpertObj var : bfdOpertLst) {
                    bfdList4Rpt.add(var.getBfdInfo());
                }
            }
        }
        catch (InstantiationException e) {
            flagExcept = true;
            logger.info("[QAsnDeleteBfdReq]delete bfd exception" + neID, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            flagExcept = true;
            logger.info("[QAsnDeleteBfdReq]delete bfd exception" + neID, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            flagExcept = true;
            logger.info("[QAsnDeleteBfdReq]delete bfd exception" + neID, (Throwable)e);
        }
        if (!errorBfdInfoList.isEmpty() || flagExcept) {
            rsp.oResult.isSuccess = false;
            rsp.oResult.retCode = 1;
        } else {
            rsp.oResult.isSuccess = true;
            rsp.oResult.retCode = 0;
        }
        logger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    private void setParamByBitSet(QAsnBfdInfo bfdInfo, RowParams rowParams) {
        BitSet modifyMask = this.bfdOpertUtil.constructBitSet(bfdInfo.poOperMask);
        if (this.isValidIntParam(bfdInfo.iAdminStatus) && this.checkModifyFlag(modifyMask, 1)) {
            rowParams.addParam("sessionstatus", String.valueOf(this.bfdOpertUtil.transE2EAdminStatus(bfdInfo.iAdminStatus)));
        }
        if (this.isValidIntParam(bfdInfo.iMinTxInterval) && this.checkModifyFlag(modifyMask, 3)) {
            rowParams.addParam("sendinterval", String.valueOf(bfdInfo.iMinTxInterval));
        }
        if (this.isValidIntParam(bfdInfo.iMinRxInterval) && this.checkModifyFlag(modifyMask, 4)) {
            rowParams.addParam("receiveinterval", String.valueOf(bfdInfo.iMinRxInterval));
        }
        if (this.isValidIntParam(bfdInfo.iDetectMult) && this.checkModifyFlag(modifyMask, 5)) {
            rowParams.addParam("localmultplier", String.valueOf(bfdInfo.iDetectMult));
        }
    }

    public int handleDeleteBfdSessionReq(QAsnDeleteBfdReq req, QAsnDeleteBfdRsp rsp, TaskMgr taskMgr) {
        logger.info(TEAsn1Util.getAsn1String((Object)req));
        if (null == req || req.lstBfdKey.isEmpty()) {
            return 0;
        }
        rsp.lstBfdInfo = new QAsnBfdInfoList();
        BussinessParams bus = null;
        ArrayList<QAsnBfdInfoEx> bfdList4Rpt = new ArrayList<QAsnBfdInfoEx>();
        ArrayList<QAsnBfdInfo> errorBfdInfoList = new ArrayList<QAsnBfdInfo>();
        HashMap<Integer, BussinessParams> ne2BusMap = new HashMap<Integer, BussinessParams>();
        HashMap ne2BfdObjMap = new HashMap();
        RowParams rowParams = null;
        TEPTNBfdContainerMOPO bfdContainerPo = null;
        BfdOpertObj bfdOpertObj = null;
        QAsnBfdInfo bfdInfo = null;
        int neID = -1;
        try {
            for (Object var : req.lstBfdKey) {
                QAsnUniResID bfdKey = (QAsnUniResID)var;
                if (!this.validateBfdKey(bfdKey)) {
                    bfdInfo = this.bfdOpertUtil.getDefaultBfdInfo(neID, -1L, "QINPUTPARAMERROR");
                    errorBfdInfoList.add(bfdInfo);
                    rsp.lstBfdInfo.add((Object)bfdInfo);
                    continue;
                }
                neID = bfdKey.neID;
                if (!ne2BusMap.containsKey(neID)) {
                    bus = new BussinessParams();
                    ne2BusMap.put(neID, bus);
                }
                if (!ne2BfdObjMap.containsKey(neID)) {
                    ne2BfdObjMap.put(neID, new ArrayList());
                }
                bfdOpertObj = new BfdOpertObj();
                bfdOpertObj.setFdn(bfdKey);
                bfdOpertObj.setSessionId(Long.parseLong(this.bfdOpertUtil.getBfdIdFromFDN(bfdKey)));
                ((List)ne2BfdObjMap.get(neID)).add(bfdOpertObj);
            }
            Iterator entryIter = ne2BusMap.entrySet().iterator();
            while (entryIter.hasNext()) {
                Map.Entry entry = entryIter.next();
                neID = (Integer)entry.getKey();
                bus = (BussinessParams)entry.getValue();
                List bfdObjList = (List)ne2BfdObjMap.get(neID);
                if (null == TENEListMgr.getInstance().getNE(neID)) {
                    for (BfdOpertObj var : bfdObjList) {
                        bfdInfo = this.bfdOpertUtil.getDefaultBfdInfo(neID, var.getSessionId(), "NENOTEXIST");
                        bfdInfo.strName = TEBfdSessionTaskHandler.long2bytes(var.getSessionId());
                        errorBfdInfoList.add(bfdInfo);
                        rsp.lstBfdInfo.add((Object)bfdInfo);
                    }
                    entryIter.remove();
                    ne2BfdObjMap.remove(neID);
                    continue;
                }
                bfdContainerPo = this.bfdOpertUtil.getBfdContainer(neID, true);
                if (null == bfdContainerPo || bfdContainerPo.getBfdList().isEmpty()) {
                    for (BfdOpertObj var : bfdObjList) {
                        bfdInfo = this.bfdOpertUtil.getDefaultBfdInfo(neID, var.getSessionId(), "NOTFOUNDBFD");
                        bfdInfo.strName = TEBfdSessionTaskHandler.long2bytes(var.getSessionId());
                        errorBfdInfoList.add(bfdInfo);
                        rsp.lstBfdInfo.add((Object)bfdInfo);
                    }
                    entryIter.remove();
                    ne2BfdObjMap.remove(neID);
                    continue;
                }
                Iterator bfdObjIter = bfdObjList.iterator();
                while (bfdObjIter.hasNext()) {
                    boolean flagFind = false;
                    bfdOpertObj = (BfdOpertObj)bfdObjIter.next();
                    Iterator bfdPoIter = bfdContainerPo.getBfdList().iterator();
                    while (bfdPoIter.hasNext()) {
                        TEPTNBfdSessionObjMOPO bfdPo = (TEPTNBfdSessionObjMOPO)bfdPoIter.next();
                        if (bfdPo.getBFDSessionID() != bfdOpertObj.getSessionId()) continue;
                        bfdInfo = this.bfdOpertUtil.trans2QasnBfdInfo(neID, bfdPo);
                        bfdInfo.strName = TEBfdSessionTaskHandler.long2bytes(bfdPo.getBFDSessionID());
                        bfdInfo.bfdFdn.strMOC = bfdOpertObj.getFdn().strMOC;
                        rsp.lstBfdInfo.add((Object)bfdInfo);
                        bfdOpertObj.setBfdInfo(bfdInfo);
                        bfdOpertObj.setSessionIndex(bfdPo.getBFDIndex());
                        flagFind = true;
                        rowParams = new RowParams();
                        rowParams.addParam("neid", String.valueOf(neID));
                        rowParams.addParam("sessionIndex", String.valueOf(bfdPo.getBFDIndex()));
                        rowParams.addParam("sessionid", String.valueOf(bfdPo.getBFDSessionID()));
                        rowParams.addParam("isRPT", "0");
                        rowParams.addParam("isLogFlag", "0");
                        bus.addRowParams(rowParams);
                        bfdPoIter.remove();
                        break;
                    }
                    if (flagFind) continue;
                    bfdInfo = this.bfdOpertUtil.getDefaultBfdInfo(neID, bfdOpertObj.getSessionId());
                    bfdInfo.poOperResult = this.bfdOpertUtil.getAsnRet(0, "");
                    bfdInfo.strName = TEBfdSessionTaskHandler.long2bytes(bfdOpertObj.getSessionId());
                    bfdInfo.bfdFdn.strMOC = bfdOpertObj.getFdn().strMOC;
                    bfdOpertObj.setBfdInfo(bfdInfo);
                    rsp.lstBfdInfo.add((Object)bfdInfo);
                }
            }
        }
        catch (Exception e) {
            logger.info("[QAsnDeleteBfdReq]error happens when handleDeleteBfdSessionReq", (Throwable)e);
        }
        this.handleLoginNE(ne2BusMap.keySet());
        boolean flagExcept = false;
        List bfdOpertLst = null;
        try {
            for (Map.Entry entry : ne2BusMap.entrySet()) {
                neID = (Integer)entry.getKey();
                bus = (BussinessParams)entry.getValue();
                if (bus.getRowParamsCount() == 0) continue;
                SubFunc subFunc = TEBFDPoOperationUtil.getSubFuncObj(neID, TEBFDPoOperationUtil.getDeleteBfdQxCmd());
                Datainterface outputData = null;
                Datainterface inputData = new Datainterface();
                inputData.setBussinessParams(bus);
                outputData = TEWNEMgrBussinessProcess.performWNEMgrBussinessProcess((int)neID, (SubFunc)subFunc, (Datainterface)inputData, null, null, null, (int)1);
                bfdOpertLst = (List)ne2BfdObjMap.get(neID);
                this.setErrorForModify(outputData, bfdOpertLst, errorBfdInfoList);
                for (BfdOpertObj var : bfdOpertLst) {
                    if (!var.getBfdInfo().poOperResult.isSuccess) continue;
                    QAsnBfdInfoEx bfdInfoEx = this.bfdOpertUtil.trans2QAsnBfdInfoEx(neID, var.getSessionId());
                    bfdInfoEx.oBfdKey.strMOC = var.getFdn().strMOC;
                    bfdList4Rpt.add(bfdInfoEx);
                }
            }
        }
        catch (InstantiationException e) {
            flagExcept = true;
            logger.error("[QAsnDeleteBfdReq]delete bfd exception" + neID, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            flagExcept = true;
            logger.error("[QAsnDeleteBfdReq]delete bfd exception" + neID, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            flagExcept = true;
            logger.error("[QAsnDeleteBfdReq]delete bfd exception" + neID, (Throwable)e);
        }
        rsp.oResult = !errorBfdInfoList.isEmpty() || flagExcept ? this.bfdOpertUtil.getAsnRet(1, "") : this.bfdOpertUtil.getAsnRet(0, "");
        this.sendRpt(bfdList4Rpt, req.poTaskFlag, 65664);
        logger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    private static byte[] long2bytes(long num) {
        byte[] b = new byte[8];
        for (int i = 0; i < 8; ++i) {
            b[i] = (byte)(num >>> 56 - i * 8);
        }
        return b;
    }

    public int handleRefreshBfdSessionReq(QAsnBfdRefreshSessionReq req, QAsnBfdRefreshSessionRsp rsp, TaskMgr taskMgr) {
        logger.info(TEAsn1Util.getAsn1String((Object)req));
        QAsnUniResIDList bfdFDNList = req.lstBfdFdn;
        if (bfdFDNList.isEmpty()) {
            return 0;
        }
        rsp.lstBfdInfo = new QAsnBfdInfoList();
        rsp.oResult = new QAsnErrInfoReturn();
        QAsnErrInfoList errorInfoList = new QAsnErrInfoList();
        Map<Integer, List<String>> neID2SIDMap = this.bfdOpertUtil.getBfdIdFromFDN(bfdFDNList, rsp, errorInfoList);
        ArrayList<QAsnBfdInfo> bfdList4ModifyRpt = new ArrayList<QAsnBfdInfo>();
        ArrayList<QAsnBfdInfoEx> bfdList4DelRpt = new ArrayList<QAsnBfdInfoEx>();
        TEPTNBfdContainerMOPO bfdContainerPo = null;
        TEPTNBfdSessionObjMOPO bfdPo = null;
        ArrayList<TEPTNBfdSessionObjMOPO> bfdPoList = null;
        QAsnErrInfo errorInfo = null;
        QAsnBfdInfo bfdInfo = null;
        boolean flagFind = false;
        Iterator<Map.Entry<Integer, List<String>>> entryIter = neID2SIDMap.entrySet().iterator();
        while (entryIter.hasNext()) {
            long sessionId;
            Map.Entry<Integer, List<String>> entry = entryIter.next();
            int neID = entry.getKey();
            List<String> bfdIDList = entry.getValue();
            if (null == TENEListMgr.getInstance().getNE(neID)) {
                for (String bfdID : bfdIDList) {
                    errorInfo = this.bfdOpertUtil.getAsnErrInfo(neID, Long.parseLong(bfdID), this.bfdOpertUtil.getBfdResByKey(neID, "NENOTEXIST"));
                    errorInfoList.add((Object)errorInfo);
                }
                entryIter.remove();
                continue;
            }
            bfdContainerPo = this.bfdOpertUtil.getBfdContainer(neID, true);
            if (null == bfdContainerPo || bfdContainerPo.getBfdList().isEmpty()) {
                for (String var : bfdIDList) {
                    sessionId = Long.parseLong(var);
                    bfdInfo = this.bfdOpertUtil.getDefaultBfdInfo(neID, sessionId, "NOTFOUNDBFD");
                    errorInfoList.add((Object)this.bfdOpertUtil.getAsnErrInfo(neID, sessionId, this.bfdOpertUtil.getBfdResByKey(neID, "NOTFOUNDBFD")));
                    rsp.lstBfdInfo.add((Object)bfdInfo);
                }
                entryIter.remove();
                continue;
            }
            bfdPoList = new ArrayList<TEPTNBfdSessionObjMOPO>();
            for (String bfdIDStr : bfdIDList) {
                sessionId = Long.parseLong(bfdIDStr);
                flagFind = false;
                int errorCode = -1;
                Iterator bfdPoIter = bfdContainerPo.getBfdList().iterator();
                while (bfdPoIter.hasNext()) {
                    bfdPo = (TEPTNBfdSessionObjMOPO)bfdPoIter.next();
                    if (sessionId != bfdPo.getBFDSessionID()) continue;
                    Datainterface output = this.bfdOpertUtil.callQueryBfdModule(neID, bfdPo.getBFDIndex(), false);
                    errorCode = Integer.parseInt(output.getErrorMessage().getErrorcode());
                    if (0 != errorCode) break;
                    if (output.getBussinessParams().getRowParamsCount() > 0) {
                        if (this.updatePo(bfdPo, this.bfdOpertUtil.getBfdMOPO(output.getBussinessParams()).get(0))) {
                            bfdList4ModifyRpt.add(this.bfdOpertUtil.trans2QasnBfdInfo(neID, bfdPo));
                        }
                        bfdPoList.add(bfdPo);
                        flagFind = true;
                        break;
                    }
                    bfdPoIter.remove();
                    bfdList4DelRpt.add(this.bfdOpertUtil.trans2QAsnBfdInfoEx(neID, bfdPo));
                    errorCode = 42707;
                    break;
                }
                if (flagFind) continue;
                if (-1 != errorCode) {
                    bfdInfo = this.bfdOpertUtil.getDefaultBfdInfo(neID, sessionId, errorCode);
                    errorInfoList.add((Object)this.bfdOpertUtil.getAsnErrInfo(neID, sessionId, errorCode, TEErrorResourceUtil.getErrorMessage((int)errorCode).getErrorinfo()));
                } else {
                    bfdInfo = this.bfdOpertUtil.getDefaultBfdInfo(neID, sessionId, "NOTFOUNDBFD");
                    errorInfoList.add((Object)this.bfdOpertUtil.getAsnErrInfo(neID, sessionId, this.bfdOpertUtil.getBfdResByKey(neID, "NOTFOUNDBFD")));
                }
                rsp.lstBfdInfo.add((Object)bfdInfo);
            }
            this.bfdOpertUtil.updateBfdInfo(neID, bfdContainerPo, true);
            rsp.lstBfdInfo.addAll(this.bfdOpertUtil.trans2QasnBfdInfo(neID, bfdPoList));
        }
        rsp.oResult.errList = errorInfoList;
        if (!errorInfoList.isEmpty()) {
            rsp.oResult.result = 1;
        }
        this.sendRptForRefresh(bfdList4ModifyRpt, bfdList4DelRpt);
        logger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    private void sendRptForRefresh(List<QAsnBfdInfo> bfdList4ModifyRpt, List<QAsnBfdInfoEx> bfdList4DelRpt) {
        if (!bfdList4ModifyRpt.isEmpty()) {
            this.sendRpt(bfdList4ModifyRpt, null, 65663);
        }
        if (!bfdList4DelRpt.isEmpty()) {
            this.sendRpt(bfdList4DelRpt, null, 65664);
        }
    }

    private boolean updatePo(TEPTNBfdSessionObjMOPO oldPo, TEPTNBfdSessionObjMOPO newPo) {
        boolean isDiff = !oldPo.equals((Object)newPo);
        oldPo.updateByNewPo(newPo);
        return isDiff;
    }

    private void handleLoginNE(Set<Integer> set) {
        Iterator<Integer> iter = set.iterator();
        int neID = -1;
        TENE ne = null;
        while (iter.hasNext()) {
            neID = iter.next();
            ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne || 1 == ne.getLogStatus()) continue;
            TEHandleSbiInfo.getInstance().handleSBIConnectOnInter(neID);
        }
    }

    public boolean setErrorForAddOperation(int neID, Datainterface outputData, BfdOpertObj bfdOpertObj, int opertType) {
        QAsnBfdInfo bfdInfo = bfdOpertObj.getBfdInfo();
        if (null == outputData) {
            bfdInfo.poOperResult = this.bfdOpertUtil.getAsnRet(1090650120, "");
            return true;
        }
        int totalErr = Integer.valueOf(outputData.getErrorMessage().getErrorcode());
        int cmdCode = 0;
        RowParams rowParams = null;
        Param param = null;
        if (0 == totalErr) {
            if (1 == opertType) {
                rowParams = outputData.getBussinessParams().getRowParams()[0];
                param = rowParams.getParam("sessionid");
                bfdOpertObj.setSessionIndex(Long.parseLong(param.getValue()));
            } else if (0 == opertType) {
                rowParams = outputData.getBussinessParams().getRowParams()[0];
                param = rowParams.getParam("sessionid");
                bfdOpertObj.setSessionId(Long.parseLong(param.getValue()));
                param = rowParams.getParam("sendinterval");
                bfdInfo.iMinTxInterval = Integer.parseInt(param.getValue());
                param = rowParams.getParam("receiveinterval");
                bfdInfo.iMinRxInterval = Integer.parseInt(param.getValue());
                param = rowParams.getParam("detectmultiple");
                bfdInfo.iDetectMult = Integer.parseInt(param.getValue());
                param = rowParams.getParam("locallabel");
                bfdInfo.iLocalID = Integer.parseInt(param.getValue());
                param = rowParams.getParam("remotelabel");
                bfdInfo.iRemoteID = Integer.parseInt(param.getValue());
                bfdInfo.bfdFdn = this.bfdOpertUtil.getBfdFdn(neID, bfdOpertObj.getSessionId());
            }
            return true;
        }
        rowParams = outputData.getBussinessParams().getRowParams()[0];
        int errorCount = rowParams.getRowErrorsCount();
        for (int i = 0; i < errorCount; ++i) {
            String errObj;
            RowErrors rowError = rowParams.getRowErrors(i);
            int errCode = Integer.valueOf(rowError.getErrorMessage().getErrorcode());
            if (0 == errCode) continue;
            param = rowError.getParam("cmdCode");
            if (null != param) {
                cmdCode = Integer.valueOf(param.getValue());
                errObj = rowError.getParam(String.valueOf(cmdCode)).getValue();
            } else {
                errObj = rowError.getErrorMessage().getErrorinfo();
            }
            bfdInfo.poOperResult = this.bfdOpertUtil.getAsnRet(errCode, errObj);
        }
        return bfdInfo.poOperResult.isSuccess;
    }

    private void setErrorForModify(Datainterface outputData, List<BfdOpertObj> list, List<QAsnBfdInfo> errorList) {
        if (null == outputData) {
            for (BfdOpertObj bfdOpertObj : list) {
                ((BfdOpertObj)bfdOpertObj).bfdInfo.poOperResult = this.bfdOpertUtil.getAsnRet(TEErrorResourceUtil.getErrorMessage((int)1090650120));
            }
            return;
        }
        for (BfdOpertObj bfdOpertObj : list) {
            if (((BfdOpertObj)bfdOpertObj).bfdInfo.poOperResult.retCode > 0) continue;
            ((BfdOpertObj)bfdOpertObj).bfdInfo.poOperResult = this.bfdOpertUtil.getAsnRet(TEErrorResourceUtil.getErrorMessage((int)0));
        }
        int totalErr = Integer.valueOf(outputData.getErrorMessage().getErrorcode());
        int cmdCode = 0;
        if (0 == totalErr) {
            return;
        }
        for (BfdOpertObj bfdOpertObj : list) {
            block3: for (RowParams rowParams : outputData.getBussinessParams().getRowParams()) {
                for (RowErrors rowErrors : rowParams.getRowErrors()) {
                    String errObj;
                    int errCode;
                    long sessionIndex = bfdOpertObj.getSessionIndex();
                    if (null == rowErrors.getParam("sessionIndex") || "".equals(rowErrors.getParam("sessionIndex").getValue())) continue block3;
                    if (sessionIndex != Long.parseLong(rowErrors.getParam("sessionIndex").getValue()) || 0 == (errCode = Integer.valueOf(rowErrors.getErrorMessage().getErrorcode()).intValue())) continue;
                    Param param = rowErrors.getParam("cmdCode");
                    if (null != param) {
                        cmdCode = Integer.valueOf(param.getValue());
                        errObj = rowErrors.getParam(String.valueOf(cmdCode)).getValue();
                    } else {
                        errObj = rowErrors.getErrorMessage().getErrorinfo();
                    }
                    bfdOpertObj.getBfdInfo().poOperResult = this.bfdOpertUtil.getAsnRet(errCode, errObj);
                    errorList.add(bfdOpertObj.getBfdInfo());
                }
            }
        }
    }

    public String convert2IPString(String ipStr) {
        if (null == ipStr) {
            return "0";
        }
        String[] strList = ipStr.split("\\.");
        StringBuilder builder = new StringBuilder();
        String temp = null;
        for (String str : strList) {
            temp = Integer.toHexString(Integer.parseInt(str));
            if (1 == temp.length()) {
                temp = "0" + temp;
            }
            builder.append(temp);
        }
        return builder.toString();
    }

    public String convert2IPString(byte[] ipBytes) {
        return this.convert2IPString(null == ipBytes ? null : new String(ipBytes));
    }

    public boolean verifySessionType(int iSessionType) {
        return 3 == iSessionType || 4 == iSessionType;
    }

    public boolean verifyBindServType(int iBindServType) {
        return 2 == iBindServType || 1 == iBindServType;
    }

    public boolean verifyBindServiceInfo(QAsnBfdInfo bfdInfo) {
        if (null == bfdInfo.poBfdBindService) {
            return false;
        }
        int q_servType = bfdInfo.iSessionType;
        int iServType = this.bfdOpertUtil.getQxSessionType(q_servType);
        int iBindServType = bfdInfo.poBfdBindService.iBindServiceType;
        if (3 != q_servType && 4 != q_servType) {
            return false;
        }
        if (!BINDTYPELIST.contains(iBindServType)) {
            return false;
        }
        if (2 == iBindServType) {
            if (null == bfdInfo.poBfdBindService.poBfdBindVrfIp) {
                return false;
            }
            QAsnBfdBindVrfIp vrfInfo = bfdInfo.poBfdBindService.poBfdBindVrfIp;
            if (!this.bfdOpertUtil.verifyBytes(vrfInfo.poRemoteIp) || !this.bfdOpertUtil.verifyUniRes(vrfInfo.strVrfFdn, false)) {
                return false;
            }
        }
        if (1 == iBindServType) {
            if (null == bfdInfo.poBfdBindService.poBfdBindIpLink) {
                return false;
            }
            QAsnBfdBindIpLink ipLinkInfo = bfdInfo.poBfdBindService.poBfdBindIpLink;
            if (1 == iServType) {
                return this.bfdOpertUtil.verifyBytes(ipLinkInfo.poRemoteIp);
            }
            return this.bfdOpertUtil.verifyBytes(ipLinkInfo.poRemoteIp) && this.bfdOpertUtil.verifyUniRes(ipLinkInfo.poOutInfFdn, true);
        }
        return true;
    }

    private boolean verifyCreateBfdInfo(QAsnBfdInfo bfdInfo) {
        int neID = bfdInfo.neID;
        if (!this.verifyBindServiceInfo(bfdInfo)) {
            bfdInfo.poOperResult = this.bfdOpertUtil.getAsnRet(1107329312, this.bfdOpertUtil.getBfdResByKey(neID, "QINPUTPARAMERROR"));
            return false;
        }
        return true;
    }

    private boolean isValidIntParam(BigInteger input) {
        return -1 != input.intValue();
    }

    private boolean isValidIntParam(int input) {
        return -1 != input;
    }

    private void addParam2RowParams(RowParams rowParams, String name, String value, boolean flagModify) {
        Param param = new Param(name, value);
        param.setModifyFlag(flagModify);
        rowParams.addParam(param);
    }

    private boolean checkModifyFlag(BitSet modifyMask, int position) {
        return modifyMask.get(position);
    }

    private boolean validateModifyMask(QAsnBfdInfo bfdInfo) {
        if (null == bfdInfo.poOperMask) {
            return false;
        }
        int maskInt = bfdInfo.poOperMask;
        if (-1 == maskInt) {
            return false;
        }
        BitSet modifyMask = this.bfdOpertUtil.constructBitSet(maskInt);
        boolean flagModify = false;
        for (int mask : MODIFYMASKLIST) {
            flagModify = flagModify || this.checkModifyFlag(modifyMask, mask);
        }
        return flagModify;
    }

    private boolean validateBfdKey(QAsnUniResID bfdKey) {
        return this.bfdOpertUtil.verifyBytes(bfdKey.strFDN);
    }

    static {
        BINDTYPELIST = new ArrayList();
        MODIFYMASKLIST = new ArrayList<Integer>();
        BINDTYPELIST.add(1);
        BINDTYPELIST.add(2);
        MODIFYMASKLIST.add(1);
        MODIFYMASKLIST.add(5);
        MODIFYMASKLIST.add(4);
        MODIFYMASKLIST.add(3);
    }

    class BfdOpertObj {
        private BussinessParams busParams = null;
        private QAsnBfdInfo bfdInfo = null;
        private QAsnUniResID fdn = null;
        private int neID = -1;
        private long sessionId;
        private long sessionIndex;
        private long commPort;

        BfdOpertObj() {
        }

        public long getSessionId() {
            return this.sessionId;
        }

        public void setSessionId(long sessionId) {
            this.sessionId = sessionId;
        }

        public void setBfdInfo(QAsnBfdInfo bfdInfo) {
            this.bfdInfo = bfdInfo;
        }

        public QAsnBfdInfo getBfdInfo() {
            return this.bfdInfo;
        }

        public void setBusParams(BussinessParams busParams) {
            this.busParams = busParams;
        }

        public BussinessParams getBusParams() {
            return this.busParams;
        }

        public void setNeID(int neID) {
            this.neID = neID;
        }

        public int getNeID() {
            return this.neID;
        }

        public void setSessionIndex(long sessionIndex) {
            this.sessionIndex = sessionIndex;
        }

        public long getSessionIndex() {
            return this.sessionIndex;
        }

        public void setFdn(QAsnUniResID fdn) {
            this.fdn = fdn;
        }

        public QAsnUniResID getFdn() {
            return this.fdn;
        }

        public void setCommPort(long commPort) {
            this.commPort = commPort;
        }

        public long getCommPort() {
            return this.commPort;
        }
    }
}

