/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.dcnmgr;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.ptn_pub.TEPTNUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class TEQueryPacketControl
extends TECommonWriteLogBean {
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.subfunc = subFunc;
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        this.neid = neid;
        Vector boardlist = ne.getBoardList();
        BussinessParams bussinessParams = inputData.getBussinessParams();
        bussinessParams.clearRowParams();
        TEBoard board = null;
        TESubBoard sb = null;
        TIntHashSet eth_boards = TEPTNUtil.instance().getFilterBoardsSet(neid, "TE_ETH_PORTS");
        int len = boardlist.size();
        for (int i = 0; i < len; ++i) {
            board = (TEBoard)boardlist.get(i);
            int jsize = board.getSubBoardList().size();
            for (int j = 0; j < jsize; ++j) {
                sb = (TESubBoard)board.getSubBoardList().get(j);
                if (!eth_boards.contains(sb.getSubBoardType())) continue;
                this.constructQx(String.valueOf(board.getSlotID()), String.valueOf(sb.getSubSlotID()), bussinessParams);
            }
            if (!eth_boards.contains(board.getBoardType())) continue;
            this.constructQx(String.valueOf(board.getSlotID()), "255", bussinessParams);
        }
        this.constructQx("65535", "255", bussinessParams);
        this.operationList = this.getOperation(neid, subFunc, inputData, memeryData);
        if (null == this.operationList || this.operationList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        int result = this.sendMessage(neid);
        if (result == 0) {
            this.handleMessage(neid, this.operationList, subFunc);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private void constructQx(String slotid, String subslotid, BussinessParams bussinessParams) {
        RowParams onerow = new RowParams();
        onerow.addParam("neid", String.valueOf(this.neid));
        onerow.addParam("slotid", slotid);
        onerow.addParam("subslotid", subslotid);
        onerow.addParam("port", "0");
        bussinessParams.addRowParams(onerow);
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)this.getFilterErrorCodeList());
        if (2 == Integer.parseInt(this.outputData.getErrorMessage().getErrorcode())) {
            return;
        }
        operationList.clear();
        ArrayList rowList = this.outputData.getBussinessParams().getRowParamList();
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_PORT_GET_NAME_EX");
        Input input = oper.getInput();
        input.setPartValue("slotid", "65535");
        input.setPartValue("subslotid", "255");
        input.setPartValue("port", "0");
        operationList.add(oper);
        int result = this.sendMessage(neid);
        if (result != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            return;
        }
        Operation tmpOper = (Operation)operationList.get(0);
        Output[] output = tmpOper.getOutput();
        for (Fault fault : output[0].getFault()) {
            int code = Integer.parseInt(fault.getCode());
            if (code == 0 || code == 38662) continue;
            ErrorMessage bigErr = TEErrorResourceUtil.getErrorMessage((int)1);
            this.outputData.setErrorMessage(bigErr);
            return;
        }
        TEPTNUtil.instance().processMPAndVEthnetPortName(rowList, output);
    }

    public List<TELogInfo> getLogInfoList(Datainterface inputData) {
        return this.getSingletonLogInfo(inputData);
    }
}

