/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.dcnmgr;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.ptn.dcnmgr.TETunnelInfo;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class TENEQueryTunnelAccess
extends TENEExplorerBean {
    private Datainterface newinput = null;
    public int accesstype = 0;
    private HashMap ipTunnelMap = new HashMap();
    private HashMap greTunnelMap = new HashMap();
    private HashMap dcnEnableTunelMap = new HashMap();
    private static final int NSCMD_CFG_IP_TNL_GET_TUNNEL = 32622;
    private static final int NSCMD_CFG_IP_TNL_GET_TUNNEL_EX = 33812;
    private static final int NSCMD_CFG_GRE_TNL_GET_TUNNEL = 32619;
    private static final int NSCMD_CFG_GRE_TNL_GET_TUNNEL_EX = 33810;
    private static final int NSCMD_DCN_GET_DCN_TUNNEL = 34521;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.neid = neid;
        this.newinput = new Datainterface();
        BussinessParams businessParam = new BussinessParams();
        this.newinput.setBussinessParams(businessParam);
        this.outputData = new Datainterface();
        this.accesstype = this.getaccesstype();
        this.handleInputData();
        this.operationList = this.getOperation(neid, subFunc, this.newinput, memeryData);
        int result = this.sendMessage(neid);
        if (result == 0) {
            this.handleMessage(neid, this.operationList, subFunc);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private int getaccesstype() {
        RowParams[] rowparas = this.inputData.getBussinessParams().getRowParams();
        Param para = rowparas[0].getParam("accesstype");
        return new Integer(para.getValue());
    }

    private void handleInputData() {
        RowParams rowParams = new RowParams();
        rowParams.addParam("tunnelindex", "0");
        this.newinput.getBussinessParams().addRowParams(rowParams);
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.outputData.setBussinessParams(new BussinessParams());
        TETunnelInfo tunelInfo = null;
        for (int i = 0; i < operationList.size(); ++i) {
            Operation operation = (Operation)operationList.get(i);
            int cmdid = operation.getCmdid();
            for (Output output : operation.getOutput()) {
                long tunnelIndex;
                long tunnelID;
                Part indexPart;
                Part idPart;
                int retCode = new Integer(output.getFault()[0].getCode());
                if (retCode != 0) continue;
                if (cmdid == 32619 || cmdid == 33810) {
                    idPart = output.getPart("tunnelid");
                    indexPart = output.getPart("tunnelindex");
                    tunnelID = Long.parseLong(idPart.getValue());
                    tunnelIndex = Long.parseLong(indexPart.getValue());
                    tunelInfo = new TETunnelInfo(tunnelID, 0, 1, 65535, tunnelIndex);
                    this.greTunnelMap.put(Long.valueOf(String.valueOf(tunelInfo.getTunnelIndex())), tunelInfo);
                }
                if (cmdid == 32622 || cmdid == 33812) {
                    idPart = output.getPart("tunnelid");
                    indexPart = output.getPart("tunnelindex");
                    tunnelID = Long.parseLong(idPart.getValue());
                    tunnelIndex = Long.parseLong(indexPart.getValue());
                    tunelInfo = new TETunnelInfo(tunnelID, 0, 1, 65535, tunnelIndex);
                    this.ipTunnelMap.put(Long.valueOf(String.valueOf(tunelInfo.getTunnelIndex())), tunelInfo);
                }
                if (cmdid != 34521) continue;
                String indexPart2 = output.getPartValue("tunnelindex");
                String tunnelType = output.getPartValue("dcnformat");
                String udpportid = output.getPartValue("udpportid");
                EnableDcnTunnel tunnel = new EnableDcnTunnel(Long.parseLong(indexPart2), Integer.parseInt(tunnelType), Integer.parseInt(udpportid));
                this.dcnEnableTunelMap.put(Long.valueOf(indexPart2), tunnel);
            }
        }
        this.handleOutData(this.accesstype);
    }

    private void handleOutData(int accessType) {
        if (accessType == 1) {
            TETunnelInfo tunnelInfo;
            for (Long tunnelindex : this.dcnEnableTunelMap.keySet()) {
                if (!this.ipTunnelMap.containsKey(tunnelindex)) continue;
                tunnelInfo = (TETunnelInfo)this.ipTunnelMap.get(tunnelindex);
                tunnelInfo.setIsDcnEnabled(1);
                tunnelInfo.setTunnelType(((EnableDcnTunnel)this.dcnEnableTunelMap.get((Object)tunnelindex)).tunneltype);
                tunnelInfo.setUdpPortID(((EnableDcnTunnel)this.dcnEnableTunelMap.get((Object)tunnelindex)).udpPortID);
            }
            Iterator itIpTunnel = this.ipTunnelMap.keySet().iterator();
            tunnelInfo = null;
            while (itIpTunnel.hasNext()) {
                Long tunnelindex = (Long)itIpTunnel.next();
                tunnelInfo = (TETunnelInfo)this.ipTunnelMap.get(tunnelindex);
                RowParams rtnRowParams = new RowParams();
                rtnRowParams.addParam("tunnelid", tunnelInfo.getTunnelID() + "");
                rtnRowParams.addParam("accesssta", tunnelInfo.getIsDcnEnabled() + "");
                rtnRowParams.addParam("tunnelindex", tunnelInfo.getTunnelIndex() + "");
                rtnRowParams.addParam("dcnformat", tunnelInfo.getTunnelType() + "");
                rtnRowParams.addParam("udpportid", tunnelInfo.getUdpPortID() + "");
                this.outputData.getBussinessParams().addRowParams(rtnRowParams);
            }
        } else if (accessType == 2) {
            for (Long tunnelindex : this.dcnEnableTunelMap.keySet()) {
                if (!this.greTunnelMap.containsKey(tunnelindex)) continue;
                TETunnelInfo tunnelInfo = (TETunnelInfo)this.greTunnelMap.get(tunnelindex);
                tunnelInfo.setIsDcnEnabled(1);
                tunnelInfo.setTunnelType(((EnableDcnTunnel)this.dcnEnableTunelMap.get((Object)tunnelindex)).tunneltype);
                tunnelInfo.setUdpPortID(((EnableDcnTunnel)this.dcnEnableTunelMap.get((Object)tunnelindex)).udpPortID);
            }
            for (Long tunnelindex : this.greTunnelMap.keySet()) {
                TETunnelInfo tunnelInfo = (TETunnelInfo)this.greTunnelMap.get(tunnelindex);
                RowParams rtnRowParams = new RowParams();
                rtnRowParams.addParam("tunnelid", tunnelInfo.getTunnelID() + "");
                rtnRowParams.addParam("accesssta", tunnelInfo.getIsDcnEnabled() + "");
                rtnRowParams.addParam("tunnelindex", tunnelInfo.getTunnelIndex() + "");
                rtnRowParams.addParam("dcnformat", tunnelInfo.getTunnelType() + "");
                rtnRowParams.addParam("udpportid", tunnelInfo.getUdpPortID() + "");
                this.outputData.getBussinessParams().addRowParams(rtnRowParams);
            }
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)0));
    }

    public static class EnableDcnTunnel {
        public long tunnelindex;
        public int tunneltype;
        public static final int INVALID_PORTID = 65535;
        public static final int TUNNEL_TYPE_MPLS = 1;
        public static final int TUNNEL_TYPE_UDP = 2;
        public int udpPortID = 65535;

        public EnableDcnTunnel(long index, int type, int portid) {
            this.tunnelindex = index;
            this.tunneltype = type;
            this.udpPortID = portid;
        }
    }
}

