/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.controlplaneconfig.rsvpprotocol;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.ptn_pub.TEPTNUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class TEQueryRsvpprotocolBean
extends TECommonWriteLogBean {
    private String INVALID_SLOTID = "65535";
    private Definitions definitions = null;
    private static final int VPORT_L3IF = 7;
    private static final int VPORT_VE = 10;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        if (null != memeryData) {
            return memeryData;
        }
        this.neid = neid;
        this.subfunc = subFunc;
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        String neVersion = ne.getHostVersion();
        if (neVersion.indexOf("58.01") >= 0 || neVersion.indexOf("59.01") >= 0) {
            this.INVALID_SLOTID = "255";
        }
        Vector boardlist = ne.getBoardList();
        inputData.getBussinessParams().clearRowParams();
        for (int i = 0; i < boardlist.size(); ++i) {
            RowParams onerow = new RowParams();
            onerow.addParam("neid", new Integer(neid).toString());
            onerow.addParam("slotid", new Integer(((TEBoard)boardlist.get(i)).getSlotID()).toString());
            onerow.addParam("subslotid", "0");
            onerow.addParam("port", "0");
            inputData.getBussinessParams().addRowParams(onerow);
        }
        RowParams onerowparam = new RowParams();
        onerowparam.addParam("neid", new Integer(neid).toString());
        onerowparam.addParam("slotid", this.INVALID_SLOTID);
        onerowparam.addParam("subslotid", "255");
        onerowparam.addParam("port", "0");
        inputData.getBussinessParams().addRowParams(onerowparam);
        this.addVInter(inputData);
        this.operationList = this.getOperation(neid, subFunc, inputData, null);
        if (null == this.operationList || this.operationList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        int result = this.sendMessage(neid);
        if (result == 0) {
            this.handleMessage(neid, this.operationList, subFunc);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
        }
        int length = 0;
        if (this.outputData.getBussinessParams() != null) {
            length = this.outputData.getBussinessParams().getRowParamsCount();
        }
        for (int i = 0; i < length; ++i) {
            RowParams onerow = this.outputData.getBussinessParams().getRowParams(i);
            if (this.outputData.getBussinessParams().getRowParams(i).getParam("certpas") == null) continue;
            String name = onerow.getParam("certpas").getValue();
            int len = name.length();
            for (int k = 0; k < len; ++k) {
                if (name.charAt(k) != '\u0000') continue;
                name = name.substring(0, k);
                break;
            }
            onerow.removeParam(onerow.getParam("certpas"));
            onerow.addParam("certpas", name);
        }
        return this.outputData;
    }

    public int sendMessage(int neid, ArrayList operationList) {
        int retCode = 0;
        OperationResult result = TENECommMgr.getInstance().sendCommandNoLog(neid, (List)operationList, this.getTimeOut());
        if (null != result) {
            retCode = result.retCode;
        }
        return retCode;
    }

    private void addVInter(Datainterface inputData) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        try {
            Definitions definitions = TECreateObjectFactory.parseQxDesFile((int)this.neid);
            Operation operation = definitions.getOperation("NSCMD_ETHN_PORT_GET_VPORT");
            Input input = operation.getInput();
            input.setPartValue("slotid", this.INVALID_SLOTID + "");
            input.setPartValue("subslotid", "255");
            input.setPartValue("vport", "0");
            operationList.add(operation);
        }
        catch (MarshalException e) {
            TELogFactory.getNormalLogger().error("MarshalException", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            TELogFactory.getNormalLogger().error("FileNotFoundException", (Throwable)e);
        }
        catch (ValidationException e) {
            TELogFactory.getNormalLogger().error("ValidationException", (Throwable)e);
        }
        TENECommMgr.getInstance().sendCommand(this.neid, operationList, this.TIME_OUT);
        Operation tmpOper = (Operation)operationList.get(0);
        operationList.clear();
        Output[] outputArr = tmpOper.getOutput();
        Output output2 = null;
        for (Output output2 : outputArr) {
            int portype;
            Fault[] faultArr = output2.getFault();
            boolean isEmpty = false;
            for (Fault fault : faultArr) {
                String code = fault.getCode();
                if (null != code && Integer.parseInt(code) == 0) continue;
                isEmpty = true;
                break;
            }
            if (isEmpty || (portype = Integer.parseInt(output2.getPartValue("porttype"))) == 7 || portype == 10) continue;
            int vport = Integer.parseInt(output2.getPartValue("vport"));
            RowParams onerowparam = new RowParams();
            onerowparam.addParam("neid", new Integer(this.neid).toString());
            onerowparam.addParam("slotid", this.INVALID_SLOTID);
            onerowparam.addParam("subslotid", "255");
            onerowparam.addParam("port", vport + "");
            inputData.getBussinessParams().addRowParams(onerowparam);
        }
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        int size = operationList.size();
        for (int i = 0; i < size; ++i) {
            Operation opertion = (Operation)operationList.get(i);
            if (!"NSCMD_MPLS_RSVP_GET_AUTHINFO".equals(opertion.getName())) continue;
            for (Output output : opertion.getOutput()) {
                Definitions.getParam((Part[])output.getPart(), (String)"certpas").setValue("*");
            }
        }
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)this.getFilterErrorCodeList());
        if (2 == Integer.parseInt(this.outputData.getErrorMessage().getErrorcode())) {
            return;
        }
        try {
            this.definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse QxDesFile fail!", (Throwable)e);
        }
        operationList.clear();
        ArrayList rowList = this.outputData.getBussinessParams().getRowParamList();
        Operation oper = this.definitions.getOperation("NSCMD_PTN_PORT_GET_NAME");
        Input input = oper.getInput();
        input.setPartValue("slotid", this.INVALID_SLOTID);
        input.setPartValue("subslotid", "255");
        input.setPartValue("port", "0");
        operationList.add(oper);
        int result = this.sendMessage(neid);
        if (result != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            return;
        }
        Operation tmpOper = (Operation)operationList.get(0);
        Output[] output = tmpOper.getOutput();
        for (Fault fault : output[0].getFault()) {
            int code = Integer.parseInt(fault.getCode());
            if (code == 0) continue;
            ErrorMessage bigErr = TEErrorResourceUtil.getErrorMessage((int)1);
            this.outputData.setErrorMessage(bigErr);
            return;
        }
        TEPTNUtil ptnUtil = TEPTNUtil.instance();
        ptnUtil.processMPAndVEthnetPortName(rowList, output);
    }

    public List<TELogInfo> getLogInfoList(Datainterface inputData) {
        return this.getSingletonLogInfo(inputData);
    }
}

