/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.controlplaneconfig.routeprotocol;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.io.File;
import java.util.ArrayList;

public class TECreateStaticRouteBean
extends TENEExplorerBean {
    private final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private final String CREATE_ROUTE_RES = "ptn" + File.separator + "res" + File.separator + "controlplaneconfig" + File.separator + "routeprotocol" + File.separator + "createstaticroute_" + this.LANGUAGE + ".ini";
    private Definitions definitions = null;
    private String INVALID_SLOTID = "65535";
    private String INVALID_SUBSLOTID = "255";
    private static final int LENGTH_WITH_SUBBOARD = 4;
    private static final int SUBBOARDINDEX = 2;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        String neVersion = ne.getHostVersion();
        if (neVersion.indexOf("58.01") >= 0 || neVersion.indexOf("59.01") >= 0) {
            this.INVALID_SLOTID = "255";
        }
        this.operationList = new ArrayList();
        this.outputData = new Datainterface();
        BussinessParams businessparams = inputData.getBussinessParams();
        try {
            this.definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
        }
        this.getCreateStaticRouteOper(businessparams, subFunc);
        if (null == this.operationList || this.operationList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        int result = this.sendMessage(neid);
        if (result == 0) {
            ArrayList filterErrorCodeList = this.getFilterErrorCodeList();
            this.handleMessage(neid, this.operationList, subFunc, filterErrorCodeList);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private void getCreateStaticRouteOper(BussinessParams bussinessparams, SubFunc subFunc) {
        RowParams rowparams = bussinessparams.getRowParams(0);
        Operation oper = this.definitions.getOperation(this.subfunc.getQxMapping(0).getContent());
        Input input = oper.getInput();
        input.setPartValue("routeID", rowparams.getParam("routeID").getValue());
        String boardInfo = rowparams.getParam("board").getValue();
        TEResourceUtil res = TEGetFilePath.getResource((int)this.neid, (String)this.CREATE_ROUTE_RES);
        if ("ML-PPP".equals(boardInfo) || "Virtual Ethernet".equals(boardInfo) || res.getString("innerVirtualPort").equals(boardInfo)) {
            input.setPartValue("slotid", "65535");
            input.setPartValue("subslotid", this.INVALID_SUBSLOTID);
        } else {
            String[] board = boardInfo.split("-");
            input.setPartValue("slotid", board[0]);
            String subslotid = this.INVALID_SUBSLOTID;
            if (4 == board.length) {
                subslotid = board[2];
            }
            input.setPartValue("subslotid", subslotid);
        }
        input.setPartValue("port", rowparams.getParam("port").getValue());
        input.setPartValue("nextHop", this.convertIPAddress(rowparams.getParam("nextHop").getValue()));
        input.setPartValue("aimNode", this.convertIPAddress(rowparams.getParam("aimNode").getValue()));
        input.setPartValue("aimNodeCode", this.convertIPAddress(rowparams.getParam("aimNodeCode").getValue()));
        if (oper.getName().equals("NSCMD_IP_ROUTE_ADD_STATICROUTE_EXPAND")) {
            input.setPartValue("cost", rowparams.getParam("cost").getValue());
        }
        this.operationList.add(oper);
    }

    private String convertIPAddress(String str) {
        StringBuffer ipAddress = new StringBuffer();
        String[] ipAddressArry = str.replace('.', '-').split("-");
        int len = ipAddressArry.length;
        for (int i = 0; i < len; ++i) {
            ipAddressArry[i] = Integer.toHexString(Integer.parseInt(ipAddressArry[i]));
            if (2 > ipAddressArry[i].length()) {
                ipAddressArry[i] = "0" + ipAddressArry[i];
            }
            ipAddress.append(ipAddressArry[i]);
        }
        return ipAddress.toString();
    }

    public String getDetailStr(RowParams rowparams) {
        StringBuffer operDesc = new StringBuffer();
        TEResourceUtil res = TEGetFilePath.getResource((int)this.neid, (String)this.CREATE_ROUTE_RES);
        operDesc.append(res.getString("routeID")).append(":").append(rowparams.getParam("routeID").getValue()).append(" ");
        operDesc.append(rowparams.getParam("board").getValue()).append("-");
        operDesc.append(rowparams.getParam("portName").getValue()).append(" ");
        operDesc.append(res.getString("nextHop")).append(":").append(rowparams.getParam("nextHop").getValue()).append(" ").append(res.getString("aimNode")).append(":").append(rowparams.getParam("aimNode").getValue()).append(" ").append(res.getString("aimNodeCode")).append(":").append(rowparams.getParam("aimNodeCode").getValue()).append(" ");
        Operation oper = this.definitions.getOperation(this.subfunc.getQxMapping(0).getContent());
        if (oper.getName().equals("NSCMD_IP_ROUTE_ADD_STATICROUTE_EXPAND")) {
            operDesc.append(res.getString("cost")).append(":").append(rowparams.getParam("cost").getValue()).append(" ");
        }
        return operDesc.toString();
    }
}

