/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.controlplaneconfig.routemanage;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.util.convertor.IPAddressUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;

public class TEQueryTunnelBind
extends TENEExplorerBean {
    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        operationList.clear();
        if (2 == Integer.parseInt(this.outputData.getErrorMessage().getErrorcode())) {
            return;
        }
        BussinessParams bussinessParams = this.outputData.getBussinessParams();
        RowParams rowParams = null;
        Param tunnelIndex = null;
        int len = bussinessParams.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            rowParams = bussinessParams.getRowParams(i);
            tunnelIndex = rowParams.getParam("tunnelIndex");
            this.processTunnelInfo(tunnelIndex, rowParams);
        }
    }

    private void processTunnelInfo(Param tunnelIndex, RowParams rowParams) {
        ArrayList<Operation> tunnelInfoList = new ArrayList<Operation>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_MPLS_GET_TUNNEL");
        Input input = oper.getInput();
        input.setPartValue("tunnelIndex", tunnelIndex.getValue());
        tunnelInfoList.add(oper);
        int result = this.sendMessage(this.neid, tunnelInfoList);
        if (result != 0) {
            return;
        }
        Operation tmpOper = (Operation)tunnelInfoList.get(0);
        Output output = tmpOper.getOutput()[0];
        String code = output.getFault()[0].getCode();
        if (null == code || Integer.parseInt(code) != 0) {
            return;
        }
        Param tunnelIDParam = new Param("tunnelID", output.getPartValue("tunnelID"));
        rowParams.addParam(tunnelIDParam);
        long ingressID = Long.valueOf(output.getPartValue("ingressID"));
        Param ingressIDParam = new Param("ingressID", IPAddressUtil.convertIPLongToStr((long)ingressID));
        rowParams.addParam(ingressIDParam);
        long egressID = Long.valueOf(output.getPartValue("egressID"));
        Param egressIDParam = new Param("egressID", IPAddressUtil.convertIPLongToStr((long)egressID));
        rowParams.addParam(egressIDParam);
        Param tunnelNameParam = new Param("tunnelName", output.getPartValue("tunnelName").trim());
        rowParams.addParam(tunnelNameParam);
    }
}

