/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.controlplaneconfig.routemanage;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.convertor.IPAddressUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.util.ArrayList;

public class TEQueryCross
extends TENEExplorerBean {
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String RES = "ptn" + File.separator + "res" + File.separator + "controlplaneconfig" + File.separator + "routemanage" + File.separator + "routemanage_" + LANGUAGE + ".ini";
    private TEResourceUtil resourceUtil;
    private static final String INGRESS = "1";

    public TEQueryCross() {
        this.resourceUtil = TEGetFilePath.getResource((int)this.neid, (String)RES);
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        operationList.clear();
        if (2 == Integer.parseInt(this.outputData.getErrorMessage().getErrorcode())) {
            return;
        }
        BussinessParams bussinessParams = this.outputData.getBussinessParams();
        RowParams rowParams = null;
        Param tunnelIndex = null;
        Param nextHopIP = null;
        Param vrf = null;
        int len = bussinessParams.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            rowParams = bussinessParams.getRowParams(i);
            tunnelIndex = rowParams.getParam("egressTunnel");
            this.processTunnelInfo(tunnelIndex);
            nextHopIP = rowParams.getParam("nextHopIP");
            nextHopIP.setValue(IPAddressUtil.convertIPLongToStr((long)Long.valueOf(nextHopIP.getValue())));
            vrf = rowParams.getParam("vrf");
            if (0xFFFFFFFFL == Long.valueOf(vrf.getValue())) {
                String crossType = rowParams.getParam("crossType").getValue();
                if (INGRESS.equals(crossType)) {
                    vrf.setValue("-");
                    continue;
                }
                vrf.setValue(this.resourceUtil.getString("publicVPN"));
                continue;
            }
            this.processVRFInfo(vrf);
        }
    }

    private void processTunnelInfo(Param tunnelIndex) {
        if (Long.valueOf(tunnelIndex.getValue()) == 0xFFFFFFFFL) {
            tunnelIndex.setValue("-");
            return;
        }
        ArrayList<Operation> tunnelInfoList = new ArrayList<Operation>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_MPLS_GET_TUNNEL");
        Input input = oper.getInput();
        input.setPartValue("tunnelIndex", tunnelIndex.getValue());
        tunnelInfoList.add(oper);
        int result = this.sendMessage(this.neid, tunnelInfoList);
        if (result != 0) {
            return;
        }
        Operation tmpOper = (Operation)tunnelInfoList.get(0);
        Output output = tmpOper.getOutput()[0];
        String code = output.getFault()[0].getCode();
        if (null == code || Integer.parseInt(code) != 0) {
            return;
        }
        long tunnelID = Long.valueOf(output.getPartValue("tunnelID"));
        long ingressID = Long.valueOf(output.getPartValue("ingressID"));
        long egressID = Long.valueOf(output.getPartValue("egressID"));
        String tunnelInfo = tunnelID + "(" + this.resourceUtil.getString("sourceNode") + ":" + IPAddressUtil.convertIPLongToStr((long)ingressID) + "," + this.resourceUtil.getString("sinkNode") + ":" + IPAddressUtil.convertIPLongToStr((long)egressID) + ")";
        tunnelIndex.setValue(tunnelInfo);
    }

    private void processVRFInfo(Param vrf) {
        ArrayList<Operation> vrfInfoList = new ArrayList<Operation>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_L3VPN_GET_VRF_INSTANCE");
        Input input = oper.getInput();
        input.setPartValue("vrfIndex", vrf.getValue());
        vrfInfoList.add(oper);
        int result = this.sendMessage(this.neid, vrfInfoList);
        if (result != 0) {
            return;
        }
        Operation tmpOper = (Operation)vrfInfoList.get(0);
        Output output = tmpOper.getOutput()[0];
        String code = output.getFault()[0].getCode();
        if (null == code || Integer.parseInt(code) != 0) {
            return;
        }
        long vrfID = Long.valueOf(output.getPartValue("vrfID"));
        String serviceName = output.getPartValue("name").trim();
        String vrfInfo = vrfID + "(" + serviceName + ")";
        vrf.setValue(vrfInfo);
    }
}

