/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.controlplaneconfig.pingtraceroute;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nemgr.ptn.controlplaneconfig.pingtraceroute.TETraceRouteEnd;
import com.huawei.nglct.nemgr.ptn.controlplaneconfig.pingtraceroute.TETraceRouteResponse;
import com.huawei.nglct.nemgr.ptn.controlplaneconfig.pingtraceroute.TETraceRouteTimeOut;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TETraceRouteProcess {
    private List resList = null;
    private List outTimeList = null;
    private List statList = null;
    private static Map<Integer, TETraceRouteProcess> reportMap = new HashMap<Integer, TETraceRouteProcess>();
    private TETraceRouteNoticeHandler traceTestNotice = null;
    private boolean hasRegister = false;
    private Object lock = new Object();
    private int neid;

    public void setNeid(int neid) {
        this.neid = neid;
    }

    public synchronized List getResData() {
        return this.resList;
    }

    public synchronized List getOutTimeData() {
        return this.outTimeList;
    }

    public synchronized List getStatData() {
        return this.statList;
    }

    public static TETraceRouteProcess getTraceRouteProcess(int neid) {
        Integer key = neid;
        TETraceRouteProcess ptr = null;
        if (reportMap.containsKey(key)) {
            return reportMap.get(key);
        }
        ptr = new TETraceRouteProcess(neid);
        reportMap.put(key, ptr);
        return ptr;
    }

    private TETraceRouteProcess(int neid) {
        this.neid = neid;
        this.resList = new ArrayList();
        this.outTimeList = new ArrayList();
        this.statList = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener() {
        Object object = this.lock;
        synchronized (object) {
            this.traceTestNotice = new TETraceRouteNoticeHandler();
            try {
                TENECommMgr.getInstance().registerListener(TECreateObjectFactory.getOperation((int)this.neid, (String)"NSEVT_PTN_ROUTE_TRACEROUTE_RSP"), (NoticeHandler)this.traceTestNotice);
                TENECommMgr.getInstance().registerListener(TECreateObjectFactory.getOperation((int)this.neid, (String)"NSEVT_PTN_ROUTE_TRACEROUTE_END"), (NoticeHandler)this.traceTestNotice);
                TENECommMgr.getInstance().registerListener(TECreateObjectFactory.getOperation((int)this.neid, (String)"NSEVT_PTN_ROUTE_TRACEROUTE_OUTTIME"), (NoticeHandler)this.traceTestNotice);
                this.hasRegister = true;
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("TETraceRouteProcess registerListener error!", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(int neid) {
        Object object = this.lock;
        synchronized (object) {
            TENECommMgr.getInstance().unregisterListener(TECreateObjectFactory.getOperation((int)neid, (String)"NSEVT_PTN_ROUTE_TRACEROUTE_RSP"), (NoticeHandler)this.traceTestNotice);
            TENECommMgr.getInstance().unregisterListener(TECreateObjectFactory.getOperation((int)neid, (String)"NSEVT_PTN_ROUTE_TRACEROUTE_END"), (NoticeHandler)this.traceTestNotice);
            TENECommMgr.getInstance().unregisterListener(TECreateObjectFactory.getOperation((int)neid, (String)"NSEVT_PTN_ROUTE_TRACEROUTE_OUTTIME"), (NoticeHandler)this.traceTestNotice);
            this.hasRegister = false;
        }
    }

    public boolean hasRegisterd() {
        return this.hasRegister;
    }

    public void clear() {
        this.resList.clear();
        this.outTimeList.clear();
        this.statList.clear();
    }

    public void cleardata(int neid) {
        if (reportMap.containsKey(neid)) {
            reportMap.get(neid).clear();
            reportMap.remove(neid);
        }
    }

    class TETraceRouteNoticeHandler
    implements NoticeHandler {
        TETraceRouteNoticeHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleNotice(int cmdkey, int neID, Operation operation) {
            String operName = operation.getName();
            Object object = TETraceRouteProcess.this.lock;
            synchronized (object) {
                if ("NSEVT_PTN_ROUTE_TRACEROUTE_RSP".equals(operName)) {
                    this.processTraceRouteRsp(neID, operation);
                } else if ("NSEVT_PTN_ROUTE_TRACEROUTE_END".equals(operName)) {
                    this.processTraceRouteStat(neID, operation);
                } else if ("NSEVT_PTN_ROUTE_TRACEROUTE_OUTTIME".equals(operName)) {
                    this.processTraceRouteOutTime(neID, operation);
                }
            }
        }

        private void processTraceRouteRsp(int neid, Operation oper) {
            Output[] outputArr = oper.getOutput();
            int len = outputArr.length;
            for (int i = 0; i < len; ++i) {
                TETraceRouteResponse data = new TETraceRouteResponse();
                data.setDestipaddress(outputArr[i].getPart("destipaddress").getValue());
                data.setFirstdelay(outputArr[i].getPart("firstdelay").getValue());
                data.setMidipaddress(outputArr[i].getPart("midipaddress").getValue());
                data.setPackageseq(outputArr[i].getPart("packageseq").getValue());
                data.setSeconddelay(outputArr[i].getPart("seconddelay").getValue());
                data.setThirddelay(outputArr[i].getPart("thirddelay").getValue());
                data.setNeid(neid);
                TETraceRouteProcess.this.getResData().add(data);
            }
        }

        private void processTraceRouteOutTime(int neid, Operation oper) {
            Output[] outputArr = oper.getOutput();
            int len = outputArr.length;
            for (int i = 0; i < len; ++i) {
                TETraceRouteTimeOut data = new TETraceRouteTimeOut();
                data.setDestipAddress(outputArr[i].getPart("destipaddress").getValue());
                data.setNeid(neid);
                TETraceRouteProcess.this.getOutTimeData().add(data);
            }
        }

        private void processTraceRouteStat(int neid, Operation oper) {
            Output[] outputArr = oper.getOutput();
            int len = outputArr.length;
            for (int i = 0; i < len; ++i) {
                TETraceRouteEnd data = new TETraceRouteEnd();
                data.setDestipAddress(outputArr[i].getPart("destipaddress").getValue());
                data.setNeid(neid);
                TETraceRouteProcess.this.getStatData().add(data);
            }
        }
    }
}

