/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.controlplaneconfig.pingtraceroute;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.QxMapping;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.ptn.controlplaneconfig.pingtraceroute.TEPingProcess;
import com.huawei.nglct.nemgr.ptn.controlplaneconfig.pingtraceroute.TEPingResponse;
import com.huawei.nglct.nemgr.ptn.controlplaneconfig.pingtraceroute.TEPingStatistic;
import com.huawei.nglct.nemgr.ptn.controlplaneconfig.pingtraceroute.TEPingTimeOut;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TEPingTestBean
extends TENEExplorerBean {
    public static final int START_PING = 1;
    public static final int STOP_PING = 2;
    public static final int REFRESH_PING = 3;
    private int configKey;
    private boolean finish = false;
    private String inputAddress = null;
    public static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String RESFILE = "ptn" + File.separator + "res" + File.separator + "controlplaneconfig" + File.separator + "pingtraceroute" + File.separator + "pingtraceroute_" + LANGUAGE + ".ini";
    public static TEResourceUtil resourceUtil = null;
    private static final int PING_NOT_EXIST = 43767;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        RowParams rowParams = inputData.getBussinessParams().getRowParams(0);
        this.inputAddress = rowParams.getParam("destip_bak").getValue();
        resourceUtil = TEGetFilePath.getResource((int)neid, (String)RESFILE);
        this.configKey = Integer.valueOf(rowParams.getParam("configKey").getValue());
        if (this.configKey == 1) {
            TEPingProcess process = TEPingProcess.getPingProcess(neid);
            if (!process.isRegisterd()) {
                process.registerListener();
            }
            process.clear();
        }
        if (3 == this.configKey) {
            this.handleMessage(neid, this.operationList, this.subfunc);
            return this.outputData;
        }
        if (null != rowParams.getParam("sourceipaddress")) {
            QxMapping qxMapping = new QxMapping();
            qxMapping.setContent("NSCMD_PTN_L3VPN_START_PING_EX");
            subFunc.setQxMapping(0, qxMapping);
        }
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        switch (this.configKey) {
            case 1: {
                super.handleMessage(neid, operationList, subfunc);
                break;
            }
            case 3: {
                this.outputData = new Datainterface();
                BussinessParams bussiness = new BussinessParams();
                TEPingProcess process = TEPingProcess.getPingProcess(neid);
                this.add(process, bussiness, neid);
                this.outputData.setBussinessParams(bussiness);
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
                break;
            }
            default: {
                super.handleMessage(neid, operationList, subfunc);
            }
        }
    }

    private void add(TEPingProcess process, BussinessParams bussiness, int neid) {
        int i;
        List resList = process.getResData();
        List outTimeList = process.getOutTimeData();
        List statList = process.getStatData();
        StringBuilder str = new StringBuilder("");
        RowParams rowdata = new RowParams();
        Param param = new Param();
        param.setName("content");
        int len = resList.size();
        for (i = 0; i < len; ++i) {
            TEPingResponse response = (TEPingResponse)resList.get(i);
            if (response.getNeid() != neid || !response.getDestipAddress().equals(this.inputAddress)) continue;
            str.append(resList.get(i).toString());
        }
        len = outTimeList.size();
        for (i = 0; i < len; ++i) {
            TEPingTimeOut outTimeData = (TEPingTimeOut)outTimeList.get(i);
            if (outTimeData.getNeid() != neid || !outTimeData.getDestipAddress().equals(this.inputAddress)) continue;
            str.append(outTimeList.get(i).toString());
        }
        len = statList.size();
        for (i = 0; i < len; ++i) {
            TEPingStatistic statictic = (TEPingStatistic)statList.get(i);
            if (statictic.getNeid() != neid || !statictic.getDestipAddress().equals(this.inputAddress)) continue;
            str.append(statList.get(i).toString());
            this.finish = true;
        }
        param.setValue(str.toString());
        rowdata.addParam(param);
        param = new Param();
        param.setName("endFlg");
        param.setValue("0");
        if (!statList.isEmpty() && this.finish) {
            param.setValue("1");
            process.unregister(neid);
            process.cleardata(neid);
        }
        rowdata.addParam(param);
        bussiness.addRowParams(rowdata);
    }

    public ArrayList<Integer> getFilterErrorCodeList() {
        ArrayList<Integer> filterlist = new ArrayList<Integer>();
        filterlist.add(43767);
        return filterlist;
    }
}

