/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.controlplaneconfig.pingtraceroute;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nemgr.ptn.controlplaneconfig.pingtraceroute.TEPingResponse;
import com.huawei.nglct.nemgr.ptn.controlplaneconfig.pingtraceroute.TEPingStatistic;
import com.huawei.nglct.nemgr.ptn.controlplaneconfig.pingtraceroute.TEPingTimeOut;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TEPingProcess {
    private List pingResList = null;
    private List pingOutTimeList = null;
    private List pingStatList = null;
    private TEPingTestNoticeHandler PingTestNotice = null;
    private int neid;
    private Object lock = new Object();
    private boolean isRegister = false;
    private static Map<Integer, TEPingProcess> reportMap = new HashMap<Integer, TEPingProcess>();
    private String NSEVT_PTN_ROUTE_PING_STATISTIC = "NSEVT_PTN_ROUTE_PING_STATISTIC";
    private String NSEVT_PTN_ROUTE_PING_RSP = "NSEVT_PTN_ROUTE_PING_RSP";
    private String NSEVT_PTN_ROUTE_PING_OUTTIME = "NSEVT_PTN_ROUTE_PING_OUTTIME";

    public void setNeid(int neid) {
        this.neid = neid;
    }

    public List getResData() {
        return this.pingResList;
    }

    public List getOutTimeData() {
        return this.pingOutTimeList;
    }

    public List getStatData() {
        return this.pingStatList;
    }

    public static synchronized TEPingProcess getPingProcess(int neid) {
        Integer key = neid;
        TEPingProcess ptr = null;
        if (reportMap.containsKey(key)) {
            return reportMap.get(key);
        }
        ptr = new TEPingProcess(neid);
        reportMap.put(key, ptr);
        return ptr;
    }

    private TEPingProcess(int neid) {
        this.neid = neid;
        this.pingResList = new ArrayList();
        this.pingOutTimeList = new ArrayList();
        this.pingStatList = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener() {
        if (this.isRegister) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.PingTestNotice = new TEPingTestNoticeHandler();
            try {
                TENECommMgr.getInstance().registerListener(TECreateObjectFactory.getOperation((int)this.neid, (String)this.NSEVT_PTN_ROUTE_PING_RSP), (NoticeHandler)this.PingTestNotice);
                TENECommMgr.getInstance().registerListener(TECreateObjectFactory.getOperation((int)this.neid, (String)this.NSEVT_PTN_ROUTE_PING_STATISTIC), (NoticeHandler)this.PingTestNotice);
                TENECommMgr.getInstance().registerListener(TECreateObjectFactory.getOperation((int)this.neid, (String)this.NSEVT_PTN_ROUTE_PING_OUTTIME), (NoticeHandler)this.PingTestNotice);
                this.isRegister = true;
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("TEPingTestProcess registerListener error!", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(int neid) {
        Object object = this.lock;
        synchronized (object) {
            TENECommMgr.getInstance().unregisterListener(TECreateObjectFactory.getOperation((int)neid, (String)this.NSEVT_PTN_ROUTE_PING_RSP), (NoticeHandler)this.PingTestNotice);
            TENECommMgr.getInstance().unregisterListener(TECreateObjectFactory.getOperation((int)neid, (String)this.NSEVT_PTN_ROUTE_PING_STATISTIC), (NoticeHandler)this.PingTestNotice);
            TENECommMgr.getInstance().unregisterListener(TECreateObjectFactory.getOperation((int)neid, (String)this.NSEVT_PTN_ROUTE_PING_OUTTIME), (NoticeHandler)this.PingTestNotice);
            this.isRegister = false;
        }
    }

    public boolean isRegisterd() {
        return this.isRegister;
    }

    public void clear() {
        this.pingResList.clear();
        this.pingOutTimeList.clear();
        this.pingStatList.clear();
    }

    public synchronized void cleardata(int neid) {
        if (reportMap.containsKey(neid)) {
            reportMap.get(neid).clear();
            reportMap.remove(neid);
        }
    }

    class TEPingTestNoticeHandler
    implements NoticeHandler {
        TEPingTestNoticeHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleNotice(int cmdkey, int neID, Operation operation) {
            String operName = operation.getName();
            Object object = TEPingProcess.this.lock;
            synchronized (object) {
                if (TEPingProcess.this.NSEVT_PTN_ROUTE_PING_RSP.equals(operName)) {
                    this.processPingRsp(neID, operation);
                } else if (TEPingProcess.this.NSEVT_PTN_ROUTE_PING_STATISTIC.equals(operName)) {
                    this.processPingStat(neID, operation);
                } else if (TEPingProcess.this.NSEVT_PTN_ROUTE_PING_OUTTIME.equals(operName)) {
                    this.processPingOutTime(neID, operation);
                } else {
                    TELogFactory.getNormalLogger().error("Ping Test operName : " + operName);
                }
            }
        }

        private void processPingRsp(int neid, Operation oper) {
            Output[] outputArr = oper.getOutput();
            int len = outputArr.length;
            for (int i = 0; i < len; ++i) {
                TEPingResponse data = new TEPingResponse();
                data.setDelayTime(outputArr[i].getPart("delaytime").getValue());
                data.setDestipAddress(outputArr[i].getPart("destipaddress").getValue());
                data.setPackageLen(outputArr[i].getPart("packagelen").getValue());
                data.setPackageSeq(outputArr[i].getPart("packageseq").getValue());
                data.setTtl(outputArr[i].getPart("ttl").getValue());
                data.setNeid(neid);
                TEPingProcess.this.getResData().add(data);
            }
        }

        private void processPingOutTime(int neid, Operation oper) {
            Output[] outputArr = oper.getOutput();
            int len = outputArr.length;
            for (int i = 0; i < len; ++i) {
                TEPingTimeOut data = new TEPingTimeOut();
                data.setDestipAddress(outputArr[i].getPart("destipaddress").getValue());
                data.setPackageseq(outputArr[i].getPart("packageseq").getValue());
                data.setPackagelen(outputArr[i].getPart("packagelen").getValue());
                data.setNeid(neid);
                TEPingProcess.this.getOutTimeData().add(data);
            }
        }

        private void processPingStat(int neid, Operation oper) {
            Output[] outputArr = oper.getOutput();
            int len = outputArr.length;
            for (int i = 0; i < len; ++i) {
                TEPingStatistic data = new TEPingStatistic();
                data.setDestipAddress(outputArr[i].getPart("destipaddress").getValue());
                data.setAverdelay(outputArr[i].getPart("averdelay").getValue());
                data.setLossrate(outputArr[i].getPart("lossrate").getValue());
                data.setMaxdelay(outputArr[i].getPart("maxdelay").getValue());
                data.setMindelay(outputArr[i].getPart("mindelay").getValue());
                data.setRxnum(outputArr[i].getPart("rxnum").getValue());
                data.setTxnum(outputArr[i].getPart("txnum").getValue());
                data.setNeid(neid);
                TEPingProcess.this.getStatData().add(data);
            }
        }
    }
}

