/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.controlplaneconfig.ospfprotocol_u2kv1r2c00;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.util.ArrayList;

public class TEcreateOSPFBean
extends TENEExplorerBean {
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String OSPF_PROTOCOL_RES = "ptn" + File.separator + "res" + File.separator + "controlplaneconfig" + File.separator + "ospfprotocol_" + LANGUAGE + ".ini";
    private TEResourceUtil resourceUtil = null;
    private Definitions definitions = null;
    private ArrayList rowErrorList = new ArrayList();
    private int TIMEOUT = 20;
    private String ospfID = "0";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.operationList = new ArrayList();
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        try {
            this.definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
        }
        int resultCode = -1;
        resultCode = this.createOspfInstance();
        if (resultCode != 0) {
            ErrorMessage bigErr = TEErrorResourceUtil.getErrorMessage((int)resultCode);
            this.outputData.setErrorMessage(bigErr);
            int size = this.rowErrorList.size();
            for (int i = 0; i < size; ++i) {
                RowParams rParam = new RowParams();
                RowErrors rError = (RowErrors)this.rowErrorList.get(i);
                rParam.addRowErrors(rError);
                this.outputData.getBussinessParams().addRowParams(rParam);
            }
            return this.outputData;
        }
        this.fillOperList();
        if (null == this.operationList || this.operationList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        int result = this.sendMessage(neid);
        if (result == 0) {
            this.handleMessage(neid, this.operationList, subFunc);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private void fillOperList() {
        RowParams rowparams = this.inputData.getBussinessParams().getRowParams(0);
        Operation oper = this.definitions.getOperation("NSCMD_OSPF_SET_SPFDELAY");
        Input input = oper.getInput();
        input.setPartValue("flag", rowparams.getParam("flag").getValue());
        input.setPartValue("ospfID", this.ospfID);
        input.setPartValue("spfinterval", rowparams.getParam("spfinterval").getValue());
        this.operationList.add(oper);
        oper = this.definitions.getOperation("NSCMD_OSPF_SET_TEENABLE");
        input = oper.getInput();
        input.setPartValue("flag", rowparams.getParam("flag").getValue());
        input.setPartValue("ospfID", this.ospfID);
        input.setPartValue("teEnable", rowparams.getParam("teEnable").getValue());
        this.operationList.add(oper);
        oper = this.definitions.getOperation("NSCMD_PTN_OSPF_SET_GR_ENABLE");
        input = oper.getInput();
        input.setPartValue("flag", rowparams.getParam("flag").getValue());
        input.setPartValue("ospfID", this.ospfID);
        input.setPartValue("grEnable", rowparams.getParam("restarterEnable").getValue());
        this.operationList.add(oper);
        if (!rowparams.getParam("restarterEnable").getValue().equals("0")) {
            oper = this.definitions.getOperation("NSCMD_PTN_OSPF_SET_GR_TIME");
            input = oper.getInput();
            input.setPartValue("flag", rowparams.getParam("flag").getValue());
            input.setPartValue("ospfID", this.ospfID);
            input.setPartValue("grTime", rowparams.getParam("restarterGrTime").getValue());
            this.operationList.add(oper);
        }
    }

    private int createOspfInstance() {
        int resultNode = 0;
        ArrayList<Operation> operList = new ArrayList<Operation>();
        Operation oper = this.definitions.getOperation("NSCMD_PROT_CRT_OSPF");
        Input input = oper.getInput();
        input.setPartValue("flag1", "0");
        int count = this.inputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < count; ++i) {
            RowParams rowparams = this.inputData.getBussinessParams().getRowParams(i);
            input.setPartValue("vpnID", rowparams.getParam("vpnID").getValue());
            input.setPartValue("flag", rowparams.getParam("flag").getValue());
            input.setPartValue("ospfID", rowparams.getParam("ospfID").getValue());
        }
        operList.add(oper);
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, operList, this.TIMEOUT);
        if (result.retCode != 0) {
            return result.retCode;
        }
        Operation tmpOper = (Operation)operList.get(0);
        for (Output output : tmpOper.getOutput()) {
            for (Fault fault : output.getFault()) {
                int code = Integer.parseInt(fault.getCode());
                if (code != 0) {
                    return code;
                }
                this.ospfID = output.getPart("ospfID").getValue();
            }
        }
        operList.clear();
        return resultNode;
    }

    public String getDetailStr(RowParams rowparams) {
        String reskey;
        this.resourceUtil = TEGetFilePath.getResource((int)this.neid, (String)OSPF_PROTOCOL_RES);
        StringBuffer operDesc = new StringBuffer();
        String ospfID = rowparams.getParam("ospfID").getValue();
        if ("0".equals(ospfID)) {
            ospfID = this.resourceUtil.getString("auto");
        }
        operDesc.append(this.resourceUtil.getString("OSPFID")).append(":").append(ospfID).append(" ");
        Param param = rowparams.getParam("spfinterval");
        if (null != param) {
            operDesc.append(this.resourceUtil.getString("spfinterval")).append(":").append(param.getValue()).append(" ");
        }
        if (null != (param = rowparams.getParam("teEnable"))) {
            reskey = "teEnable" + param.getValue();
            operDesc.append(this.resourceUtil.getString("teEnable")).append(":").append(this.resourceUtil.getString(reskey)).append(" ");
        }
        if (null != (param = rowparams.getParam("restarterEnable"))) {
            reskey = "restarterEnable" + param.getValue();
            operDesc.append(this.resourceUtil.getString("restarterEnable")).append(":").append(this.resourceUtil.getString(reskey)).append(" ");
        }
        if (null != (param = rowparams.getParam("restarterGrTime"))) {
            operDesc.append(this.resourceUtil.getString("restarterGrTime")).append(":").append(this.resourceUtil.getString(param.getValue())).append(" ");
        }
        return operDesc.toString();
    }
}

