/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.controlplaneconfig.ospfprotocol_u2kv1r2c00;

import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEConvertUtil;
import com.huawei.nglct.util.string.TEResourceUtil;

public class TEcreateInterfaceBean
extends TENEExplorerBean {
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String OSPF_PROTOCOL_RES = "ptn/res/controlplaneconfig/ospfprotocol_" + LANGUAGE + ".ini";
    private TEResourceUtil resourceUtil = null;
    private static final int INVALID_VALUE = 255;
    private static final int MLPPP = 4096;
    private static final int VIRTUAL_PORT = 10240;
    private static final int SERIALPORT = 6144;

    public String getDetailStr(RowParams rowparams) {
        this.resourceUtil = TEGetFilePath.getResource((int)this.neid, (String)OSPF_PROTOCOL_RES);
        TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
        StringBuffer operDesc = new StringBuffer();
        operDesc.append(this.resourceUtil.getString("ospfID")).append(":");
        operDesc.append(rowparams.getParam("ospfID").getValue()).append(" ");
        operDesc.append(this.resourceUtil.getString("areaid")).append(":");
        operDesc.append(TEConvertUtil.convertHexIptoTen((String)rowparams.getParam("areaid").getValue())).append(" ");
        int port = 0;
        if (rowparams.getParam("port") != null && rowparams.getParam("port").getValue() != null) {
            port = Integer.parseInt(rowparams.getParam("port").getValue());
        }
        if (4096 <= port && 6144 > port) {
            operDesc.append("MLPPP-").append(port - 4096);
        } else if (10240 <= port) {
            operDesc.append("VEther-").append(port - 10240);
        } else {
            String portName = "";
            if (rowparams.getParam("slotid") != null && rowparams.getParam("slotid").getValue() != null) {
                String slotid = rowparams.getParam("slotid").getValue();
                int boardType = configurDataMgr.getBoard(this.neid, Integer.parseInt(slotid)).getBoardType();
                String boardName = configurDataMgr.getBoardTypeName(this.neid, boardType);
                operDesc.append(slotid).append("-").append(boardName).append("-");
                String subBaordid = rowparams.getParam("subSlotid").getValue();
                if ("255".equals(subBaordid)) {
                    portName = configurDataMgr.getPortName(this.neid, Integer.parseInt(slotid), boardType, port);
                } else {
                    int subBoardType = configurDataMgr.getSubboardType(this.neid, Integer.parseInt(slotid), Integer.parseInt(subBaordid));
                    String subBoardName = configurDataMgr.getBoardTypeName(this.neid, subBoardType);
                    portName = configurDataMgr.getPortName(this.neid, Integer.parseInt(slotid), subBoardType, port);
                    operDesc.append(subBaordid).append("-").append(subBoardName).append("-");
                }
            }
            if (6144 <= port) {
                int serialPort = port - 6144;
                portName = serialPort + "(Serial-Port-" + serialPort + ")";
            }
            operDesc.append(portName);
        }
        return operDesc.toString();
    }
}

