/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.controlplaneconfig.ospfprotocol_u2kv1r2c00;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.io.File;
import java.util.ArrayList;

public class TESetPortConfigBean
extends TENEExplorerBean {
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String OSPF_PROTOCOL_RES = "ptn" + File.separator + "res" + File.separator + "controlplaneconfig" + File.separator + "ospfprotocol_" + LANGUAGE + ".ini";
    private TEResourceUtil resourceUtil = null;
    private static final int MLPPP = 4096;
    private static final int SERIALPORT = 6144;
    private static final int VIRTUAL_PORT = 10240;

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        try {
            ArrayList operationList = TEDataConverter.convertToOperation((SubFunc)subFunc, (Datainterface)inputData, (int)neid);
            for (RowParams rowParams : inputData.getBussinessParams().getRowParams()) {
                Param helloTime_oldParam = rowParams.getParam("helloTime_old");
                Param deadintvl_oldParam = rowParams.getParam("deadintvl_old");
                if (null == helloTime_oldParam || null == deadintvl_oldParam) continue;
                Operation helloOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PROT_CONF_OSPFHELLO");
                Operation deadOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_OSPF_SET_DEADINTVL");
                int deadintvl_old = Integer.parseInt(deadintvl_oldParam.getValue());
                int helloTime_new = Integer.parseInt(rowParams.getParam("helloTime_new").getValue());
                Input input = helloOper.getInput();
                input.setPartValue("flag", rowParams.getParam("flag").getValue());
                input.setPartValue("ospfID", rowParams.getParam("ospfID").getValue());
                input.setPartValue("slotid", rowParams.getParam("slotid").getValue());
                input.setPartValue("subslotid", rowParams.getParam("subslotid").getValue());
                input.setPartValue("port", rowParams.getParam("port").getValue());
                input.setPartValue("helloTime", rowParams.getParam("helloTime_new").getValue());
                input = deadOper.getInput();
                input.setPartValue("flag", rowParams.getParam("flag").getValue());
                input.setPartValue("ospfID", rowParams.getParam("ospfID").getValue());
                input.setPartValue("slotid", rowParams.getParam("slotid").getValue());
                input.setPartValue("subslotid", rowParams.getParam("subslotid").getValue());
                input.setPartValue("port", rowParams.getParam("port").getValue());
                input.setPartValue("deadintvl", rowParams.getParam("deadintvl_new").getValue());
                if (helloTime_new >= deadintvl_old) {
                    operationList.add(operationList.size(), deadOper);
                    operationList.add(operationList.size(), helloOper);
                    continue;
                }
                operationList.add(operationList.size(), helloOper);
                operationList.add(operationList.size(), deadOper);
            }
            return operationList;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
    }

    public String getDetailStr(RowParams rowparams) {
        TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
        this.resourceUtil = TEGetFilePath.getResource((int)this.neid, (String)OSPF_PROTOCOL_RES);
        StringBuffer operDesc = new StringBuffer();
        operDesc.append(this.resourceUtil.getString("OSPFID")).append(":").append(rowparams.getParam("ospfID").getValue()).append(",");
        int port = Integer.parseInt(rowparams.getParam("port").getValue());
        if (4096 <= port && 6144 > port) {
            operDesc.append("MLPPP-").append(port - 4096);
        } else if (10240 <= port) {
            operDesc.append("VEther-").append(port - 10240);
        } else {
            String slotid = rowparams.getParam("slotid").getValue();
            int boardType = 0;
            if (configurDataMgr.getBoard(this.neid, Integer.parseInt(slotid)) != null) {
                boardType = configurDataMgr.getBoard(this.neid, Integer.parseInt(slotid)).getBoardType();
            }
            String boardName = configurDataMgr.getBoardTypeName(this.neid, boardType);
            operDesc.append(slotid).append("-").append(boardName).append("-");
            String subBaordid = rowparams.getParam("subSlotid").getValue();
            String portName = "";
            if ("255".equals(subBaordid)) {
                portName = configurDataMgr.getPortName(this.neid, Integer.parseInt(slotid), boardType, port);
            } else {
                int subBoardType = configurDataMgr.getSubboardType(this.neid, Integer.parseInt(slotid), Integer.parseInt(subBaordid));
                String subBoardName = configurDataMgr.getBoardTypeName(this.neid, subBoardType);
                portName = configurDataMgr.getPortName(this.neid, Integer.parseInt(slotid), subBoardType, port);
                operDesc.append(subBaordid).append("-").append(subBoardName).append("-");
            }
            if (6144 <= port) {
                int serialPort = port - 6144;
                portName = serialPort + "(Serial-Port-" + serialPort + ")";
            }
            operDesc.append(portName).append(" ");
        }
        this.processParam(operDesc, rowparams, "areaidstr");
        this.processParam(operDesc, rowparams, "helloTime");
        this.processParam(operDesc, rowparams, "drpriority");
        this.processParam(operDesc, rowparams, "deadintvl");
        this.processParam(operDesc, rowparams, "transitdelay");
        this.processParam(operDesc, rowparams, "retransintvl");
        this.processEnumParam(operDesc, rowparams, "ifauthtype");
        this.processEnumParam(operDesc, rowparams, "iftype");
        this.processParam(operDesc, rowparams, "ifcost");
        this.processEnumParam(operDesc, rowparams, "grhelper");
        this.processParam(operDesc, rowparams, "helperintvl");
        return operDesc.toString();
    }

    public void processParam(StringBuffer operDesc, RowParams rowparams, String fieldName) {
        Param param = rowparams.getParam(fieldName);
        if (null != param) {
            operDesc.append(this.resourceUtil.getString(fieldName)).append(":").append(param.getValue()).append(" ");
        }
    }

    public void processEnumParam(StringBuffer operDesc, RowParams rowparams, String fieldName) {
        Param param = rowparams.getParam(fieldName);
        if (null != param) {
            operDesc.append(this.resourceUtil.getString(fieldName)).append(":").append(this.resourceUtil.getString(fieldName + param.getValue())).append(" ");
        }
    }
}

