/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.controlplaneconfig.ospfprotocol_u2kv1r2c00;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;

public class TEQueryOspfPeerInfoBean
extends TENEExplorerBean {
    private Definitions definitions = null;
    private static final long PUBLIC_PROTOCOL_ID = 0xFFFFFFFFL;
    private static final int MLPPP_PORT = 4096;
    private static final int VETHNET_PORT = 10240;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        try {
            this.definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
        }
        String ospfID = this.getOspfID();
        if ("".equals(ospfID)) {
            this.outputData = new Datainterface();
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
            return this.outputData;
        }
        inputData.getBussinessParams().clearRowParams();
        RowParams onerow = new RowParams();
        onerow.addParam("neid", new Integer(neid).toString());
        onerow.addParam("ospfID", ospfID);
        onerow.addParam("slotid", "0");
        onerow.addParam("subslotid", "0");
        onerow.addParam("port", "0");
        inputData.getBussinessParams().addRowParams(onerow);
        this.operationList = this.getOperation(neid, subFunc, inputData, memeryData);
        if (null == this.operationList || this.operationList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        int result = this.sendMessage(neid);
        if (result == 0) {
            this.handleMessage(neid, this.operationList, subFunc);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private String getOspfID() {
        String ospfID = "";
        ArrayList<Operation> ospfIDList = new ArrayList<Operation>();
        Operation oper = this.definitions.getOperation("NSCMD_PTN_OSPF_GET_OSPFINSTANCE");
        Input input = oper.getInput();
        input.setPartValue("ospfID", "0");
        ospfIDList.add(oper);
        int result = this.sendMessage(this.neid, ospfIDList);
        if (result != 0) {
            return "";
        }
        Operation tmpOper = (Operation)ospfIDList.get(0);
        Output[] outputArr = tmpOper.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            long vpnID;
            boolean emptyFlag = false;
            Output output = outputArr[i];
            Fault[] faultArr = output.getFault();
            int len2 = faultArr.length;
            for (int j = 0; j < len2; ++j) {
                emptyFlag = false;
                Fault fault = faultArr[j];
                String code = fault.getCode();
                if (null != code && Integer.parseInt(code) == 0) continue;
                emptyFlag = true;
                break;
            }
            if (emptyFlag || (vpnID = Long.parseLong(output.getPartValue("vpnID"))) != 0xFFFFFFFFL) continue;
            ospfID = output.getPartValue("protocolID");
            break;
        }
        return ospfID;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)this.getFilterErrorCodeList());
        if (2 == Integer.parseInt(this.outputData.getErrorMessage().getErrorcode())) {
            return;
        }
        try {
            this.definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse QxDesFile fail!", (Throwable)e);
        }
        operationList.clear();
        ArrayList rowList = this.outputData.getBussinessParams().getRowParamList();
        Operation oper = this.definitions.getOperation("NSCMD_PTN_PORT_GET_NAME_EX");
        Input input = oper.getInput();
        input.setPartValue("slotid", "65535");
        input.setPartValue("subslotid", "255");
        input.setPartValue("port", "0");
        operationList.add(oper);
        int result = this.sendMessage(neid);
        if (result != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            return;
        }
        Operation tmpOper = (Operation)operationList.get(0);
        Output[] output = tmpOper.getOutput();
        for (Fault fault : output[0].getFault()) {
            int code = Integer.parseInt(fault.getCode());
            if (code == 0) continue;
            ErrorMessage bigErr = TEErrorResourceUtil.getErrorMessage((int)1);
            this.outputData.setErrorMessage(bigErr);
            return;
        }
        String portname = null;
        int size = rowList.size();
        block3: for (int i = 0; i < size; ++i) {
            RowParams row = (RowParams)rowList.get(i);
            if (row.getParam("slotid") == null || !row.getParam("slotid").getValue().equals("65535") || row.getParam("subslotid") == null || !row.getParam("subslotid").getValue().equals("255")) continue;
            int len = output.length;
            for (int j = 0; j < len; ++j) {
                int portId2;
                int portId = Integer.parseInt(row.getParam("port").getValue());
                if (portId != (portId2 = Integer.parseInt(output[j].getPartValue("port")))) continue;
                portname = output[j].getPartValue("portName").trim();
                if ("".equals(portname)) {
                    portname = portId >= 10240 ? portId - 10240 + "" : portId - 4096 + "";
                }
                row.getParam("portname").setValue(portname);
                continue block3;
            }
        }
    }

    public boolean isNeedOperationlog() {
        return true;
    }
}

