/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.controlplaneconfig.ospfprotocol_u2kv1r2c00;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.ptn_pub.TEPTNUtil;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.List;

public class TEQueryOSPFPortConfBean
extends TENEExplorerBean {
    private Definitions definitions = null;
    private static final long PUBLIC_PROTOCOL_ID = 0xFFFFFFFFL;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        inputData.getBussinessParams().clearRowParams();
        try {
            this.definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
        }
        String ospfID = this.getOspfID();
        if ("".equals(ospfID)) {
            this.outputData = new Datainterface();
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
            return this.outputData;
        }
        inputData.getBussinessParams().clearRowParams();
        RowParams onerow = new RowParams();
        onerow.addParam("neid", new Integer(neid).toString());
        onerow.addParam("ospfID", ospfID);
        onerow.addParam("slotid", "0");
        onerow.addParam("subslotid", "0");
        onerow.addParam("port", "0");
        inputData.getBussinessParams().addRowParams(onerow);
        this.operationList = this.getOperation(neid, subFunc, inputData, memeryData);
        if (null == this.operationList || this.operationList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        int result = this.sendMessage(neid);
        if (result == 0) {
            this.handleMessage(neid, this.operationList, subFunc);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    public int sendMessage(int neid, ArrayList operationList) {
        int retCode = 0;
        OperationResult result = TENECommMgr.getInstance().sendCommandNoLog(neid, (List)operationList, this.getTimeOut());
        if (null != result) {
            retCode = result.retCode;
        }
        return retCode;
    }

    private String getOspfID() {
        String ospfID = "";
        ArrayList<Operation> ospfIDList = new ArrayList<Operation>();
        Operation oper = this.definitions.getOperation("NSCMD_PTN_OSPF_GET_OSPFINSTANCE");
        Input input = oper.getInput();
        input.setPartValue("ospfID", "0");
        ospfIDList.add(oper);
        int result = this.sendMessage(this.neid, ospfIDList);
        if (result != 0) {
            return "";
        }
        Operation tmpOper = (Operation)ospfIDList.get(0);
        Output[] outputArr = tmpOper.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            long vpnID;
            boolean emptyFlag = false;
            Output output = outputArr[i];
            Fault[] faultArr = output.getFault();
            int len2 = faultArr.length;
            for (int j = 0; j < len2; ++j) {
                emptyFlag = false;
                Fault fault = faultArr[j];
                String code = fault.getCode();
                if (null != code && Integer.parseInt(code) == 0) continue;
                emptyFlag = true;
                break;
            }
            if (emptyFlag || (vpnID = Long.parseLong(output.getPartValue("vpnID"))) != 0xFFFFFFFFL) continue;
            ospfID = output.getPartValue("protocolID");
            break;
        }
        return ospfID;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            TELogInfo loginfo = null;
            int userID = 0;
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
            }
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            String operObj = "";
            operObj = null == neObj ? String.valueOf(neid) : neObj.getNEName();
            RowParams rowparams = null;
            RowParams errorRowParams = null;
            int tmpErrorCode = 0;
            loginfo = new TELogInfo();
            rowparams = inputData.getBussinessParams().getRowParams(0);
            loginfo.setOperateDesc(this.getDetailStr(rowparams));
            if (errorCode != 0 && errorCode != 2 && errorCode != 1) {
                loginfo.setResult(2);
                loginfo.setErrCode(errorCode);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
            } else if (errorCode == 0) {
                loginfo.setResult(0);
                loginfo.setErrCode(errorCode);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
            } else if (errorCode == 1) {
                loginfo.setResult(1);
                loginfo.setErrCode(errorCode);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
            } else {
                int outputRowCount = outputData.getBussinessParams().getRowParamsCount();
                errorRowParams = outputData.getBussinessParams().getRowParams(outputRowCount - 1);
                tmpErrorCode = this.getOperResult(rowparams, errorRowParams);
                if (tmpErrorCode != 0) {
                    loginfo.setResult(2);
                } else {
                    loginfo.setResult(0);
                }
                loginfo.setErrCode(tmpErrorCode);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)tmpErrorCode));
            }
            loginfoList.add(loginfo);
            int size = loginfoList.size();
            for (int i = 0; i < size; ++i) {
                loginfo = (TELogInfo)loginfoList.get(i);
                loginfo.setCmdID(subfunc.getCode());
                loginfo.setLocation(ipAddress);
                loginfo.setUserID(userID);
                loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
                loginfo.setOperateName(subfunc.getSubFuncDes(neid));
                loginfo.setOperateObject(operObj);
                TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        int size = operationList.size();
        for (int i = 0; i < size; ++i) {
            Operation opertion = (Operation)operationList.get(i);
            if (!"NSCMD_OSPF_GET_IFAUTH".equals(opertion.getName())) continue;
            for (Output output : opertion.getOutput()) {
                Definitions.getParam((Part[])output.getPart(), (String)"authcode").setValue("*");
            }
        }
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList);
        if (2 == Integer.parseInt(this.outputData.getErrorMessage().getErrorcode())) {
            return;
        }
        try {
            this.definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse QxDesFile fail!", (Throwable)e);
        }
        operationList.clear();
        ArrayList rowList = this.outputData.getBussinessParams().getRowParamList();
        Operation oper = this.definitions.getOperation("NSCMD_PTN_PORT_GET_NAME_EX");
        Input input = oper.getInput();
        input.setPartValue("slotid", "65535");
        input.setPartValue("subslotid", "255");
        input.setPartValue("port", "0");
        operationList.add(oper);
        int result = this.sendMessage(neid);
        if (result != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            return;
        }
        Operation tmpOper = (Operation)operationList.get(0);
        Output[] output = tmpOper.getOutput();
        for (Fault fault : output[0].getFault()) {
            int code = Integer.parseInt(fault.getCode());
            if (code == 0) continue;
            ErrorMessage bigErr = TEErrorResourceUtil.getErrorMessage((int)1);
            this.outputData.setErrorMessage(bigErr);
            return;
        }
        TEPTNUtil ptnUtil = TEPTNUtil.instance();
        ptnUtil.processMPAndVEthnetPortName(rowList, output);
    }
}

