/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.controlplaneconfig.ospfprotocol_u2kv1r2c00;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class TEGetAvaiOspfBean
extends TENEExplorerBean {
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String OSPF_PROTOCOL_RES = "ptn" + File.separator + "res" + File.separator + "controlplaneconfig" + File.separator + "ospfprotocol_" + LANGUAGE + ".ini";
    private TEResourceUtil resourceUtil = null;
    private Definitions definitions = null;
    private ArrayList rowErrorList = new ArrayList();
    private int TIMEOUT = 20;
    private static final int NULL_QUERY = 38662;
    private List ospfIDList = new ArrayList();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.operationList = new ArrayList();
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        this.resourceUtil = TEGetFilePath.getResource((int)neid, (String)OSPF_PROTOCOL_RES);
        try {
            this.definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
        }
        int resultCode = -1;
        resultCode = this.doQueryOspfIdList(this.ospfIDList);
        if (resultCode != 0 && resultCode != 38662) {
            ErrorMessage bigErr = TEErrorResourceUtil.getErrorMessage((int)resultCode);
            this.outputData.setErrorMessage(bigErr);
            int size = this.rowErrorList.size();
            for (int i = 0; i < size; ++i) {
                RowParams rParam = new RowParams();
                RowErrors rError = (RowErrors)this.rowErrorList.get(i);
                rParam.addRowErrors(rError);
                this.outputData.getBussinessParams().addRowParams(rParam);
            }
            return this.outputData;
        }
        int size = this.ospfIDList.size();
        for (int i = 0; i < size; ++i) {
            Operation oper = this.definitions.getOperation("NSCMD_OSPF_GET_AREAINFO");
            Input input = oper.getInput();
            input.setPartValue("ospfID", (String)this.ospfIDList.get(i));
            this.operationList.add(oper);
        }
        if (null == this.operationList || this.operationList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        int result = this.sendMessage(neid);
        if (result == 0 || result == 38662) {
            this.handleMessage(neid, this.operationList, subFunc);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private int doQueryOspfIdList(List idlist) {
        int resultNode = -1;
        ArrayList<Operation> operList = new ArrayList<Operation>();
        Operation oper = this.definitions.getOperation("NSCMD_PTN_OSPF_GET_OSPFINSTANCE");
        Input input = oper.getInput();
        input.setPartValue("ospfID", "0");
        operList.add(oper);
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, operList, this.TIMEOUT);
        if (result.retCode != 0) {
            return result.retCode;
        }
        Operation tmpOper = (Operation)operList.get(0);
        for (Output output : tmpOper.getOutput()) {
            for (Fault fault : output.getFault()) {
                int code = Integer.parseInt(fault.getCode());
                if (code != 0) {
                    TELogFactory.getNormalLogger().info(TEErrorResourceUtil.getErrCodeResWithDot((int)this.neid, (int)code));
                    RowErrors rowError = new RowErrors();
                    Param errorParam = new Param("errObj", this.resourceUtil.getString("queryOSPF"));
                    rowError.addParam(errorParam);
                    rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)code));
                    this.rowErrorList.add(rowError);
                    return code;
                }
                resultNode = code;
                idlist.add(output.getPart("protocolID").getValue());
            }
        }
        operList.clear();
        return resultNode;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        LinkedHashMap<String, ArrayList<String>> ospfIDMap = new LinkedHashMap<String, ArrayList<String>>();
        int size = operationList.size();
        for (int j = 0; j < size; ++j) {
            Operation oper = (Operation)operationList.get(j);
            for (Output output : oper.getOutput()) {
                for (Fault fault : output.getFault()) {
                    int code = Integer.parseInt(fault.getCode());
                    if (code != 0) continue;
                    String ospfID = output.getPart("ospfID").getValue();
                    String areaid = output.getPart("areaid").getValue();
                    ArrayList<String> areaidList = (ArrayList<String>)ospfIDMap.get(ospfID);
                    if (null == areaidList) {
                        areaidList = new ArrayList<String>();
                        ospfIDMap.put(ospfID, areaidList);
                    }
                    areaidList.add(areaid);
                }
            }
        }
        BussinessParams bParams = new BussinessParams();
        for (String ospfid : ospfIDMap.keySet()) {
            List areaidList = (List)ospfIDMap.get(ospfid);
            if (null == areaidList || areaidList.isEmpty()) continue;
            RowParams rParams = new RowParams();
            Param param = null;
            param = new Param("ospfID", ospfid);
            rParams.addParam(param);
            param = new Param("areaid", "-");
            int size1 = areaidList.size();
            for (int j = 0; j < size1; ++j) {
                Option option = new Option((String)areaidList.get(j));
                param.addOption(option);
            }
            rParams.addParam(param);
            bParams.addRowParams(rParams);
        }
        this.outputData.setBussinessParams(bParams);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

