/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.controlplaneconfig.ldpprotocol_u2kv1r2c00;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.ptn_pub.TEPTNUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Vector;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class TEQueryLDPPortBean
extends TECommonWriteLogBean {
    private Definitions definitions = null;
    private static final int ERROR_CODE_PORT_NOT_EXIST = 42165;
    private static final int VPORT_L3IF = 7;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        Vector boardlist = ne.getBoardList();
        inputData.getBussinessParams().clearRowParams();
        for (int i = 0; i < boardlist.size(); ++i) {
            RowParams onerow = new RowParams();
            onerow.addParam("neid", new Integer(neid).toString());
            onerow.addParam("slotid", new Integer(((TEBoard)boardlist.get(i)).getSlotID()).toString());
            onerow.addParam("subslotid", "0");
            onerow.addParam("port", "0");
            inputData.getBussinessParams().addRowParams(onerow);
        }
        this.addMPGroupInter(inputData);
        this.addVInter(inputData);
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    private void addMPGroupInter(Datainterface inputData) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        try {
            Definitions definitions = TECreateObjectFactory.parseQxDesFile((int)this.neid);
            Operation operation = definitions.getOperation("NSCMD_ETHN_MLPPP_GET_MP_EX");
            if (null == operation) {
                return;
            }
            Input input = operation.getInput();
            input.setPartValue("mpid", "0");
            operationList.add(operation);
            TENECommMgr.getInstance().sendCommand(this.neid, operationList, this.TIME_OUT);
            Operation tmpOper = (Operation)operationList.get(0);
            operationList.clear();
            Output[] outputArr = tmpOper.getOutput();
            Output output2 = null;
            boolean isEmpty = false;
            Fault fault2 = null;
            RowParams onerowparam = null;
            for (Output output2 : outputArr) {
                Fault[] faultArr = output2.getFault();
                isEmpty = false;
                for (Fault fault2 : faultArr) {
                    String code = fault2.getCode();
                    if (null != code && Integer.parseInt(code) == 0) continue;
                    isEmpty = true;
                    break;
                }
                if (isEmpty) continue;
                int mpid = Integer.parseInt(output2.getPartValue("mpid"));
                onerowparam = new RowParams();
                onerowparam.addParam("neid", new Integer(this.neid).toString());
                onerowparam.addParam("slotid", "65535");
                onerowparam.addParam("subslotid", "255");
                onerowparam.addParam("port", mpid + "");
                inputData.getBussinessParams().addRowParams(onerowparam);
            }
        }
        catch (MarshalException e) {
            TELogFactory.getNormalLogger().error("MarshalException:", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            TELogFactory.getNormalLogger().error("FileNotFoundException:", (Throwable)e);
        }
        catch (ValidationException e) {
            TELogFactory.getNormalLogger().error("ValidationException:", (Throwable)e);
        }
    }

    private void addVInter(Datainterface inputData) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        try {
            Definitions definitions = TECreateObjectFactory.parseQxDesFile((int)this.neid);
            Operation operation = definitions.getOperation("NSCMD_ETHN_PORT_GET_VPORT");
            Input input = operation.getInput();
            input.setPartValue("slotid", "65535");
            input.setPartValue("subslotid", "255");
            input.setPartValue("vport", "0");
            operationList.add(operation);
            TENECommMgr.getInstance().sendCommand(this.neid, operationList, this.TIME_OUT);
            Operation tmpOper = (Operation)operationList.get(0);
            operationList.clear();
            Output[] outputArr = tmpOper.getOutput();
            Output output2 = null;
            boolean isEmpty = false;
            Fault fault2 = null;
            RowParams onerowparam = null;
            for (Output output2 : outputArr) {
                int portype;
                Fault[] faultArr = output2.getFault();
                isEmpty = false;
                for (Fault fault2 : faultArr) {
                    String code = fault2.getCode();
                    if (null != code && Integer.parseInt(code) == 0) continue;
                    isEmpty = true;
                    break;
                }
                if (isEmpty || (portype = Integer.parseInt(output2.getPartValue("porttype"))) == 7) continue;
                int vport = Integer.parseInt(output2.getPartValue("vport"));
                onerowparam = new RowParams();
                onerowparam.addParam("neid", new Integer(this.neid).toString());
                onerowparam.addParam("slotid", "65535");
                onerowparam.addParam("subslotid", "255");
                onerowparam.addParam("port", vport + "");
                inputData.getBussinessParams().addRowParams(onerowparam);
            }
        }
        catch (MarshalException e) {
            TELogFactory.getNormalLogger().error("MarshalException:", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            TELogFactory.getNormalLogger().error("FileNotFoundException:", (Throwable)e);
        }
        catch (ValidationException e) {
            TELogFactory.getNormalLogger().error("ValidationException:", (Throwable)e);
        }
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)this.getFilterErrorCodeList());
        if (2 == Integer.parseInt(this.outputData.getErrorMessage().getErrorcode())) {
            return;
        }
        try {
            this.definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse QxDesFile fail!", (Throwable)e);
        }
        operationList.clear();
        ArrayList rowList = this.outputData.getBussinessParams().getRowParamList();
        Operation oper = this.definitions.getOperation("NSCMD_PTN_PORT_GET_NAME");
        Input input = oper.getInput();
        input.setPartValue("slotid", "65535");
        input.setPartValue("subslotid", "255");
        input.setPartValue("port", "0");
        operationList.add(oper);
        int result = this.sendMessage(neid);
        if (result != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            return;
        }
        Operation tmpOper = (Operation)operationList.get(0);
        Output[] output = tmpOper.getOutput();
        for (Fault fault : output[0].getFault()) {
            int code = Integer.parseInt(fault.getCode());
            if (code == 0) continue;
            ErrorMessage bigErr = TEErrorResourceUtil.getErrorMessage((int)1);
            this.outputData.setErrorMessage(bigErr);
            return;
        }
        TEPTNUtil ptnUtil = TEPTNUtil.instance();
        ptnUtil.processMPAndVEthnetPortName(rowList, output);
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorList = new ArrayList<Integer>();
        errorList.add(38662);
        errorList.add(42165);
        return errorList;
    }

    protected boolean isSingletonLog() {
        return true;
    }
}

