/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.controlplaneconfig.isisprotocol_v2r7c03;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;

public class TEQueryLinkBean
extends TENEExplorerBean {
    private Definitions definitions = null;
    private ArrayList rowErrorList = new ArrayList();
    private int TIMEOUT = 20;
    private String nodeIP = "";
    private ArrayList<String> protocolIDArray = null;
    private String PROTOCOL_TYPE = "5";
    private static final int EMPTY_RESULT = 38662;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        int i;
        this.neid = neid;
        this.subfunc = subFunc;
        this.operationList = new ArrayList();
        this.outputData = new Datainterface();
        BussinessParams businessparams = inputData.getBussinessParams();
        RowParams rowparams = businessparams.getRowParams(0);
        String level = rowparams.getParam("level").getValue();
        if ("OSPF".equals(level)) {
            this.PROTOCOL_TYPE = "1";
        }
        try {
            this.definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
        }
        int resultCode = -1;
        resultCode = this.doQueryNodeIP(this.nodeIP);
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        if (ne.getNEType() == 63) {
            if (resultCode == 0) {
                resultCode = this.doQuery912IsisID();
            }
        } else if (resultCode == 0) {
            resultCode = this.doQueryIsisID();
        }
        if (resultCode != 0) {
            if (resultCode == 38662) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            ErrorMessage bigErr = TEErrorResourceUtil.getErrorMessage((int)resultCode);
            this.outputData.setErrorMessage(bigErr);
            this.outputData.setBussinessParams(new BussinessParams());
            int size = this.rowErrorList.size();
            for (int i2 = 0; i2 < size; ++i2) {
                RowParams rParam = new RowParams();
                RowErrors rError = (RowErrors)this.rowErrorList.get(i2);
                rParam.addRowErrors(rError);
                this.outputData.getBussinessParams().addRowParams(rParam);
            }
            return this.outputData;
        }
        if ("5".equals(this.PROTOCOL_TYPE)) {
            int len = this.protocolIDArray.size();
            for (i = 0; i < len; ++i) {
                Operation oper = this.definitions.getOperation("NSCMD_IP_ISIS_GET_LINKTEINFO");
                Input input = oper.getInput();
                input.setPartValue("isisID", this.protocolIDArray.get(i).toString());
                input.setPartValue("remoteNodeIP", this.nodeIP);
                input.setPartValue("level", level);
                this.operationList.add(oper);
            }
        } else {
            int len = this.protocolIDArray.size();
            for (i = 0; i < len; ++i) {
                Operation oper = this.definitions.getOperation("NSCMD_PTN_OSPF_GET_LINKTEINFO");
                Input input = oper.getInput();
                input.setPartValue("ospfID", this.protocolIDArray.get(i).toString());
                input.setPartValue("remoteNodeIP", this.nodeIP);
                this.operationList.add(oper);
            }
        }
        this.protocolIDArray.clear();
        if (null == this.operationList || this.operationList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        int result = this.sendMessage(neid);
        if (result == 0) {
            this.handleMessage(neid, this.operationList, subFunc);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private int doQueryNodeIP(String nodeIP) {
        int resultNode = -1;
        ArrayList<Operation> operList = new ArrayList<Operation>();
        Operation oper = this.definitions.getOperation("NSCMD_CFG_GET_GCPNODEID");
        operList.add(oper);
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, operList, this.TIMEOUT);
        if (result.retCode != 0) {
            return result.retCode;
        }
        Operation tmpOper = (Operation)operList.get(0);
        for (Output output : tmpOper.getOutput()) {
            for (Fault fault : output.getFault()) {
                int code = Integer.parseInt(fault.getCode());
                if (code != 0) {
                    TELogFactory.getNormalLogger().info(TEErrorResourceUtil.getErrCodeResWithDot((int)this.neid, (int)code));
                    RowErrors rowError = new RowErrors();
                    Param errorParam = new Param("errorBbj", this.neid + "Query Node IP");
                    rowError.addParam(errorParam);
                    rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)code));
                    this.rowErrorList.add(rowError);
                    return code;
                }
                resultNode = code;
                this.nodeIP = output.getPart("nodeID").getValue();
            }
        }
        operList.clear();
        return resultNode;
    }

    private int doQueryIsisID() {
        int resultNode = -1;
        ArrayList<Operation> operList = new ArrayList<Operation>();
        Operation oper = this.definitions.getOperation("NSCMD_PTN_L3VPN_GET_PROTOCOL");
        Input input = oper.getInput();
        input.setPartValue("vpnID", "4294967295");
        operList.add(oper);
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, operList, this.TIMEOUT);
        if (result.retCode != 0) {
            return result.retCode;
        }
        this.protocolIDArray = new ArrayList();
        Operation tmpOper = (Operation)operList.get(0);
        for (Output output : tmpOper.getOutput()) {
            for (Fault fault : output.getFault()) {
                int code = Integer.parseInt(fault.getCode());
                if (code != 0) {
                    TELogFactory.getNormalLogger().info(TEErrorResourceUtil.getErrCodeResWithDot((int)this.neid, (int)code));
                    RowErrors rowError = new RowErrors();
                    Param errorParam = new Param("errorBbj", this.neid + "Query ISIS ID");
                    rowError.addParam(errorParam);
                    rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)code));
                    this.rowErrorList.add(rowError);
                    return code;
                }
                resultNode = code;
            }
            if (!output.getPart("protocolType").getValue().equals(this.PROTOCOL_TYPE)) continue;
            this.protocolIDArray.add(output.getPart("protocolID").getValue());
        }
        operList.clear();
        return resultNode;
    }

    private int doQuery912IsisID() {
        int resultNode = -1;
        ArrayList<Operation> operList = new ArrayList<Operation>();
        Operation oper = this.definitions.getOperation("NSCMD_PTN_ISIS_GET_ISISINSTANCE");
        Input input = oper.getInput();
        input.setPartValue("neid", String.valueOf(this.neid));
        input.setPartValue("vpnID", "4294967295");
        input.setPartValue("protocolType", "5");
        operList.add(oper);
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, operList, this.TIMEOUT);
        if (result.retCode != 0) {
            return result.retCode;
        }
        this.protocolIDArray = new ArrayList();
        Operation tmpOper = (Operation)operList.get(0);
        for (Output output : tmpOper.getOutput()) {
            for (Fault fault : output.getFault()) {
                int code = Integer.parseInt(fault.getCode());
                if (code != 0) {
                    TELogFactory.getNormalLogger().info(TEErrorResourceUtil.getErrCodeResWithDot((int)this.neid, (int)code));
                    RowErrors rowError = new RowErrors();
                    Param errorParam = new Param("errorBbj", this.neid + "Query ISIS ID");
                    rowError.addParam(errorParam);
                    rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)code));
                    this.rowErrorList.add(rowError);
                    return code;
                }
                resultNode = code;
            }
            this.protocolIDArray.add(output.getPart("isisID").getValue());
        }
        operList.clear();
        return resultNode;
    }
}

