/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.controlplaneconfig.ibgpprotocol;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;

public class TEQueryIbgpPeerPolicyBean
extends TENEExplorerBean {
    private static int NOT_BIND_BGP_POLICY = 44314;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData.setBussinessParams(new BussinessParams());
        Operation tmpOper = (Operation)operationList.get(0);
        Output output = tmpOper.getOutput(0);
        Fault[] faultArr = output.getFault();
        int resultCode = 0;
        for (Fault fault : faultArr) {
            int code = Integer.parseInt(fault.getCode());
            if (code == NOT_BIND_BGP_POLICY) {
                ErrorMessage bigErr = TEErrorResourceUtil.getErrorMessage((int)resultCode);
                this.outputData.setErrorMessage(bigErr);
                return;
            }
            if (code == 0) continue;
            resultCode = 2;
            RowErrors rowError = new RowErrors();
            Param errorParam = new Param("nename", TENEListMgr.getInstance().getNE(neid).getNEName());
            rowError.addParam(errorParam);
            rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)code));
            RowParams rParam = new RowParams();
            rParam.addRowErrors(rowError);
            this.outputData.getBussinessParams().addRowParams(rParam);
        }
        ErrorMessage bigErr = TEErrorResourceUtil.getErrorMessage((int)resultCode);
        this.outputData.setErrorMessage(bigErr);
        if (resultCode == 2) {
            return;
        }
        RowParams rowparam = null;
        Param param = null;
        Part part = output.getPart("policyInfo");
        if (part == null) {
            return;
        }
        byte[] bValue = part.getValue().getBytes();
        int stepLength = 10;
        int startIndex = 0;
        while (startIndex + stepLength <= bValue.length) {
            rowparam = new RowParams();
            byte[] bTmp = new byte[8];
            System.arraycopy(bValue, startIndex + 0, bTmp, 0, 8);
            int policyID = IOStreamConvertor.readPositiveLong((byte[])bTmp, (int)0);
            param = new Param("policyID", String.valueOf(policyID));
            rowparam.addParam(param);
            param = new Param("policyName", this.queryPolicyName(policyID));
            rowparam.addParam(param);
            bTmp = new byte[2];
            System.arraycopy(bValue, startIndex + 8, bTmp, 0, 2);
            int policyType = IOStreamConvertor.readPositiveShort((byte[])bTmp, (int)0);
            param = new Param("policyType", policyType + "");
            rowparam.addParam(param);
            this.outputData.getBussinessParams().addRowParams(rowparam);
            startIndex += stepLength;
        }
    }

    private String queryPolicyName(int policyID) {
        Definitions definitions = null;
        try {
            definitions = TECreateObjectFactory.parseQxDesFile((int)this.neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return "";
        }
        Operation oper = definitions.getOperation("NSCMD_BGP_GET_POLICY");
        Input input = oper.getInput();
        input.setPartValue("policyID", String.valueOf(policyID));
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        operationList.add(oper);
        int result = this.sendMessage(this.neid, operationList);
        if (result != 0) {
            return "";
        }
        Operation tmpOper = (Operation)operationList.get(0);
        operationList.clear();
        Output output = tmpOper.getOutput(0);
        int code = Integer.parseInt(output.getFault(0).getCode());
        if (code != 0) {
            return "";
        }
        return output.getPartValue("policyName").trim();
    }
}

