/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.controlplaneconfig.ibgpprotocol;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.util.convertor.IPAddressUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.List;

public class TEQueryIbgpPeerHrrBean
extends TENEExplorerBean {
    private Definitions definitions = null;
    private String ibgpID = "";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        try {
            this.definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
        }
        this.getIbgpID();
        if ("".equals(this.ibgpID)) {
            this.outputData = new Datainterface();
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        inputData.getBussinessParams().getRowParams()[0].getParam("ibgpID").setValue(this.ibgpID);
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    public int sendMessage(int neid, ArrayList operationList) {
        int retCode = 0;
        OperationResult result = TENECommMgr.getInstance().sendCommandNoLog(neid, (List)operationList, this.getTimeOut());
        if (null != result) {
            retCode = result.retCode;
        }
        return retCode;
    }

    private void getIbgpID() {
        ArrayList<Operation> ibgpIDList = new ArrayList<Operation>();
        Operation oper = this.definitions.getOperation("NSCMD_PTN_BGP_GET_BGPINSTANCE");
        Input input = oper.getInput();
        input.setPartValue("ibgpID", "0");
        ibgpIDList.add(oper);
        int result = this.sendMessage(this.neid, ibgpIDList);
        if (result != 0) {
            return;
        }
        Operation tmpOper = (Operation)ibgpIDList.get(0);
        for (Output output : tmpOper.getOutput()) {
            String code = output.getFault()[0].getCode();
            if (null == code || Integer.parseInt(code) != 0) {
                return;
            }
            long vpnID = 0L;
            if (output.getPartValue("serviceID") != null && !output.getPartValue("serviceID").trim().equals("")) {
                vpnID = Long.parseLong(output.getPartValue("serviceID"));
            }
            if (vpnID != 0xFFFFFFFFL) continue;
            this.ibgpID = output.getPartValue("ibgpID");
            break;
        }
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        int size = operationList.size();
        for (int i = 0; i < size; ++i) {
            Operation opertion = (Operation)operationList.get(i);
            if (!"NSCMD_PTN_BGP_GET_PEER_EX".equals(opertion.getName())) continue;
            for (Output output : opertion.getOutput()) {
                Definitions.getParam((Part[])output.getPart(), (String)"md5").setValue("*");
            }
        }
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        operationList.clear();
        if (2 == Integer.parseInt(this.outputData.getErrorMessage().getErrorcode())) {
            return;
        }
        String clusterID = this.processClusterID();
        RowParams rowParams = new RowParams();
        rowParams.addParam(new Param("clusterID", clusterID));
        rowParams.addParam(new Param("ibgpID", this.ibgpID));
        this.outputData.getBussinessParams().addRowParams(0, rowParams);
    }

    private String processClusterID() {
        ArrayList<Operation> tunnelInfoList = new ArrayList<Operation>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_BGP_GET_CLUSTERID");
        Input input = oper.getInput();
        input.setPartValue("ibgpID", this.ibgpID);
        tunnelInfoList.add(oper);
        int result = this.sendMessage(this.neid, tunnelInfoList);
        if (result != 0) {
            return "";
        }
        Operation tmpOper = (Operation)tunnelInfoList.get(0);
        Output output = tmpOper.getOutput()[0];
        String code = output.getFault()[0].getCode();
        if (null == code || Integer.parseInt(code) != 0) {
            return "";
        }
        return IPAddressUtil.convertIPLongToStr((long)Long.valueOf(output.getPartValue("clusterID")));
    }
}

