/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.constringency;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Arrays;

public class TEQueryConstringencyPort
extends TENEExplorerBean {
    private String[] portIDList = new String[0];

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        RowParams[] inputParam = inputData.getBussinessParams().getRowParams();
        if (inputParam.length != 0) {
            String portIDListStr = inputParam[0].getParam("portidlist").getValue();
            Object[] portArray = portIDListStr.split(",");
            Arrays.sort(portArray);
            this.portIDList = portArray;
        }
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        Operation operation = (Operation)operationList.get(0);
        RowParams rowParams = null;
        for (int i = 0; i < operation.getOutputCount(); ++i) {
            Output output = operation.getOutput(i);
            int errCode = Integer.parseInt(output.getFault(0).getCode());
            if (errCode != 0) continue;
            int slotid = Integer.parseInt(output.getPartValue("slotid"));
            int portnum = Integer.parseInt(output.getPartValue("portnum"));
            int[] rateArray = this.getRateFromList(output.getPartValue("constringencyrate"));
            if (portnum != this.portIDList.length || rateArray.length != portnum) {
                return;
            }
            int portidTemp = 0;
            for (int j = 0; j < this.portIDList.length; ++j) {
                portidTemp = Integer.parseInt(this.portIDList[j]);
                rowParams = new RowParams();
                rowParams.addParam(this.constructParam("constringencyid", output.getPartValue("constringencyid")));
                rowParams.addParam(this.constructParam("slotid", output.getPartValue("slotid")));
                rowParams.addParam(this.constructParam("boardname", this.getBoardName(neid, slotid)));
                rowParams.addParam(this.constructParam("portid", String.valueOf(portidTemp)));
                rowParams.addParam(this.constructParam("portname", this.getPortName(neid, slotid, portidTemp)));
                rowParams.addParam(this.constructParam("constringencyrate", String.valueOf(rateArray[j])));
                this.outputData.getBussinessParams().addRowParams(rowParams);
            }
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
    }

    private String getBoardName(int neid, int slotid) {
        String boardName = "";
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neid, slotid);
        if (board != null) {
            boardName = board.getBoardName();
        }
        return boardName;
    }

    private String getPortName(int neid, int slotid, int portid) {
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
        String portName = TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, boardType, portid);
        return portName;
    }

    private Param constructParam(String key, String value) {
        Param param = new Param();
        param.setName(key);
        param.setValue(value);
        return param;
    }

    private int[] getRateFromList(String idstring) {
        int[] idlist = new int[idstring.length() / 2];
        int length = 2;
        int index = -1;
        if (idstring.length() != 0) {
            int len = idstring.length();
            for (int i = 0; i < len; i += length) {
                idlist[++index] = Integer.parseInt(idstring.substring(i, i + length), 16);
            }
        }
        return idlist;
    }
}

