/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.constringency;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TEQueryConstringencyGroup
extends TENEExplorerBean {
    private Definitions definitions = null;
    private ArrayList rowErrorList = new ArrayList();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.operationList = new ArrayList();
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        try {
            this.definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
        }
        BussinessParams businessparams = inputData.getBussinessParams();
        RowParams rowparams = businessparams.getRowParams(0);
        String slotid = rowparams.getParam("slotid").getValue();
        int resultCode = -1;
        resultCode = this.getConstringencyGroup(slotid);
        ErrorMessage bigErr = TEErrorResourceUtil.getErrorMessage((int)resultCode);
        this.outputData.setErrorMessage(bigErr);
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private int getConstringencyGroup(String slotid) {
        int i;
        RowParams rowparam = null;
        Param param = null;
        Part part = null;
        Operation oper = this.definitions.getOperation("NSCMD_ETHN_GET_CONSTRINGENCY_INFO");
        Input input = oper.getInput();
        input.setPartValue("slotid", slotid);
        this.operationList.add(oper);
        int result = this.sendMessage(this.neid);
        if (result != 0) {
            return result;
        }
        Operation tmpOper = (Operation)this.operationList.get(0);
        this.operationList.clear();
        Output[] outputArr = tmpOper.getOutput();
        Output output = outputArr[0];
        for (Fault fault : output.getFault()) {
            int code = Integer.parseInt(fault.getCode());
            if (code == 0) continue;
            TELogFactory.getNormalLogger().info(TEErrorResourceUtil.getErrCodeResWithDot((int)this.neid, (int)code));
            RowErrors rowError = new RowErrors();
            Param errorParam = new Param("slotid", slotid);
            rowError.addParam(errorParam);
            rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)code));
            this.rowErrorList.add(rowError);
            return code;
        }
        int slotid_rtn = Integer.parseInt(output.getPartValue("slotid"));
        int constringgencynum = Integer.parseInt(output.getPartValue("constringgencynum"));
        int portnum = Integer.parseInt(output.getPartValue("portnum"));
        part = Definitions.getParam((Part[])output.getPart(), (String)"constringencyidlist");
        int[] groupIDArray = this.getGroupIDList(part.getValue());
        HashMap<String, String> portMap = new HashMap<String, String>();
        if (portnum != groupIDArray.length) {
            return 2;
        }
        if (portnum > 0) {
            for (i = 0; i < portnum; ++i) {
                portMap.put(String.valueOf(i + 1), String.valueOf(groupIDArray[i]));
            }
        }
        for (i = 0; i < constringgencynum; ++i) {
            rowparam = new RowParams();
            param = new Param("slotid", slotid_rtn + "");
            rowparam.addParam(param);
            param = new Param("constringencyid", i + 1 + "");
            rowparam.addParam(param);
            param = new Param("constringencyband", output.getPartValue("constringencyband"));
            rowparam.addParam(param);
            param = new Param("portnum", this.getPortNumInConstringency(i + 1, groupIDArray) + "");
            rowparam.addParam(param);
            param = new Param("portidlist", this.getPortIDsFromMap(i + 1 + "", portMap));
            rowparam.addParam(param);
            this.outputData.getBussinessParams().addRowParams(rowparam);
        }
        return 0;
    }

    private String getPortIDsFromMap(String constringencyID, HashMap portMap) {
        Iterator iterator = portMap.entrySet().iterator();
        StringBuffer buffer = new StringBuffer();
        Map.Entry entry = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (!((String)entry.getValue()).equalsIgnoreCase(constringencyID)) continue;
            buffer.append((String)entry.getKey()).append(",");
        }
        return buffer.toString();
    }

    private int[] getGroupIDList(String idstring) {
        int[] idlist = new int[idstring.length() / 2];
        int length = 2;
        int index = -1;
        if (idstring.length() != 0) {
            int len = idstring.length();
            for (int i = 0; i < len; i += length) {
                idlist[++index] = Integer.parseInt(idstring.substring(i, i + length), 16);
            }
        }
        return idlist;
    }

    private int getPortNumInConstringency(int constringency, int[] conencyList) {
        int count = 0;
        int len = conencyList.length;
        for (int i = 0; i < len; ++i) {
            if (constringency != conencyList[i]) continue;
            ++count;
        }
        return count;
    }
}

