/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.clockptp;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class TEQueryOuterBMCBean
extends TENEExplorerBean {
    private int OUTER_PARA_1 = 1;
    private int OUTER_PARA_2 = 2;
    private String OUTER_PORT_1 = "21";
    private String OUTER_PORT_2 = "22";
    private static int IS_OUTERCLOCK = 43236;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList);
        int errorCode = Integer.parseInt(this.outputData.getErrorMessage().getErrorcode());
        if (0 == errorCode || 1 == errorCode) {
            if (this.outputData.getBussinessParams().getRowParamsCount() > 0) {
                RowParams rowdata = this.outputData.getBussinessParams().getRowParams(0);
                TENE ne = TENEListMgr.getInstance().getNE(neid);
                Param neNameParam = rowdata.getParam("neName");
                if (null != neNameParam) {
                    ne.setNEName(neNameParam.getValue().trim());
                    neNameParam.setValue(ne.getNEName());
                }
            }
            boolean hasErrorCode = false;
            RowParams[] rowArray = this.outputData.getBussinessParams().getRowParams();
            int rowArrayLen = rowArray.length;
            for (int i = 0; i < rowArrayLen; ++i) {
                RowErrors[] rowErrorsArray = rowArray[i].getRowErrors();
                for (int rowErrorsLen = rowErrorsArray.length - 1; rowErrorsLen >= 0; --rowErrorsLen) {
                    RowErrors rowErrors = rowErrorsArray[rowErrorsLen];
                    if (IS_OUTERCLOCK != Integer.parseInt(rowErrors.getErrorMessage().getErrorcode())) continue;
                    rowArray[i].removeRowErrors(rowErrors);
                }
                if (0 == rowArray[i].getRowErrorsCount()) continue;
                hasErrorCode = true;
            }
            if (!hasErrorCode) {
                this.outputData.getErrorMessage().setErrorcode(Integer.toString(0));
            }
        }
    }

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        TEBoard board;
        Map<String, List<String>> slotPortMap = this.getClockSlots();
        if (!slotPortMap.isEmpty()) {
            return this.constructOperationList(slotPortMap);
        }
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        int neType = ne.getNEType();
        if (neType == 58) {
            board = ne.getBoard(1);
            if (board == null) {
                board = ne.getBoard(2);
            }
            if (board.getBoardType() == 2128) {
                this.OUTER_PORT_1 = "7";
                this.OUTER_PORT_2 = "8";
            } else {
                this.OUTER_PORT_1 = "1";
                this.OUTER_PORT_2 = "2";
            }
            this.OUTER_PARA_1 = 1;
            this.OUTER_PARA_2 = 2;
        } else if (neType == 59) {
            this.OUTER_PARA_1 = 9;
            this.OUTER_PARA_2 = 10;
            this.OUTER_PORT_1 = "1";
            this.OUTER_PORT_2 = "2";
        } else if (neType == 91) {
            this.OUTER_PORT_1 = "37";
            this.OUTER_PORT_2 = "38";
        } else if (neType == 65 || neType == 87 || neType == 94) {
            this.OUTER_PARA_1 = 7;
            this.OUTER_PARA_2 = 8;
            this.OUTER_PORT_1 = "1";
            this.OUTER_PORT_2 = "2";
        } else if (neType == 78) {
            this.OUTER_PARA_1 = 23;
            this.OUTER_PARA_2 = 24;
            this.OUTER_PORT_1 = "1";
            this.OUTER_PORT_2 = "2";
        } else if (neType == 64 || neType == 86) {
            board = ne.getBoard(1);
            if (board == null) {
                board = ne.getBoard(2);
            }
            if (board.getBoardType() == 1607 || board.getBoardType() == 1608 || board.getBoardType() == 2396 || board.getBoardType() == 2397) {
                this.OUTER_PORT_1 = "23";
                this.OUTER_PORT_2 = "24";
            } else if (board.getBoardType() == 1609 || board.getBoardType() == 2443) {
                this.OUTER_PORT_1 = "11";
                this.OUTER_PORT_2 = "12";
            } else if (board.getBoardType() == 2465) {
                this.OUTER_PORT_1 = "13";
                this.OUTER_PORT_2 = "14";
            } else {
                this.OUTER_PORT_1 = "21";
                this.OUTER_PORT_2 = "22";
            }
        }
        ArrayList<Object> templist = new ArrayList<Object>();
        try {
            Definitions definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
            Operation oper = definitions.getOperation("NSCMD_CFG_GET_PTPTIMEATTR");
            Input input = oper.getInput();
            Vector boardList = ne.getBoardList();
            Collections.sort(boardList);
            int size = boardList.size();
            for (int i = 0; i < size; ++i) {
                TEBoard board2 = (TEBoard)boardList.get(i);
                int slotID = board2.getSlotID();
                if (this.OUTER_PARA_1 != slotID && this.OUTER_PARA_2 != slotID) continue;
                input.setPartValue("slotid", slotID + "");
                input.setPartValue("subslotid", "255");
                input.setPartValue("port", this.OUTER_PORT_1);
                templist.add(oper.clone());
                input = oper.getInput();
                input.setPartValue("slotid", slotID + "");
                input.setPartValue("subslotid", "255");
                input.setPartValue("port", this.OUTER_PORT_2);
                templist.add(oper.clone());
            }
            return templist;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
    }

    private Map<String, List<String>> getClockSlots() {
        TENE ne = TENEListMgr.getInstance().getNE(this.neid);
        List clockSlots = TESpecialAttrMgr.getInstance().getNEAttrListValue(this.neid, "TE_FUNC_CFG_PTPCLOCK_EXTERN_TIME", "PTN_ATTR_CLOCKSLOTS");
        int clockSlotid = -1;
        HashMap<String, List<String>> slotPortMap = new HashMap<String, List<String>>();
        for (String slotid : clockSlots) {
            clockSlotid = Integer.parseInt(slotid);
            TEBoard tmpboard = ne.getBoard(clockSlotid);
            if (null == tmpboard) continue;
            List portIDs = TESpecialAttrMgr.getInstance().getCPAttrListValue(this.neid, clockSlotid, "TE_FUNC_CFG_PTPCLOCK_EXTERN_TIME", "PTN_ATTR_EXTIMEINF_PORTS");
            slotPortMap.put(slotid, portIDs);
        }
        return slotPortMap;
    }

    private ArrayList constructOperationList(Map<String, List<String>> slotPortMap) {
        Definitions definitions;
        ArrayList<Object> tempList = new ArrayList<Object>();
        try {
            definitions = TECreateObjectFactory.parseQxDesFile((int)this.neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
        Operation oper = definitions.getOperation("NSCMD_CFG_GET_PTPTIMEATTR");
        Input input = oper.getInput();
        for (String slotid : slotPortMap.keySet()) {
            List<String> portids = slotPortMap.get(slotid);
            for (String portid : portids) {
                input.setPartValue("slotid", slotid);
                input.setPartValue("subslotid", "255");
                input.setPartValue("port", portid);
                tempList.add(oper.clone());
            }
        }
        return tempList;
    }
}

