/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.clock;

import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import java.io.File;

public class TEClockUtility {
    private static final String filename = "clockres_" + TESysManagerBean.getInstance().getlanguage() + ".ini";
    private static String PAKAGE_PATH = "ptn" + File.separator + "res" + File.separator + "clock" + File.separator + filename;

    public static String getClockSourceName(int neid, int clockid) {
        int slotid = clockid >> 24 & 0xFF;
        int portid = clockid & 0xFFFF;
        int subboardid = clockid >> 16 & 0xFF;
        StringBuffer name = new StringBuffer();
        String clockname = null;
        if (clockid == 0xF00001) {
            clockname = TEGetFilePath.getResource((int)neid, (String)PAKAGE_PATH).getString("extclock1");
            return clockname;
        }
        if (clockid == 0xF00002) {
            clockname = TEGetFilePath.getResource((int)neid, (String)PAKAGE_PATH).getString("extclock2");
            return clockname;
        }
        if (clockid == 65537) {
            clockname = TEGetFilePath.getResource((int)neid, (String)PAKAGE_PATH).getString("adapttopclock");
            return clockname;
        }
        if (clockid == 65538) {
            clockname = TEGetFilePath.getResource((int)neid, (String)PAKAGE_PATH).getString("difftopclock1");
            return clockname;
        }
        if (clockid == 65539) {
            clockname = TEGetFilePath.getResource((int)neid, (String)PAKAGE_PATH).getString("difftopclock2");
            return clockname;
        }
        if (clockid == 0xF10001) {
            clockname = TEGetFilePath.getResource((int)neid, (String)PAKAGE_PATH).getString("innerclcok");
            return clockname;
        }
        if (slotid == 0 && subboardid == 2) {
            slotid = clockid >> 8 & 0xFF;
            int acrid = clockid & 0xFF;
            TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neid, slotid);
            if (board == null) {
                clockname = TEGetFilePath.getResource((int)neid, (String)PAKAGE_PATH).getString("noinfo");
                return clockname;
            }
            int boardtype = board.getBoardType();
            String boardname = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardtype);
            name.append(slotid).append("-").append(boardname).append("-").append("ACR").append(acrid);
            return name.toString();
        }
        if (slotid <= 0 || portid <= 0) {
            clockname = TEGetFilePath.getResource((int)neid, (String)PAKAGE_PATH).getString("noinfo");
            return clockname;
        }
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neid, slotid);
        if (board == null) {
            clockname = TEGetFilePath.getResource((int)neid, (String)PAKAGE_PATH).getString("noinfo");
            return clockname;
        }
        int boardtype = board.getBoardType();
        String boardname = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardtype);
        if (subboardid != 255) {
            int subboardtype = TEConfigurationDataMgr.getInstance().getSubboardType(neid, slotid, subboardid);
            String subboardname = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, subboardtype);
            String portname = TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, subboardtype, portid);
            name.append(slotid).append("-").append(boardname).append("-").append(subboardid).append("-").append(subboardname).append("-").append(portname);
        } else {
            String portname = TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, boardtype, portid);
            name.append(slotid).append("-").append(boardname).append("-").append(portname);
        }
        return name.toString();
    }
}

