/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.bfdmanagement.mooperation.datacfg;

import com.huawei.nglct.cbb.datamanage.integration.model.TEDataCfgNEInfo;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ptn.bfdmanagement.mooperation.TEBFDPoOperationUtil;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import java.io.FileNotFoundException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.slf4j.Logger;

public class TEPTNBFDDataCfgHandler {
    private TEDataCfgNEInfo cfgNEInfo = null;
    private Logger logger = null;
    private boolean isRPT = true;
    private TEBFDPoOperationUtil bfdOpertUtil = null;
    private final int opertFlag;

    public TEPTNBFDDataCfgHandler(TEDataCfgNEInfo cfgNEInfo, int opertFlag) {
        this.cfgNEInfo = cfgNEInfo;
        this.logger = TELogFactory.getNormalLogger();
        this.bfdOpertUtil = TEBFDPoOperationUtil.getInstance();
        this.opertFlag = opertFlag;
    }

    public int performDataCfgAction() {
        SubFunc subFunc;
        int neID = this.cfgNEInfo.getNeID();
        Datainterface inputData = new Datainterface();
        Datainterface outputData = null;
        BussinessParams bus = new BussinessParams();
        RowParams rowParams = new RowParams();
        inputData.setBussinessParams(bus);
        rowParams.addParam("neid", String.valueOf(neID));
        rowParams.addParam("isauto", "0");
        rowParams.addParam("sessionIndex", "0");
        rowParams.addParam("isRPT", this.isRPT ? "1" : "0");
        rowParams.addParam("isLogFlag", "0");
        bus.addRowParams(rowParams);
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null != ne && 1 != ne.getLogStatus()) {
            TEHandleSbiInfo.getInstance().handleSBIConnectOnInter(neID);
        }
        if (null == (subFunc = this.getSubFunc())) {
            TELogFactory.getNormalLogger().info("Not Find Query Bfd subFunc!");
            return -1;
        }
        subFunc.setTransSupport(true);
        outputData = TEBFDPoOperationUtil.getInstance().callLctDomainModule(neID, inputData, subFunc, true);
        if (null == outputData) {
            return -1;
        }
        int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != errorCode) {
            this.logger.info("[Bfd DataCfg]query bfd failed" + neID);
            return -1;
        }
        return this.bfdOpertUtil.saveBfdInfo2DB(neID, outputData, this.opertFlag, false).getOpertResult();
    }

    private SubFunc getSubFunc() {
        SubFunc subFunc = null;
        int neID = this.cfgNEInfo.getNeID();
        int neType = this.cfgNEInfo.getNeType();
        int sfid = 2106573;
        String neVersion = this.cfgNEInfo.getNeVersion();
        try {
            subFunc = TECreateObjectFactory.getSubFuncByVer((int)neID, (int)sfid, (int)neType, (String)neVersion);
        }
        catch (MarshalException e) {
            this.logger.error("[Bfd Module] data cfg from weblct exception " + neID, (Throwable)e);
        }
        catch (FileNotFoundException e) {
            this.logger.error("[Bfd Module] data cfg from weblct exception " + neID, (Throwable)e);
        }
        catch (ValidationException e) {
            this.logger.error("[Bfd Module] data cfg from weblct exception " + neID, (Throwable)e);
        }
        return subFunc;
    }

    public void setisRPT(boolean isRPT) {
        this.isRPT = isRPT;
    }

    public boolean getisRPT() {
        return this.isRPT;
    }
}

