/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.bfdmanagement.mooperation;

import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnSingleReturn;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_common.QAsnUniResIDList;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_model.QAsnBfdBindIpLink;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_model.QAsnBfdBindService;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_model.QAsnBfdBindVrfIp;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_model.QAsnBfdInfo;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_model.QAsnBfdInfoEx;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_model.QAsnBfdInfoExList;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_model.QAsnBfdInfoList;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_op.QAsnBfdRefreshSessionRsp;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.event.Event;
import com.huawei.nglct.core.reliableevent.TEReliableEventMgr;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.jni.TEJNIFacadeUtil;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnSingleReturn;
import com.huawei.nglct.nemgr.f_interface.portfdn.AsnPTNCommonPort;
import com.huawei.nglct.nemgr.f_interface.portfdn.AsnPTNGetFdnByPortReq;
import com.huawei.nglct.nemgr.f_interface.portfdn.AsnPTNGetFdnByPortRsp;
import com.huawei.nglct.nemgr.f_interface.portfdn.AsnPTNGetPortByFdnReq;
import com.huawei.nglct.nemgr.f_interface.portfdn.AsnPTNGetPortByFdnRsp;
import com.huawei.nglct.nemgr.f_interface.vrf.AsnPTNGetVrfIndexByIdReq;
import com.huawei.nglct.nemgr.f_interface.vrf.AsnPTNGetVrfIndexdByIdRsp;
import com.huawei.nglct.nemgr.f_interface.vrf.AsnPTNVrfkey;
import com.huawei.nglct.nemgr.f_interface.vrf.AsnPTNVrfkeyList;
import com.huawei.nglct.nemgr.ptn.bfdmanagement.mooperation.TEBfdResultObject;
import com.huawei.nglct.nemgr.ptn.bfdmanagement.mooperation.TEVrfResultObject;
import com.huawei.nglct.po.embeddednemgrmo.ptn.bfd.TEPTNBfdContainerMOPO;
import com.huawei.nglct.po.embeddednemgrmo.ptn.bfd.TEPTNBfdSessionObjMOPO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.convertor.IPAddressUtil;
import com.huawei.nglct.util.fdn.FDNParser;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.nglct.wnemgrprocess.TEWNEMgrBussinessProcess;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEBFDPoOperationUtil {
    private static TEBFDPoOperationUtil instance = null;
    private final Logger logger;
    private static final int SERVICE_STATIC = 1;
    private final String filePath = new StringBuffer("ptn").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("bfdmanagement").append(File.separator).append("bfdmanagement_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini").toString();
    private TEResourceUtil bfdRes = null;

    private TEBFDPoOperationUtil() {
        this.logger = TELogFactory.getNormalLogger();
    }

    public static synchronized TEBFDPoOperationUtil getInstance() {
        if (null == instance) {
            instance = new TEBFDPoOperationUtil();
        }
        return instance;
    }

    public TEResourceUtil getBfdResUtil(int neid) {
        if (null == this.bfdRes) {
            this.bfdRes = TEGetFilePath.getResource((int)neid, (String)this.filePath);
        }
        return this.bfdRes;
    }

    public String getBfdResByKey(int neid, String key) {
        return this.getBfdResUtil(neid).getString(key);
    }

    public Datainterface callQueryBfdModule(int neid, long sessionIndex, boolean flagsaveDB) {
        Datainterface di = new Datainterface();
        BussinessParams busParam = new BussinessParams();
        RowParams rowParams = new RowParams();
        rowParams.addParam("neid", String.valueOf(neid));
        rowParams.addParam("isauto", "0");
        rowParams.addParam("sessionIndex", String.valueOf(sessionIndex));
        rowParams.addParam("isLogFlag", "0");
        busParam.addRowParams(rowParams);
        di.setBussinessParams(busParam);
        SubFunc subFunc = TEBFDPoOperationUtil.getSubFuncObj(neid, TEBFDPoOperationUtil.getQueryBfdQxCmd());
        return this.callLctDomainModule(neid, di, subFunc, flagsaveDB);
    }

    public Datainterface callModifyBfdModule(int neid, Datainterface di, boolean flagsaveDB) {
        SubFunc subFunc = TEBFDPoOperationUtil.getSubFuncObj(neid, TEBFDPoOperationUtil.getModifyBfdQxCmd());
        return this.callLctDomainModule(neid, di, subFunc, flagsaveDB);
    }

    public static final SubFunc getSubFuncObj(int neid, int sfid) {
        SubFunc subFunc = null;
        try {
            subFunc = TECreateObjectFactory.getSubFunc((int)neid, (int)sfid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("[bfd module]get subfunc failed", (Throwable)e);
        }
        return subFunc;
    }

    public Datainterface callLctDomainModule(int neid, Datainterface inputData, SubFunc subFunc, boolean flagSaveDB) {
        Datainterface outputData = null;
        try {
            if (flagSaveDB) {
                outputData = TEWNEMgrBussinessProcess.performWNEMgrBussinessProcess((int)neid, (SubFunc)subFunc, (Datainterface)inputData, null, null, null, (int)1);
            } else {
                TENEMgrInterface neExploreBean = TEBFDPoOperationUtil.getNEExploreBean(subFunc);
                if (null != neExploreBean) {
                    outputData = neExploreBean.performBussinessProcess(neid, subFunc, inputData, null, null, null);
                }
            }
        }
        catch (InstantiationException e) {
            this.logger.error("[Bfd Module]Exception occurs,cmdCode is %d,ErrorMsg:%s", (Object)subFunc.getCode(), (Object)e);
        }
        catch (IllegalAccessException e) {
            this.logger.error("[Bfd Module]Exception occurs,cmdCode is %d,ErrorMsg:%s", (Object)subFunc.getCode(), (Object)e);
        }
        catch (ClassNotFoundException e) {
            this.logger.error("[Bfd Module]Exception occurs,cmdCode is %d,ErrorMsg:%s", (Object)subFunc.getCode(), (Object)e);
        }
        return outputData;
    }

    public void createBfdRptEvent(Event event) {
        FStruct rpt = (FStruct)event.getEventContext();
        TEReliableEventMgr.getInstance().send(event.getEventID(), rpt);
        this.logger.info(TEAsn1Util.getAsn1String((Object)rpt));
    }

    public TEBfdResultObject saveBfdInfo2DB(int neID, Datainterface di, int opertFlag, boolean flagNeedLock) {
        TEPTNBfdContainerMOPO bfdContainer = this.getBfdContainer(neID, flagNeedLock);
        List<TEPTNBfdSessionObjMOPO> bfdListFromNe = this.getBfdMOPO(di.getBussinessParams());
        if (1 == opertFlag) {
            bfdContainer.getBfdList().clear();
        }
        bfdContainer.getBfdList().addAll(bfdListFromNe);
        return this.saveBfdInfo2DB(neID, bfdListFromNe, bfdContainer, flagNeedLock);
    }

    public int updateBfdInfo(int neID, TEPTNBfdContainerMOPO bfdContainer, boolean flagNeedLock) {
        TEDaoOperationResult result = new TEDaoOperationResult();
        try {
            result = flagNeedLock ? TECommonDaoService.update((int[])new int[]{neID}, (Object)bfdContainer) : TECommonDaoService.update_NonLock((int[])new int[]{neID}, (Object)bfdContainer);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("[Bfd Module]save bfdInfo to DB Failed!", (Throwable)e);
        }
        return result.getResult();
    }

    public TEBfdResultObject saveBfdInfo2DB(int neID, Object opertObj, TEPTNBfdContainerMOPO bfdContainer, boolean flagNeedLock) {
        TEBfdResultObject bfdOpertResult = null;
        bfdOpertResult = null != opertObj ? new TEBfdResultObject(opertObj) : new TEBfdResultObject();
        TEDaoOperationResult result = new TEDaoOperationResult();
        try {
            result = flagNeedLock ? TECommonDaoService.update((int[])new int[]{neID}, (Object)bfdContainer) : TECommonDaoService.update_NonLock((int[])new int[]{neID}, (Object)bfdContainer);
        }
        catch (Exception e) {
            bfdOpertResult.setOpertResult(-1);
            TELogFactory.getNormalLogger().error("[Bfd Module]save bfdInfo to DB Failed!", (Throwable)e);
        }
        if (0 != result.getResult()) {
            bfdOpertResult.setOpertResult(-1);
        }
        return bfdOpertResult.setOpertResult(0);
    }

    public TEBfdResultObject saveBfdInfo2DB(int neID, RowParams rowParams, int opertFlag, boolean flagNeedLock) {
        Datainterface di = new Datainterface();
        BussinessParams bus = new BussinessParams();
        bus.addRowParams(rowParams);
        di.setBussinessParams(bus);
        return this.saveBfdInfo2DB(neID, di, opertFlag, flagNeedLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TEBfdResultObject deleteBfdFromDB(int neID, Datainterface deleteData, Map<Long, Long> excludeData) {
        TEPTNBfdContainerMOPO bfdContainer = this.getBfdContainer(neID, true);
        TEBfdResultObject bfdOpertResulst = new TEBfdResultObject();
        ArrayList<TEPTNBfdSessionObjMOPO> bfdPo2DelList = new ArrayList<TEPTNBfdSessionObjMOPO>();
        HashMap<Long, Long> id2IndexDelMap = new HashMap<Long, Long>();
        if (null == bfdContainer || bfdContainer.getBfdList().isEmpty()) {
            return bfdOpertResulst;
        }
        for (RowParams rowParams : deleteData.getBussinessParams().getRowParams()) {
            Long sessionID = Long.valueOf(rowParams.getParam("sessionid").getValue());
            Long sessionIndex = Long.valueOf(rowParams.getParam("sessionIndex").getValue());
            if (excludeData.containsKey(sessionID) && excludeData.get(sessionID) == sessionIndex) continue;
            id2IndexDelMap.put(sessionID, sessionIndex);
        }
        Iterator bfdPOIter = bfdContainer.getBfdList().iterator();
        while (bfdPOIter.hasNext()) {
            TEPTNBfdSessionObjMOPO bfd2Del = (TEPTNBfdSessionObjMOPO)bfdPOIter.next();
            if (!id2IndexDelMap.containsKey(bfd2Del.getBFDSessionID()) || ((Long)id2IndexDelMap.get(bfd2Del.getBFDSessionID())).longValue() != bfd2Del.getBFDIndex()) continue;
            bfdPo2DelList.add(bfd2Del);
            bfdPOIter.remove();
        }
        TEDaoOperationResult dbResult = new TEDaoOperationResult();
        try {
            dbResult = TECommonDaoService.update((int[])new int[]{neID}, (Object)bfdContainer);
            bfdOpertResulst.setOpertObj(bfdPo2DelList);
            bfdOpertResulst.setOpertResult(0);
        }
        catch (Exception e) {
            this.logger.error("[Bfd Module]delete bfd from db failed", (Throwable)e);
            bfdOpertResulst.setOpertResult(-1);
        }
        finally {
            this.fillDBErrors(neID, deleteData, dbResult);
        }
        return bfdOpertResulst;
    }

    public List<TEPTNBfdSessionObjMOPO> getBfdMOPO(BussinessParams bus) {
        ArrayList<TEPTNBfdSessionObjMOPO> bfdMoPoList = new ArrayList<TEPTNBfdSessionObjMOPO>();
        HashMap<String, String> valMap = new HashMap<String, String>();
        Param tempParam = null;
        for (RowParams rowParams : bus.getRowParams()) {
            int size = rowParams.getParamCount();
            for (int i = 0; i < size; ++i) {
                tempParam = rowParams.getParam(i);
                if (null == tempParam.getName()) continue;
                valMap.put(tempParam.getName(), tempParam.getValue());
            }
            TEPTNBfdSessionObjMOPO bfdMoPo = this.constructBfdMoPoByValMap(valMap);
            bfdMoPoList.add(bfdMoPo);
        }
        return bfdMoPoList;
    }

    public TEPTNBfdSessionObjMOPO constructBfdMoPoByValMap(Map<String, String> valMap) {
        TEPTNBfdSessionObjMOPO.BFDPOBuilder bfdBuilder = new TEPTNBfdSessionObjMOPO.BFDPOBuilder(Long.parseLong(valMap.get("sessionIndex")), Long.parseLong(valMap.get("sessionid")));
        if (null != valMap.get("sourceboard") && !"".equals(valMap.get("sourceboard"))) {
            bfdBuilder.slotID(Long.parseLong(valMap.get("sourceboard")));
        }
        if (null != valMap.get("frontport") && !"".equals(valMap.get("frontport"))) {
            bfdBuilder.portID(Long.parseLong(valMap.get("frontport")));
        }
        if (null != valMap.get("srcport") && !"".equals(valMap.get("srcport"))) {
            bfdBuilder.srcIpAddress(Long.parseLong(valMap.get("srcport")));
        }
        bfdBuilder.localID(Long.parseLong(valMap.get("locallabel"))).remoteID(Long.parseLong(valMap.get("remotelabel"))).sessionType(Short.parseShort(valMap.get("sessiontype"))).sessionStatus(Short.parseShort(valMap.get("sessionstatus"))).txInterval(Long.parseLong(valMap.get("sendinterval"))).rxInterval(Long.parseLong(valMap.get("receiveinterval"))).detectMult(Long.parseLong(valMap.get("detectmultiple"))).diagWord(Short.parseShort(valMap.get("diagnoseword"))).destIpAddress(Long.parseLong(valMap.get("endport")));
        if (valMap.containsKey("vrfindex")) {
            bfdBuilder.vrfIndex(Long.parseLong(valMap.get("vrfindex"))).vrfId(Long.parseLong(valMap.get("vrfid")));
        }
        return bfdBuilder.build();
    }

    public boolean updateBfdPoByValMap(TEPTNBfdSessionObjMOPO bfdPo, Map<String, String> valMap) {
        boolean flagModify = false;
        for (Map.Entry<String, String> entry : valMap.entrySet()) {
            if ("sendinterval".equals(entry.getKey())) {
                bfdPo.setTxInterval(Long.parseLong(entry.getValue()));
                flagModify = true;
                continue;
            }
            if ("sessionstatus".equals(entry.getKey())) {
                bfdPo.setSessionStatus(Short.parseShort(entry.getValue()));
                flagModify = true;
                continue;
            }
            if ("receiveinterval".equals(entry.getKey())) {
                bfdPo.setRxInterval(Long.parseLong(entry.getValue()));
                flagModify = true;
                continue;
            }
            if (!"localmultplier".equals(entry.getKey())) continue;
            bfdPo.setDetectMult(Long.parseLong(entry.getValue()));
            flagModify = true;
        }
        return flagModify;
    }

    public String getVrfIdFromFDN(QAsnUniResID qAsnFdn) {
        return new FDNParser(new String(qAsnFdn.strFDN)).getValue("VRF").split("\\|")[0];
    }

    public String getBfdIdFromFDN(QAsnUniResID bfdFDN) {
        String bfdIdStr = null;
        try {
            bfdIdStr = new FDNParser(new String(bfdFDN.strFDN)).getValue("BFD").split("\\|")[0];
        }
        catch (IllegalArgumentException e) {
            bfdIdStr = "";
        }
        return bfdIdStr;
    }

    public Map<Integer, List<String>> getBfdIdFromFDN(QAsnUniResIDList bfdFDNList, QAsnBfdRefreshSessionRsp rsp, QAsnErrInfoList errorInfoList) {
        HashMap<Integer, List<String>> neID2SIDMap = new HashMap<Integer, List<String>>();
        QAsnUniResID uniResID2 = null;
        QAsnBfdInfo errorBfdInfo = null;
        String bfdID = null;
        int neID = -1;
        boolean isValid = false;
        for (QAsnUniResID uniResID2 : bfdFDNList) {
            isValid = false;
            if (this.verifyUniRes(uniResID2, false) && this.isNumericStr(bfdID = this.getBfdIdFromFDN(uniResID2))) {
                isValid = true;
                if (!neID2SIDMap.containsKey(uniResID2.neID)) {
                    neID2SIDMap.put(uniResID2.neID, new ArrayList());
                }
                ((List)neID2SIDMap.get(uniResID2.neID)).add(bfdID);
            }
            if (isValid) continue;
            neID = uniResID2.neID;
            errorBfdInfo = this.getDefaultBfdInfo(neID, -1L, "QINPUTPARAMERROR");
            errorInfoList.add((Object)this.getAsnErrInfo(neID, -1L, this.getBfdResByKey(neID, "QINPUTPARAMERROR")));
            rsp.lstBfdInfo.add((Object)errorBfdInfo);
        }
        return neID2SIDMap;
    }

    public Datainterface fillDBErrors(int neID, Datainterface outputData, TEDaoOperationResult dbResult) {
        if (dbResult != null) {
            if (dbResult.getResult() == 0) {
                return outputData;
            }
            TELogFactory.getNormalLogger().error("[Bfd Module]Operate DB Failed!ErrorCode is %s,errorInfo is %s", (Object)dbResult.getResult(), (Object)TEErrorResourceUtil.getErrorMessage((int)dbResult.getResult()));
        }
        int errorCode = 1090646274;
        RowErrors rowError = new RowErrors();
        Param errorparam = new Param("neid", String.valueOf(neID));
        rowError.addParam(errorparam);
        ErrorMessage errorMessage = new ErrorMessage();
        errorMessage.setErrorcode(String.valueOf(errorCode));
        errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
        rowError.setErrorMessage(errorMessage);
        outputData.getBussinessParams().getRowParams(0).addRowErrors(rowError);
        errorMessage = outputData.getErrorMessage();
        if (0 == Integer.parseInt(errorMessage.getErrorcode())) {
            errorMessage.setErrorcode(String.valueOf(errorCode));
            errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)neID, (int)errorCode));
        }
        return outputData;
    }

    public TEPTNBfdContainerMOPO getBfdContainer(int neID, boolean flagNeedLock) {
        List objList;
        String errorStr = null;
        TEPTNBfdContainerMOPO bfdContainerMOPO = new TEPTNBfdContainerMOPO();
        TEDaoOperationResult dbResult = new TEDaoOperationResult();
        try {
            dbResult = flagNeedLock ? TECommonDaoService.findAll((int[])new int[]{neID}, TEPTNBfdContainerMOPO.class) : TECommonDaoService.findAll_NonLock((int[])new int[]{neID}, TEPTNBfdContainerMOPO.class);
            if (null == dbResult) {
                errorStr = String.format("get bfd container failed,the dbResult is null,neid:%d", neID);
                this.logger.error(errorStr);
            }
        }
        catch (Exception e) {
            errorStr = String.format("get bfd container failed,DB opert error,neid:%d", neID);
            this.logger.error(errorStr, (Throwable)e);
        }
        if (null != dbResult && 0 == dbResult.getResult() && null != (objList = dbResult.getData()) && !objList.isEmpty()) {
            bfdContainerMOPO = (TEPTNBfdContainerMOPO)objList.get(0);
        }
        return bfdContainerMOPO;
    }

    public QAsnBfdInfo trans2QasnBfdInfo(int neID, TEPTNBfdSessionObjMOPO opertObj) {
        QAsnBfdInfo result = new QAsnBfdInfo();
        result.neID = neID;
        result.poOperResult = new QAsnSingleReturn();
        result.poOperResult.isSuccess = true;
        result.poOperResult.retCode = 0;
        result.poOperResult.reason = "".getBytes();
        result.bfdFdn = this.getBfdFdn(neID, opertObj.getBFDSessionID());
        result.iLocalID = (int)opertObj.getLocalID();
        result.iRemoteID = (int)opertObj.getRemoteID();
        result.iAdminStatus = this.transQAdminStatus(opertObj.getSessionStatus(), true);
        result.iSessionType = this.getQSessionType(opertObj.getSessionType());
        result.iMinTxInterval = (int)opertObj.getTxInterval();
        result.iMinRxInterval = (int)opertObj.getRxInterval();
        result.iDetectMult = (int)opertObj.getDetectMult();
        result.iSessionStatus = this.transQxSessionStatus(opertObj.getSessionStatus(), true);
        result.iBfdDeployStatus = 0;
        result.poSessionID = (int)opertObj.getBFDSessionID();
        result.iServiceType = 1;
        result.isProcessIf = 0;
        result.iTosExp = 0;
        result.iWtr = 0;
        result.strDescription = "".getBytes();
        result.strName = "".getBytes();
        result.poBfdBindService = new QAsnBfdBindService();
        QAsnBfdBindIpLink bfdIpLink = null;
        QAsnBfdBindVrfIp vrfIp = null;
        if (0xFFFFFFFFL != opertObj.getVrfIndex()) {
            vrfIp = new QAsnBfdBindVrfIp();
            vrfIp.poSourceIp = IPAddressUtil.convertIPLongToStr((long)opertObj.getSrcIpAddress()).getBytes();
            vrfIp.poRemoteIp = IPAddressUtil.convertIPLongToStr((long)opertObj.getDestIpAddress()).getBytes();
            vrfIp.strVrfFdn = this.getVrfFDN(neID, opertObj.getVrfID());
            result.poBfdBindService.iBindServiceType = 2;
            result.poBfdBindService.poBfdBindVrfIp = vrfIp;
        } else {
            bfdIpLink = new QAsnBfdBindIpLink();
            bfdIpLink.iIpBindType = 1;
            AsnPTNCommonPort asnCommPort = new AsnPTNCommonPort();
            asnCommPort.portID = BigInteger.valueOf(this.getPortID((int)opertObj.getPortID()));
            asnCommPort.portType = BigInteger.valueOf(0L);
            asnCommPort.slotID = BigInteger.valueOf(opertObj.getSlotID());
            asnCommPort.portPPPEnableState = BigInteger.valueOf(1L);
            if (0 == opertObj.getSessionType()) {
                bfdIpLink.poOutInfFdn = this.getPortFDN(neID, asnCommPort);
            }
            bfdIpLink.poRemoteIp = IPAddressUtil.convertIPLongToStr((long)opertObj.getDestIpAddress()).getBytes();
            bfdIpLink.poSourceIp = IPAddressUtil.convertIPLongToStr((long)opertObj.getSrcIpAddress()).getBytes();
            result.poBfdBindService.iBindServiceType = 1;
            result.poBfdBindService.poBfdBindIpLink = bfdIpLink;
        }
        result.poAutoNegotiate = 0;
        return result;
    }

    public QAsnBfdInfo getDefaultBfdInfo(int neID, long sessionID, String errorDesc) {
        QAsnBfdInfo result = this.getDefaultBfdInfo(neID, sessionID);
        result.poOperResult = this.getAsnRet(1107329312, this.getBfdResByKey(neID, errorDesc));
        return result;
    }

    public QAsnBfdInfo getDefaultBfdInfo(int neID, long sessionID) {
        QAsnBfdInfo result = new QAsnBfdInfo();
        result.neID = neID;
        result.poOperResult = new QAsnSingleReturn();
        result.poOperResult.isSuccess = true;
        result.poOperResult.retCode = 0;
        result.iLocalID = 0;
        result.iRemoteID = 0;
        result.iAdminStatus = 0;
        result.iSessionType = 0;
        result.iMinTxInterval = 0;
        result.iMinRxInterval = 0;
        result.iDetectMult = 0;
        result.iSessionStatus = 0;
        result.poSessionID = (int)sessionID;
        result.iAdminStatus = 0;
        result.iBfdDeployStatus = 0;
        result.iServiceType = 1;
        result.isProcessIf = 0;
        result.iTosExp = 0;
        result.iWtr = 0;
        result.strDescription = "".getBytes();
        result.strName = "".getBytes();
        result.bfdFdn = this.getBfdFdn(neID, sessionID);
        return result;
    }

    public QAsnBfdInfo getDefaultBfdInfo(int neID, long sessionID, int errCode) {
        QAsnBfdInfo result = this.getDefaultBfdInfo(neID, sessionID);
        result.poOperResult = this.getAsnRet(errCode, TEErrorResourceUtil.getErrorMessage((int)errCode).getErrorinfo());
        return result;
    }

    public QAsnSingleReturn getAsnRet(int retCode, String reason) {
        QAsnSingleReturn asnRet = new QAsnSingleReturn();
        asnRet.isSuccess = 0 == retCode;
        asnRet.retCode = retCode;
        asnRet.reason = reason.getBytes();
        return asnRet;
    }

    public QAsnSingleReturn getAsnRet(ErrorMessage errMsg) {
        return this.getAsnRet(Integer.parseInt(errMsg.getErrorcode()), errMsg.getErrorinfo());
    }

    public List<QAsnBfdInfo> trans2QasnBfdInfo(int neID, Set<TEPTNBfdSessionObjMOPO> opertObj) {
        ArrayList<TEPTNBfdSessionObjMOPO> bfdPoList = new ArrayList<TEPTNBfdSessionObjMOPO>(opertObj);
        return this.trans2QasnBfdInfo(neID, bfdPoList);
    }

    public List<QAsnBfdInfo> trans2QasnBfdInfo(int neID, List<TEPTNBfdSessionObjMOPO> opertObj) {
        ArrayList<QAsnBfdInfo> bfdInfoList = new ArrayList<QAsnBfdInfo>();
        QAsnBfdInfo asnBfdInfo = null;
        for (TEPTNBfdSessionObjMOPO bfdPo : opertObj) {
            if (null == bfdPo) continue;
            asnBfdInfo = this.trans2QasnBfdInfo(neID, bfdPo);
            bfdInfoList.add(asnBfdInfo);
        }
        return bfdInfoList;
    }

    public QAsnBfdInfoEx trans2QAsnBfdInfoEx(int neID, TEPTNBfdSessionObjMOPO bfdPo) {
        return this.trans2QAsnBfdInfoEx(neID, bfdPo.getBFDSessionID());
    }

    public QAsnBfdInfoEx trans2QAsnBfdInfoEx(int neID, long sessionID) {
        QAsnBfdInfoEx asnBfdInfoEx = new QAsnBfdInfoEx();
        asnBfdInfoEx.oBfdKey = this.getBfdFdn(neID, sessionID);
        return asnBfdInfoEx;
    }

    public List<QAsnBfdInfoEx> trans2QAsnBfdInfoEx(int neID, List<TEPTNBfdSessionObjMOPO> opertObj) {
        ArrayList<QAsnBfdInfoEx> bfdInfoExList = new ArrayList<QAsnBfdInfoEx>();
        QAsnBfdInfoEx asnBfdInfoEx = null;
        for (TEPTNBfdSessionObjMOPO bfdPo : opertObj) {
            asnBfdInfoEx = this.trans2QAsnBfdInfoEx(neID, bfdPo);
            bfdInfoExList.add(asnBfdInfoEx);
        }
        return bfdInfoExList;
    }

    public Object getQasnListForRpt(int neID, List<TEPTNBfdSessionObjMOPO> bfdListFromNe, List<TEPTNBfdSessionObjMOPO> bfdListFromDB, int rptFlag) {
        QAsnBfdInfoList bfdInfoList = new QAsnBfdInfoList();
        List<TEPTNBfdSessionObjMOPO> diffBfdList = null;
        if (1 == rptFlag) {
            QAsnBfdInfoExList bfdInfoExList = new QAsnBfdInfoExList();
            diffBfdList = this.getExcluSet(bfdListFromDB, bfdListFromNe);
            bfdInfoExList.addAll(this.trans2QAsnBfdInfoEx(neID, diffBfdList));
            return bfdInfoExList;
        }
        if (0 == rptFlag) {
            diffBfdList = this.getExcluSet(bfdListFromNe, bfdListFromDB);
            bfdInfoList.addAll(this.trans2QasnBfdInfo(neID, diffBfdList));
        } else if (2 == rptFlag) {
            diffBfdList = this.getDiffSet(bfdListFromDB, bfdListFromNe);
            bfdInfoList.addAll(this.trans2QasnBfdInfo(neID, diffBfdList));
        }
        return bfdInfoList;
    }

    public List<TEPTNBfdSessionObjMOPO> getExcluSet(List<TEPTNBfdSessionObjMOPO> ls1, List<TEPTNBfdSessionObjMOPO> ls2) {
        ArrayList<TEPTNBfdSessionObjMOPO> result = new ArrayList<TEPTNBfdSessionObjMOPO>(Arrays.asList(new TEPTNBfdSessionObjMOPO[ls1.size()]));
        ArrayList<TEPTNBfdSessionObjMOPO> list2 = new ArrayList<TEPTNBfdSessionObjMOPO>(Arrays.asList(new TEPTNBfdSessionObjMOPO[ls2.size()]));
        Collections.copy(result, ls1);
        Collections.copy(list2, ls2);
        Iterator iterls1 = result.iterator();
        block0: while (iterls1.hasNext()) {
            TEPTNBfdSessionObjMOPO bfdPols1 = (TEPTNBfdSessionObjMOPO)iterls1.next();
            Iterator iterls2 = list2.iterator();
            while (iterls2.hasNext()) {
                TEPTNBfdSessionObjMOPO bfdPols2 = (TEPTNBfdSessionObjMOPO)iterls2.next();
                if (bfdPols2.getBFDSessionID() != bfdPols1.getBFDSessionID()) continue;
                iterls1.remove();
                iterls2.remove();
                continue block0;
            }
        }
        return result;
    }

    public List<TEPTNBfdSessionObjMOPO> getDiffSet(List<TEPTNBfdSessionObjMOPO> ls1, List<TEPTNBfdSessionObjMOPO> ls2) {
        ArrayList<TEPTNBfdSessionObjMOPO> result = new ArrayList<TEPTNBfdSessionObjMOPO>(Arrays.asList(new TEPTNBfdSessionObjMOPO[ls1.size()]));
        ArrayList<TEPTNBfdSessionObjMOPO> list2 = new ArrayList<TEPTNBfdSessionObjMOPO>(Arrays.asList(new TEPTNBfdSessionObjMOPO[ls2.size()]));
        Collections.copy(list2, ls2);
        block0: for (TEPTNBfdSessionObjMOPO bfdPols1 : ls1) {
            Iterator iterls2 = list2.iterator();
            while (iterls2.hasNext()) {
                TEPTNBfdSessionObjMOPO bfdPols2 = (TEPTNBfdSessionObjMOPO)iterls2.next();
                if (bfdPols2.getBFDSessionID() != bfdPols1.getBFDSessionID() || bfdPols2.equals((Object)bfdPols1)) continue;
                result.add(bfdPols2);
                iterls2.remove();
                continue block0;
            }
        }
        return result;
    }

    public AsnPTNCommonPort getPortByFdnReq(int neID, QAsnUniResID asnBfdFdn) {
        AsnPTNGetPortByFdnReq req = new AsnPTNGetPortByFdnReq();
        AsnPTNGetPortByFdnRsp rsp = new AsnPTNGetPortByFdnRsp();
        AsnPTNCommonPort asnCommonPort = new AsnPTNCommonPort();
        asnCommonPort.portID = BigInteger.ZERO;
        asnCommonPort.slotID = BigInteger.ZERO;
        asnCommonPort.portType = BigInteger.ZERO;
        asnCommonPort.portPPPEnableState = BigInteger.ZERO;
        req.neID = rsp.neID = BigInteger.valueOf(neID);
        req.strFDN = asnBfdFdn.strFDN;
        req.poSerialNum = null == asnBfdFdn.poSerialNum ? "".getBytes() : asnBfdFdn.poSerialNum;
        req.strMOC = asnBfdFdn.strMOC;
        this.logger.info(TEAsn1Util.getAsn1String((Object)req));
        rsp.port = asnCommonPort;
        long result = TEJNIFacadeUtil.sendJNIMessage((int)7, (FStruct)req, (FStruct)rsp);
        if (0L == result && null != rsp) {
            this.logger.info(TEAsn1Util.getAsn1String((Object)rsp));
            asnCommonPort = rsp.port;
            asnCommonPort.portID = asnCommonPort.portID;
        }
        return asnCommonPort;
    }

    public QAsnUniResID getPortFDN(int neID, AsnPTNCommonPort asnCommPort) {
        AsnPTNGetFdnByPortReq req = new AsnPTNGetFdnByPortReq();
        AsnPTNGetFdnByPortRsp rsp = new AsnPTNGetFdnByPortRsp();
        QAsnUniResID asnBfdFdn = new QAsnUniResID();
        asnBfdFdn.strFDN = "".getBytes();
        asnBfdFdn.strMOC = "".getBytes();
        asnBfdFdn.poSerialNum = "".getBytes();
        req.neID = rsp.neID = BigInteger.valueOf(neID);
        req.port = asnCommPort;
        rsp.strFDN = "".getBytes();
        rsp.poSerialNum = "".getBytes();
        rsp.strMOC = "".getBytes();
        this.logger.info(TEAsn1Util.getAsn1String((Object)req));
        long result = TEJNIFacadeUtil.sendJNIMessage((int)8, (FStruct)req, (FStruct)rsp);
        if (0L == result && null != rsp) {
            this.logger.info(TEAsn1Util.getAsn1String((Object)rsp));
            asnBfdFdn.strFDN = rsp.strFDN;
            asnBfdFdn.strMOC = rsp.strMOC;
            asnBfdFdn.neID = rsp.neID.intValue();
            asnBfdFdn.poSerialNum = rsp.poSerialNum;
        }
        return asnBfdFdn;
    }

    public static final TENEMgrInterface getNEExploreBean(SubFunc subFunc) {
        String className = subFunc.getClassMapping();
        TENEMgrInterface neExploreBean = null;
        try {
            if (null == className || "".equals(className)) {
                className = "com.huawei.nglct.explorer.TENEExplorerBean";
            }
            neExploreBean = (TENEMgrInterface)Class.forName(className).newInstance();
        }
        catch (InstantiationException e) {
            TELogFactory.getNormalLogger().info("[BFD Module]get neexploreBean failed!", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            TELogFactory.getNormalLogger().info("[BFD Module]get neexploreBean failed!", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            TELogFactory.getNormalLogger().info("[BFD Module]get neexploreBean failed!", (Throwable)e);
        }
        return neExploreBean;
    }

    public TEVrfResultObject getVrfIndexById(int userId, int neID, long vrfId) {
        AsnPTNGetVrfIndexByIdReq req = new AsnPTNGetVrfIndexByIdReq();
        AsnPTNVrfkey vrfKey = null;
        TEVrfResultObject vrfRetObj = new TEVrfResultObject();
        req.userID = BigInteger.valueOf(userId);
        req.vrfKeyList = new AsnPTNVrfkeyList();
        vrfKey = new AsnPTNVrfkey();
        vrfKey.neID = BigInteger.valueOf(neID);
        vrfKey.result = this.getDefaultSingleReturn();
        vrfKey.vrfID = BigInteger.valueOf(vrfId);
        vrfKey.vrfIndex = BigInteger.valueOf(0xFFFFFFFFL);
        req.vrfKeyList.add((Object)vrfKey);
        AsnPTNGetVrfIndexdByIdRsp rsp = new AsnPTNGetVrfIndexdByIdRsp();
        rsp.result = this.getDefaultSingleReturn();
        long ret = TEJNIFacadeUtil.sendJNIMessage((int)9, (FStruct)req, (FStruct)rsp);
        if (0L == ret && null != rsp) {
            vrfKey = (AsnPTNVrfkey)rsp.vrfKeyList.get(0);
            if (vrfKey.result.isSuccess) {
                vrfRetObj.setVrfIndex(vrfKey.vrfIndex.longValue());
            }
        }
        vrfRetObj.setErrorCode((int)ret);
        return vrfRetObj;
    }

    public AsnSingleReturn getDefaultSingleReturn() {
        AsnSingleReturn singleReturn = new AsnSingleReturn();
        singleReturn.isSuccess = false;
        singleReturn.retCode = BigInteger.valueOf(1107329312L);
        singleReturn.reason = "".getBytes();
        return singleReturn;
    }

    public QAsnUniResID getBfdFdn(int neID, long sessionID) {
        QAsnUniResID uniResID = new QAsnUniResID();
        uniResID.neID = neID;
        uniResID.poSerialNum = "".getBytes();
        uniResID.strMOC = "".getBytes();
        StringBuilder builder = new StringBuilder();
        builder.append("NE=").append(neID).append(",");
        builder.append("BFD=").append(sessionID).append("|");
        uniResID.strFDN = builder.toString().getBytes();
        return uniResID;
    }

    public QAsnUniResID getVrfFDN(int neID, long vrfID) {
        QAsnUniResID uniResID = new QAsnUniResID();
        uniResID.neID = neID;
        uniResID.poSerialNum = "".getBytes();
        uniResID.strMOC = "".getBytes();
        StringBuilder builder = new StringBuilder();
        builder.append("NE=").append(neID).append(",");
        builder.append("VRF=").append(vrfID).append("|");
        uniResID.strFDN = builder.toString().getBytes();
        return uniResID;
    }

    public int getQxSessionType(int qSessionType) {
        return 3 == qSessionType ? 0 : 1;
    }

    public int getQSessionType(int qxSessionType) {
        return 0 == qxSessionType ? 3 : 4;
    }

    public int transQxSessionStatus(int sessionStatus_qx, boolean flagE2ERet) {
        return flagE2ERet ? sessionStatus_qx + 1 : sessionStatus_qx;
    }

    public int transQAdminStatus(int sessionStatus_qx, boolean flagE2ERet) {
        int adminStatus;
        int n = adminStatus = 0 == sessionStatus_qx ? 0 : 1;
        if (flagE2ERet) {
            adminStatus = 1 == adminStatus ? adminStatus : 2;
        }
        return adminStatus;
    }

    public int transE2EAdminStatus(int adminStatus_e2e) {
        return 1 == adminStatus_e2e ? 1 : 0;
    }

    public BitSet constructBitSet(int modifyMask) {
        BitSet s1 = new BitSet();
        for (int i = 31; i >= 0; --i) {
            if ((1 << i & modifyMask) != 0) {
                s1.set(i);
                continue;
            }
            s1.clear(i);
        }
        return s1;
    }

    public int getPortID(int absolutePortID) {
        return absolutePortID & 0xFFFF;
    }

    public boolean verifyUniRes(QAsnUniResID uniRes, boolean flagMoc) {
        boolean flagValid;
        boolean bl = flagValid = null != uniRes && this.verifyBytes(uniRes.strFDN);
        if (flagMoc) {
            flagValid = flagValid || this.verifyBytes(uniRes.strMOC);
        }
        return flagValid;
    }

    public boolean isNumericStr(byte[] inputBytes) {
        if (null == inputBytes) {
            return false;
        }
        return this.isNumericStr(new String(inputBytes));
    }

    public boolean isNumericStr(String inputStr) {
        try {
            Long.parseLong(inputStr);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static Long getCommPort(long portid, long subslotid) {
        String result = "10";
        if (255L != subslotid) {
            result = Long.toHexString(subslotid) + result;
        }
        String temp = Long.toHexString(portid);
        while (temp.length() < 4) {
            temp = "0" + temp;
        }
        result = result + temp;
        return Long.parseLong(result, 16);
    }

    public static void updateByCommPort(long commPort, RowParams rowParams) {
        int size = rowParams.getParamCount();
        for (int i = 0; i < size; ++i) {
            Param param = rowParams.getParam(i);
            if (!param.getName().equals("frontport")) continue;
            param.setValue(String.valueOf(commPort));
        }
    }

    public boolean verifyBytes(byte[] inputBytes) {
        return null != inputBytes && !"".equals(new String(inputBytes));
    }

    public QAsnErrInfo getAsnErrInfo(int neID, long sessionId, String errorDesc) {
        return this.getAsnErrInfo(neID, sessionId, 1107329312, errorDesc);
    }

    public QAsnErrInfo getAsnErrInfo(int neID, long sessionId, int errCode, String errorDesc) {
        QAsnErrInfo errorInfo = new QAsnErrInfo();
        errorInfo.objID.add((Object)neID);
        errorInfo.objName = this.getBfdFdn((int)neID, (long)sessionId).strFDN;
        errorInfo.errCode = errCode;
        errorInfo.strOperDesc = errorDesc.getBytes();
        return errorInfo;
    }

    public static int getQueryBfdQxCmd() {
        return 2106573;
    }

    public static int getModifyBfdQxCmd() {
        return 2106576;
    }

    public static int getCreateBfdQxCmd() {
        return 2106574;
    }

    public static int getDeleteBfdQxCmd() {
        return 2106575;
    }
}

