/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.bfdmanagement;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.convertor.IPAddressUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.util.ArrayList;

public class TEQueryVRFInfo
extends TENEExplorerBean {
    private TEResourceUtil res = null;
    private final String filePath = "ptn/res/bfdmanagement/bfdmanagement_" + TESysManagerBean.getInstance().getlanguage() + ".ini";
    private static final int RD_TYPE_AS = 0;
    private static final int RD_TYPE_IPV4 = 1;
    private static final String DEFAULT_VRFINDEX = "4294967295";
    private static final String VRFINDEX_STRING = "vrfIndex";
    private static final String VRFID_STRING = "vrfID";
    private static final String VPNNAME_STRING = "name";
    private static final String RDINFO_STRING = "RDInfo";
    private static final String RDTYPE_STRING = "RDType";
    private static final String RDADMINNO_STRING = "RDAdministrator";
    private static final String TDASSIGNEDNO_STRING = "TDAssignedNumber";
    private static final String EMPTY_STRING = "";
    private final String Default_VPNNAME;

    public TEQueryVRFInfo() {
        this.res = TEGetFilePath.getResource((int)this.neid, (String)this.filePath);
        this.Default_VPNNAME = this.res.getString("DefaultVPNName");
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        BussinessParams bussiness = this.outputData.getBussinessParams();
        String errorCode = this.outputData.getErrorMessage().getErrorcode();
        try {
            int errorCodeNum = Integer.parseInt(errorCode);
            ArrayList<RowParams> rowList = new ArrayList<RowParams>();
            if (0 == errorCodeNum) {
                RowParams[] rowParams = bussiness.getRowParams();
                for (int i = rowParams.length - 1; i >= 0; --i) {
                    RowParams rowParam = rowParams[i];
                    rowList.add(rowParam);
                }
                this.outputData.getBussinessParams().clearRowParams();
                RowParams defaultParams = this.getDefaultVRFParams();
                this.outputData.getBussinessParams().addRowParams(defaultParams);
                int size = rowList.size();
                for (int i = 0; i < size; ++i) {
                    RowParams rowParam = (RowParams)rowList.get(i);
                    this.analyseRDInfoByRDType(rowParam);
                    this.outputData.getBussinessParams().addRowParams(rowParam);
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse VRF Info Failed!", (Throwable)e);
        }
    }

    private RowParams getDefaultVRFParams() {
        Param[] params;
        RowParams defaultParams = new RowParams();
        for (Param param : params = new Param[]{new Param(VRFINDEX_STRING, DEFAULT_VRFINDEX), new Param(VRFID_STRING, "/"), new Param(VPNNAME_STRING, this.Default_VPNNAME), new Param(RDINFO_STRING, "/")}) {
            defaultParams.addParam(param);
        }
        return defaultParams;
    }

    private void analyseRDInfoByRDType(RowParams rowParam) {
        String ipStr;
        Param rdInfoParam = rowParam.getParam(RDINFO_STRING);
        String rdInfoString = null;
        if (rdInfoParam == null) {
            rdInfoParam = new Param(RDINFO_STRING, EMPTY_STRING);
            rowParam.addParam(rdInfoParam);
            Param rdTypeParam = rowParam.getParam(RDTYPE_STRING);
            if (null == rdTypeParam || EMPTY_STRING.equals(rdTypeParam.getValue())) {
                rdInfoParam.setValue("/");
                return;
            }
        }
        int rdType = Integer.parseInt(rowParam.getParam(RDTYPE_STRING).getValue().trim());
        long rdAdminNo = Long.parseLong(rowParam.getParam(RDADMINNO_STRING).getValue().trim());
        long tdAssignedNo = Long.parseLong(rowParam.getParam(TDASSIGNEDNO_STRING).getValue().trim());
        rdInfoString = 0 == rdType ? rdAdminNo + ":" + tdAssignedNo : (1 == rdType ? (IPAddressUtil.isValidIP((String)(ipStr = IPAddressUtil.convertIPLongToStr((long)rdAdminNo))) ? ipStr + ":" + tdAssignedNo : "/") : "/");
        rdInfoParam.setValue(rdInfoString);
    }
}

