/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.bfdmanagement;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ptn.TENE_PTN;
import com.huawei.nglct.ptn_pub.TEPTNUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TEQueryVEthnetPortBean
extends TENEExplorerBean {
    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList);
        if (2 == Integer.parseInt(this.outputData.getErrorMessage().getErrorcode())) {
            return;
        }
        Definitions definitions = null;
        try {
            definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse QxDesFile fail!", (Throwable)e);
            return;
        }
        String slotidStr = this.inputData.getBussinessParams().getRowParams()[0].getParam("slotid").getValue();
        operationList.clear();
        ArrayList rowList = this.outputData.getBussinessParams().getRowParamList();
        Operation oper_name = null;
        Operation oper_mp = null;
        if (((TENE_PTN)TENEListMgr.getInstance().getNE(neid)).getBibyteVersion()) {
            oper_name = definitions.getOperation("NSCMD_PTN_PORT_GET_NAME_EX");
            oper_mp = definitions.getOperation("NSCMD_ETHN_MLPPP_GET_MP_EX");
        } else {
            oper_name = definitions.getOperation("NSCMD_PTN_PORT_GET_NAME");
            oper_mp = definitions.getOperation("NSCMD_ETHN_MLPPP_GET_MP");
        }
        Input input = oper_name.getInput();
        input.setPartValue("slotid", slotidStr);
        input.setPartValue("subslotid", "255");
        input.setPartValue("port", "0");
        operationList.add(oper_name);
        String portName = "";
        int result = this.sendMessage(neid);
        if (result != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            return;
        }
        Operation tmpOper = (Operation)operationList.get(0);
        Output[] output = tmpOper.getOutput();
        for (Fault fault : output[0].getFault()) {
            int code = Integer.parseInt(fault.getCode());
            if (code == 0) continue;
            ErrorMessage bigErr = TEErrorResourceUtil.getErrorMessage((int)1);
            this.outputData.setErrorMessage(bigErr);
            return;
        }
        TEPTNUtil ptnUtil = TEPTNUtil.instance();
        Iterator ite = rowList.iterator();
        while (ite.hasNext()) {
            RowParams row = (RowParams)ite.next();
            int portId = Integer.parseInt(row.getParam("vport").getValue());
            if (ptnUtil.isVEPort(portId)) {
                ite.remove();
                continue;
            }
            int len = output.length;
            for (int j = 0; j < len; ++j) {
                int portId2 = Integer.parseInt(output[j].getPartValue("port"));
                if (portId != portId2) continue;
                portName = ptnUtil.getLogicPortName(portId, portName);
                row.getParam("portName").setValue(portName);
                break;
            }
            portName = "";
        }
        input = oper_mp.getInput();
        input.setPartValue("mpid", "0");
        operationList.clear();
        operationList.add(oper_mp);
        result = this.sendMessage(neid);
        if (result != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            return;
        }
        operationList.add(0, oper_name);
        this.getQueryMLPPPOper(operationList);
    }

    private void getQueryMLPPPOper(List operList) {
        Operation tmpOper = (Operation)operList.get(1);
        Operation portNameOper = (Operation)operList.get(0);
        Output[] outputArr = tmpOper.getOutput();
        ArrayList<String> portidList = new ArrayList<String>();
        for (Output output : outputArr) {
            int mpid;
            boolean isRepeat;
            Fault[] faultArr = output.getFault();
            boolean isEmpty = false;
            for (Fault fault : faultArr) {
                String code = fault.getCode();
                if (null != code && Integer.parseInt(code) == 0) continue;
                isEmpty = true;
                break;
            }
            if (isEmpty || (isRepeat = portidList.contains((mpid = Integer.parseInt(output.getPartValue("mpid"))) + ""))) continue;
            portidList.add(mpid + "");
        }
        Output[] outputArr2 = portNameOper.getOutput();
        TEPTNUtil ptnUtil = TEPTNUtil.instance();
        String portname = "";
        for (Output output2 : outputArr2) {
            int mpidlen = portidList.size();
            for (int k = 0; k < mpidlen; ++k) {
                int portId2;
                int portId = Integer.parseInt((String)portidList.get(k));
                if (portId != (portId2 = Integer.parseInt(output2.getPartValue("port")))) continue;
                portname = ptnUtil.getLogicPortName(portId, portname);
                this.constructRowData(portId, portname);
                break;
            }
            portname = "";
        }
    }

    private void constructRowData(int portID, String portName) {
        RowParams rParams = new RowParams();
        Param param = null;
        param = new Param("portType", "MLPPP");
        rParams.addParam(param);
        param = new Param("slotid", "65535");
        rParams.addParam(param);
        param = new Param("subslotid", "255");
        rParams.addParam(param);
        param = new Param("vport", String.valueOf(portID));
        rParams.addParam(param);
        param = new Param("portName", portName);
        rParams.addParam(param);
        this.outputData.getBussinessParams().addRowParams(rParams);
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

