/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.bfdmanagement;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;

public class TEQueryTrackBFD
extends TENEExplorerBean {
    public static final long MPLSTUNNELSTARTINDEX = 1L;
    public static final long GRETUNNELSTARTINDEX = 0x1000001L;
    public static final long IPTUNNELSTARTINDEX = 0x2000001L;
    private Definitions definitions = null;
    private static final int VIRTUAL_PORT = 10240;
    private static final int VIRTUAL_PORT_2 = 14336;
    private static final int VIRTUAL_PORT_EXCURSION = 2048;
    private static final int MLPPP_PORT = 4096;
    public static final int MPLS = 0;
    public static final int GRE = 1;
    public static final int IP = 2;
    public static final String SINGLE_HOP = "0";
    public static final String MULTI_HOP = "1";
    public static final int TRACE_TYPE_BFD = 1;
    public static final int TRACE_TYPE_VRRP = 2;
    TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.operationList = new ArrayList();
            ArrayList<Object> fstOperationList = new ArrayList<Object>();
            ArrayList<Object> scdOperationList = new ArrayList<Object>();
            Definitions definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
            this.outputData = new Datainterface();
            this.outputData.setBussinessParams(new BussinessParams());
            String staticrouteid = inputData.getBussinessParams().getRowParams()[0].getParam("staticrouteid").getValue();
            Operation operation = definitions.getOperation("NSCMD_IP_ROUTE_GET_STCROUTE_TRACKEVT");
            operation.getInput().setPartValue("staticrouteid", staticrouteid);
            fstOperationList.add(operation.clone());
            OperationResult result = TENECommMgr.getInstance().sendCommand(neid, fstOperationList, this.TIME_OUT);
            if (result.retCode == 0) {
                Output output = ((Operation)fstOperationList.get(0)).getOutput(0);
                int returnCode = Integer.parseInt(output.getFault(0).getCode());
                if (0 == returnCode) {
                    String tracertType = output.getPartValue("trackevttype");
                    String bfdIndex = output.getPartValue("trackevtindex");
                    if (Integer.valueOf(tracertType) == 1 && !bfdIndex.equals(SINGLE_HOP)) {
                        operation = definitions.getOperation("NSCMD_CFG_BFD_GET_SESSION_EXPAND_INFO");
                        operation.getInput().setPartValue("sessionIndex", bfdIndex);
                        scdOperationList.add(operation.clone());
                    } else {
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                    }
                } else {
                    ErrorMessage errorMessage = new ErrorMessage();
                    errorMessage.setErrorcode(returnCode + "");
                    errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)returnCode));
                    RowErrors rowError = new RowErrors();
                    Param errorparam = new Param("neid", String.valueOf(neid));
                    rowError.addParam(errorparam);
                    errorparam = new Param("staticrouteid", staticrouteid);
                    rowError.addParam(errorparam);
                    errorparam = new Param("nename", TENEListMgr.getInstance().getNE(neid).getNEName());
                    rowError.addParam(errorparam);
                    RowParams rowParams = new RowParams();
                    rowParams.addRowErrors(rowError);
                    rowError.setErrorMessage(errorMessage);
                    this.outputData.getBussinessParams().addRowParams(rowParams);
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
                }
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result.retCode));
            }
            if (!scdOperationList.isEmpty()) {
                result = TENECommMgr.getInstance().sendCommand(neid, scdOperationList, this.TIME_OUT);
                if (result.retCode == 0) {
                    this.operationList.clear();
                    this.operationList.addAll(scdOperationList);
                    this.handleMessage(neid, this.operationList, subFunc, this.getFilterErrorCodeList());
                } else {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result.retCode));
                }
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        BussinessParams bussiness = this.outputData.getBussinessParams();
        boolean allSucc = true;
        boolean allFail = true;
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        Vector logBoardList = neObj.getBoardList();
        int errorCode = Integer.parseInt(this.outputData.getErrorMessage().getErrorcode());
        ArrayList<RowParams> rowList = new ArrayList<RowParams>();
        if (0 == errorCode) {
            int i;
            allFail = false;
            RowParams[] rowParams = bussiness.getRowParams();
            for (i = rowParams.length - 1; i >= 0; --i) {
                RowParams rowParam = rowParams[i];
                if (rowParam.getParam("sourceboard").getValue().equals("") || rowParam.getParam("frontport").getValue().equals("")) continue;
                rowList.add(rowParam);
            }
            this.outputData.getBussinessParams().clearRowParams();
            int size = rowList.size();
            for (i = 0; i < size; ++i) {
                RowParams rowParam = (RowParams)rowList.get(i);
                int slotId = Integer.parseInt(rowParam.getParam("sourceboard").getValue());
                int portId = Integer.parseInt(rowParam.getParam("frontport").getValue());
                this.outputData.getBussinessParams().addRowParams(rowParam);
                if (rowParam.getParam("sessiontype").getValue().equals(SINGLE_HOP)) {
                    rowParam.addParam("frontportName", this.queryPortName(slotId, portId));
                }
                int len = logBoardList.size();
                for (int bdIndex = 0; bdIndex < len; ++bdIndex) {
                    TEBoard board = (TEBoard)logBoardList.get(bdIndex);
                    int boardType = board.getBoardType();
                    int boardSlot = board.getSlotID();
                    if (boardSlot != slotId) continue;
                    String boardName = this.cfgDataMgr.getBoardTypeName(neid, boardType);
                    rowParam.addParam("bdName", boardName);
                }
                String tunnelIndex = rowParam.getParam("tunnelindex").getValue();
                if (tunnelIndex == null || tunnelIndex.equals("")) {
                    rowParam.addParam("bindtype", "3");
                    continue;
                }
                if ("4294967295".equals(tunnelIndex)) {
                    rowParam.addParam("bindtype", MULTI_HOP);
                    continue;
                }
                rowParam.addParam("tunnelid", SINGLE_HOP);
                rowParam.addParam("ip", SINGLE_HOP);
            }
            if (allSucc) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            } else if (allFail) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1));
            }
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> filterErrorCodeList = new ArrayList<Integer>(1);
        filterErrorCodeList.add(new Integer(38662));
        return filterErrorCodeList;
    }

    private String queryPortName(int slotid, int port) {
        try {
            this.definitions = TECreateObjectFactory.parseQxDesFile((int)this.neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse QxDesFile fail!", (Throwable)e);
        }
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation oper = this.definitions.getOperation("NSCMD_PTN_PORT_GET_NAME_EX");
        if (oper == null) {
            oper = this.definitions.getOperation("NSCMD_PTN_PORT_GET_NAME");
        }
        Input input2 = oper.getInput();
        input2.setPartValue("slotid", slotid + "");
        input2.setPartValue("subslotid", "255");
        input2.setPartValue("port", port + "");
        operationList.add(oper);
        TENECommMgr.getInstance().sendCommand(this.neid, operationList, this.TIME_OUT);
        String portName = ((Operation)operationList.get(0)).getOutput()[0].getPartValue("portName");
        if (portName == null) {
            return "";
        }
        if ("".equals(portName = portName.trim())) {
            String resFilePath = "res" + File.separator + "stringresource_" + TESysManagerBean.getInstance().getlanguage() + ".ini";
            portName = TEResourceUtil.getInstance((String)resFilePath).getString("portname") + "-" + port;
        }
        if (port >= 10240) {
            int portExcursion = 10240;
            if (14336 <= port) {
                portExcursion = 12288;
            }
            portName = portName == null || "".equals(portName.trim()) ? Integer.valueOf(port - portExcursion).toString() : portName.trim();
            portName = port - portExcursion + "(VEther-" + portName + ")";
        } else if (port >= 4096) {
            portName = portName == null || "".equals(portName.trim()) ? Integer.valueOf(port - 4096).toString() : portName.trim();
            portName = port - 4096 + "(MP-" + portName + ")";
        } else {
            portName = port + "(" + portName + ")";
        }
        return portName;
    }
}

