/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.bfdmanagement;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.nelist.model.circuitpack.TEPortProperty;
import com.huawei.nglct.nemgr.ptn.util.TEGetPortRes;
import com.huawei.nglct.ptn_pub.TEPTNDataMgr;
import com.huawei.nglct.ptn_pub.TEPTNPortNumData;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.slf4j.Logger;

public class TEQueryPorts
implements TENEMgrInterface {
    private Datainterface datainterface = null;
    Vector boardList = null;
    int neID = 0;
    int slotID = 0;
    int subslotID = 0;
    int querytype = 0;
    private Logger log = TELogFactory.getNormalLogger();
    private TEGetPortRes resUtil = TEGetPortRes.getInstance();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neID = neid;
        Param slotidParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"slotid");
        this.slotID = Integer.parseInt(slotidParam.getValue());
        Param subSlotidParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"subslotid");
        this.subslotID = Integer.parseInt(subSlotidParam.getValue());
        Param queryTypeParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"querytype");
        if (queryTypeParam != null) {
            this.querytype = Integer.parseInt(queryTypeParam.getValue());
        }
        this.datainterface = this.querytype == 0 ? this.constructBoardListData() : this.constructEthPortData();
        if (null != this.datainterface && null != this.datainterface.getBussinessParams()) {
            this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        } else {
            this.log.error("Get BoardInfo Fail!\n");
            this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
        }
        return this.datainterface;
    }

    public Datainterface constructEthPortData() {
        Datainterface data = new Datainterface();
        BussinessParams bParams = new BussinessParams();
        String portLists = "";
        Param param = null;
        TENE ne = TEConfigurationDataMgr.getInstance().getNE(this.neID);
        int neType = ne.getNEType();
        List portNumBoardList = TEPTNDataMgr.getInstance().getPortNumList(neType);
        if (this.subslotID == 0) {
            int boardType = TEConfigurationDataMgr.getInstance().getBoard(this.neID, this.slotID).getBoardType();
            boolean hasInvalidPort = false;
            Set invalid_portlist = new HashSet();
            if (null != portNumBoardList) {
                for (TEPTNPortNumData portNumData : portNumBoardList) {
                    TEBoard processBoard;
                    if (this.slotID != portNumData.getCur_cpslotID() || !portNumData.getCur_cptype_list().contains(boardType) || null == (processBoard = ne.getBoard(portNumData.getPcp_slotID())) || !portNumData.getPcp_type_list().contains(processBoard.getBoardType())) continue;
                    hasInvalidPort = true;
                    invalid_portlist = portNumData.getInvalid_portlist();
                    break;
                }
            }
            ArrayList<TEPortProperty> boardPortList = this.resUtil.getAllPorts(this.neID, this.slotID, this.subslotID, boardType);
            int len = boardPortList.size();
            for (int j = 0; j < len; ++j) {
                TEPortProperty portProperty = boardPortList.get(j);
                int portID = portProperty.getPortNo();
                if (portProperty.getPortType() != 1799 && portProperty.getPortType() != 1025 || hasInvalidPort && invalid_portlist.contains(portID)) continue;
                RowParams rParams = new RowParams();
                String portName = TEConfigurationDataMgr.getInstance().getPortName(this.neID, this.slotID, boardType, portID);
                portLists = portName + "," + portID;
                param = new Param("portList", portLists);
                rParams.addParam(param);
                param = new Param("slotid", this.slotID + "");
                rParams.addParam(param);
                param = new Param("portid", portID + "");
                rParams.addParam(param);
                param = new Param("subslotid", "0");
                rParams.addParam(param);
                bParams.addRowParams(rParams);
            }
        } else {
            List subBoardList = TEConfigurationDataMgr.getInstance().getBoard(this.neID, this.slotID).getSubBoardList();
            int isize = subBoardList.size();
            for (int k = 0; k < isize; ++k) {
                TESubBoard subBoards = (TESubBoard)subBoardList.get(k);
                int subBoardType = subBoards.getSubBoardType();
                int subBoardSlot = subBoards.getSubSlotID();
                ArrayList<TEPortProperty> subBoardPortList = this.resUtil.getAllPorts(this.neID, this.slotID, this.subslotID, subBoardType);
                int len = subBoardPortList.size();
                for (int j = 0; j < len; ++j) {
                    int portID = subBoardPortList.get(j).getPortNo();
                    RowParams rParams = new RowParams();
                    String portName = TEConfigurationDataMgr.getInstance().getPortName(this.neID, subBoardSlot, subBoardType, portID);
                    portLists = portName + "," + portID;
                    param = new Param("portList", portLists);
                    rParams.addParam(param);
                    param = new Param("slotid", this.slotID + "");
                    rParams.addParam(param);
                    param = new Param("portid", portID + "");
                    rParams.addParam(param);
                    param = new Param("subslotid", subBoardSlot + "");
                    rParams.addParam(param);
                    bParams.addRowParams(rParams);
                }
            }
        }
        data.setBussinessParams(bParams);
        return data;
    }

    public Datainterface constructBoardListData() {
        Datainterface data = new Datainterface();
        BussinessParams bParams = new BussinessParams();
        String portLists = "";
        Param param = null;
        if (TEConfigurationDataMgr.getInstance().getBoard(this.neID, this.slotID) == null) {
            data.setBussinessParams(bParams);
            return data;
        }
        if (this.subslotID == 0) {
            int boardType = 0;
            if (TEConfigurationDataMgr.getInstance().getBoard(this.neID, this.slotID) != null) {
                boardType = TEConfigurationDataMgr.getInstance().getBoard(this.neID, this.slotID).getBoardType();
            }
            ArrayList<TEPortProperty> boardPortList = this.resUtil.getAllPorts(this.neID, this.slotID, this.subslotID, boardType);
            int len = boardPortList.size();
            for (int j = 0; j < len; ++j) {
                int portID = boardPortList.get(j).getPortNo();
                String portName = TEConfigurationDataMgr.getInstance().getPortName(this.neID, this.slotID, boardType, portID);
                portLists = portName + "," + portID;
                param = new Param("portList", portLists);
                RowParams rParams = new RowParams();
                rParams.addParam(param);
                bParams.addRowParams(rParams);
            }
        } else {
            List subBoardList = TEConfigurationDataMgr.getInstance().getBoard(this.neID, this.slotID).getSubBoardList();
            int isize = subBoardList.size();
            for (int k = 0; k < isize; ++k) {
                TESubBoard subBoards = (TESubBoard)subBoardList.get(k);
                int subBoardType = subBoards.getSubBoardType();
                int subBoardSlot = subBoards.getSubSlotID();
                ArrayList<TEPortProperty> subBoardPortList = this.resUtil.getAllPorts(this.neID, this.slotID, this.subslotID, subBoardType);
                int len = subBoardPortList.size();
                for (int j = 0; j < len; ++j) {
                    int portID = subBoardPortList.get(j).getPortNo();
                    String portName = TEConfigurationDataMgr.getInstance().getPortName(this.neID, subBoardSlot, subBoardType, portID);
                    portLists = portName + "," + portID;
                    param = new Param("portList", portLists);
                    RowParams rParams = new RowParams();
                    rParams.addParam(param);
                    bParams.addRowParams(rParams);
                }
            }
        }
        data.setBussinessParams(bParams);
        return data;
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

