/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.bfdmanagement;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.ptn_pub.TEPTNUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import gnu.trove.TIntHashSet;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;

public class TEQueryEthBoards
implements TENEMgrInterface {
    private Datainterface datainterface = null;
    Vector boardList = null;
    int neID = 0;
    int queryType = 0;
    private Logger log = TELogFactory.getNormalLogger();
    TEPTNUtil ptnutil = TEPTNUtil.instance();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neID = neid;
        Param qtParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"queryType");
        this.queryType = Integer.parseInt(qtParam.getValue());
        TENE ne = TENEListMgr.getInstance().getNE(this.neID);
        if (ne != null) {
            this.boardList = ne.getBoardList();
        }
        if (null == this.boardList || this.boardList.isEmpty()) {
            this.datainterface = new Datainterface();
            this.datainterface.setBussinessParams(new BussinessParams());
            this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)0));
            return this.datainterface;
        }
        this.datainterface = this.constructBoardListData();
        if (null != this.datainterface && null != this.datainterface.getBussinessParams()) {
            this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        } else {
            this.log.error("Get BoardInfo Fail!\n");
            this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
        }
        return this.datainterface;
    }

    public Datainterface constructBoardListData() {
        Datainterface data = new Datainterface();
        BussinessParams bParams = new BussinessParams();
        TIntHashSet filterBoards01 = this.ptnutil.getFilterBoardsSet(this.neID, "CREATE_BFD_01");
        TIntHashSet filterBoards02 = this.ptnutil.getFilterBoardsSet(this.neID, "CREATE_BFD_02");
        int size = this.boardList.size();
        for (int i = 0; i < size; ++i) {
            RowParams rParams = new RowParams();
            TEBoard board = (TEBoard)this.boardList.get(i);
            int boardType = board.getBoardType();
            if (this.queryType == 0) {
                if (!filterBoards01.contains(boardType)) continue;
                this.constructBoardData(board, rParams, bParams);
                continue;
            }
            if (!filterBoards02.contains(boardType)) continue;
            this.constructBoardData(board, rParams, bParams);
        }
        data.setBussinessParams(bParams);
        return data;
    }

    private void constructBoardData(TEBoard board, RowParams rParams, BussinessParams bParams) {
        int slotid = board.getSlotID();
        String boardName = board.getBoardName();
        List subBoardList = board.getSubBoardList();
        Param param = null;
        if (!subBoardList.isEmpty()) {
            int isize = subBoardList.size();
            for (int k = 0; k < isize; ++k) {
                TESubBoard subBoards = (TESubBoard)subBoardList.get(k);
                int subBoardSlot = subBoards.getSubSlotID();
                String subBoardName = subBoards.getSubBoardName();
                String sourceBoard = slotid + "-" + boardName + "-" + subBoardSlot + "-" + subBoardName;
                param = new Param("sourceboard", sourceBoard);
                rParams.addParam(param);
            }
        } else {
            param = new Param("sourceboard", slotid + "-" + boardName);
            rParams.addParam(param);
        }
        bParams.addRowParams(rParams);
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

