/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.bfdmanagement;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.ptn_pub.TEPTNUtil;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Vector;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class TEQueryBFD
extends TENEExplorerBean {
    public static final long MPLSTUNNELSTARTINDEX = 1L;
    public static final long GRETUNNELSTARTINDEX = 0x1000001L;
    public static final long IPTUNNELSTARTINDEX = 0x2000001L;
    public static final int MPLS = 0;
    public static final int GRE = 1;
    public static final int IP = 2;
    public static final String SINGLE_HOP = "0";
    public static final String MULTI_HOP = "1";
    private static final String PUBLIC_VRFINDEX = "4294967295";
    private static final String VRFINFO_QUERYSTRING = "NSCMD_PTN_L3VPN_GET_VRF_INSTANCE";
    private static final String STATICVRFINFO_QUERYSTRING = "NSCMD_PTN_L3VPN_GET_STATIC_VRF_INSTANCE";
    private final String filePath = "ptn/res/bfdmanagement/bfdmanagement_" + TESysManagerBean.getInstance().getlanguage() + ".ini";
    private final TEResourceUtil res = TEGetFilePath.getResource((int)this.neid, (String)this.filePath);
    private boolean issupportsvrf = false;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        BussinessParams bussiness = this.outputData.getBussinessParams();
        boolean allSucc = true;
        boolean allFail = true;
        TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        Vector logBoardList = neObj.getBoardList();
        String errorCode = this.outputData.getErrorMessage().getErrorcode();
        ArrayList<RowParams> rowList = new ArrayList<RowParams>();
        if (SINGLE_HOP.equals(errorCode)) {
            int i;
            allFail = false;
            RowParams[] rowParams = bussiness.getRowParams();
            for (i = rowParams.length - 1; i >= 0; --i) {
                RowParams rowParam = rowParams[i];
                if (rowParam.getParam("sourceboard").getValue().equals("") || rowParam.getParam("frontport").getValue().equals("")) continue;
                rowList.add(rowParam);
            }
            this.outputData.getBussinessParams().clearRowParams();
            int size = rowList.size();
            for (i = 0; i < size; ++i) {
                String tunnelIndex;
                RowParams rowParam = (RowParams)rowList.get(i);
                int slotId = Integer.parseInt(rowParam.getParam("sourceboard").getValue());
                int portId = Integer.parseInt(rowParam.getParam("frontport").getValue());
                this.outputData.getBussinessParams().addRowParams(rowParam);
                if (rowParam.getParam("sessiontype").getValue().equals(SINGLE_HOP)) {
                    rowParam.addParam("frontportName", this.queryPortName(slotId, portId));
                }
                if (slotId != 255 && slotId != 65535) {
                    int len = logBoardList.size();
                    for (int j = 0; j < len; ++j) {
                        TEBoard board = (TEBoard)logBoardList.get(j);
                        int boardType = board.getBoardType();
                        int boardSlot = board.getSlotID();
                        if (boardSlot != slotId) continue;
                        String boardName = cfgDataMgr.getBoardTypeName(neid, boardType);
                        rowParam.addParam("bdName", boardName);
                    }
                } else {
                    rowParam.addParam("bdName", "-");
                }
                Param vrfIndexParam = rowParam.getParam("vrfIndex");
                if (null != vrfIndexParam) {
                    boolean isSupportSvrfInUpLoad;
                    Param supportSVRFParam = this.inputData.getBussinessParams().getRowParams(0).getParam("supportsvrf");
                    this.issupportsvrf = null != supportSVRFParam && MULTI_HOP.equals(supportSVRFParam.getValue());
                    String versionNo = TENEListMgr.getInstance().getNE(neid).getHostVersion();
                    String lastNo = versionNo.substring(versionNo.length() - 5, versionNo.length());
                    boolean bl = isSupportSvrfInUpLoad = lastNo.compareTo("03.20") > 0 || TESpecialAttrMgr.getInstance().isNESupport(neid, "PTN_FUNC_BFD", "TE_ATTR_PTN_BFD_SUPPSVRF");
                    if (!this.queryVrfInfo(vrfIndexParam, rowParam, VRFINFO_QUERYSTRING) && (this.issupportsvrf || isSupportSvrfInUpLoad)) {
                        this.queryVrfInfo(vrfIndexParam, rowParam, STATICVRFINFO_QUERYSTRING);
                    }
                }
                if ((tunnelIndex = rowParam.getParam("tunnelindex").getValue()) == null || tunnelIndex.equals("")) {
                    rowParam.addParam("bindtype", "3");
                    continue;
                }
                if (PUBLIC_VRFINDEX.equals(tunnelIndex)) {
                    rowParam.addParam("bindtype", MULTI_HOP);
                    continue;
                }
                this.queryTunnelInfo(tunnelIndex, rowParam);
            }
            if (allSucc) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            } else if (allFail) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1));
            }
        }
    }

    private void queryTunnelInfo(String tunnelIndex, RowParams rowParam) {
        String cmdCode = "";
        Operation operation = null;
        try {
            Definitions definitions = TECreateObjectFactory.parseQxDesFile((int)this.neid);
            if (this.getTunnelType(Long.parseLong(tunnelIndex)) == 1) {
                cmdCode = "NSCMD_CFG_GRE_TNL_GET_TUNNEL_EX";
                rowParam.addParam("bindtype", String.valueOf(1));
            } else {
                cmdCode = "NSCMD_CFG_IP_TNL_GET_TUNNEL_EX";
                rowParam.addParam("bindtype", String.valueOf(2));
            }
            operation = definitions.getOperation(cmdCode);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse QxDesFile fail!", (Throwable)e);
        }
        if (null == operation) {
            return;
        }
        operation.getInput().getPart("tunnelindex").setValue(tunnelIndex);
        ArrayList<Operation> list = new ArrayList<Operation>();
        list.add(operation);
        int result = this.sendMessage(this.neid, list);
        if (result == 0) {
            rowParam.addParam("tunnelid", operation.getOutput(0).getPart("tunnelid").getValue());
            rowParam.addParam("ip", operation.getOutput(0).getPart("ip").getValue());
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
    }

    public int getTunnelType(long tunnelIndex) {
        int tunnelType = -1;
        tunnelType = 1L <= tunnelIndex && tunnelIndex < 0x1000001L ? 0 : (0x1000001L <= tunnelIndex && tunnelIndex < 0x2000001L ? 1 : 2);
        return tunnelType;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> filterErrorCodeList = new ArrayList<Integer>(1);
        filterErrorCodeList.add(new Integer(38662));
        filterErrorCodeList.add(new Integer(42707));
        return filterErrorCodeList;
    }

    private String queryPortName(int slotid, int port) {
        String portName = "";
        if (slotid != 255 && slotid != 65535) {
            String resFilePath = "res" + File.separator + "stringresource_" + TESysManagerBean.getInstance().getlanguage() + ".ini";
            portName = port + "(" + TEResourceUtil.getInstance((String)resFilePath).getString("portname") + "-" + port + ")";
        } else {
            TEPTNUtil ptnUtil = TEPTNUtil.instance();
            portName = ptnUtil.getLogicPortName(port, portName);
        }
        return portName;
    }

    private boolean queryVrfInfo(Param vrfIndexParam, RowParams rowParam, String cmdCode) {
        String vrfInfo = null;
        String vrfIndex = vrfIndexParam.getValue();
        Operation operation = null;
        Output output = null;
        String vrfId = null;
        String vrfName = null;
        if (PUBLIC_VRFINDEX.equals(vrfIndex)) {
            vrfInfo = this.res.getString("DefaultVPNName");
            rowParam.addParam("vrfindex", String.valueOf(PUBLIC_VRFINDEX));
            rowParam.addParam("vrfid", SINGLE_HOP);
        } else {
            Definitions definitions = null;
            try {
                definitions = TECreateObjectFactory.parseQxDesFile((int)this.neid);
            }
            catch (MarshalException e) {
                TELogFactory.getNormalLogger().info("get qx desc file failed!", (Throwable)e);
            }
            catch (FileNotFoundException e) {
                TELogFactory.getNormalLogger().info("get qx desc file failed!", (Throwable)e);
            }
            catch (ValidationException e) {
                TELogFactory.getNormalLogger().info("get qx desc file failed!", (Throwable)e);
            }
            if (null == definitions) {
                return false;
            }
            operation = definitions.getOperation(cmdCode);
            if (null == operation) {
                return false;
            }
            operation.getInput().getPart("vrfIndex").setValue(vrfIndex);
            ArrayList<Operation> opertList = new ArrayList<Operation>();
            opertList.add(operation);
            int result = this.sendMessage(this.neid, opertList);
            if (0 == result) {
                output = operation.getOutput()[0];
                String code = output.getFault()[0].getCode();
                if (null == code || Integer.parseInt(code) != 0) {
                    return false;
                }
                if (output.getPart("vrfID").getValue() != null && !output.getPart("vrfID").getValue().trim().equals("")) {
                    vrfId = output.getPart("vrfID").getValue().trim();
                }
                if (output.getPart("name").getValue() != null && !output.getPart("name").getValue().trim().equals("")) {
                    vrfName = output.getPart("name").getValue().trim();
                }
                vrfInfo = vrfId + "(" + vrfName + ")";
                if (output.getPart("vrfIndex").getValue() != null && !output.getPart("vrfIndex").getValue().trim().equals("")) {
                    rowParam.addParam("vrfindex", output.getPart("vrfIndex").getValue().trim());
                }
                rowParam.addParam("vrfid", vrfId);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                return false;
            }
        }
        vrfIndexParam.setValue(vrfInfo);
        return true;
    }
}

