/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEQueryLogicPort;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.nemgr.ptn.TENEImplInterface_PTN;
import com.huawei.nglct.nemgr.ptn.TENEInterImpl_PTN;
import com.huawei.nglct.nemgr.ptn.TENESingleImpl_PTN;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.login.QueryPortNameRunnable;
import com.huawei.nglct.util.login.TELoginNEManager;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TimerTask;
import java.util.Vector;

public class TENE_PTN
extends TENE {
    private static final String QX_DES_PATH_MAIN = "conf" + File.separator + "qxdescrib.xml";
    private static final String STATUS_ACTIVE = "3";

    public void setLastBoardModifyTime() {
        TENEImplInterface_PTN neImpl = (TENEImplInterface_PTN)this.getNeImplInterface();
        neImpl.setLastBoardModifyTime(System.currentTimeMillis());
    }

    public boolean isCanUpdateBoardList() {
        if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
            return true;
        }
        TENEImplInterface_PTN neImpl = (TENEImplInterface_PTN)this.getNeImplInterface();
        return (double)Math.abs(System.currentTimeMillis() - neImpl.getLastBoardModifyTime()) > (double)neImpl.getBOARD_QUERY_PERIOD() * 1.5;
    }

    public TENE_PTN() {
        if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
            this.setNeImplInterface(new TENEInterImpl_PTN(this.neID));
            TENEImplInterface_PTN neImpl = (TENEImplInterface_PTN)this.getNeImplInterface();
            neImpl.setBOARD_QUERY_PERIOD(300000);
        } else {
            this.setNeImplInterface(new TENESingleImpl_PTN(this.neID));
        }
    }

    public void afterLogoutNE() {
        TENEImplInterface_PTN neImpl = (TENEImplInterface_PTN)this.getNeImplInterface();
        Vector alarmList = neImpl.getAlarmList();
        if (alarmList != null && !alarmList.isEmpty()) {
            alarmList.clear();
        }
        TELoginNEManager.getInstance().removeNe((TENE)this);
    }

    public void initNEData() {
        this.queryBoard();
        if (!this.neImplInterface.isSchedule()) {
            TELoginNEManager.getInstance().registerNe((TENE)this);
            TELogFactory.getNormalLogger().info("NEname: " + this.getNEName() + " start boardTimerTask ");
            this.neImplInterface.setSchedule(true);
        }
    }

    private void queryLogicPort() {
        TENEImplInterface_PTN neImplInterface = (TENEImplInterface_PTN)this.getNeImplInterface();
        Vector boardList = neImplInterface.getBoardList();
        int size = boardList.size();
        for (int i = 0; i < size; ++i) {
            TEBoard board1 = (TEBoard)boardList.get(i);
            int boardType = board1.getBoardType();
            if (!TEConfigurationDataMgr.getInstance().isDynPortBoardType(this.neID, boardType)) continue;
            int slotId = board1.getSlotID();
            TEQueryLogicPort.queryExistLogicPort((int)this.neID, (int)slotId, (int)boardType);
        }
    }

    private ArrayList sendQueryBoardCmd() {
        if (!this.isCanUpdateBoardList()) {
            return null;
        }
        Operation oper1 = null;
        Operation oper2 = null;
        Operation oper3 = null;
        Operation oper4 = null;
        ArrayList<Object> operationList = new ArrayList<Object>();
        try {
            oper1 = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_CFG_GET_BD");
            if (null == oper1) {
                oper1 = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_CFG_GET_BD_EX");
            }
            if (null == (oper2 = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_CFG_GET_PHY_BD"))) {
                oper2 = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_CFG_GET_PHY_BD_EX");
            }
            oper3 = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_CFG_GET_NE_NAMEEX");
            oper4 = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_CFG_SUBBD_GET");
            operationList.add(oper1.clone());
            operationList.add(oper2.clone());
            operationList.add(oper3.clone());
            operationList.add(oper4);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("query board error", (Throwable)e);
        }
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.neID, operationList, 10);
        if (result.retCode != 0) {
            return null;
        }
        return operationList;
    }

    private void processLogicBoard(Operation qBOperation) {
        TENEImplInterface_PTN neImpl = (TENEImplInterface_PTN)this.getNeImplInterface();
        boolean querySucc = false;
        int slotID = -1;
        int boardType = -1;
        HashMap<String, TEBoard> queryboardMap = new HashMap<String, TEBoard>();
        ArrayList<TEBoard> tmpBoardList = new ArrayList<TEBoard>();
        for (Output output : qBOperation.getOutput()) {
            if (!output.getFault()[0].getCode().equals("0")) continue;
            querySucc = true;
            for (Part part : output.getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equals("slotID") && value != null) {
                    slotID = Integer.parseInt(value);
                    continue;
                }
                if (name.equals("boardType") && value != null) {
                    boardType = Integer.parseInt(value);
                    continue;
                }
                if (!"activatingFlag".equals(name) || !STATUS_ACTIVE.equals(value)) continue;
                TEBoard board = new TEBoard(this.neID, slotID, boardType);
                List unmodifiedCPList = TENEListUtils.getCPTypeList();
                if (!unmodifiedCPList.contains(new Integer(boardType))) {
                    TELoginNEManager.getInstance().getChanel().putRequest((Runnable)new QueryPortNameRunnable(this.neID, slotID, boardType));
                }
                queryboardMap.put(String.valueOf(slotID), board);
                tmpBoardList.add(board);
            }
        }
        Vector boardList = neImpl.getBoardList();
        if (querySucc) {
            if (queryboardMap.size() != boardList.size()) {
                this.setBoardUpdateFlag(true);
            } else {
                int i = 0;
                int len = boardList.size();
                for (i = 0; i < len; ++i) {
                    TEBoard board1 = (TEBoard)boardList.get(i);
                    if (queryboardMap.containsValue(board1)) continue;
                    this.setBoardUpdateFlag(true);
                    break;
                }
                if (i >= len) {
                    this.setBoardUpdateFlag(false);
                }
            }
            Vector<TEBoard> tmpBoardVec = new Vector<TEBoard>();
            Iterator iter = queryboardMap.values().iterator();
            while (iter.hasNext()) {
                tmpBoardVec.add((TEBoard)iter.next());
            }
            if (this.isCanUpdateBoardList()) {
                Collections.sort(tmpBoardVec);
                this.setBoardList(tmpBoardVec);
            }
            this.queryLogicPort();
        }
        queryboardMap.clear();
    }

    private void processPhyBoard(Operation qBOperation) {
        int slotID = -1;
        int boardType = -1;
        Vector<TEBoard> newPhyBoardList = new Vector<TEBoard>();
        for (Output output : qBOperation.getOutput()) {
            if (!output.getFault()[0].getCode().equals("0") || output.getPart(1).getValue().equals("0")) continue;
            for (Part part : output.getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equals("slotID") && value != null) {
                    slotID = new Integer(value);
                    continue;
                }
                if (!name.equals("boardType") || value == null) continue;
                boardType = new Integer(value);
            }
            TEBoard board = new TEBoard(this.neID, slotID, boardType);
            newPhyBoardList.add(board);
        }
        this.setPhyBoardList(newPhyBoardList);
    }

    private void processNEName(Operation qNENameOpeation) {
        TENEImplInterface_PTN neImpl = (TENEImplInterface_PTN)this.getNeImplInterface();
        TEDataConverter.handleSpecialStr((Operation)qNENameOpeation);
        Output[] outputArr3 = qNENameOpeation.getOutput();
        Output output = outputArr3[0];
        if (output.getFault()[0].getCode().equals("0")) {
            for (Part part : output.getPart()) {
                String name = part.getName();
                String value = part.getValue().trim();
                if (!name.equals("neName") || value == null || neImpl.getNeName().equals(value)) continue;
                this.setNEName(value.trim());
                this.setBoardUpdateFlag(true);
            }
        }
    }

    public void queryBoard() {
        ArrayList operationList = this.sendQueryBoardCmd();
        if (operationList == null) {
            return;
        }
        this.processLogicBoard((Operation)operationList.get(0));
        this.processPhyBoard((Operation)operationList.get(1));
        this.processNEName((Operation)operationList.get(2));
        this.processSubBoard((Operation)operationList.get(3));
    }

    private void processSubBoard(Operation qSubBoard) {
        for (Output output : qSubBoard.getOutput()) {
            if (!output.getFault()[0].getCode().equals("0")) continue;
            int slotid = Integer.parseInt(output.getPartValue("slotid"));
            int sbbdid = Integer.parseInt(output.getPartValue("subbdid"));
            int sbbdtype = Integer.parseInt(output.getPartValue("subbdtype"));
            TEBoard board = this.getBoard(slotid);
            TESubBoard subboard = new TESubBoard(board, this.neID, sbbdid, sbbdtype);
            if (board.getSubBoardList().contains(subboard)) continue;
            board.addSubBoard(subboard);
        }
    }

    public void queryAlarm() {
    }

    public Vector getAlarmList() {
        TENEImplInterface_PTN neImpl = (TENEImplInterface_PTN)this.getNeImplInterface();
        return neImpl.getAlarmList();
    }

    public Vector getBoardList() {
        TENEImplInterface_PTN neImpl = (TENEImplInterface_PTN)this.getNeImplInterface();
        return neImpl.getBoardList();
    }

    public synchronized Vector getPhyBoardList() {
        TENEImplInterface_PTN neImpl = (TENEImplInterface_PTN)this.getNeImplInterface();
        return neImpl.getPhyBoardList();
    }

    public synchronized Vector getClonedBoardList() {
        TENEImplInterface_PTN neImpl = (TENEImplInterface_PTN)this.getNeImplInterface();
        Vector boardList = neImpl.getBoardList();
        Vector<Object> clonedBoardList = new Vector<Object>();
        try {
            for (int i = 0; i < boardList.size(); ++i) {
                clonedBoardList.add(((TEBoard)boardList.get(i)).clone());
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("The sfid is , program inner error\u00a3\u00ba\n", (Throwable)e);
        }
        return clonedBoardList;
    }

    public synchronized void setBoardList(Vector newBoardList) {
        TENEImplInterface_PTN neImpl = (TENEImplInterface_PTN)this.getNeImplInterface();
        neImpl.setBoardList(newBoardList);
    }

    public synchronized Vector getClonedPhyBoardList() {
        TENEImplInterface_PTN neImpl = (TENEImplInterface_PTN)this.getNeImplInterface();
        Vector phyBoardList = neImpl.getPhyBoardList();
        Vector<Object> clonedBoardList = new Vector<Object>();
        for (int i = 0; i < phyBoardList.size(); ++i) {
            clonedBoardList.add(((TEBoard)phyBoardList.get(i)).clone());
        }
        return clonedBoardList;
    }

    public synchronized void setPhyBoardList(Vector newBoardList) {
        TENEImplInterface_PTN neImpl = (TENEImplInterface_PTN)this.getNeImplInterface();
        neImpl.setPhyBoardList(newBoardList);
    }

    public boolean getBibyteVersion() {
        String ver = this.getShowNEVersion();
        return ver.indexOf("5.58.01") <= 0 && ver.indexOf("5.59.01") <= 0;
    }

    public class BoardTimerTask
    extends TimerTask {
        @Override
        public void run() {
            try {
                TENE_PTN.this.queryBoard();
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().info("queryboard error.", (Throwable)e);
            }
        }
    }
}

