/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.device.ptn.bundleactivator;

import com.huawei.nglct.bundlemgr.TEBundleSuperActivator;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.xmlinterpreter.TELoadDataUtil;
import com.huawei.nglct.nemgr.device.ptn.bundleactivator.TEPTNDevFileProvider;
import com.huawei.nglct.nemgr.device.ptn.bundleactivator.TEPTNLineMspAdapter;
import com.huawei.nglct.nemgr.neadapter.NEFunctionAdapterInterface;
import com.huawei.nglct.nemgr.neadapter.TENEFuntionAdapterMgr;
import com.huawei.nglct.util.string.IFileRegisterer;
import com.huawei.nglct.util.string.TEFileRegisterer;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.nglct.util.xml.IFileProvider;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import gnu.trove.TIntArrayList;
import java.util.HashSet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;

public class PTNDevBundleActivator
extends TEBundleSuperActivator
implements IFileRegisterer {
    private static final String NE_FILEPATH = "device/ptn/conf/ne.xml";
    private TIntArrayList fbMapping = new TIntArrayList();
    private ServiceRegistration serviceReg;

    public void start(BundleContext context) throws Exception {
        context.registerService(IFileProvider.class.getName(), (Object)new TEPTNDevFileProvider(), null);
        try {
            this.fbMapping = TEFileRegisterer.registerFiles((Bundle)context.getBundle());
            this.serviceReg = context.registerService(IFileRegisterer.class.getName(), (Object)this, null);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("PTNDevBundleActivator start fail!", (Throwable)e);
        }
        Bundle commBundle = FrameworkUtil.getBundle(IFileProvider.class);
        if (commBundle.getState() == 32) {
            this.loadNeWhenBundleStart();
        }
        context.addBundleListener((BundleListener)new ActivatorBundleListener());
        this.registerFunctionInterface(context.getBundle());
        this.addFilterLogCmds();
    }

    public void stop(BundleContext context) throws Exception {
        this.serviceReg.unregister();
        this.unregisterFunctionInterface(context.getBundle());
    }

    public void registerFunctionInterface(Bundle bundle) {
        TENEFuntionAdapterMgr.getInstance().registerFunctionInterface(bundle.getSymbolicName(), (NEFunctionAdapterInterface)new TEPTNLineMspAdapter());
    }

    public void unregisterFunctionInterface(Bundle bundle) {
        TENEFuntionAdapterMgr.getInstance().unregisterFunctionInterface(bundle.getSymbolicName(), new TEPTNLineMspAdapter().getInterfaceName());
        TENEFuntionAdapterMgr.getInstance().unregisterFunctionInterface(bundle.getSymbolicName(), new TEPTNLineMspAdapter().getInterfaceName());
    }

    public boolean containsResFile(String filePaht) {
        int hash = TEStringUtils.hashString((String)filePaht);
        return this.fbMapping.contains(hash);
    }

    private void addFilterLogCmds() {
        HashSet<Integer> qxCmdSet = new HashSet<Integer>();
        int NSCMD_IP_ISIS_SET_AUTHENINFO = 32356;
        int NSCMD_IP_ISIS_GET_AUTHENINFO = 32357;
        int NSCMD_PTN_ISIS_SET_AUTHENINFO_EX = 34641;
        int NSCMD_PTN_ISIS_GET_AUTHENINFO_EX = 34642;
        int NSCMD_OSPF_GET_IFAUTH = 36371;
        int NSCMD_OSPF_SET_IFAUTH = 36359;
        int NSCMD_OSPF_GET_AREAINFO = 36372;
        int NSCMD_OSPF_SET_AREAAUTH = 36360;
        int NSCMD_MPLS_RSVP_GET_AUTHINFO = 32616;
        int NSCMD_MPLS_RSVP_SET_AUTHINFO = 32615;
        int NSCMD_MPLS_RSVP_GET_AUTHINFO_EX = 34005;
        int NSCMD_MPLS_RSVP_SET_AUTHINFO_EX = 34004;
        int NSCMD_ISIS_SET_AREA_AUTHENINFO = 36270;
        int NSCMD_ISIS_GET_AREA_AUTHENINFO = 36271;
        int NSCMD_PTN_BGP_SET_MD5 = 37804;
        int NSCMD_PTN_BGP_GET_PEER = 34601;
        int NSCMD_PTN_BGP_GET_PEER_EX = 37991;
        int NSCMD_MPLS_LDP_SET_MD5PWD = 36306;
        int NSCMD_MPLS_LDP_GET_MD5PWD = 36307;
        int NSCMD_SNMP_ADD_ACCESSINFO = 37245;
        int NSCMD_SNMP_GET_ACCESSINFO = 37246;
        int NSCMD_SNMP_ED_ACCESSINFO = 37247;
        qxCmdSet.add(NSCMD_IP_ISIS_SET_AUTHENINFO);
        qxCmdSet.add(NSCMD_IP_ISIS_GET_AUTHENINFO);
        qxCmdSet.add(NSCMD_PTN_ISIS_SET_AUTHENINFO_EX);
        qxCmdSet.add(NSCMD_PTN_ISIS_GET_AUTHENINFO_EX);
        qxCmdSet.add(NSCMD_OSPF_GET_IFAUTH);
        qxCmdSet.add(NSCMD_OSPF_SET_IFAUTH);
        qxCmdSet.add(NSCMD_OSPF_GET_AREAINFO);
        qxCmdSet.add(NSCMD_OSPF_SET_AREAAUTH);
        qxCmdSet.add(NSCMD_MPLS_RSVP_GET_AUTHINFO);
        qxCmdSet.add(NSCMD_MPLS_RSVP_SET_AUTHINFO);
        qxCmdSet.add(NSCMD_MPLS_RSVP_GET_AUTHINFO_EX);
        qxCmdSet.add(NSCMD_MPLS_RSVP_SET_AUTHINFO_EX);
        qxCmdSet.add(NSCMD_ISIS_SET_AREA_AUTHENINFO);
        qxCmdSet.add(NSCMD_ISIS_GET_AREA_AUTHENINFO);
        qxCmdSet.add(NSCMD_PTN_BGP_SET_MD5);
        qxCmdSet.add(NSCMD_PTN_BGP_GET_PEER);
        qxCmdSet.add(NSCMD_PTN_BGP_GET_PEER_EX);
        qxCmdSet.add(NSCMD_MPLS_LDP_SET_MD5PWD);
        qxCmdSet.add(NSCMD_MPLS_LDP_GET_MD5PWD);
        qxCmdSet.add(NSCMD_SNMP_ADD_ACCESSINFO);
        qxCmdSet.add(NSCMD_SNMP_GET_ACCESSINFO);
        qxCmdSet.add(NSCMD_SNMP_ED_ACCESSINFO);
        TENECommMgr.getInstance().addFilterLogCmds(qxCmdSet);
    }

    public void loadNeStaticData() {
        TELoadDataUtil.loadNemgrData((String)NE_FILEPATH);
    }

    public String getDomain() {
        return "ptn";
    }

    class ActivatorBundleListener
    implements BundleListener {
        ActivatorBundleListener() {
        }

        public void bundleChanged(BundleEvent arg0) {
            Bundle bundle = (Bundle)arg0.getSource();
            if ("com.huawei.weblct.common".equals(bundle.getSymbolicName()) && bundle.getState() == 32) {
                PTNDevBundleActivator.this.loadNeWhenBundleStart();
            }
        }
    }
}

