/***************************************      ***************************************/
var language = SYSTEMCONF.getLanguage();
var st = new SortTable();
var st1 = new SortTable();
var rowIndex = 0;
var winobj = getNeProperty(self);
if(!winobj.neid)
{
	winobj = parent.obj;
}

var nmUser = winobj["nmUser"];

var neID = winobj.neid;
var slotID = winobj.slotid;

var btnRightArr = new Object();
var deleteRight = false;
var queryRight = false;
var modifyRight = false;
var createRight = false;
var oprSucc = 0;
var oprFail = 2;
var ports = null;
var TIMEOUT = 1090650120;

var QUERYSFID = TECMDCODE_IP_GET_VLANGROUP;//    id
var DELETESFID = TECMDCODE_IP_DEL_VLANGROUP;//    id
var SENDSFID = TECMDCODE_IP_MODIFY_VLANGROUP;//         id

var servInfoArray = null;
var modifyInfoArray = [];
var i_modify = 0;

var BOARD_TYPE_L4G = 927;

/***************************************      ***************************************/

/*
 *       
 */
function ServiceInfo()
{   
    this.neid=null;  
    this.soltID=null;        
    this.port = null;     
    this.firstVlan = null;     
    this.totalVlan = null;  
    this.totalVlan_bak = null; 

     
    this.torowparamXML=function()
    {
     	  var row = new tagElement("row-params");

     	  this.addParam(row,"neid",this.neid);
          this.addParam(row,"slotid",this.soltID);
          this.addParam(row,"port",this.port);
          this.addParam(row,"firstVlan",this.firstVlan);
          this.addParam(row,"totalVlan",this.totalVlan);
          this.addParam(row,"totalVlan_bak",this.totalVlan_bak);
          
     	  return row;
    }

    this.addParam=function(row,name,value)
    {
        var param=new tagElement("param");
        param.setAttribute("name",name);
        param.setAttribute("value",value);
        row.appendChild(param);         
    }
}

/*************************************      *****************************************/

/*
  *       
  */
function init()
{    
    SpecialAttrMgr.getCPFunInfo(neID, slotID, 'TE_FUNC_CFG_ETH_VLAN_GROUP');
    st.setOnRowSelectHandler(rowSelected);
    st.setImage("../../../../../images/");
    st.setOnCellEditHandler(cellEditHandler);
    if(winobj["boardType"] == BOARD_TYPE_L4G || SpecialAttrMgr.isCPNotSupport(neID, slotID, 'TE_FUNC_CFG_ETH_VLAN_GROUP', 'VLANGROUP_NOTSUPPORT_TOTALVLANNUM') )//c125198  L4G        L4G     VLAN    
    {
    	window.tableconf[0].getColFromColId("totalVlan").cell.isEdit ="0";
    }
    
    createTableHead(st, window.tableconf[0]);
    document.getElementById("tablecomponent").appendChild(st.getTable());
    st.setBodyHeight(getTableHeight($("tablecomponent"),st)*0.74+"px"); 
    initButton();
    
	if(btnRightArr.querybtn.right)
	{
		doQuery(true);
	}  
	
}


/*
 *       
 */
function initButton()
{
		document.getElementById("applybtn").value=RESOURCE["applybtn"];
    document.getElementById("querybtn").value=RESOURCE["querybtn"];
    document.getElementById("createbtn").value=RESOURCE["createbtn"];
    document.getElementById("deletebtn").value=RESOURCE["deletebtn"];
    
	  
		btnRightArr.applybtn = new BtnRightObj("applybtn",TE_IP_VLAN_OAMENABLE);
    btnRightArr.querybtn = new BtnRightObj("querybtn",TECMDCODE_IP_EVPL_QUERY);    
    btnRightArr.createbtn = new BtnRightObj("createbtn",TECMDCODE_IP_EVPL_CREATE);    
    btnRightArr.deletebtn = new BtnRightObj("deletebtn",TECMDCODE_IP_EVPL_DELETE); 
    sendRightInfo(btnRightArr);  
    initBtnStatue();      
}

/**
 *         
 * @param  
 * @return  
 */
function initBtnStatue()
{	

    $("querybtn").disabled = !btnRightArr.querybtn.right;	
    $("createbtn").disabled = !btnRightArr.createbtn.right;
    $("deletebtn").disabled = !btnRightArr.deletebtn.right;	
    $("applybtn").disabled = !btnRightArr.applybtn.right;
    deleteRight = btnRightArr.deletebtn.right;
    queryRight = btnRightArr.querybtn.right;
    createRight = btnRightArr.createbtn.right;
    modifyRight = btnRightArr.applybtn.right;
    		
}

/**
 * do the query
 */
function doQuery(fromNE)
{
	document.getElementById("querybtn").disabled = true;
    document.getElementById("createbtn").disabled = true;
    document.getElementById("deletebtn").disabled = true;
    document.getElementById("applybtn").disabled = true;
    
    var xml = createQueryRequest(fromNE);
    var URL = "../../../../../neExlorerServlet?sfid="+QUERYSFID+"&flag=1&nmUser="+winobj["nmUser"];
    loadXMLdoc(URL,"POST", false, processQueryResponse, null, "inputdata="+xml);
    
}

/**
 * create query XML request
 */
function createQueryRequest(fromNE)
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    
  
	    var row = new tagElement("row-params");
	
	    var param = new tagElement("param");
	    param.setAttribute("name", "neid");
	    param.setAttribute("value", neID);
	    row.appendChild(param);
	
	    param = new tagElement("param");
	    param.setAttribute("name", "slotid");
	    param.setAttribute("value", slotID);
	    row.appendChild(param);
	
	    param = new tagElement("param");
	    param.setAttribute("name", "port");
	    param.setAttribute("value", "0");
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name", "firstVlan");
	    param.setAttribute("value", 0xffff);
	    row.appendChild(param);
	
	    business.appendChild(row);
    
    root.getRoot().appendChild(business);
    return root.toString();
}

/**
 * callback function
 */
function processQueryResponse(doc)
{
    var dinterface = EncapsulateData(doc);

    var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "slotid";
    errArr[2] = "boardname";
    var size = dinterface.getBErrLength();
    for(var i = 0;i < size;i++)
    {
	      var tempObj = dinterface.getError().rowErrors[i].errorObj;
  	    tempObj["slotID"] = slotID + "-TBE" + "-"+ RESOURCE["querybtn"] + RESOURCE["vlangrouptabtitle"];
		}
		if (oprSucc != dinterface.getError().getGlobleECode()) 
    { 
    	  var flag = true;
    	  var len = dinterface.errObj.rowErrors.length
    	  for (var i = 0; i < len; i++)
    	  {
    	  	  if ("41917" != dinterface.errObj.rowErrors[i].error.code)
    	  	  {
    	  	  	  flag = false;
    	  	  	  break;
    	  	  }
    	  }
    	  if (flag && TIMEOUT != dinterface.errObj.s_error.code)
    	  {
    	  	  dinterface.errObj.s_error.code = oprSucc;
    	  }
    }
    openErrPage("../../../../../page/", dinterface.getError(), errArr);
   
    if (oprFail == dinterface.getError().getGlobleECode() 
        || TIMEOUT == dinterface.getError().getGlobleECode()) 
    {
    	$("querybtn").disabled = !btnRightArr.querybtn.right;	
        $("createbtn").disabled = !btnRightArr.createbtn.right;
        document.getElementById("deletebtn").disabled = true;
        document.getElementById("applybtn").disabled = true;
        		
    	  return;
    }
    

    for(var i = 0, len = dinterface.getDataRowLength(); i < len; i++)
	  {
	  	  var diobj = dinterface.rows[i];
    	  var ptag = null;
	  	  if (0x8000 > dinterface.getDataRowParam(i,"port"))
	  	  {
    	      ptag = new ParamTag();
    	      ptag.value = "PORT" + dinterface.getDataRowParam(i, "port");
    	      diobj["port"]=ptag;
	  	  }
          else
          {
        	  ptag = new ParamTag();
    	      ptag.value = "VCTRUNK" + (dinterface.getDataRowParam(i, "port") - 0x8000);
    	      diobj["port"]=ptag;
          }
          if (0xFFFF == dinterface.getDataRowParam(i,"firstVlan"))
          {
    	  
    	      ptag = new ParamTag();
    	      ptag.value = "-";
    	      diobj["firstVlan"]=ptag;
          }
          if (0xFFFF == dinterface.getDataRowParam(i,"totalVlan"))
          {
    	  
    	      ptag = new ParamTag();
    	      ptag.value = "-";
    	      diobj["totalVlan"]=ptag;
          }
	      ptag = new ParamTag();
	      ptag.value = parseInt(dinterface.getDataRowParam(i,"firstVlan"))
	                    + parseInt(dinterface.getDataRowParam(i,"totalVlan")) -1;
	      diobj["lastVlan"]=ptag;
	      
	      ptag = new ParamTag();
	      ptag.value = dinterface.getDataRowParam(i,"totalVlan");
	      diobj["totalVlan_bak"]=ptag;
         
          

	  }   
	  clearTable();
	  createTableBody(st, window.tableconf[0], dinterface, RESOURCE);
	  
      addCellEvent();
	  
	  if(!st.element.colsArray.selectedId)
	  {
	  	 st.element.colsArray.selectedId = "port";
	  	 st.element.colsArray.imgflag = 1;
	  }
	  var td=st.element.headRow.element.cols[st.element.colsArray.selectedId].element; 
	  st.sortRows(td,st.element.colsArray.imgflag);
	  
	  document.getElementById("querybtn").disabled = !btnRightArr.querybtn.right;
      document.getElementById("createbtn").disabled = !btnRightArr.createbtn.right;
      document.getElementById("deletebtn").disabled = true;
      document.getElementById("applybtn").disabled = true;
}

/*
* Create sort table body
* st SortTable Object
* tc TableConf Object
* di DataInterface Object
* res RESOUCE object
*/
function createTableST(st, tc, di, res)
{
	  for(var i = 0; i < di.getDataRowLength(); i++)
    {
        var row = st.createRow();
        for(var j = 0; j < tc.getColsLength(); j++)
        {            
            var cell = st.createCell(tc.getColWidth(j));
            cell.colid=tc.getColId(j);
            st.setCellIsEdit(cell, tc.getIsEdit(j));
            var atom = st.createAtom(tc.getColShowType(j))
            var options = tc.getColShowOptions(j);
            if(null != options && "" != options)
            {
                for(var k = 0; k < options.length; k++)
                {
                    atom.addOption(options[k].getName(), options[k].getValue());
                }
                atom.element.disabled = true;
            } 
            var showvalue = "";
            if(tc.getColKeyArray(j).length > 0)
            {   
                for(var k = 0; k <tc.getColKeyArray(j).length; k++)
                {
                    if(di.getDataRowParam(i, tc.getColKeyArray(j)[k].getName()))
                    {
                        st.setCellValue(cell, tc.getColKeyArray(j)[k].getName(), di.getDataRowParam(i, tc.getColKeyArray(j)[k].getName()));
                        if(tc.getColKeyArray(j)[k].getConvert())
                        {
                            showvalue += convertMsg(res, eval(tc.getColKeyArray(j)[k].getConvert()), 
                                                        di.getDataRowParam(i, tc.getColKeyArray(j)[k].getName()))+"-";
                        }
                        else
                        {
                            showvalue += di.getDataRowParam(i, tc.getColKeyArray(j)[k].getName()) + "-";
                        }   
                    }
                }
            }
            
            if(showvalue && showvalue.length > 0)
            {
                atom.setValue(showvalue.substring(0, showvalue.length-1));
            }
            else
            {
                atom.setValue("-");
            }
            var cellID = tc.getColId(j);
            if("oamEN" == cellID && "-" == atom.getValue())
            {
                st.setCellIsEdit(cell, 0);    
            }
            st.addCellShow(cell, atom);
            
            if(tc.getIsEdit(j) == 1)
            {
                var ops = di.getDataRowOptions(i, tc.getColKeyArray(j)[0].getName());
                var atom = st.createAtom(tc.getColEditType(j));
                var options = tc.getColEditOptions(j)
                if(options.length > 0)
                {
                    for(var k = 0; k < options.length; k++)
                    {
                        atom.addOption(options[k].getName(), options[k].getValue());
                    }
                }  
                else if(ops)
                {
                    var convert = tc.getColKeyArray(j)[0].getConvert(); 
                    if(convert)
                    {
                        for(var k = 0; k <ops.length; k++)
                        {
                            var conv = eval(convert);
                            atom.addOption(convertMsg(res, conv, ops[k]), ops[k]); 
                        }
                    }
                    else
                    {
                        for(var k = 0; k <ops.length; k++)
                        {
                            atom.addOption(ops[k], ops[k]); 
                        }
                    }   
                }
                st.addCellEdit(cell, atom);                    
            }
            else if(tc.hasEditElement(j))
            {
                var convert = tc.getColKeyArray(j)[0].getConvert();                 
                var atom = st.createAtom(tc.getColEditType(j));
                var ops = di.getDataRowOptions(i, tc.getColKeyArray(j)[0].getName()); 
                if(ops)
                {
                    if(convert)
                    {
                        for(var k = 0; k <ops.length; k++)
                        {
                            atom.addOption(convertMsg(res, eval(convert), ops[k]), ops[k]); 
                        }
                    }
                    else
                    {
                        for(var k = 0; k <ops.length; k++)
                        {
                            atom.addOption(ops[k], ops[k]); 
                        }
                    }   
                }
                st.addCellEdit(cell, atom);     
            }            
            st.addCell(row, tc.getColId(j), cell);
            var cellwidth = tc.getColWidth(j);
            if(cellwidth == "0" || cellwidth == "0px" || cellwidth == "0%")
            {
                cell.element.style.display = "none";    
            }
        }
        st.addRow(row)
    }
}



/**
 * remove all the table rows
 */
function clearTable()
{
    for(var i=0; i< st.getDataRowLength(); ++i)
    {
        st.deleteRow(i);
    }
    st.adjustDataRows();
    
}



/**
 * create table cell
 */
function createCell(st, tc, row, colName, showValue, storeValue, hide)
{
    if (!tc[colName])
    {
        return;
    }
    var cell = st.createCell(tc[colName].width);
    st.setCellIsEdit(cell, tc[colName].cell.isEdit);
    var atom = st.createAtom(tc[colName].cell.showElement.type);
    if (showValue)
    {
        atom.setValue(showValue);
    }
    else
    {
        atom.setValue("-");
    }
    if (storeValue)
    {
        st.setCellValue(cell, colName, storeValue);
    }
    else
    {
        st.setCellValue(cell, colName, atom.getValue());
    }
    if (hide)
    {
        cell.element.style.display = "none";
    }
    else
    {
        cell.element.style.display = "";
    }
    st.addCellShow(cell, atom);
    st.addCell(row, tc[colName].id, cell);
    return cell;
}




/**
 * do the delete
 */
function doDelete()
{
    if (st.getSelectedRowCount() <= 0)
    {
        alert(RESOURCE["noselect"]);
        return;
    }
    if (!confirm(RESOURCE["confmsg"]))
    {
        return;
    }
    
    document.getElementById("querybtn").disabled = true;
    document.getElementById("createbtn").disabled = true;
    document.getElementById("deletebtn").disabled = true;
    document.getElementById("applybtn").disabled = true;
    
    var xml = createDeleteRequest();
    var URL = "../../../../../neExlorerServlet?sfid="+DELETESFID+"&flag=1&nmUser="+winobj["nmUser"];
    loadXMLdoc(URL,"POST", true, processDeleteResponse, null, "inputdata="+xml);
}

/**
 * create delete XML request
 */
function createDeleteRequest()
{
    var ports = [];
    var firstVlans = [];
    var totalVlans = [];
    var lastVlans = [];
    var selRows = st.getSelectedRows();
    for (var i = 0; i < selRows.length; ++i)
    {
        ports[ports.length] = st.getCellStoreValue(selRows[i], "port", "port");
        firstVlans[firstVlans.length] = st.getCellStoreValue(selRows[i], "firstVlan", "firstVlan");
        lastVlans[lastVlans.length] = st.getCellStoreValue(selRows[i], "lastVlan", "lastVlan");
        totalVlans[totalVlans.length] = st.getCellStoreValue(selRows[i], "totalVlan", "totalVlan");
    }

    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    for (var i = 0; i < selRows.length; ++i)
    {
        var row = new tagElement("row-params");

        var param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neID);
        row.appendChild(param);

        param = new tagElement("param");
        param.setAttribute("name", "slotid");
        param.setAttribute("value", slotID);
        row.appendChild(param);

		var portNO;
	    var portName = "PORT";
	    var vctrunkName = "VCTRUNK";
	    if(ports[i].substr(0,portName.length) == portName)
	    {
	    	portNO = ports[i].substr(portName.length);
	    }
	    else
	    {
	    	portNO = parseInt(ports[i].substr(vctrunkName.length)) + 0x8000;
	    }
    
        param = new tagElement("param");
        param.setAttribute("name", "port");
        param.setAttribute("value", portNO);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "firstVlan");
        param.setAttribute("value", firstVlans[i]);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "lastVlan");
        param.setAttribute("value", lastVlans[i]);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "totalVlan");
        param.setAttribute("value", totalVlans[i]);
        row.appendChild(param);

        business.appendChild(row);
    }
    root.getRoot().appendChild(business);
    return root.toString();
}

/**
 * callback function
 */
function processDeleteResponse(doc)
{
	/*
    if (deleteRight)
    {
        document.getElementById("deletebtn").disabled = false;
    }*/  

    var dinterface = EncapsulateData(doc);

    var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "slotid";
    errArr[2] = "boardname";
    openErrPage("../../../../../page/", dinterface.getError(), errArr);

    doQuery(true);
}
/**
 * do apply
 */
function doApply()
{
		 if (!confirm(RESOURCE["confmsg"]))
     {
        return;
     }
	document.getElementById("querybtn").disabled = true;
    document.getElementById("createbtn").disabled = true;
    document.getElementById("deletebtn").disabled = true;
    document.getElementById("applybtn").disabled = true;
	sreahModify();
    

	
    /*
    if(!validateForm())
    {         
        return;
    }

    if(!isValidatetotalVlan())
    {
     	alert(RESOURCE["totalVlanMsg"]);
     	document.getElementById("querybtn").disabled = false;
	    document.getElementById("createbtn").disabled = false;
	    document.getElementById("deletebtn").disabled = false;
	    document.getElementById("applybtn").disabled = false;
        return;
    }
    
 */
    
    var xml=createSendXml();
    
    if (null == xml)
    {
     	  return;
    }

    sendXmlData(xml);  
       
    
    modifyInfoArray = [];
}

function isValidatetotalVlan()
{        
	 for(var i=0;i< modifyInfoArray.length;i++)
	{
	    var servInfo = modifyInfoArray[i];     
	    
		
	    var totalVlan = servInfo.totalVlan;
	    
	    var totalVlans = [1,2,4,8,16,32,64,128,256,512,1024,2047,4095];
	    
	    if(!totalVlan)
	    {
	        return;
	    }
	    
	    if (totalVlans.contains(totalVlan))
	    {
	    	return true;
	    }
	    else
	    {
	    	return false;
	    }
	}
}
function validatetotalVlanTofirstVlan()
{        

	 for(var i=0;i< modifyInfoArray.length;i++)
	{
	    var servInfo = modifyInfoArray[i];     
	    
	    var firstVlan = servInfo.firstVlan;
	    var totalVlan = servInfo.totalVlan;
	    
	   var value = firstVlan%totalVlan;
	    
	  
	    
	    if (value == 0)
	    {
	    	return true;
	    }
	    else
	    {
	    	return false;
	    }
	}
}
/*
 *                
 */
function createSendXml()
{
    var root =new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");

    for(var i=0;i< modifyInfoArray.length;i++)
	{
	    var servInfo = modifyInfoArray[i];     
	    servInfo.neid = neID;
	    servInfo.soltID = slotID;
	  
	    var portNO;
	    var portName = "PORT";
	    var vctrunkName = "VCTRUNK";
	    if(servInfo.port.substr(0,portName.length) == portName)
	    {
	    	portNO = servInfo.port.substr(portName.length);
	    }
	    else
	    {
	    	portNO = parseInt(servInfo.port.substr(vctrunkName.length)) + 0x8000;
	    }
	    
	    servInfo.port = portNO;
	    
	    var row = servInfo.torowparamXML();
	    bussiness.appendChild(row);
	}
	
    root.getRoot().appendChild(bussiness);
    var xml = root.toString();

    return xml;   
      
}


/*
 *   xml  
 * @param xml       
 */
function sendXmlData(xml)
{    
    
    var url = "../../../../../neExlorerServlet?sfid="+SENDSFID+"&flag=1&nmUser="+nmUser;;
      
    loadXMLdoc(url,"POST",true,PostCallBackHandler,null,"inputdata="+xml);   
}

/*
 *          
 * @param doc        
 */
function PostCallBackHandler(doc)
{
    
    var dinterface = EncapsulateData(doc);
    refreshTableState(st, window.tableconf[0], dinterface);//      
     var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "slotid";
    errArr[2] = "boardname";
    openErrPage("../../../../../page/", dinterface.getError(), errArr);
    document.getElementById("querybtn").disabled = !btnRightArr.querybtn.right;
    document.getElementById("createbtn").disabled = !btnRightArr.createbtn.right;
    if(st.getSelectedRows().length > 0)
    {
    	document.getElementById("deletebtn").disabled = !btnRightArr.deletebtn.right;
    }
    if(dinterface.getError().getGlobleECode() != 0)
    {
    	document.getElementById("applybtn").disabled = false;
    }

}
/**
 * create query XML request
 */
function createQueryPortRequest(portNO)
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
        var row = new tagElement("row-params");

        var param = new tagElement("param");
        param.setAttribute("name", "neID");
        param.setAttribute("value", neID);
        row.appendChild(param);

        param = new tagElement("param");
        param.setAttribute("name", "slotid");
        param.setAttribute("value", slotID);
        row.appendChild(param);

        param = new tagElement("param");
        param.setAttribute("name", "port");
        param.setAttribute("value", portNO);
        row.appendChild(param);
        
        if (0x8000 > portNO)
        {
       	    param=new tagElement("param");
       	    param.setAttribute("name","attrid");
       	    param.setAttribute("value","ATTR_ETHOVERSDH_MAC_PE_TYPE");
       	    row.appendChild(param);    
   
       	    param=new tagElement("param");
            param.setAttribute("name","attrid");
            param.setAttribute("value","ATTR_ETHOVERSDH_MAC_ENABLE");
            row.appendChild(param);
        
            param=new tagElement("param");
            param.setAttribute("name","attrid");
            param.setAttribute("value","ATTR_ETHOVERSDH_MAC_TAG");
            row.appendChild(param);
        }
        else
        {
       		  param=new tagElement("param");
        		param.setAttribute("name","attrid");
       		  param.setAttribute("value","ATTR_ETHOVERSDH_VCG_PE_TYPE");
       		  row.appendChild(param);
        
        		param=new tagElement("param");
       		  param.setAttribute("name","attrid");
       	    param.setAttribute("value","ATTR_ETHOVERSDH_VCG_TAG");
       		  row.appendChild(param);
        }

        business.appendChild(row);
    root.getRoot().appendChild(business);
    return root.toString();
}

/**
 * callback function
 */
function processQueryPortResponse(doc)
{
    var dinterface = EncapsulateData(doc);

    var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "slotid";
    errArr[2] = "boardname";
    openErrPage("../../../../../page/", dinterface.getError(), errArr);
    if (oprSucc != dinterface.getError().getGlobleECode()) 
    {
    	 
        		
        if (deleteRight)
        {
        	  document.getElementById("deletebtn").disabled = false;
        } 
        if (convertRight)
        {
        	  document.getElementById("convertbtn").disabled = false;
        } 
    	  return;
    }
    queryPortAttr(ports[1],dinterface);
}

function addTableData(dinterface)
{
    var length = st1.getDataRowLength();
	  if (0 < length)
	  {
	      for(var i = length -1; i >= 0; i--)
        {
            st1.deleteRow(i);
        }
        st1.adjustDataRows();
    }
    
    for (var i = 0; i < dinterface.rows.length; ++i)
    {
        if (dinterface.rows[i].port.value < 0x8000)
        {
        	  var ptagName = new ParamTag();
        	  ptagName.value = "PORT" + (dinterface.rows[i].port.value);
            dinterface.rows[i]["port"] = ptagName;
            var ptagType = new ParamTag();
            ptagType.value = PortType[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_MAC_PE_TYPE")];
            dinterface.rows[i]["portType"] = ptagType;
            var ptagEnable = new ParamTag();
            if ("en" == language)
            {
    	          ptagEnable.value = PortEnableEN[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_MAC_ENABLE")];
            }
            else
            {
            	  ptagEnable.value = PortEnable[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_MAC_ENABLE")];
            }
            dinterface.rows[i]["portEnable"] = ptagEnable;
            var ptagTag = new ParamTag();
            ptagTag.value = PortTag[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_MAC_TAG")];
            dinterface.rows[i]["portTag"] = ptagTag;
        }
        else
        {
        	  var ptagName = new ParamTag();
        	  ptagName.value = "VCTRUNK" + (dinterface.rows[i].port.value - 0x8000);
            dinterface.rows[i]["port"] = ptagName;
            var ptagType = new ParamTag();
            ptagType.value = PortType[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_VCG_PE_TYPE")];
            dinterface.rows[i]["portType"] = ptagType;
            var ptagEnable = new ParamTag();
            ptagEnable.value = PortEnable["255"];
            dinterface.rows[i]["portEnable"] = ptagEnable;
            var ptagTag = new ParamTag();
            ptagTag.value = PortTag[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_VCG_TAG")];
            dinterface.rows[i]["portTag"] = ptagTag;
        }
        
    }
    createTableBody(st1, window.tableconf[1], dinterface, RESOURCE);
    if(!st1.element.colsArray.selectedId)
	  {
	  	 st1.element.colsArray.selectedId = "port";
	  	 st1.element.colsArray.imgflag = 1;
	  }
	  var td=st1.element.headRow.element.cols[st1.element.colsArray.selectedId].element; 
	  st1.sortRows(td,st1.element.colsArray.imgflag);
    
}

function processQueryPortAttrResponse(doc,dainterface)
{
	$("querybtn").disabled = !btnRightArr.querybtn.right;	
    $("createbtn").disabled = !btnRightArr.createbtn.right; 
    
    		
    if (deleteRight)
    {
    	  document.getElementById("deletebtn").disabled = false;
    } 
    if (convertRight)
    {
    	  document.getElementById("convertbtn").disabled = false;
    } 
        
    var dinterface = EncapsulateData(doc);

    var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "slotid";
    errArr[2] = "boardname";
    openErrPage("../../../../../page/", dinterface.getError(), errArr);
    if (oprSucc != dinterface.getError().getGlobleECode()) 
    {
    	  return;
    }
    addTableData(dainterface);
    for (var i = 0; i < dinterface.rows.length; ++i)
    {
        if (dinterface.rows[i].port.value < 0x8000)
        {
        	  var ptagName = new ParamTag();
        	  ptagName.value = "PORT" + (dinterface.rows[i].port.value);
            dinterface.rows[i]["port"] = ptagName;
            var ptagType = new ParamTag();
            ptagType.value = PortType[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_MAC_PE_TYPE")];
            dinterface.rows[i]["portType"] = ptagType;
            var ptagEnable = new ParamTag();
            if ("en" == language)
            {
    	          ptagEnable.value = PortEnableEN[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_MAC_ENABLE")];
            }
            else
            {
            	  ptagEnable.value = PortEnable[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_MAC_ENABLE")];
            }
            dinterface.rows[i]["portEnable"] = ptagEnable;
            var ptagTag = new ParamTag();
            ptagTag.value = PortTag[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_MAC_TAG")];
            dinterface.rows[i]["portTag"] = ptagTag;
        }
        else
        {
        	  var ptagName = new ParamTag();
        	  ptagName.value = "VCTRUNK" + (dinterface.rows[i].port.value - 0x8000);
            dinterface.rows[i]["port"] = ptagName;
            var ptagType = new ParamTag();
            ptagType.value = PortType[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_VCG_PE_TYPE")];
            dinterface.rows[i]["portType"] = ptagType;
            var ptagEnable = new ParamTag();
            ptagEnable.value = PortEnable["255"];
            dinterface.rows[i]["portEnable"] = ptagEnable;
            var ptagTag = new ParamTag();
            ptagTag.value = PortTag[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_VCG_TAG")];
            dinterface.rows[i]["portTag"] = ptagTag;
        }
        
    }
    createTableBody(st1, window.tableconf[1], dinterface, RESOURCE);
}

function processRefreshPort(doc)
{
    var dinterface = EncapsulateData(doc);

    var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "slotid";
    errArr[2] = "boardname";
    openErrPage("../../../../../page/", dinterface.getError(), errArr);

    for (var i = 0; i < dinterface.rows.length; ++i)
    {
        if (dinterface.rows[i].port.value < 0x8000)
        {            
            st1.getCellShow(rowIndex, "port").setValue("PORT" + (dinterface.rows[i].port.value));
            st1.getCellShow(rowIndex, "portType").setValue(PortType[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_MAC_PE_TYPE")]);
            if ("en" == language)
            {
    	          st1.getCellShow(rowIndex, "portEnable").setValue(PortEnableEN[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_MAC_ENABLE")]);
            }
            else
            {
                st1.getCellShow(rowIndex, "portEnable").setValue(PortEnable[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_MAC_ENABLE")]);
            }
            st1.getCellShow(rowIndex, "portTag").setValue(PortTag[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_MAC_TAG")]);
        }
        else
        {
        	  st1.getCellShow(rowIndex, "port").setValue("VCTRUNK" + (dinterface.rows[i].port.value- 0x8000));
            st1.getCellShow(rowIndex, "portType").setValue(PortType[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_VCG_PE_TYPE")]);
            st1.getCellShow(rowIndex, "portEnable").setValue(PortEnable["255"]);
            st1.getCellShow(rowIndex, "portTag").setValue(PortTag[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_VCG_TAG")]);            
        }       
    }
    if (0 == rowIndex)
    {
    	  rowIndex = 1;
    }
    else
    {
    	  rowIndex = 0;
    }
}

function refreshPorts(port)
{   
    if (port)
    {
        if (-1 != port.indexOf("PORT"))
        {
        	  port = port.substring(4);
        }
        else
        {
        	  port = 0x8000 + parseInt(port.substring(7));
        }
        var xml = createQueryPortRequest(port);
        var URL = "../../../../../neExlorerServlet?sfid="+TECMDCODE_IP_PORTATTRI+"&flag=1&nmUser="+winobj["nmUser"];
    	  loadXMLdoc(URL,"POST", false, processQueryPortResponse, null, "inputdata="+xml);                     
    }
    else
    {
        for(var i=0; i< st1.getDataRowLength(); ++i)
        {
            st1.deleteRow(i);
        }
        st1.adjustDataRows();
    }
}

function queryPortAttr(port,dinterface)
{
    if (port)
    {
        if (-1 != port.indexOf("PORT"))
        {
        	  port = port.substring(4);
        }
        else
        {
        	  port = 0x8000 + parseInt(port.substring(7));
        }
        var xml = createQueryPortRequest(port);
        var URL = "../../../../../neExlorerServlet?sfid="+TECMDCODE_IP_PORTATTRI+"&flag=1&nmUser="+winobj["nmUser"];
    	  loadXMLdoc(URL,"POST", false, processQueryPortAttrResponse, dinterface, "inputdata="+xml);                     
    }
    else
    {
        for(var i=0; i< st1.getDataRowLength(); ++i)
        {
            st1.deleteRow(i);
        }
        st1.adjustDataRows();
    }
}
 

/**
 *               
 * @param  
 * @return  
 */
function cellEditHandler()
{
	if(btnRightArr.applybtn.right)
	{
		$("applybtn").disabled = false; 
	}
}

function showShareChanged()
{
	  sharedFlag = false;
      doQuery(false);
}

/**************************************        ****************************************/

/*
 *       
 */
function queryLink(fromNE)
{
    doQuery(fromNE);
}

/*
 *       
 */
function delLink()
{
    doDelete();
}
/**************************************      ****************************************/


/**
 *        
 * @param btnId       ID  sfid             ID
 * @return  
 */ 
function BtnRightObj(btnId,sfid)
{
	  if(null != btnId)
	  {
	    	this.btnId = btnId;
	  }
	  else
	  {
	    	this.btnId = "";
  	  }
	
  	  if(isNaN(parseInt(sfid)))
	  {
	    	this.sfid = -1;
	  }
	  else
	  {
		    this.sfid = sfid;
	  }
	  
	  this.right = true;
}

/**
 *       
 * @param  
 * @return  
 */ 
function sendRightInfo()
{
	  var url = "../../../../../securityServlet?neID="+winobj["neid"]+"&nmUser="+winobj["nmUser"];
	  loadXMLdoc(url,"POST",false,rightHandleBack,null,"inputdata=" + createRightXML());
}

/**
 *           XML
 * @param  
 * @return  
 */ 
function createRightXML()
{
	  var root = new inputxml("datainterface");//Create the root of a xml file
	  var firstlevel = new tagElement("bussiness-params");
	
	  var secondlevel=null;;
	  var thirdlevel=null;
	
    for(var btnrightobj in btnRightArr)
	  {
		    secondlevel = new tagElement("row-params"); //bean         	
		
		    thirdlevel = new tagElement("param");
		    thirdlevel.setAttribute("name","btnID");
		    thirdlevel.setAttribute("value",btnRightArr[btnrightobj].btnId);
		    secondlevel.appendChild(thirdlevel);
		
		    thirdlevel = new tagElement("param");	
		    thirdlevel.setAttribute("name","sfid");
		    thirdlevel.setAttribute("value",btnRightArr[btnrightobj].sfid);
		    secondlevel.appendChild(thirdlevel);
		
		    firstlevel.appendChild(secondlevel);
	  }
	  root.getRoot().appendChild(firstlevel);
	  return root.toString();
}
/**
 *           
 * @param  
 * @return  
 */ 
function rightHandleBack(doc)
{
	  var data = EncapsulateData(doc);
    
	  for(var i = 0; i < data.getDataRowLength(); i++)  //       
    {
      	var right = data.getDataRowParam(i,"right");
    	
      	if(0 == right)
    	  {
    	    	btnRightArr[data.getDataRowParam(i,"btnID")].right = false;
    	  } 
      	else
    	  {
    	    	btnRightArr[data.getDataRowParam(i,"btnID")].right = true;
    	  }        
    }   
}


/**************************************      ****************************************/

/*
 *   tab   
 */
function tabSelectHandler()
{

      if(btnRightArr.querybtn.right)
      {
	        doQuery(true);
      }
}

/*
 *         
 */
window.onresize=function()
{
	  st.setBodyHeight(getTableHeight($("tablecomponent"),st)*0.8+"px");
}


/**
 * table selection change
 */
function rowSelected(rows)
{//debugger;
	if(rows.length > 0)
	{
		if (deleteRight)
    {
        document.getElementById("deletebtn").disabled = false;
    }
	}
	else
	{
		$("deletebtn").disabled = true;
	}
    
   
    
    servInfoArray = [];
    for (var i = 0; i<rows.length; i++)
    {
    	var servInfo = new ServiceInfo();
	    servInfo.port = st.getCellStoreValue(rows[i], "port", "port");
	    servInfo.firstVlan = st.getCellStoreValue(rows[i], "firstVlan", "firstVlan");
	    servInfo.totalVlan = st.getCellStoreValue(rows[i], "totalVlan", "totalVlan");
	    
	    servInfoArray[servInfoArray.length] = servInfo;
    }
   
}


/**
 *      
 */
function addCellEvent()
{
	var cell = null;
	
	for(var i = 0,len = st.getDataRowLength();i<len;i++)
	{
		cell = st.getCell(i,"totalVlan");
			textCheck(cell.element.editElement.element,"1","4095");

		
	}	
}

/**
 * TAG       
 * @param cell    
 * @return  
 */
function tagCellEvent(cell)
{
	var atom = cell.element.editElement;
	atom.element["onchange"] = function()
	{
		
		tabCellEditHandler(this);
	}
	atom.element["onkeydown"] = function()
	{
		
	}
	
}
/**
 *             
 * @param  
 * @return  
 */
function tabCellEditHandler(atom)
{
	if (modifyRight)
	{
	        document.getElementById("applybtn").disabled = false;
	}
  	var rowindex = atom.parentNode.parentNode.rowIndex;
  	var colid = atom.parentNode.colid;
  	var value = atom.value;
  	

		
		
		
		
		
		
		
		st.setCellIsEdit(st.getCell(rowindex,colid),1);
		

	    
	    modifyInfoArray.length = 0;
	    for(var i = 0,len = st.getDataRowLength();i<len;i++)
	    {
		
			if(st.getCellModify(i,"totalVlan"))
			{
				
							
				var servInfo = new ServiceInfo();
			    servInfo.port = st.getCellStoreValue(i,"port","port");
			    servInfo.firstVlan = st.getCellStoreValue(i,"firstVlan","firstVlan"); 
			    servInfo.totalVlan = value;
			    servInfo.totalVlan_bak = st.getCellStoreValue(i,"totalVlan_bak","totalVlan_bak");
			    
			    modifyInfoArray[modifyInfoArray.length] = servInfo;
			}
		}	
	
}
/**
 *           
 */
function sreahModify()
{
	
		
	    
	    modifyInfoArray.length = 0;
	    for(var i = 0,len = st.getDataRowLength();i<len;i++)
	    {
		
			if(st.getCellModify(i,"totalVlan"))
			{
				
							
				var servInfo = new ServiceInfo();
			    servInfo.port = st.getCellStoreValue(i,"port","port");
			    servInfo.firstVlan = st.getCellStoreValue(i,"firstVlan","firstVlan"); 
			    servInfo.totalVlan = st.getCellStoreValue(i,"totalVlan","totalVlan");
			    servInfo.totalVlan_bak = st.getCellStoreValue(i,"totalVlan_bak","totalVlan_bak");
			    
			    modifyInfoArray[modifyInfoArray.length] = servInfo;
			}
		}	
	
}
