loadXMLdoc("../../../../../conf/system.xml", "GET", false,EncapsulateSConf);

var language= SYSTEMCONF.getLanguage(); 

loadXMLdoc("../../conf/transtunnel/tunnel_boundpath_"+SYSTEMCONF.getLanguage()+".xml", "GET", false,EncapsulateTable);

getResourse("../../../../../res/configres_" + language + ".xml");
getResourse("../../../../../res/commonres_" + language + ".xml");
getResourse("../../../../../res/necommres_" + language + ".xml");
getResourse("../../../../../res/neinformationres_" + language + ".xml");

loadXMLdoc("../../../../help/"+SYSTEMCONF.getLanguage()+"/helpidresource.xml", "GET", false,EncapsulateHelpConfig);
getResourse("../../res/transtunnel/transtunnel_"+SYSTEMCONF.getLanguage()+".xml");


document.title = RESOURCE["createtunnel"]

var vctrunk = [];

var winobj = getNeProperty(self);
var neID = getParentWindow().neid;
var nmUser = getParentWindow().nmUser;
var subrackName = getParentWindow().subrackName;
var slotID = getParentWindow().slotid;
var supportBoundPath = getParentWindow().supportBoundPath;

var stTunnel;
var stAttr;
var stBoundPath;

var boardAtom;
var boardAtomR;

var nodeTypeAtom;
var nodeTypeAtomR;

var tunnelIndexAtom;
var tunnelIndexAtomR;

var inPortAtom;
var inPortAtomR;

var inLabelAtom;
var inLabelAtomR;

var outPortAtom;
var outPortAtomR;

var outLabelAtom;
var outLabelAtomR;

var nextHopIpAtom;
var nextHopIpAtomR;
var inPortTypeAtom;
var inPortEnableAtom;

var outPortTypeAtom;
var outPortEnableAtom;

var VCTRUNK_BASE = 32768;

var parentWin = getParentWindow();

/**
 *            
 * @param  
 * @return  
 */
function initBody()
{
	initTable();
	initButton();
}

/**
 *          
 * @param  
 * @return  
 */
function initTable()
{
		initTunnelTable();
		showReverseTunnel(false);
		doQuery();

		initAttrTable();

		vctrunk.clear();
		addOnlyVctrunk(inPortAtom.getValue());
		addOnlyVctrunk(outPortAtom.getValue());
		$("configBtn").disabled = true;
		
		bindListeners();
		
		initBoundPathTable();
}

/**
 *          
 * @param  
 * @return  
 */
function initButton()
{
	$("confirmBtn").value = RESOURCE["okbutton"];
  $("cancelBtn").value = RESOURCE["cancelbutton"]; 
	$("applyBtn").value = RESOURCE["applybutton"];
  $("configBtn").value = RESOURCE["configbutton"];
  
  if( SYSTEMCONF.getLanguage() == "en" )
  {
  	$("configBtn").style.width = "120px";
  }
}

/**
 *       
 * @param  
 * @return  
 */
function doQuery()
{
  $("confirmBtn").disabled = true;
  $("cancelBtn").disabled = true;
  $("applyBtn").disabled = true;

	initPortList();
}

function showErrorDialog(data)
{
	var errArr = [];
	  errArr[0] = "nename";
	  errArr[1] = "slotId";
	  errArr[2] = "portId";
    openErrPage("../../../../../page/", data.getError(), errArr);
    errArr = null;
}

function doConfig()
{

	if(isIE)
	{
		parent.xshowModalDialog("../ipmgr_v2r8c01/boundpathconfig.html?ifsingle=true","",760,620,"../../../../../../images/");
	}
	else
	{
		window.open("../ipmgr_v2r8c01/boundpathconfig.html?ifsingle=true","","height = 610,width=800,left=100, top=50, status=no, toolbar=no, menubar=no,scrollbars=no,resizable=no");
	}
}

/*-----------------------------------------				       Start				-----------------------------------*/

function initPortList()
{  
  var xml = getPortListXML();

  var URL = "../../../../../neExlorerServlet?sfid=" + TECMD_ETHN_QUERY_TUNNEL_PORTLIST +"&nmUser=" + nmUser;

  loadXMLdoc(URL, "POST", false, getPortListBack, null, "inputdata=" + xml);
}

function getPortListXML()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;

    row = new tagElement("row-params");
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neID);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", slotID);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);

    return root.toString();
}

function getPortListBack(doc)
{
    var data = EncapsulateData(doc);
    var smallErrorCode = data.getSErrorCode();
    var portid = null;
    var portname = null;
    var portAtom = null;

    inPortAtom.clearOptions();
    outPortAtom.clearOptions();

    if ( 0 == smallErrorCode )
    {
        for (var i = 0, len = data.getDataRowLength(); i < len; i ++)
        {
            portid = data.getDataRowParam(i, "portid", "portid");
            portname = data.getDataRowParam(i, "portname", "portname");

            inPortAtom.addOption(portname, portid);
            inPortAtomR.addOption(portname, portid);

            outPortAtom.addOption(portname, portid);
            outPortAtomR.addOption(portname, portid);
        }
    }
    
  	$("confirmBtn").disabled = false;
  	$("cancelBtn").disabled = false;
  	$("applyBtn").disabled = false;

}

/*-----------------------------------------				       End				-----------------------------------*/


function initTunnelTable()
{
		stTunnel = new MTable();
		
		stTunnel.addHead(RESOURCE["ATTRIBUTE"], RESOURCE["PVALUE"], RESOURCE["RVALUE"]);

		var win = getParentWindow();
		var showBoardName = win.neName + "-";
		if (subrackName != "")
		{
			showBoardName += subrackName + "-";
		}
		showBoardName += getSlotIDFromSlot(slotID) + "-" + win.winobj.boardname;
		
		var boardAtom = new Atom("span");
		boardAtom.setValue(showBoardName); 
		boardAtom.element.style.width="100%";
		var boardAtomR = new Atom("span"); 
		boardAtomR.setValue(showBoardName);
		boardAtomR.element.style.width="100%"; 
		stTunnel.addAttrRow("boardType",RESOURCE["BOARD"],boardAtom,boardAtomR);

 		var nodeTypeAtom = new Atom("span");
 		nodeTypeAtom.setValue("Transit"); 
		nodeTypeAtom.element.style.width="100%";
		var nodeTypeAtomR = new Atom("span"); 
		nodeTypeAtomR.setValue("Transit");
		nodeTypeAtomR.element.style.width="100%"; 
		stTunnel.addAttrRow("nodeType",RESOURCE["NODETYPE"],nodeTypeAtom,nodeTypeAtomR);		
		
 		tunnelIndexAtom = new Atom("text");
 		tunnelIndexAtom.setValue(""); 
		tunnelIndexAtom.element.style.width="100%";
		validateNum(tunnelIndexAtom.element,1,2048,4);		
		tunnelIndexAtomR = new Atom("text"); 
		tunnelIndexAtomR.setValue("");
		tunnelIndexAtomR.element.style.width="100%"; 
		validateNum(tunnelIndexAtomR.element,1,2048,4);
		stTunnel.addAttrRow("tunnelIndex","Tunnel Index",tunnelIndexAtom,tunnelIndexAtomR);


 		inPortAtom = new Atom("select");
		inPortAtom.element.style.width="100%";
		inPortAtomR = new Atom("select"); 
		inPortAtomR.element.style.width="100%"; 
		inPortAtomR.element.disabled=true;
		stTunnel.addAttrRow("inPort",RESOURCE["INPORT"],inPortAtom,inPortAtomR);

 		inLabelAtom = new Atom("text");
 		inLabelAtom.setValue(""); 
		inLabelAtom.element.style.width="100%";
		validateNum(inLabelAtom.element,16,1048575,7);		
		inLabelAtomR = new Atom("text"); 
		inLabelAtomR.setValue("");
		inLabelAtomR.element.style.width="100%"; 
		validateNum(inLabelAtomR.element,16,1048575,7);
		stTunnel.addAttrRow("inLabel",RESOURCE["INLABEL"],inLabelAtom,inLabelAtomR);		

 		outPortAtom = new Atom("select");
		outPortAtom.element.style.width="100%";
		outPortAtomR = new Atom("select"); 
		outPortAtomR.element.style.width="100%";
		outPortAtomR.element.disabled=true;
		stTunnel.addAttrRow("outPort",RESOURCE["OUTPORT"],outPortAtom,outPortAtomR);		

 		outLabelAtom = new Atom("text");
 		outLabelAtom.setValue(""); 
		outLabelAtom.element.style.width="100%";
		validateNum(outLabelAtom.element,16,1048575,7);
		outLabelAtomR = new Atom("text"); 
		outLabelAtomR.setValue("");
		outLabelAtomR.element.style.width="100%";
		validateNum(outLabelAtomR.element,16,1048575,7);
		stTunnel.addAttrRow("outLabel",RESOURCE["OUTLABEL"],outLabelAtom,outLabelAtomR);		

 		nextHopIpAtom = new Atom("text");
 		nextHopIpAtom.setValue(""); 
		nextHopIpAtom.element.style.width="100%";
		validateIp(nextHopIpAtom.element);
		nextHopIpAtomR = new Atom("text"); 
		nextHopIpAtomR.setValue("");
		nextHopIpAtomR.element.style.width="100%"; 
		validateIp(nextHopIpAtomR.element);
		stTunnel.addAttrRow("nextHopIp",RESOURCE["NEXTHOPIP"],nextHopIpAtom,nextHopIpAtomR);

		document.getElementById("tunneltablecomponent").appendChild(stTunnel.getTable());
}


function initAttrTable()
{
		stAttr = new MTable();
		
		stAttr.addHead(RESOURCE["PORT"], RESOURCE["PORTTYPE"], RESOURCE["PORTENABLE"]);

		inPortTypeAtom = new Atom("span");
		inPortTypeAtom.setValue("NNI"); 
		inPortTypeAtom.element.style.width="100%";
		inPortEnableAtom = new Atom("select"); 
		inPortEnableAtom.addOption(RESOURCE["EnabledStr"], "1");
		inPortEnableAtom.addOption(RESOURCE["DisabledStr"], "0");
		inPortEnableAtom.element.style.width="100%";
		
		var inPortValue = inPortAtom.element.options[inPortAtom.element.selectedIndex].text;
		stAttr.addAttrRow("inPort",inPortValue,inPortTypeAtom,inPortEnableAtom);

 		outPortTypeAtom = new Atom("span");
 		outPortTypeAtom.setValue("NNI"); 
		outPortTypeAtom.element.style.width="100%";
		outPortEnableAtom = new Atom("select"); 
		outPortEnableAtom.addOption(RESOURCE["EnabledStr"], "1");
		outPortEnableAtom.addOption(RESOURCE["DisabledStr"], "0");
		outPortEnableAtom.element.style.width="100%"; 
		
		var outPortValue = outPortAtom.element.options[outPortAtom.element.selectedIndex].text;		
		stAttr.addAttrRow("outPort",outPortValue,outPortTypeAtom,outPortEnableAtom);

		document.getElementById("attrtablecomponent").appendChild(stAttr.getTable());
		
		var portAttrLable = document.getElementById("portAttrLable");
		portAttrLable.innerText = RESOURCE["PORTATTR"];

}

function initBoundPathTable()
{
	stBoundPath = new SortTable();
    stBoundPath.setImage("../../../../../../images/");
    createTableHead(stBoundPath, window.tableconf[0]);
    stBoundPath.setBodyHeight(getComponetHeight($("boundpathtablecomponent"), 400)+"px");//        
    $("boundpathtablecomponent").appendChild(stBoundPath.getTable());

		var boundPathLable = document.getElementById("boundPath");
		boundPathLable.innerText = RESOURCE["BOUNDPATH"];
    refreshVctrunk();
    
    $("dualDirectionlabel").innerText = RESOURCE["DUALDIRECTION"];
}


function bindListeners()
{
 		inPortAtom.element.onchange = function()
 		{
 			outPortAtomR.element.value = inPortAtom.element.value;
 			
 			var inPortText = inPortAtom.element.options[inPortAtom.element.selectedIndex].text;
 			var node = stAttr.attrNameArray["inPort"];
 			node.nodeValue = inPortText;
 			
 			var inPortValue = inPortAtom.element.options[inPortAtom.element.selectedIndex].value;
			inPortEnableAtom.element.options.length = 0;
 			if( inPortValue > VCTRUNK_BASE )
 			{
				inPortEnableAtom.addOption("-", "0");
 				inPortEnableAtom.element.disabled = true;
 			}
 			else
 			{
				inPortEnableAtom.addOption(RESOURCE["EnabledStr"], "1");
				inPortEnableAtom.addOption(RESOURCE["DisabledStr"], "0");
 				inPortEnableAtom.element.disabled = false;
 			}


			vctrunk.clear();
 			var outPortValue = outPortAtom.element.options[outPortAtom.element.selectedIndex].value;
 			addOnlyVctrunk(inPortValue);
 			addOnlyVctrunk(outPortValue);
 			
			if((inPortValue > VCTRUNK_BASE || outPortValue > VCTRUNK_BASE) && supportBoundPath == "yes")
			{
				$("configBtn").disabled = false;
			}
			if((inPortValue < VCTRUNK_BASE && outPortValue < VCTRUNK_BASE) || supportBoundPath == "no")
			{
				$("configBtn").disabled = true;
			}
			refreshVctrunk();
 		}
 		outPortAtom.element.onchange = function()
 		{
 			inPortAtomR.element.value = outPortAtom.element.value;

 			var outPortText = outPortAtom.element.options[outPortAtom.element.selectedIndex].text;
 			var node = stAttr.attrNameArray["outPort"];
 			node.nodeValue = outPortText;
 			
 			var outPortValue = outPortAtom.element.options[outPortAtom.element.selectedIndex].value;
			outPortEnableAtom.element.options.length = 0;
 			if( outPortValue > VCTRUNK_BASE )
 			{
				outPortEnableAtom.addOption("-", "0");
 				outPortEnableAtom.element.disabled = true;
 			}
 			else
 			{
				outPortEnableAtom.addOption(RESOURCE["EnabledStr"], "1");
				outPortEnableAtom.addOption(RESOURCE["DisabledStr"], "0");
 				outPortEnableAtom.element.disabled = false;
 			}
 			
 			
			vctrunk.clear();
			var inPortValue = inPortAtom.element.options[inPortAtom.element.selectedIndex].value;
			addOnlyVctrunk(inPortValue);
			addOnlyVctrunk(outPortValue);
			
			if((inPortValue > VCTRUNK_BASE || outPortValue > VCTRUNK_BASE) && supportBoundPath == "yes")
			{
				$("configBtn").disabled = false;
			}
			if((inPortValue < VCTRUNK_BASE && outPortValue < VCTRUNK_BASE) || supportBoundPath == "no")
			{
				$("configBtn").disabled = true;
			}
			refreshVctrunk();
 		}

 		$("dualDirectionChkbox").onclick = function()
 		{
 			if( $("dualDirectionChkbox").checked )
 			{
				showReverseTunnel(true);
 			}
 			else
 			{
 				showReverseTunnel(false);
 			}
 		}
}

function showReverseTunnel(ifShow)
{
	var show = (ifShow==true) ? "" : "none";
	var headNode = stTunnel.headArray[2];
	var headCell = headNode.parentNode;
	var headTD = headCell.parentElement;
	headTD.style.display = show;
	for( var i = 0; i < stTunnel.attrArray2.length; i++ )
	{
		var atom = stTunnel.attrArray2[i];
		var parentCell = atom.element.parentElement;
		parentCell.style.display = show;
	}
}

function doApply(isApply)
{

	if( checkTunnelInput() == false )
	{
		return;
	}

	var url = "../../../../../neExlorerServlet?sfid="+TE_CMD_MPLSTUNNEL_ADD_P2PTUNNEL+"&nmUser="+nmUser;
	var xml = createApplyXml();

  loadXMLdoc(url,"POST",true,callbackApply,isApply,"inputdata="+xml);
}

function createApplyXml()
{
	  var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;

    row = new tagElement("row-params");
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neID);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", slotID);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "tunnelIndex");
    param.setAttribute("value", tunnelIndexAtom.getValue());
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "inPort");
    param.setAttribute("value", inPortAtom.getValue());
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "inLabel");
    param.setAttribute("value", inLabelAtom.getValue());
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "outPort");
    param.setAttribute("value", outPortAtom.getValue());
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "outLabel");
    param.setAttribute("value", outLabelAtom.getValue());
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "nextHopIp");
    param.setAttribute("value", nextHopIpAtom.getValue());
    row.appendChild(param);


    param = new tagElement("param");
    param.setAttribute("name", "inPortEnable");
    param.setAttribute("value", inPortEnableAtom.getValue());
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "outPortEnable");
    param.setAttribute("value", outPortEnableAtom.getValue());
    row.appendChild(param);

		var bIfDualDire = $("dualDirectionChkbox").checked;
		var ifDualDire = bIfDualDire==true?"1":"0";
    param = new tagElement("param");
    param.setAttribute("name", "dualdiretion");
    param.setAttribute("value", ifDualDire);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "tunnelIndexR");
    param.setAttribute("value", tunnelIndexAtomR.getValue());
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "inLabelR");
    param.setAttribute("value", inLabelAtomR.getValue());
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "outLabelR");
    param.setAttribute("value", outLabelAtomR.getValue());
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "nextHopIpR");
    param.setAttribute("value", nextHopIpAtomR.getValue());
    row.appendChild(param);


    business.appendChild(row);
    root.getRoot().appendChild(business);

    return root.toString();
}

function callbackApply(doc, isApply)
{
  var dinterface  = EncapsulateData(doc);
  
        parentWin.doQuery();

	if( 0 != dinterface.getSErrorCode() ) 
	{
		showErrorDialog(dinterface);
	} else {
	    if(!isApply)
	    {
	    	if( isIE )
	    	{
	    		xcloseDialog();
	    	}
	    	else
	    	{
	    		setTimeout(xcloseDialog,3000);
	    	}
	    }
	}
}

























/*---------------------------------------  MTable------------------------------------*/

function MTable()
{
    this.element = document.createElement("table");
    this.element.appendChild(document.createElement("thead"));
    this.element.appendChild(document.createElement("tbody"));
    this.element.firstChild.appendChild(document.createElement("tr"));

		this.headArray = new Array();
    this.attrNameArray = new Object();
    this.attrArray = new Object();
    this.attrArray2 = new Array();
    this.element.className = "mTable";

    this.addHead = function (head1, head2, head3)
    {
        var th = document.createElement("td");
        span = document.createElement("span")
        var textNode1 = document.createTextNode(head1);
        span.appendChild(textNode1);
        th.appendChild(span);
        this.element.firstChild.firstChild.appendChild(th);
        
        th = document.createElement("td");
        span = document.createElement("span")
        var textNode2 = document.createTextNode(head2);
        span.appendChild(textNode2);
        th.appendChild(span);
        this.element.firstChild.firstChild.appendChild(th);
        
        th = document.createElement("td");
        span = document.createElement("span")
        var textNode3 = document.createTextNode(head3);
        span.appendChild(textNode3);
        th.appendChild(span);
        this.element.firstChild.firstChild.appendChild(th);
        
        this.headArray.push(textNode1);
        this.headArray.push(textNode2);
        this.headArray.push(textNode3);
    }

	this.addAttrRow = function(attrid, attrname, atom, atom2)
	{
		tr = document.createElement("tr");
		td = document.createElement("td");
		span = document.createElement("span");
		var textNode = document.createTextNode(attrname)
		span.appendChild(textNode);

		td.appendChild(span);
		tr.appendChild(td);

		td = document.createElement("td");
		td.appendChild(atom.element);
		tr.appendChild(td);
		
		td = document.createElement("td");
		td.appendChild(atom2.element);
		tr.appendChild(td);

		this.element.childNodes[1].appendChild(tr);

		this.attrArray[attrid] = atom;
		this.attrArray2.push(atom2);
		this.attrNameArray[attrid] = textNode;
	}

	 this.getAtom=function(attrid,index)
	{
		if( index == 0 )
		{
	    if(this.attrArray[attrid])
			{
			   return this.attrArray[attrid];
			}
		}
		else
		{
				return this.attrArray2[attrid];
		}

  }
	this.getTable = function()
	{
		return this.element;
	}
}

function addOnlyVctrunk(porValue)
{
	if( porValue > VCTRUNK_BASE )
	{
		vctrunk.append(porValue);
	}	
}

function refreshVctrunk()
{
	if (supportBoundPath == "no")
	{
		return;
	}
	
    var xml = createQueryVCtrunk();
    var URL = "../../../../../neExlorerServlet?sfid="+TE_CORBA_MSTPINV_GETBINDINGPATH+"&flag=1&nmUser="+nmUser;

    loadXMLdoc(URL,"POST", false, refreshVCtrunkCallback, null, "inputdata="+xml);
}

function createQueryVCtrunk()
{	
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");

    var row = new tagElement("row-params");

    var param = new tagElement("param");
    param.setAttribute("name", "neID");
    param.setAttribute("value", neID);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "slotID");
    param.setAttribute("value", slotID);
    row.appendChild(param);
    
    var portid = inPortAtom.element.value;
    param = new tagElement("param");  
    param.setAttribute("name", "vctrunk");
    param.setAttribute("value", portid);
		row.appendChild(param);
    business.appendChild(row);
    
    row = new tagElement("row-params");

    var param = new tagElement("param");
    param.setAttribute("name", "neID");
    param.setAttribute("value", neID);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "slotID");
    param.setAttribute("value", slotID);
    row.appendChild(param);
    
    portid = outPortAtom.element.value;
    param = new tagElement("param");  
    param.setAttribute("name", "vctrunk");
    param.setAttribute("value", portid);
		row.appendChild(param);
    business.appendChild(row);

    root.getRoot().appendChild(business);
    return root.toString();
    
    
}

function refreshVCtrunkCallback(doc)
{
	stBoundPath.clearTableData();
	
  var dinterface  = EncapsulateData(doc);
	createTableBody(stBoundPath, window.tableconf[0], dinterface, RESOURCE);

}

function checkTunnelInput()
{
	if( tunnelIndexAtom.getValue() == "" )
	{
		alert(RESOURCE["ID_NUMLEFT"] + "1" + RESOURCE["ID_NUMMIDDLE"] + "2048" + RESOURCE["ID_NUMRIGHT"]);
		tunnelIndexAtom.element.focus();
		return false;
	}
	if( inLabelAtom.getValue() == "" )
	{
		alert(RESOURCE["ID_NUMLEFT"] + "16" + RESOURCE["ID_NUMMIDDLE"] + "1048575" + RESOURCE["ID_NUMRIGHT"]);
		inLabelAtom.element.focus();
		return false;
	}
	if( outLabelAtom.getValue() == "" )
	{
		alert(RESOURCE["ID_NUMLEFT"] + "16" + RESOURCE["ID_NUMMIDDLE"] + "1048575" + RESOURCE["ID_NUMRIGHT"]);
		outLabelAtom.element.focus();
		return false;
	}
	if( !check_IPaddr( nextHopIpAtom.getValue() ) )
	{
		nextHopIpAtom.element.focus();
		return false;
	}

  if( $("dualDirectionChkbox").checked == true )
  {
		if( tunnelIndexAtomR.getValue() == "" )
		{
			alert(RESOURCE["ID_NUMLEFT"] + "1" + RESOURCE["ID_NUMMIDDLE"] + "2048" + RESOURCE["ID_NUMRIGHT"]);
			tunnelIndexAtomR.element.focus();
			return false;
		}
		if( inLabelAtomR.getValue() == "" )
		{
			alert(RESOURCE["ID_NUMLEFT"] + "16" + RESOURCE["ID_NUMMIDDLE"] + "1048575" + RESOURCE["ID_NUMRIGHT"]);
			inLabelAtomR.element.focus();
			return false;
		}
		if( outLabelAtomR.getValue() == "" )
		{
			alert(RESOURCE["ID_NUMLEFT"] + "16" + RESOURCE["ID_NUMMIDDLE"] + "1048575" + RESOURCE["ID_NUMRIGHT"]);
			outLabelAtomR.element.focus();
			return false;
		}
		if( !check_IPaddr(nextHopIpAtomR.getValue()) )
		{
			nextHopIpAtomR.element.focus();
			return false;
		}
  }
  return true;
}
