 //         
var isChangePortAttr = false; 

var PortType = new Object();
PortType["2"] = "UNI";
PortType["5"] = "C-Aware";
PortType["6"] = "S-Aware";
PortType["255"] = "-";

var PortDisabled = new Object();
PortDisabled["0"] = RESOURCE["disabled"];
PortDisabled["1"] = RESOURCE["enabled"];
PortDisabled["255"] = "-";

var TagIdentifier = new Object();
TagIdentifier["0"] = "Access";
TagIdentifier["1"] = "Tag Aware";
TagIdentifier["2"] = "Hybrid";
TagIdentifier["3"] = "No Tag Aware";

TagIdentifier["255"] = "-";

var win = getParentWindow();

var nmUser = win["nmUser"];

var EPL = 0;
var EVPL = 1;
var MININPUT = 1;
var MAXINPUT = 4094;
var ADD_SERVICE = 0;
var TRANSPARENT_SERVICE = 1;
var TRANSLAT_SERVICE = 2;
var TRANCLAT_SERVICE = 4;
var Bi_TRANSPARENT_SERVICE = 0;
var Bi_TRANSLAT_SERVICE = 1;
var STRIP_SERVICE = 3;
var SIDIRECTION = 0;     
var BIDIRECTION = 1;

var UNI = 2;
var CAWARE = 5;
var SAWARE = 6;
var TBE_BOARD = 1067;


if(win.winobj["boardType"] == TBE_BOARD) 
{
    MAXINPUT =4095;
}
	
/*
 *     
 */
function initCreateTable()
{
    var element = document.createElement("span");
    element.innerHTML = RESOURCE["attrValue"];
    document.getElementById("attrHead").appendChild(element);
    
    element = document.createElement("span");
    element.innerHTML = RESOURCE["workAttr"];
    document.getElementById("workAttrHead").appendChild(element);
    
    element = document.createElement("span");
    element.innerHTML = RESOURCE["protectAttr"];
    document.getElementById("protectAttrHead").appendChild(element);
    
    element = document.createElement("span");
    element.innerHTML = RESOURCE["boardName"];
    document.getElementById("board").appendChild(element);
    
    element = document.createElement("span");
    var boardName = getShowName(win.slotID);
    element.innerHTML = boardName;
    document.getElementById("workBoard").appendChild(element);
    
    element = document.createElement("span");
    element.innerHTML = boardName;
    document.getElementById("protectBoard").appendChild(element);
    
    element = document.createElement("span");
    element.innerHTML = RESOURCE["linkType"];
    document.getElementById("serviceType").appendChild(element);
    
    element = document.createElement("select");    
    element.options[0] = new Option("EPL", 0);     
    element.options[1] = new Option("EVPL(QinQ)", 1);
    document.getElementById("workType").appendChild(element);
    element.onchange = changeServiceType;
    
    element = document.createElement("span");
    element.innerHTML = LinkType[0];
    document.getElementById("protectType").appendChild(element);
    
    element = document.createElement("span");
    element.innerHTML = RESOURCE["linkdirection"];
    document.getElementById("serviceDeriction").appendChild(element);
    
    element = document.createElement("select");    
    element.options[0] = new Option(RESOURCE["sidirectional"], 0);     
    element.options[1] = new Option(RESOURCE["bidirectional"], 1);    
    document.getElementById("workDeriction").appendChild(element);
    element.onchange = changePDeriction;
    
    element = document.createElement("span");    
    element.innerHTML = RESOURCE["sidirectional"];
    document.getElementById("protectDeriction").appendChild(element);
    
    element = document.createElement("span");
    element.innerHTML = RESOURCE["srcport"];
    document.getElementById("source").appendChild(element);
    
    
    var source = document.createElement("select");
    for(var i = 0, len1 = srcPortsOfUse.length; i < len1; i++)
    {
    	source.options[i] = new Option(srcPortsOfUse[i].portName, i);
    }
    document.getElementById("workSource").appendChild(source);
    source["onchange"] = refreshPortTable;
    
    var source = document.createElement("select");
    for(var j = 0, len2 = srcPortsOfUse.length; j < len2; j++)
    {
    	source.options[j] = new Option(srcPortsOfUse[j].portName, j);
    }
    document.getElementById("protectSource").appendChild(source);
    source["onchange"] = refreshPortTable;
    
    element = document.createElement("span");
    element.innerHTML = RESOURCE["srccvlan"];
    document.getElementById("sourceVlanId").appendChild(element);
    
    element = document.createElement("input");
    element.className = "textInput";
    element.setAttribute("type", "text");
    element.style.imeMode = "disabled";
    document.getElementById("workSVlanId").appendChild(element);
    element.style.imeMode = "disabled"
    element["onkeypress"] = isValidateVlanID;
    element["onblur"] = function() { changePVlan(0); };    
    
    element = document.createElement("span");
    document.getElementById("protectSVlanId").appendChild(element);
    
    element = document.createElement("span");
    element.innerHTML = RESOURCE["snkport"];
    document.getElementById("sink").appendChild(element);
    
    var sink = document.createElement("select");
    for(var k = 0, len3 = snkPortsOfUse.length; k < len3; k++)
    {
    	sink.options[k] = new Option(snkPortsOfUse[k].portName, k);
    }
    document.getElementById("workSink").appendChild(sink);
    sink["onchange"] = changePSnkPort;
    
    element = document.createElement("span");
    element.innerHTML = sink.options[0].text;
    document.getElementById("protectSink").appendChild(element);
    
    element = document.createElement("span");
    element.innerHTML = RESOURCE["snkcvlan"];
    document.getElementById("sinkVlanId").appendChild(element);
    
    element = document.createElement("input");
    element.className = "textInput";
    element.setAttribute("type", "text");
    element.style.imeMode = "disabled";
    document.getElementById("workSinkVlanId").appendChild(element);
    element["onkeypress"] = isValidateVlanID;
    element["onblur"] = function() { changePVlan(1); };
    
    element = document.createElement("span");    
    document.getElementById("protectSinkVlanId").appendChild(element);
    
}
/*
 *        
 */
function initPortAttr()
{
    portAttrTable = new SortTable();
    portAttrTable.setImage("../../../../../images/");    
    createTableHead(portAttrTable, window.tableconf[0]);
    portAttrTable.setBodyHeight(100);
    document.getElementById("portAttr").appendChild(portAttrTable.getTable());
}

/*
 *        
 */
function initCreateButton()
{
    document.getElementById("okbtn").value = RESOURCE["okbutton"];	
    document.getElementById("cancelbtn").value = RESOURCE["cancelbutton"];	
    document.getElementById("applybtn").value = RESOURCE["applybutton"];	
}

/*
 *              
 */
function initPortTblInfo()
{
    document.getElementById("portTableName").innerHTML = RESOURCE["portTblName"];
}

/*
 *      
 */ 
function initCreatePage()
{        
    
    getSupportPorts(win.neID, win.slotID);
    
    
    
    initCreateTable();
    
    initPortTblInfo();
    
    initPortAttr();
    
    initCreateButton();
    
    refreshPortTable();
    
}

/*
 *               onclick  
 *                  vlanSNCP
 * @param btnFlag 0        1       
 */
function doCreateSNCP(btnFlag)
{
	if(btnFlag == 1 && document.getElementById("applybtn").disabled)
	{
		xcloseDialog();
		return;
	}	    
    var workSVlanId = $("workSVlanId").firstChild.value;
    var workSinkVlanId = $("workSinkVlanId").firstChild.value;
    var serviceType = $("workType").firstChild.selectedIndex;
    
    if (EPL == serviceType)
    {    	
        if(!isValidateVlan(workSVlanId))
        {
        	alert(RESOURCE["invalidatesrcvlanid"]);
        	return;
        }
        
        if(!isValidateVlan(workSinkVlanId))
        {
        	alert(RESOURCE["invalidatesnkvlan"]);
        	return;
        }
    }
    
    if (EVPL == serviceType)
    {
    	  var srcSVlan = $("workSrcSVlan").firstChild.value;
    	  if (!isValidateSVlan(srcSVlan))
    	  {
    	  	  alert(RESOURCE["invalidatesrcsvlan"]);
    	      return;
    	  }
    	  var snkSVlan = $("workSnkSVlan").firstChild.value;
    	  if (!isValidateSVlan(snkSVlan))
    	  {
    	  	  alert(RESOURCE["invalidatesnksvlan"]);
    	      return;
    	  }
    	  
    	  var element = $("workOperation").firstChild;
        if (ADD_SERVICE == element.options[element.selectedIndex].value
            && "" == workSVlanId)
        {
        	  alert(RESOURCE["inputSrcCVlan"]);
    	      return;
    	  }
        if (TRANSLAT_SERVICE == element.options[element.selectedIndex].value
            && snkSVlan == srcSVlan)
        {
        	  alert(RESOURCE["srcSVlansnk"]);
    	      return;
    	  }
    	  
    }
    
    if(!validateCreateForm())
    {
        
        return;
    }    
    setStatus(true);
    if (EVPL == serviceType)
    {
    	  $("workOperation").firstChild.disabled = true;
    	  $("workSrcSVlan").firstChild.disabled = true;
    	  $("workSnkSVlan").firstChild.disabled = true;
    }
    
    var portArrXml = createPortArrXmlInfo();
    
    var portArrURL = "../../../../../neExlorerServlet?sfid="+TECMDCODE_SET_SDHETHPORTATTRIB+"&nmUser="+win["nmUser"];
    
    if(isChangePortAttr)
    {
	    loadXMLdoc(portArrURL, "POST", false, callbackSetPortArr, btnFlag, "inputdata="+portArrXml);
    }
    else
    {
    	createVLANSNCP(btnFlag);
    }        
}

function isValidateSVlan(vlanID)
{
    if(vlanID == "")
    {
       return false;
    }
    return true;
}

/*
 *            xml
 */
function createPortArrXmlInfo()
{    
	var root = new inputxml("datainterface");
	var business = new tagElement("bussiness-params");
	isChangePortAttr = false;
	for(var i = 0, len = portAttrTable.getDataRowLength(); i < len; i++)
	{
			isChangePortAttr = true;
			var row = new tagElement("row-params");
			
			var param = new tagElement("param");
			param.setAttribute("name", "neID");
			param.setAttribute("value", win.neID);
			row.appendChild(param);
			
			param = new tagElement("param");
			param.setAttribute("name", "slotid");
			param.setAttribute("value", win.slotID);
			row.appendChild(param);
			
			param = new tagElement("param");
			param.setAttribute("name", "port");
			var portno = portAttrTable.getCellStoreValue(i, "portno", "portno");
			param.setAttribute("value", portno);
			row.appendChild(param);
			
			var portTypeFlag = portAttrTable.getCellStoreValue(i, "portTypeFlag", "portTypeFlag");
			
			if("0" == portTypeFlag)
			{
				param = new tagElement("param");
				param.setAttribute("name", "ATTR_ETHOVERSDH_MAC_PE_TYPE")
				param.setAttribute("value", portAttrTable.getCellStoreValue(i, "portType", "portType"));
				row.appendChild(param);
				
				param = new tagElement("param");
				param.setAttribute("name", "ATTR_ETHOVERSDH_MAC_ENABLE");
				param.setAttribute("value", portAttrTable.getCellStoreValue(i, "portDisabled", "portDisabled"));
				row.appendChild(param);
				
				param = new tagElement("param");
				param.setAttribute("name", "ATTR_ETHOVERSDH_MAC_TAG");
				param.setAttribute("value", portAttrTable.getCellStoreValue(i, "tagIdentifier", "tagIdentifier"));
				row.appendChild(param);
			}
			else
			{
				param = new tagElement("param");
				param.setAttribute("name", "ATTR_ETHOVERSDH_VCG_PE_TYPE");
				param.setAttribute("value", portAttrTable.getCellStoreValue(i, "portType", "portType"));
				row.appendChild(param);
				
				param = new tagElement("param");
				param.setAttribute("name", "ATTR_ETHOVERSDH_VCG_TAG");
				param.setAttribute("value", portAttrTable.getCellStoreValue(i, "tagIdentifier", "tagIdentifier"));
				row.appendChild(param);
			}
			
			business.appendChild(row);
			
	}
	
	root.getRoot().appendChild(business);
	
	return root.toString();
}

/*
 *            
 */
function callbackSetPortArr(doc, btnFlag)
{	
	var isSetArr = false;
	
    var datainterface = EncapsulateData(doc);
    if(datainterface.getError().rowErrors[0])
	  {		
			  var size = datainterface.getBErrLength();
			  var errorCodeArr = new Array();
			  for(var i = size -1;i >= 0;i--)
			  {
			  		var temp = datainterface.getError().rowErrors[i];
			    	var tempObj = temp.errorObj;
			    	var errorCode = temp.error.code;
  			    tempObj["slotID"] = win.slotID;
  			    if(!errorCodeArr.contains("" + errorCode + tempObj["port"]))
  			    {
  			    	errorCodeArr.push("" + errorCode + tempObj["port"]);
  			    }
  			    else
  			    {
  			    	datainterface.getError().rowErrors.splice(i,1);
  			    	continue;
  			    }
  			    var portNo = Number(tempObj["port"]);
  			    
  			    if(portNo > 32768)
  			    {
  			    	tempObj["port"] = "VCTRUNK" + (portNo - 32768);
  			    }
  			    else
  			    {
  			    	tempObj["port"] = "PORT" + portNo;
  			    }
			  }
		}		
	  var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "slotID";
    errArr[2] = "boardname";
    errArr[3] = "port";
    openErrPage("../../../../../page/", datainterface.getError(), errArr);
    
	if(0 == datainterface.getSErrorCode())
	{
		isSetArr = true;
	}
    
    
    refreshTableState(portAttrTable,window.tableconf[0],datainterface);
    if(!isSetArr)
    {
        setStatus(false);
        if (EVPL == $("workType").firstChild.selectedIndex)
        {
        	  $("workOperation").firstChild.disabled = false;
        	  $("workSrcSVlan").firstChild.disabled = false;
        	  $("workSnkSVlan").firstChild.disabled = false;
        }
        return;        
    }
    createVLANSNCP(btnFlag);
}

/*
 *   vlansncp  
 */
function createVLANSNCP(btnFlag)
{
    var xmlData = createSNCPCrtXmlInfo();
    
    var createURL = "../../../../../neExlorerServlet?sfid="+TE_IP_VLANSNCP_CREATE+"&nmUser="+win["nmUser"];
    
    loadXMLdoc(createURL, "POST", true, callbackCreate, btnFlag, "inputdata="+xmlData);	
}

/*
 *       SNCP xml   
 */
function createSNCPCrtXmlInfo()
{		
	var wSourVlanIds = splitVlanID($("workSVlanId").firstChild.value);
	
	var wSinkVlanIds = splitVlanID($("workSinkVlanId").firstChild.value);
	
	if(0 == wSourVlanIds.length)
	{
		wSourVlanIds[wSourVlanIds.length] = "" + 0xffff;
		wSinkVlanIds[wSinkVlanIds.length] = "" + 0xffff;
	}
	

	var vlansncpIDs = win.getVlanSNCPIDOfUse(wSourVlanIds.length);	
	
	var direction = $("workDeriction").firstChild.value
	
	
	
	
	var linkIDs = win.getLinkIDsOfUse(wSourVlanIds.length*(parseInt(direction)+1)*2);
	
	
	var root = new inputxml("datainterface");
	var business = new tagElement("bussiness-params");
	
	for(var i = 0, len = wSourVlanIds.length; i < len; i++)
	{
		var row = new tagElement("row-params");	
		
	    var param = new tagElement("param");
	 	param.setAttribute("name", "neID");
	 	param.setAttribute("value", win.neID);
	 	row.appendChild(param);
	 	
	 	param = new tagElement("param");
	 	param.setAttribute("name", "slotID");
	 	param.setAttribute("value", win.slotID);
	 	row.appendChild(param);
	 	
	 	param = new tagElement("param");
	 	param.setAttribute("name", "vlansncpID");
	 	param.setAttribute("value", vlansncpIDs[i]);
	 	row.appendChild(param);
	 	
	 	param = new tagElement("param");
	 	param.setAttribute("name", "direction");
	 	param.setAttribute("value", direction);
	 	row.appendChild(param);
	 	
	 	var wLinkIDs = linkIDs.slice(i*2*(parseInt(direction)+1), (i*2 + 1)*(parseInt(direction)+1)).toString();
	 	param = new tagElement("param");
	 	param.setAttribute("name", "workLinkID");
	 	param.setAttribute("value", wLinkIDs);
	 	row.appendChild(param);
	 	
	 	var pLinkIDs = linkIDs.slice((i*2 + 1)*(parseInt(direction)+1) , (i+1)*(parseInt(direction)+1)*2).toString();
	 	param = new tagElement("param");
	 	param.setAttribute("name", "protectLinkID");
	 	param.setAttribute("value", pLinkIDs);
	 	row.appendChild(param);
	 	
	 	param = new tagElement("param");
	 	param.setAttribute("name", "workSrcPort");
	 	var element = $("workSource").firstChild;
	 	var workSrcPort = element.options[element.selectedIndex].value;
	 	workSrcPort = srcPortsOfUse[workSrcPort].portno;
	 	param.setAttribute("value", workSrcPort);
	 	row.appendChild(param);
	 	
	 	param = new tagElement("param");
	 	param.setAttribute("name", "protectSrcPort");
	 	var element = $("protectSource").firstChild;
	 	var protectSrcPort = element.options[element.selectedIndex].value;
	 	protectSrcPort = srcPortsOfUse[protectSrcPort].portno;
	 	param.setAttribute("value", protectSrcPort);
	 	row.appendChild(param);
	 	
	 	param = new tagElement("param");
	 	param.setAttribute("name", "workSrcVlan");
	 	param.setAttribute("value", wSourVlanIds[i]);
	 	row.appendChild(param);
	 	
	 	param = new tagElement("param");
	 	param.setAttribute("name", "protectSrcVlan");
	 	param.setAttribute("value", wSourVlanIds[i]);
	 	row.appendChild(param);
	 	
	 	param = new tagElement("param");
	 	param.setAttribute("name", "workSnkPort");
	 	var element = $("workSink").firstChild;
	 	var workSnkPort = element.options[element.selectedIndex].value;
	 	workSnkPort = snkPortsOfUse[workSnkPort].portno
	 	param.setAttribute("value", workSnkPort);
	 	row.appendChild(param);
	 	
	 	param = new tagElement("param");
	 	param.setAttribute("name", "protectSnkPort");
	 	param.setAttribute("value", workSnkPort);
	 	row.appendChild(param);
	 	
 		param = new tagElement("param");
 		param.setAttribute("name", "workSnkVlan");
 		param.setAttribute("value", wSinkVlanIds[i]);
 		row.appendChild(param);
 		
 		param = new tagElement("param");
	 	param.setAttribute("name", "protectSnkVlan");
	 	param.setAttribute("value", wSinkVlanIds[i]);
	 	row.appendChild(param);
	 	
	 	var ipLong = convertIPStrToLong("192.168.0.1");
	 	param = new tagElement("param");
	 	param.setAttribute("name", "sncpIndentifier");
	 	param.setAttribute("value", ipLong);
	 	row.appendChild(param);
	 	
	 	var element = $("workType").firstChild;
	 	var serviceType = element.options[element.selectedIndex].value;
	 	param = new tagElement("param");
	 	param.setAttribute("name", "serviceType");
		param.setAttribute("value", serviceType);
	 	row.appendChild(param);
	 	
	 	if (EVPL == serviceType)
	 	{
	 		element = $("workOperation").firstChild;
	 		var operationType = element.options[element.selectedIndex].value;	 		
	 		param = new tagElement("param");
	 		param.setAttribute("name", "operationType");
		 	param.setAttribute("value", operationType);
	 		row.appendChild(param);
	 		
	 		param = new tagElement("param");
	 		param.setAttribute("name", "srcSVlan");
		 	param.setAttribute("value", $("workSrcSVlan").firstChild.value);
	 		row.appendChild(param);
	 		
	 		param = new tagElement("param");
	 		param.setAttribute("name", "snkSVlan");
		 	param.setAttribute("value", $("workSnkSVlan").firstChild.value);
	 		row.appendChild(param);
	 	}
	 	
	 	business.appendChild(row);
	}
	
 	root.getRoot().appendChild(business);
 	
 	return root.toString(); 	
}

/*
 *   VLAN SNCP         
 */
function callbackCreate(doc, btnFlag)
{ 
    var datainterface = EncapsulateData(doc);
    if(datainterface.getError().rowErrors[0] && (0 != datainterface.getSErrorCode()))
	  {
		  var neName = datainterface.getDataRowParam(0,"neName");
			var size = datainterface.getBErrLength();
			for(var i = 0;i < size;i++)
			{
				var tempObj = datainterface.getError().rowErrors[i].errorObj;
  			tempObj["neName"] = neName + "-" + win.slotID + "-" + portData.getDataRowParam(0,"boardName")
			}
		}
	var errArr = [];
  errArr[0] = "neName";
  openErrPage("../../../../../page/", datainterface.getError(), errArr);//????????
    
    
    
    setStatus(false);
    var element = $("workType").firstChild;
	 	var serviceType = element.options[element.selectedIndex].value;
    if(EVPL == serviceType)
    {        
        element = $("workOperation").firstChild;
	    	var operatType = element.options[element.selectedIndex].value;
	    	
        $("workOperation").firstChild.disabled = false;
        $("workSrcSVlan").firstChild.disabled = false;
        $("workSnkSVlan").firstChild.disabled = false;
        
        if (TRANSPARENT_SERVICE == operatType || TRANSLAT_SERVICE == operatType)
        {
        	  $("workSVlanId").firstChild.disabled = true;
    	      $("workSinkVlanId").firstChild.disabled = true;
        }	      	  
    }
    if(2 != datainterface.getSErrorCode())
    {
        document.getElementById("applybtn").disabled = true;
        win.doQuery();
    }
    
    if( (1 == btnFlag ) && ( 0 == datainterface.getSErrorCode()))
    {
    	xcloseDialog();
    }
    return;
}

/*
   :
         
*/
function showErrorDialog(data)
{
    if(data.getError().rowErrors[0] && (0 != data.getSErrorCode()))
	  {
		  var neName = data.getDataRowParam(0,"neName");

			var size = data.getBErrLength();
			for(var i = 0;i < size;i++)
			{
				var tempObj = data.getError().rowErrors[i].errorObj;
  			tempObj["neName"] = neName + "-" + win.slotID + "-" + portData.getDataRowParam(0,"boardName")
			}
		}
	var errArr = [];
  errArr[0] = "neName";
  openErrPage("../../../../../page/", data.getError(), errArr);
}

/*
 *                       
 */
function changePDeriction()
{
    
    $("applybtn").disabled = false;
    var targetElm = getEventSrc();
    document.getElementById("protectDeriction").firstChild.innerHTML = targetElm.options[targetElm.selectedIndex].text;
    
    var serviceType = $("workType").firstChild.selectedIndex;
    if (EVPL == serviceType)
    {
    	  var element = $("workOperation").firstChild;
    	  element.options.length = 0;
    	      	  
    	  if (SIDIRECTION == targetElm.selectedIndex)
    	  {    
    	    if(win.winobj["boardType"] == TBE_BOARD)
            {
	            element.options[0] = new Option(RESOURCE["AddSVLAN"], 0);   
	            element.options[1] = new Option(RESOURCE["TransparentlyTransmitSVLAN"], 1);    
	            element.options[2] = new Option(RESOURCE["TransparentlyTransmitCVLAN"], 4);   
	            element.options[3] = new Option(RESOURCE["TranslateSVLAN"], 2);
	            element.options[4] = new Option(RESOURCE["StripSVLAN"], 3); 
            }
            else
            {
	            element.options[0] = new Option(RESOURCE["AddSVLAN"], 0);   
	            element.options[1] = new Option(RESOURCE["TransparentlyTransmitSVLAN"], 1);     
	            element.options[2] = new Option(RESOURCE["TranslateSVLAN"], 2);
	            element.options[3] = new Option(RESOURCE["StripSVLAN"], 3);
            }
            
            $("protectOperation").firstChild.innerHTML = element.options[0].text; 
    	      
    	      if(win.winobj["boardType"] == TBE_BOARD)
            {
                $("workSVlanId").firstChild.disabled = false;
		        	  $("workSVlanId").firstChild.value = "";
		        	  $("protectSVlanId").firstChild.innerHTML = "";
		        	    
		        	  $("workSinkVlanId").firstChild.disabled = false;
		        	  $("workSinkVlanId").firstChild.value = "";
		        	  $("protectSinkVlanId").firstChild.innerHTML = "";
		        	    
            	  checkDataCellEvent($("workSVlanId").firstChild,MININPUT,MAXINPUT);
            	  checkDataCellEvent($("workSinkVlanId").firstChild,MININPUT,MAXINPUT);
            }
            
	          $("workSrcSVlan").firstChild.disabled = true;
	          $("workSrcSVlan").firstChild.value = "-";
	          $("protectSrcSVlan").firstChild.innerHTML = "-";
	          
	          $("workSnkSVlan").firstChild.disabled = false;
	          $("workSnkSVlan").firstChild.value = "";
	          $("protectSnkSVlan").firstChild.innerHTML = "";
	          		       	
            var wsnpElement = $("workSink").firstChild;
            var workSnkPort = wsnpElement.options[wsnpElement.selectedIndex].value;
            var snkPortNO = srcPortsOfUse[workSnkPort].portno;
            
            for(var i = 0, len = portAttrTable.getDataRowLength(); i < len; i++)
	          {
	          	  if (snkPortNO == portAttrTable.getCellStoreValue(i, "portno", "portno"))
	          	  {
	          	  	  cell = portAttrTable.getCell(i,"portType");
	          	  	  portAttrTable.setCellValue(cell,"portType",SAWARE);
                    portAttrTable.setAtomValue(cell.element.showElement,"S-Aware");
	          	  }
	          	  else
	          	  {
	          	  	  cell = portAttrTable.getCell(i,"portType");
	          	  	  portAttrTable.setCellValue(cell,"portType",CAWARE);
                    portAttrTable.setAtomValue(cell.element.showElement,"C-Aware");
	          	  }
	          } 
        } 
        else
        {     
            if(win.winobj["boardType"] == TBE_BOARD)
            {
	            element.options[0] = new Option(RESOURCE["TransparentlyTransmitSVLAN"], 1);   
	            element.options[1] = new Option(RESOURCE["TransparentlyTransmitCVLAN"], 4); 
	            element.options[2] = new Option(RESOURCE["TranslateSVLAN"], 2);  
            }
            else
            {
	            element.options[0] = new Option(RESOURCE["TransparentlyTransmitSVLAN"], 1);   
	            element.options[1] = new Option(RESOURCE["TranslateSVLAN"], 2);  
            }
            
            $("protectOperation").firstChild.innerHTML = element.options[0].text; 
    	      
    	      if(win.winobj["boardType"] == TBE_BOARD)
            {
                $("workSVlanId").firstChild.disabled = true;
		$("workSVlanId").firstChild.value = "-";
		$("protectSVlanId").firstChild.innerHTML = "-";
		        	    
		     	  $("workSinkVlanId").firstChild.disabled = true;
		        	  $("workSinkVlanId").firstChild.value = "-";
		        	  $("protectSinkVlanId").firstChild.innerHTML = "-";
		        	    
            	  checkDataCellEvent($("workSVlanId").firstChild,MININPUT,MAXINPUT);
            	  checkDataCellEvent($("workSinkVlanId").firstChild,MININPUT,MAXINPUT);
            }
            
	          $("workSrcSVlan").firstChild.disabled = false;
	          $("workSrcSVlan").firstChild.value = "";
	          $("protectSrcSVlan").firstChild.innerHTML = "";
	          
	          $("workSnkSVlan").firstChild.disabled = false;
	          $("workSnkSVlan").firstChild.value = "";
	          $("protectSnkSVlan").firstChild.innerHTML = "";
	          		       	
            var wsnpElement = $("workSink").firstChild;
            var workSnkPort = wsnpElement.options[wsnpElement.selectedIndex].value;
            var snkPortNO = srcPortsOfUse[workSnkPort].portno;
            
            for(var i = 0, len = portAttrTable.getDataRowLength(); i < len; i++)
	          {
	          	  if (snkPortNO == portAttrTable.getCellStoreValue(i, "portno", "portno"))
	          	  {
	          	  	  cell = portAttrTable.getCell(i,"portType");
	          	  	  portAttrTable.setCellValue(cell,"portType",SAWARE);
                    portAttrTable.setAtomValue(cell.element.showElement,"S-Aware");
	          	  }
	          	  else
	          	  {
	          	  	  cell = portAttrTable.getCell(i,"portType");
	          	  	  portAttrTable.setCellValue(cell,"portType",SAWARE);
                    portAttrTable.setAtomValue(cell.element.showElement,"S-Aware");
	          	  }
	          }        	
        }
    }	 
}

/*
 *                     
 */
function changePSnkPort()
{  
    $("applybtn").disabled = false;
    var targetElm = getEventSrc();
    
    document.getElementById("protectSink").firstChild.innerHTML = targetElm.options[targetElm.selectedIndex].text;
    
    refreshPortTable();
}

/*
 *       
 */
function changeServiceType()
{        
    var childIndex = 0;
    for (var i = 0, len = $("table").childNodes.length; i < len; i++)
    {
    	  if ("TBODY" == $("table").childNodes[i].tagName)
    	  {
    	  	  childIndex = i;
    	  }
    }
    
	  $("applybtn").disabled = false;
    var selectedIndex = this.selectedIndex;
    $("protectType").firstChild.innerHTML = this.options[selectedIndex].text;
    
    if (EPL == selectedIndex)
    {
    	  window.dialogHeight="480px";
    	  $("table").childNodes[childIndex].removeChild($("operationTypeRow"));
    	  $("table").childNodes[childIndex].removeChild($("srcSVlanRow"));
    	  $("table").childNodes[childIndex].removeChild($("snkSVlanRow"));
    	     	  
        $("workDeriction").firstChild.value = SIDIRECTION;
        $("protectDeriction").firstChild.innerHTML = RESOURCE["sidirectional"];
    	  
    	  $("workSVlanId").firstChild.disabled = false;
    	  $("workSVlanId").firstChild.value = "";
    	  $("protectSVlanId").firstChild.innerHTML = "";
    	  
    	  $("workSinkVlanId").firstChild.disabled = false;
    	  $("workSinkVlanId").firstChild.value = "";
    	  $("protectSinkVlanId").firstChild.innerHTML = "";
    	       	
    	 /* for(var i = 0, len = portAttrTable.getDataRowLength(); i < len; i++)
	      {
	     	    var cell = portAttrTable.getCell(i,"portType");
            portAttrTable.setCellValue(cell,"portType",UNI);
            portAttrTable.setAtomValue(cell.element.showElement,"UNI");
	      }*/
	      refreshPortTable()
	      setTagCellEdit();         	
    }
    else
    {
    	  window.dialogHeight="560px";
        $("workDeriction").firstChild.value = SIDIRECTION;
        $("protectDeriction").firstChild.innerHTML = RESOURCE["sidirectional"];
    	  
    	  var tr = document.createElement("tr");
		    tr.setAttribute("id", "operationTypeRow");
    	  
		    var td1 = document.createElement("td");
		    td1.setAttribute("id", "operationType");
        element = document.createElement("span");
        element.innerHTML = RESOURCE["operationType"];
        td1.appendChild(element);
		    
		    var td2 = document.createElement("td");
		    td2.setAttribute("id", "workOperation");
        element = document.createElement("select");
        if(win.winobj["boardType"] == TBE_BOARD)
    	{
	        element.options[0] = new Option(RESOURCE["AddSVLAN"], 0);    
	        element.options[1] = new Option(RESOURCE["TransparentlyTransmitSVLAN"], 1);   
	        element.options[2] = new Option(RESOURCE["TransparentlyTransmitCVLAN"], 4);   
	        element.options[3] = new Option(RESOURCE["TranslateSVLAN"], 2);    
	        element.options[4] = new Option(RESOURCE["StripSVLAN"], 3);
        }
        else
        {
	        element.options[0] = new Option(RESOURCE["AddSVLAN"], 0);    
	        element.options[1] = new Option(RESOURCE["TransparentlyTransmitSVLAN"], 1);   
	        element.options[2] = new Option(RESOURCE["TranslateSVLAN"], 2);    
	        element.options[3] = new Option(RESOURCE["StripSVLAN"], 3);
        }
        element.onchange = changeOperationType;
        td2.appendChild(element);
        
		    var td3 = document.createElement("td");
		    td3.setAttribute("id", "protectOperation");
        element = document.createElement("span");
        element.innerHTML = RESOURCE["AddSVLAN"];
        td3.appendChild(element); 
        
		    tr.appendChild(td1);
		    tr.appendChild(td2);
		    tr.appendChild(td3);
		    
		    $("table").childNodes[childIndex].insertBefore(tr, $("srcPort"));
    	  
    	  var tr = document.createElement("tr");
    	  tr.setAttribute("id", "srcSVlanRow");
    	  
		    var td1 = document.createElement("td");
		    td1.setAttribute("id", "srcSVlan");
        element = document.createElement("span");
        element.innerHTML = RESOURCE["sourceS-VLAN"];
        td1.appendChild(element);
		    
		    var td2 = document.createElement("td");
		    td2.setAttribute("id", "workSrcSVlan");
        element = document.createElement("input");
        element.className = "textInput";
        element.setAttribute("type", "text");
        element.style.imeMode = "disabled";
        element.value = "-";
        element.disabled = true;
        checkDataCellEvent(element,MININPUT,MAXINPUT);
        element["onblur"]=changeSrcSVlan;
        td2.appendChild(element);     
        
		    var td3 = document.createElement("td");
		    td3.setAttribute("id", "protectSrcSVlan");
        element = document.createElement("span");
        td3.appendChild(element); 
        
		    tr.appendChild(td1);
		    tr.appendChild(td2);
		    tr.appendChild(td3);
		    
		    $("table").childNodes[childIndex].insertBefore(tr, $("snkPort"));
		    
    	  var tr = document.createElement("tr");
    	  tr.setAttribute("id", "snkSVlanRow");
    	  
		    var td1 = document.createElement("td");
		    td1.setAttribute("id", "svlan");
        element = document.createElement("span");
        element.innerHTML = RESOURCE["snkS-VLAN"];
        td1.appendChild(element);
		    
		    var td2 = document.createElement("td");
		    td2.setAttribute("id", "workSnkSVlan");
        element = document.createElement("input");
        element.className = "textInput";
        element.setAttribute("type", "text");
        checkDataCellEvent(element,MININPUT,MAXINPUT);
        element["onblur"]=changeSnkSVlan;
        td2.appendChild(element);     
        
		    var td3 = document.createElement("td");
		    td3.setAttribute("id", "protectSnkSVlan");
        element = document.createElement("span");
        td3.appendChild(element); 
        
		    tr.appendChild(td1);
		    tr.appendChild(td2);
		    tr.appendChild(td3);
		    
		    $("table").childNodes[childIndex].appendChild(tr);		  		  
		    
    	  if(win.winobj["boardType"] == TBE_BOARD && $("workOperation").firstChild.selectedIndex == 0)
    	  {
    	  	checkDataCellEvent($("workSVlanId").firstChild,MININPUT,MAXINPUT);
    	  	checkDataCellEvent($("workSinkVlanId").firstChild,MININPUT,MAXINPUT);
    	  }
    	  else
    	  {
		    	  $("workSVlanId").firstChild.disabled = true;
		    	  $("workSVlanId").firstChild.value = "-";
		    	  $("protectSVlanId").firstChild.innerHTML = "-";
		    	  
		    	  $("workSinkVlanId").firstChild.disabled = true;
		    	  $("workSinkVlanId").firstChild.value = "-";
		    	  $("protectSinkVlanId").firstChild.innerHTML = "-";
    	  } 	      	  
    	       	
        var wsnpElement = $("workSink").firstChild;
        var workSnkPort = wsnpElement.options[wsnpElement.selectedIndex].value;
        var snkPortNO = srcPortsOfUse[workSnkPort].portno;
        
    	  for(var i = 0, len = portAttrTable.getDataRowLength(); i < len; i++)
	      {
	      	  if (snkPortNO == portAttrTable.getCellStoreValue(i, "portno", "portno"))
	      	  {
	      	  	  cell = portAttrTable.getCell(i,"portType");
	      	  	  portAttrTable.setCellValue(cell,"portType",SAWARE);
                portAttrTable.setAtomValue(cell.element.showElement,"S-Aware");
	      	  }
	      	  else
	      	  {
	      	  	  cell = portAttrTable.getCell(i,"portType");
	      	  	  portAttrTable.setCellValue(cell,"portType",CAWARE);
                portAttrTable.setAtomValue(cell.element.showElement,"C-Aware");
	      	  }
	      } 
	      controlPortType();
	      setTagCellEdit(); 
    }   
}       
        
function changeOperationType()
{
	  $("applybtn").disabled = false;
    var operationType = this.options[this.selectedIndex].value;
    document.getElementById("protectOperation").firstChild.innerHTML = this.options[this.selectedIndex].text;
    var workDerictionElement = $("workDeriction").firstChild;
    var workDerictionValue = workDerictionElement.options[workDerictionElement.selectedIndex].value;
    if(workDerictionValue == 0)
    {
        if (ADD_SERVICE == operationType)
        {       	
        		if(win.winobj["boardType"] == TBE_BOARD)
        	  {
        	      $("workSVlanId").firstChild.disabled = false;
		        	  $("workSVlanId").firstChild.value = "";
		        	  $("protectSVlanId").firstChild.innerHTML = "";
		        	    
		        	  $("workSinkVlanId").firstChild.disabled = false;
		        	  $("workSinkVlanId").firstChild.value = "";
		        	  $("protectSinkVlanId").firstChild.innerHTML = "";
		        	    
        	  	  checkDataCellEvent($("workSVlanId").firstChild,MININPUT,MAXINPUT);
        	  	  checkDataCellEvent($("workSinkVlanId").firstChild,MININPUT,MAXINPUT);
        	  }
        	  else
        	  {
		        	  $("workSVlanId").firstChild.disabled = true;
		        	  $("workSVlanId").firstChild.value = "-";
		        	  $("protectSVlanId").firstChild.innerHTML = "-";
		        	  
		        	  $("workSinkVlanId").firstChild.disabled = true;
		        	  $("workSinkVlanId").firstChild.value = "-";
		        	  $("protectSinkVlanId").firstChild.innerHTML = "-";
        	  }
        	  
	        	$("workSrcSVlan").firstChild.disabled = true;
	        	$("workSrcSVlan").firstChild.value = "-";
	        	$("protectSrcSVlan").firstChild.innerHTML = "-";
	        	
	        	$("workSnkSVlan").firstChild.disabled = false;
	        	$("workSnkSVlan").firstChild.value = "";
	          $("protectSnkSVlan").firstChild.innerHTML = "";
	          		       	
            var wsnpElement = $("workSink").firstChild;
            var workSnkPort = wsnpElement.options[wsnpElement.selectedIndex].value;
            var snkPortNO = srcPortsOfUse[workSnkPort].portno;
            
        	  for(var i = 0, len = portAttrTable.getDataRowLength(); i < len; i++)
	          {
	          	  if (snkPortNO == portAttrTable.getCellStoreValue(i, "portno", "portno"))
	          	  {
	          	  	  cell = portAttrTable.getCell(i,"portType");
	          	  	  portAttrTable.setCellValue(cell,"portType",SAWARE);
                    portAttrTable.setAtomValue(cell.element.showElement,"S-Aware");
	          	  }
	          	  else
	          	  {
	          	  	  cell = portAttrTable.getCell(i,"portType");
	          	  	  portAttrTable.setCellValue(cell,"portType",CAWARE);
                    portAttrTable.setAtomValue(cell.element.showElement,"C-Aware");
	          	  }
	          }  
        }
        else if (TRANSPARENT_SERVICE == operationType || TRANSLAT_SERVICE == operationType)
        {
        	  if(win.winobj["boardType"] == TBE_BOARD)
        	  {
        	  		$("workSVlanId").firstChild.disabled = true;
		        	  $("workSVlanId").firstChild.value = "-";
		        	  $("protectSVlanId").firstChild.innerHTML = "-";
		        	  
		        	  $("workSinkVlanId").firstChild.disabled = true;
		        	  $("workSinkVlanId").firstChild.value = "-";
		        	  $("protectSinkVlanId").firstChild.innerHTML = "-";
        	  }
        	  $("workSrcSVlan").firstChild.disabled = false;
        	  $("workSrcSVlan").firstChild.value = "";
        	  $("protectSrcSVlan").firstChild.innerHTML = "";
        	
        	  $("workSnkSVlan").firstChild.disabled = false;
        	  $("workSnkSVlan").firstChild.value = "";
          	$("protectSnkSVlan").firstChild.innerHTML = ""; 
          	
        	  for(var i = 0, len = portAttrTable.getDataRowLength(); i < len; i++)
	          {	      	  
	          	  cell = portAttrTable.getCell(i,"portType");
	          	  portAttrTable.setCellValue(cell,"portType",SAWARE);
                portAttrTable.setAtomValue(cell.element.showElement,"S-Aware");	      	  
	          }  
        }
        else if(TRANCLAT_SERVICE == operationType)
        {
            $("workSVlanId").firstChild.disabled = false;
            $("workSVlanId").firstChild.value = "";
            $("protectSVlanId").firstChild.innerHTML = "";
		        	    
	    $("workSinkVlanId").firstChild.disabled = false;
	    $("workSinkVlanId").firstChild.value = "";
	    $("protectSinkVlanId").firstChild.innerHTML = "";
	    
	    checkDataCellEvent($("workSVlanId").firstChild,MININPUT,MAXINPUT);
            checkDataCellEvent($("workSinkVlanId").firstChild,MININPUT,MAXINPUT);
            
            $("workSrcSVlan").firstChild.disabled = true;
	    $("workSrcSVlan").firstChild.value = "-";
	    $("protectSrcSVlan").firstChild.innerHTML = "-";
	       	
	    $("workSnkSVlan").firstChild.disabled = true;
	    $("workSnkSVlan").firstChild.value = "-";
	    $("protectSnkSVlan").firstChild.innerHTML = "-";
            
            for(var i = 0, len = portAttrTable.getDataRowLength(); i < len; i++)
	    {	      	  
	        cell = portAttrTable.getCell(i,"portType");
	        portAttrTable.setCellValue(cell,"portType",SAWARE);
                portAttrTable.setAtomValue(cell.element.showElement,"C-Aware");	      	  
	    }  
        }
        else
        {
        	  $("workSVlanId").firstChild.disabled = false;
		        $("workSVlanId").firstChild.value = "";
		        $("protectSVlanId").firstChild.innerHTML = "";
		          
		        $("workSinkVlanId").firstChild.disabled = false;
		        $("workSinkVlanId").firstChild.value = "";
		        $("protectSinkVlanId").firstChild.innerHTML = "";
		          
        	  checkDataCellEvent($("workSVlanId").firstChild,MININPUT,MAXINPUT);
        	  checkDataCellEvent($("workSinkVlanId").firstChild,MININPUT,MAXINPUT);
        	
        	  $("workSrcSVlan").firstChild.disabled = false;
        	  $("workSrcSVlan").firstChild.value = "";
        	  $("protectSrcSVlan").firstChild.innerHTML = "";
        	
        	  $("workSnkSVlan").firstChild.disabled = true;
        	  $("workSnkSVlan").firstChild.value = "-";
          	$("protectSnkSVlan").firstChild.innerHTML = "-";     	      	  
        	       	
            var wsnpElement = $("workSink").firstChild;
            var workSnkPort = wsnpElement.options[wsnpElement.selectedIndex].value;
            var snkPortNO = srcPortsOfUse[workSnkPort].portno;
            
        	  for(var i = 0, len = portAttrTable.getDataRowLength(); i < len; i++)
	          {
	          	  if (snkPortNO == portAttrTable.getCellStoreValue(i, "portno", "portno"))
	          	  {
	          	  	  cell = portAttrTable.getCell(i,"portType");
	          	  	  portAttrTable.setCellValue(cell,"portType",CAWARE);
                    portAttrTable.setAtomValue(cell.element.showElement,"C-Aware");
	          	  }
	          	  else
	          	  {
	          	  	  cell = portAttrTable.getCell(i,"portType");
	          	  	  portAttrTable.setCellValue(cell,"portType",SAWARE);
                    portAttrTable.setAtomValue(cell.element.showElement,"S-Aware");
	          	  }
	          }  
        }
   }
   else
   {
        if (TRANSPARENT_SERVICE == operationType || TRANSLAT_SERVICE == operationType)
        {
        	  if(win.winobj["boardType"] == TBE_BOARD)
        	  {
        	  		$("workSVlanId").firstChild.disabled = true;
		        	  $("workSVlanId").firstChild.value = "-";
		        	  $("protectSVlanId").firstChild.innerHTML = "-";
		        	  
		        	  $("workSinkVlanId").firstChild.disabled = true;
		        	  $("workSinkVlanId").firstChild.value = "-";
		        	  $("protectSinkVlanId").firstChild.innerHTML = "-";
        	  }
        	  
        	  $("workSrcSVlan").firstChild.disabled = false;
        	  $("workSrcSVlan").firstChild.value = "";
        	  $("protectSrcSVlan").firstChild.innerHTML = "";
        	
        	  $("workSnkSVlan").firstChild.disabled = false;
        	  $("workSnkSVlan").firstChild.value = "";
          	$("protectSnkSVlan").firstChild.innerHTML = ""; 
          	
        	  for(var i = 0, len = portAttrTable.getDataRowLength(); i < len; i++)
	          {	      	  
	          	  cell = portAttrTable.getCell(i,"portType");
	          	  portAttrTable.setCellValue(cell,"portType",SAWARE);
                portAttrTable.setAtomValue(cell.element.showElement,"S-Aware");	      	  
	          }  
        }
        else if(TRANCLAT_SERVICE == operationType)
        {
            $("workSVlanId").firstChild.disabled = false;
            $("workSVlanId").firstChild.value = "";
            $("protectSVlanId").firstChild.innerHTML = "";
		        	    
	    $("workSinkVlanId").firstChild.disabled = false;
	    $("workSinkVlanId").firstChild.value = "";
	    $("protectSinkVlanId").firstChild.innerHTML = "";
	    
	    checkDataCellEvent($("workSVlanId").firstChild,MININPUT,MAXINPUT);
            checkDataCellEvent($("workSinkVlanId").firstChild,MININPUT,MAXINPUT);
            
            $("workSrcSVlan").firstChild.disabled = true;
	    $("workSrcSVlan").firstChild.value = "-";
	    $("protectSrcSVlan").firstChild.innerHTML = "-";
	       	
	    $("workSnkSVlan").firstChild.disabled = true;
	    $("workSnkSVlan").firstChild.value = "-";
	    $("protectSnkSVlan").firstChild.innerHTML = "-";
            
            for(var i = 0, len = portAttrTable.getDataRowLength(); i < len; i++)
	    {	      	  
	        cell = portAttrTable.getCell(i,"portType");
	        portAttrTable.setCellValue(cell,"portType",SAWARE);
                portAttrTable.setAtomValue(cell.element.showElement,"C-Aware");	      	  
	    }  
        }
        else
        {      	
        		if(win.winobj["boardType"] == TBE_BOARD)
        	  {
        	      $("workSVlanId").firstChild.disabled = false;
		        	  $("workSVlanId").firstChild.value = "";
		        	  $("protectSVlanId").firstChild.innerHTML = "";
		        	    
		        	  $("workSinkVlanId").firstChild.disabled = false;
		        	  $("workSinkVlanId").firstChild.value = "";
		        	  $("protectSinkVlanId").firstChild.innerHTML = "";
		        	    
        	  	  checkDataCellEvent($("workSVlanId").firstChild,MININPUT,MAXINPUT);
        	  	  checkDataCellEvent($("workSinkVlanId").firstChild,MININPUT,MAXINPUT);
        	  }
        	  
        	  $("workSrcSVlan").firstChild.disabled = true;
        	  $("workSrcSVlan").firstChild.value = "-";
        	  $("protectSrcSVlan").firstChild.innerHTML = "-";
        	
        	  $("workSnkSVlan").firstChild.disabled = false;
        	  $("workSnkSVlan").firstChild.value = "";
          	$("protectSnkSVlan").firstChild.innerHTML = "";  	      	  
        	       	
            var wsnpElement = $("workSink").firstChild;
            var workSnkPort = wsnpElement.options[wsnpElement.selectedIndex].value;
            var snkPortNO = srcPortsOfUse[workSnkPort].portno;
            
        	  for(var i = 0, len = portAttrTable.getDataRowLength(); i < len; i++)
	          {
	          	  if (snkPortNO == portAttrTable.getCellStoreValue(i, "portno", "portno"))
	          	  {
	          	  	  cell = portAttrTable.getCell(i,"portType");
	          	  	  portAttrTable.setCellValue(cell,"portType",SAWARE);
                    portAttrTable.setAtomValue(cell.element.showElement,"S-Aware");
	          	  }
	          	  else
	          	  {
	          	  	  cell = portAttrTable.getCell(i,"portType");
	          	  	  portAttrTable.setCellValue(cell,"portType",CAWARE);
                    portAttrTable.setAtomValue(cell.element.showElement,"C-Aware");
	          	  }
	          }  
        }
   }
}

function changeSrcSVlan()
{
	  $("applybtn").disabled = false;
    var svlan = this.value;
    $("protectSrcSVlan").firstChild.innerHTML = svlan;
    
    var element = $("workOperation").firstChild;
    if (TRANSPARENT_SERVICE == element.options[element.selectedIndex].value)
    {
    	$("workSnkSVlan").firstChild.value = svlan;
    	$("protectSnkSVlan").firstChild.innerHTML = svlan;
    }
}

function changeSnkSVlan()
{
	  $("applybtn").disabled = false;
    var svlan = this.value;
    $("protectSnkSVlan").firstChild.innerHTML = svlan;
    
    var element = $("workOperation").firstChild;
    if (TRANSPARENT_SERVICE == element.options[element.selectedIndex].value)
    {
    	$("workSrcSVlan").firstChild.value = svlan;
    	$("protectSrcSVlan").firstChild.innerHTML = svlan;
    }
}

/*
 *        VLan       VLAN
 * isSrcVlan 0    1   
 */
function changePVlan(isSrcVlan)
{
	$("applybtn").disabled = false;
    var targetElm = getEventSrc();
    
    if(!isSrcVlan)
    {        
        $("workSinkVlanId").firstChild.value = targetElm.value;
    }
    else
    {    	
        $("workSVlanId").firstChild.value = targetElm.value;
    }
    document.getElementById("protectSVlanId").firstChild.innerHTML = targetElm.value;
    document.getElementById("protectSinkVlanId").firstChild.innerHTML = targetElm.value;
}

/*
 *         
 */
function getEventSrc()
{
    var e = window.event;
    
    var targetElm = (e.target) ? e.target : e.srcElement;
    
    return targetElm;
}

/*
 *      SNCP          
 */
function setStatus(state)
{
	$("workDeriction").firstChild.disabled = state;
	
	$("workSource").firstChild.disabled = state;
	
	$("protectSource").firstChild.disabled = state;
	
	$("workSVlanId").firstChild.disabled = state;
	
	$("workSink").firstChild.disabled = state;
	
	$("workSinkVlanId").firstChild.disabled = state;
	
	$("okbtn").disabled = state;
	
	$("applybtn").disabled = state;
	
}
/*
 *      vlanid    
 */
function isValidateVlanID()
{				
	var key,keychar;	
    var key=(event.keyCode!=0?event.keyCode:event.charCode);
    
    keychar = convertChar(key);
    
    if((key == null) || (key == 0) || (key == 9) || (key == 13) || (key == 27))
    { 
        return true;
    }
    else if(isValidateInput(key))
    {
        return true;
    }
    else if((isValidateChar(key))&& restrictVlanID(this, keychar))
    {    	
        return true;
    }
    else
    {
        return false;
    }
}

/*
 * 
 */
function isValidateInput(code)
{	
        
    if(code > 34 && code < 41)
    {
        return true;        //   ,home,end
    }

    if(event.shiftKey || event.ctrlKey)
    {
        return false;
    }
    if(code < 48 || code > 57 )
    {
    	
        return false;  //   
    }
}

/*
 *       "0123456789,-"
 */
function isValidateChar(code)
{
	 if( (47 < code && 58 > code ) || (44 == code) || (45 == code) )
	 {
    	
        return true;  //  
     }
     if(code == 8 || code == 46 || code == 9)
     {
    	return true;   //DEL   
     }
     return false;
     
}

/*
 *  key       
 */
function convertChar(code)
{
	var keyChar;
	
	if(45 == code)
	{
	    keyChar = '-';
	}
	else if(44 == code)
	{
        keyChar = ',';
    }
    else if(47 < code && 58 > code)
    {
    	keyChar = code - 48;
    }
    else if(95 < code && 106 > code)
    {
    	keyChar = code - 96;
    }
    else
    {
    	keyChar = "ch" + code;
    }
    return keyChar;
}

/*
 * vlanID      
 *         
 */
function restrictVlanID(obj, ch)
{
    
	var posStart;
	var posEnd;
	
	if(isIE)
	{
		var selectRng = document.selection.createRange();
	    selectRng.text = "";
	    var pos = digitalTag_getPos(obj);
	    posStart = pos;
	    posEnd = pos;
	}
	else
	{
		posStart = obj.selectionStart;
		posEnd = obj.selectionEnd;
	}
	

	
    
    
    
    
    
   
	
	if("," == ch || "-" == ch)
	{
		
		if(0 == posStart)
		{
		    return false;
		}
		else if("," == obj.value.charAt(posStart-1) || "-" == obj.value.charAt(posStart-1)
			|| "," == obj.value.charAt(posStart) || "-" == obj.value.charAt(posStart))
		{
			return false;
		}
	}
	if("0" == ch)
	{
		if( (obj.value.substring(posEnd).length > 0) && ((posStart == 0) || "-" == obj.value.charAt(posStart-1) || "," == obj.value.charAt(posStart-1)))
		{
			return false;
		}
		else
		{
			var v1 = obj.value.substring(0,posStart);
			var v2 = obj.value.substring(posEnd);
			
			var str1 = "";
		    var str2 = "";
		    
		    if(v1.length >= 1)
		    {
		    	if(v1.lastIndexOf("-") >= 0)
				{
					var v3 = v1.substring(v1.lastIndexOf("-")+1);
					if(v3.length >= 1)
					{
						if(v3.lastIndexOf(",") >= 0 )
						{
							str1 = v3.substring(v3.lastIndexOf(",")+1);
						}
						else
						{
							str1 = v3;
						}
					}
				}
				else if(v1.lastIndexOf(",") >= 0)
				{
					str1 = v1.substring(v1.lastIndexOf(",")+1);
				}
				else
				{
					str1 = v1;				
				}
			}
			
			if(str1.indexOf("0") == 0)
			{
				return false;
			}
			
		    
		}
	}
	if("123456789".indexOf(ch) >= 0 )
	{
		var v1 = obj.value.substring(0,posStart);
		var v2 = obj.value.substring(posEnd);
	    if(v1.length >= 1)
	    {
	    	if(v1.lastIndexOf("-") >= 0 )
			{
				var v3 = v1.substring(v1.lastIndexOf("-")+1);
				if(v3.length == 1 && v3 == "0")
				{
					obj.value = obj.value.substring(0, posStart-1) + obj.value.substring(posEnd);
				}
			}
			else if(v1.lastIndexOf(",") >= 0)
			{
				var v4 = v1.substring(v1.lastIndexOf(",")+1);
				if(v4.length == 1 && v4 == "0")
				{
					obj.value = obj.value.substring(0, posStart-1) + obj.value.substring(posEnd);
				}
			}
			else if(v1.length == 1 && v1 == "0")
			{
				obj.value = obj.value.substring(posEnd);
				return true;
			}
		}
	}
	if("0123456789".indexOf(ch) >= 0 || "ch8" == ch || "ch9" == ch || "ch46" ==ch)
	{
		var v1 = obj.value.substring(0,posStart);
		var v2 = obj.value.substring(posEnd);
		
		var str1 = "";
		var str2 = "";
		if(v1.length >= 1)
		{
			if(v1.lastIndexOf("-") >= 0)
			{
				var v3 = v1.substring(v1.lastIndexOf("-")+1);
				if(v3.length >= 1)
				{
					if(v3.lastIndexOf(",") >= 0 )
					{
						str1 = v3.substring(v3.lastIndexOf(",")+1);
					}
					else
					{
						str1 = v3;
					}
				}
			}
			else if(v1.lastIndexOf(",") >= 0)
			{
				str1 = v1.substring(v1.lastIndexOf(",")+1);
			}
			else
			{
				str1 = v1;				
			}
		}
		if(v2.length >= 1)
		{
			if(v2.indexOf("-") >= 0)
			{
				var v4 = v2.substring(0, v2.indexOf("-"));
				if(v4.length >= 1)
				{
					if(v4.indexOf(",") >= 0 )
					{
						str2 = v4.substring(0, v4.indexOf(","));
					}
					else
					{
						str2 = v4;
					}
				}
			}
			else if(v2.indexOf(",") >= 0)
			{
				str2 = v2.substring(v2.indexOf(",")+1);
			}
			else
			{
				str2 = v2;
			}
			
		}


		if((parseInt(str1 + ch + str2) > MAXINPUT)||(parseInt(str1 + ch + str2)==0))
		{
			
			alert(RESOURCE["ID_NUMLEFT"]+MININPUT+RESOURCE["ID_NUMMIDDLE"]+MAXINPUT+RESOURCE["ID_NUMRIGHT"]);
			return false;
		}
		
		
	}
	
	return true;
}

/*
 *       
 */
function clearPortTable()
{
	for(var i = 0, len = portAttrTable.getDataRowLength(); i < len; i++)
	{
		portAttrTable.deleteRow(i);
	}
	portAttrTable.adjustDataRows();
}

/*
 *          
 *                
 *            
 */
function refreshPortTable()
{
	$("applybtn").disabled = false;
	
	clearPortTable();
	
    var wspElement = $("workSource").firstChild;
    var workSrcPort = wspElement.options[wspElement.selectedIndex].value;
    
    var pspElement = $("protectSource").firstChild;
    var protectSrcPort = pspElement.options[pspElement.selectedIndex].value;
    
    var wsnpElement = $("workSink").firstChild;
    var workSnkPort = wsnpElement.options[wsnpElement.selectedIndex].value;
    
    var ports = new Object();
    ports[srcPortsOfUse[workSrcPort].portno] = srcPortsOfUse[workSrcPort];
    ports[srcPortsOfUse[protectSrcPort].portno] = srcPortsOfUse[protectSrcPort];
    ports[snkPortsOfUse[workSnkPort].portno] = snkPortsOfUse[workSnkPort];
    
    var portData = createPortData(ports); 
    
    createGenCfgTableBody(portAttrTable, window.tableconf[0], portData);  

    for(var i = 0,len = portAttrTable.getDataRowLength();i<len;i++)
	  {
		    var cell = portAttrTable.getCellElement(i,"portType");
		    cell.editElement.element["onchange"] = changePortType;
	  }

    if(!portAttrTable.element.colsArray.selectedId)
	  {
	  	 portAttrTable.element.colsArray.selectedId = "port";
	  	 portAttrTable.element.colsArray.imgflag = 1;
	  }
	  var td=portAttrTable.element.headRow.element.cols[portAttrTable.element.colsArray.selectedId].element; 
	  portAttrTable.sortRows(td,portAttrTable.element.colsArray.imgflag);
	  
	  setTagCellEdit();
    controlPortType();
}

function changePortType()
{
	  var rowindex = this.parentNode.parentNode.rowIndex;
	  var value = this.value;
	
    var tagCell = portAttrTable.getCellElement(rowindex,"tagIdentifier");
    if(value == 2)
		{
			  portAttrTable.setCellIsEdit(tagCell,1);
	      portAttrTable.setAtomValue(tagCell.showElement,"Tag Aware");
		}
		else
		{
			  portAttrTable.setCellIsEdit(tagCell,0);
	      portAttrTable.setAtomValue(tagCell.showElement,"-");
		}
}

function controlPortType()
{
   
    if(win.winobj["boardType"] == TBE_BOARD &&(EPL==$("workType").firstChild.selectedIndex) ) 
    {
       
         for( var i = 0, iLen = portAttrTable.getDataRowLength(); i < iLen; i++)
		 {
		        portAttrTable.setCellIsEdit(portAttrTable.getCell(i,"portType"),0);
		        pTypeEditCell = portAttrTable.getCellEdit(i,"portType");
		        pTypeEditCell.clearOptions();
				pTypeEditCell.addOption("UNI",2);
		 }
		
    }
    else
    {
        for( var i = 0, iLen = portAttrTable.getDataRowLength(); i < iLen; i++)
	   {
           
            pTypeEditCell = portAttrTable.getCellEdit(i,"portType");
            portAttrTable.setCellIsEdit(portAttrTable.getCell(i,"portType"),0);
            pTypeEditCell.clearOptions();
       }
    }
  
}

function setTagCellEdit()
{
	for(var i = 0,len = portAttrTable.getDataRowLength();i < len;i++)
	{
        var portType = portAttrTable.getCellStoreValue(i,"portType","portType");
        var tagCell = portAttrTable.getCell(i,"tagIdentifier");
        var tagCellShowValue = TagIdentifier[portAttrTable.getCellStoreValue(i,"tagIdentifier","tagIdentifier")];
        if(portType == 2)
		{
			portAttrTable.setCellIsEdit(tagCell,1);
	    if(tagCellShowValue != null && typeof(tagCellShowValue) != "undefined")
			{
	        portAttrTable.setAtomValue(tagCell.element.showElement,TagIdentifier[portAttrTable.getCellStoreValue(i,"tagIdentifier","tagIdentifier")]);
	    }
	    else
	    {
	    	portAttrTable.setAtomValue(tagCell.element.showElement,TagIdentifier["1"]);
	    	portAttrTable.setCellValue(tagCell,"tagIdentifier","1");
	    }
		}
		else
		{
			portAttrTable.setCellIsEdit(tagCell,0);
	      	portAttrTable.setAtomValue(tagCell.element.showElement,"-");
		}
	}
}

/*
 *         onchange  
 */
function registerPortTypeEvent()
{
	for(var i = 0, len = portAttrTable.getDataRowLength(); i < len; i++)
	{
		var pTypeAtom = portAttrTable.getCellEdit(i, "portType");
		pTypeAtom.element.onchange = function(){
			
			this.style.display = "none";
		    this.parentNode.showElement.element.style.display	=	"";
		    
		    for( var j = 0, jLen = portAttrTable.getDataRowLength(); j < jLen; j++)
		    {
		    	var pTypeCell = portAttrTable.getCell(j, "portType");	
		    	
		        pTypeCell.element.showElement.setValue(PortType[this.value]);
		        pTypeCell.element.modify = true;
	            pTypeCell.element.parentNode.modify = true;
	            pTypeCell.element.style.backgroundColor="#d0f946";
	            pTypeCell.element.parent.setTdCellValue(pTypeCell.element, this.parentNode.colid, this.value);          
	            pTypeCell.element.showElement.element.style.display	=	"";
	            handleCellEdit(pTypeCell.element,TABLE_CONSTANT.AFTEREDIT); 
		    }
		}
	}
} 
/*
* Create sort table body
* st SortTable Object
* tc TableConf Object
* di DataInterface Object
* res RESOUCE object
*/
function createTableST(st, tc, di, res)
{
	  for(var i = 0; i < di.getDataRowLength(); i++)
    {
        var row = st.createRow();
        for(var j = 0; j < tc.getColsLength(); j++)
        {            
            var cell = st.createCell(tc.getColWidth(j));
            cell.colid=tc.getColId(j);
            st.setCellIsEdit(cell, tc.getIsEdit(j));
            var atom = st.createAtom(tc.getColShowType(j))
            var options = tc.getColShowOptions(j);
            if(null != options && "" != options)
            {
                for(var k = 0; k < options.length; k++)
                {
                    atom.addOption(options[k].getName(), options[k].getValue());
                }
                atom.element.disabled = true;
            } 
            var showvalue = "";
            if(tc.getColKeyArray(j).length > 0)
            {   
                for(var k = 0; k <tc.getColKeyArray(j).length; k++)
                {
                    if(di.getDataRowParam(i, tc.getColKeyArray(j)[k].getName()))
                    {
                        st.setCellValue(cell, tc.getColKeyArray(j)[k].getName(), di.getDataRowParam(i, tc.getColKeyArray(j)[k].getName()));
                        if(tc.getColKeyArray(j)[k].getConvert())
                        {
                            showvalue += convertMsg(res, eval(tc.getColKeyArray(j)[k].getConvert()), 
                                                        di.getDataRowParam(i, tc.getColKeyArray(j)[k].getName()))+"-";
                        }
                        else
                        {
                            showvalue += di.getDataRowParam(i, tc.getColKeyArray(j)[k].getName()) + "-";
                        }   
                    }
                }
            }
            
            if(showvalue && showvalue.length > 0)
            {
                atom.setValue(showvalue.substring(0, showvalue.length-1));
            }
            else
            {
                atom.setValue("-");
            }
            
            var cellID = tc.getColId(j);
            if("portDisabled" == cellID && "-" == atom.getValue())
            {
                st.setCellIsEdit(cell, 0);    
            }
            st.addCellShow(cell, atom);
            
            if(tc.getIsEdit(j) == 1)
            {
                var ops = di.getDataRowOptions(i, tc.getColKeyArray(j)[0].getName());
                var atom = st.createAtom(tc.getColEditType(j));
                var options = tc.getColEditOptions(j)
                if(options.length > 0)
                {
                    for(var k = 0; k < options.length; k++)
                    {
                        atom.addOption(options[k].getName(), options[k].getValue());
                    }
                }  
                else if(ops)
                {
                    var convert = tc.getColKeyArray(j)[0].getConvert(); 
                    if(convert)
                    {
                        for(var k = 0; k <ops.length; k++)
                        {
                            var conv = eval(convert);
                            atom.addOption(convertMsg(res, conv, ops[k]), ops[k]); 
                        }
                    }
                    else
                    {
                        for(var k = 0; k <ops.length; k++)
                        {
                            atom.addOption(ops[k], ops[k]); 
                        }
                    }   
                }
                st.addCellEdit(cell, atom);                    
            }
            else if(tc.hasEditElement(j))
            {
                var convert = tc.getColKeyArray(j)[0].getConvert();                 
                var atom = st.createAtom(tc.getColEditType(j));
                var ops = di.getDataRowOptions(i, tc.getColKeyArray(j)[0].getName()); 
                if(ops)
                {
                    if(convert)
                    {
                        for(var k = 0; k <ops.length; k++)
                        {
                            atom.addOption(convertMsg(res, eval(convert), ops[k]), ops[k]); 
                        }
                    }
                    else
                    {
                        for(var k = 0; k <ops.length; k++)
                        {
                            atom.addOption(ops[k], ops[k]); 
                        }
                    }   
                }
                st.addCellEdit(cell, atom);     
            }            
            st.addCell(row, tc.getColId(j), cell);
            var cellwidth = tc.getColWidth(j);
            if(cellwidth == "0" || cellwidth == "0px" || cellwidth == "0%")
            {
                cell.element.style.display = "none";    
            }
        }
        st.addRow(row)
    }
}

/*
 *               datainterface
 * @param ports Object   portno   TEPort  
 * @return Datainterface
 */
function createPortData(ports)
{
    var datainterface = new DataInterface();
    
    for(var key in ports)
    {
    	
    	queryPortAttr(ports[key]);
    	
    	var obj = new Object();
    	var ptag1 = new ParamTag();
    	
    	ptag1.value = ports[key].portName;    	
    	obj["port"] = ptag1;
    	
    	var ptag5 = new ParamTag();
    	ptag5.value = ports[key].portno;
    	obj["portno"] = ptag5;
    	
    	var ptag6 = new ParamTag();
    	ptag6.value = ports[key].portTypeFlag;
    	obj["portTypeFlag"] = ptag6;
    	
    	var ptag2 = new ParamTag();
    	ptag2.value = ports[key].portType;
    	var serviceType = $("workType").firstChild.selectedIndex;
    	var operationType;
      var wsnpElement = $("workSink").firstChild;
      var workSnkPort = wsnpElement.options[wsnpElement.selectedIndex].value;
      var snkPortNO = snkPortsOfUse[workSnkPort].portno;
    	if(EPL == serviceType)
    	{
    		ptag2.value = UNI;
    	}
    	else if(key == snkPortNO)
    	{
    		var element = $("workOperation").firstChild;
    	  operationType = element.options[element.selectedIndex].value;
    	  
    		if(STRIP_SERVICE == operationType || TRANCLAT_SERVICE == operationType)
    		{
    			ptag2.value = CAWARE;
    		}
    		else
    		{
    			ptag2.value = SAWARE;
    		}  		
    	}
    	else
    	{
    		var element = $("workOperation").firstChild;
    	  operationType = element.options[element.selectedIndex].value;
    		if(ADD_SERVICE == operationType || TRANCLAT_SERVICE == operationType)
    		{
    			ptag2.value = CAWARE;
    		}
    		else
    		{
    			ptag2.value = SAWARE;
    		}
    	}
    	obj["portType"] = ptag2;
    	var ptag3 = new ParamTag();
    	ptag3.value = ports[key].portEnable;
    	obj["portDisabled"] = ptag3;
    	
    	var ptag4 = new ParamTag();
    	ptag4.value = ports[key].portTag;
    	obj["tagIdentifier"] = ptag4;    	    	    	
    	    	    	
    	datainterface.rows[datainterface.rows.length] = obj; 
    }
    
    return datainterface;
}

/*
 *       
 */
function queryPortAttr(port)
{
    var xmlData = queryPortAtrrXml(port);
    var URL = "../../../../../neExlorerServlet?sfid="+TECMDCODE_IP_PORTATTRI+"&nmUser="+win["nmUser"]; 
    loadXMLdoc(URL,"POST",false,callbackQueryPortAttr,port,"inputdata="+xmlData);
}

/*
 *            
 */
function callbackQueryPortAttr(doc, port)
{
    var portAttrData = EncapsulateData(doc);
    showErrorDialog(portAttrData);
    if (0 == portAttrData.getError().getGlobleECode()
        && null != portAttrData 
        && 0 < portAttrData.getDataRowLength()) 
    {    
        
	      if ( "0" == port.portTypeFlag )
	      {
	          port.portType = 2;
	          port.portEnable = portAttrData.getDataRowParam(0,"ATTR_ETHOVERSDH_MAC_ENABLE"); 
	          port.portTag = portAttrData.getDataRowParam(0,"ATTR_ETHOVERSDH_MAC_TAG");         
	      }    
	      else
	      {
	          port.portType = 2;
	          port.portTag = portAttrData.getDataRowParam(0,"ATTR_ETHOVERSDH_VCG_TAG");         
	      }
	 }
}

/*
         
 */
function queryPortAtrrXml(port)
{
    var root =new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row=new tagElement("row-params");

    var param=new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",win.neID);
    row.appendChild(param);
   
    param=new tagElement("param");
    param.setAttribute("name","slotID");
    param.setAttribute("value",win.slotID);
    row.appendChild(param);
    
    param=new tagElement("param");
    param.setAttribute("name","port");
    param.setAttribute("value",port.portno);
    row.appendChild(param);
   
    if ("0" == port.portTypeFlag)
    {
        param=new tagElement("param");
        param.setAttribute("name","attrid");
        param.setAttribute("value","ATTR_ETHOVERSDH_MAC_PE_TYPE");
        row.appendChild(param);    
   
        param=new tagElement("param");
        param.setAttribute("name","attrid");
        param.setAttribute("value","ATTR_ETHOVERSDH_MAC_ENABLE");
        row.appendChild(param);
        
        param=new tagElement("param");
        param.setAttribute("name","attrid");
        param.setAttribute("value","ATTR_ETHOVERSDH_MAC_TAG");
        row.appendChild(param);
    }   
    else
    {
        param=new tagElement("param");
        param.setAttribute("name","attrid");
        param.setAttribute("value","ATTR_ETHOVERSDH_VCG_PE_TYPE");
        row.appendChild(param);
        
        param=new tagElement("param");
        param.setAttribute("name","attrid");
        param.setAttribute("value","ATTR_ETHOVERSDH_VCG_TAG");
        row.appendChild(param);
    }   
    
    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);
    
    return root.toString();
}
