 //    
var neID;
var slotID;


/*
 *       
 */
function getPortName(portNum)
{
    var portName;
    
    if(0x8000 < portNum)
    {
    	portName = "VCTRUNK" + (portNum - 0x8000);
    }
    else
    {
    	portName = "PORT" + portNum;
    }
    
    return portName;
}

/*
 *           
 */
function getPortNo(portName)
{
	var portNo = portName;
	
	var str1 = "vctrunk";
	var str2 = "port";
	if(portName.toLowerCase().indexOf(str1) >= 0)
	{
		portNo = parseInt(portName.substring(portName.toLowerCase().indexOf(str1)+str1.length)) + 0x8000;
	}
	else if(portName.toLowerCase().indexOf(str2) >= 0)
	{
		portNo = portName.substring(portName.toLowerCase().indexOf(str2)+str2.length);
	}
	
	return portNo;
	
}
 

/*
 *       id
 */
function getBoardTypeId()
{
    var obj = parseURLStr(self);
    return obj["boardType"];
}

/*
 *     id
 */
function getSlotId()
{
    var obj = parseURLStr(self);
    slotID = obj["slotid"];
    return obj["slotid"];
}

/*
 *     id
 */
function getNeId()
{
    var obj = parseURLStr(self);
    neID = obj["neid"];
    return obj["neid"];
}

/*
 *              
 *  data datainterface     datainterface
 *  err []     
 */
function showErrPage(data, errArr)
{
	openErrPage("../../../../../page/", datainterface.getError(), errArr);
}

/*
 *              
 * 0.       
 * 1.   
 * 2.        
 * 3.        
 * 4.        
 * 5.        
 * 6.     
 */
function createjsDOMenu(btnStr)
{
	removejsDOMmenu();
	
	if("functionMenus" == btnStr)
	{
	
		var isHasWrtMode = false;
		
		for(var i = 0, len = workTable.getDataRowLength(); i < len; i++)
		{
		    if(workTable.getRowSelFlag(i))
		    {
		    	var wrtMode = workTable.getCellStoreValue(i, "hideWrtMode", "hideWrtMode");
		    	if( 1 == wrtMode )
		    	{
		    		isHasWrtMode = true;
		    	}
		    }	
		}
		
	    var cursorMenu = new jsDOMenu(180); //   180
	    
	    var SWITCH_STATUS_QUERY = 0;//      
	    var CLEAR = 1;//  
	    var FORCETOPROTECTION = 2; //       
	    var FORCETOWORKING = 3; //       
	    var MANUALTOPROTECTION = 4; //       
	    var MANUALTOWORKING = 5; //       
	  	var LOCKOUTOFPROTECTION = 6;//     
	  	
		cursorMenu.addMenuItem(new menuItem(RESOURCE["switchstatusquery"], "", switchFunction, SWITCH_STATUS_QUERY));
	    
	    cursorMenu.addMenuItem(new menuItem("-"));
	    
	    cursorMenu.addMenuItem(new menuItem(RESOURCE["clear"],"",switchFunction,CLEAR));
	    
	    cursorMenu.addMenuItem(new menuItem(RESOURCE["lockoutofprotection"], "", switchFunction, LOCKOUTOFPROTECTION));
		
	    cursorMenu.addMenuItem(new menuItem(RESOURCE["forcetoprotection"],"",switchFunction,FORCETOPROTECTION));
	    
		cursorMenu.addMenuItem(new menuItem(RESOURCE["forcetoworking"], "", switchFunction, FORCETOWORKING, (!isHasWrtMode)));
	  
	  
	    cursorMenu.addMenuItem(new menuItem(RESOURCE["manualtoprotection"], "", switchFunction, MANUALTOPROTECTION));
	    
	    cursorMenu.addMenuItem(new menuItem(RESOURCE["manualtoworking"], "", switchFunction, MANUALTOWORKING, (!isHasWrtMode)));
	
	    setPopUpMenu(cursorMenu);
	}
	else if("activatebtn" == btnStr)
	{
		var isOAMEnable = false;
		var isOAMDisable = false;
		
		for(var i = 0, len = workTable.getDataRowLength(); i < len; i++)
		{
		    if(workTable.getRowSelFlag(i))
		    {
		    	var oamEN = workTable.getCellStoreValue(i, "oamEN", "oamEN");
		    	if( "1" == oamEN )
		    	{
		    		isOAMEnable = true;
		    	}
		    	else
		    	{
		    		isOAMDisable = true;
		    	}
		    }	
		}
		
	    var cursorMenu = new jsDOMenu(120); //   180
	    
	    cursorMenu.addMenuItem(new menuItem(RESOURCE["oameny"], "", doActivateSNCP, "1", (isOAMDisable)));
	    cursorMenu.addMenuItem(new menuItem(RESOURCE["oamenn"], "", doActivateSNCP, "0", (isOAMEnable)));
	    
	    setPopUpMenu(cursorMenu);
	}
}

/**
 * vlan sncp    
 * command     
 * 0.       
 * 1.   
 * 2.        
 * 3.        
 * 4.        	
 * 5.        
 * 6.     
 */
function switchFunction(command)
{
    doVlanSncpSwitch(command);
}

/*
 *   vlanID
 * 1-3, 6-5, 10     1 2 3 5, 6,10
 *     vlanArr []
 */
function splitVlanID(vlanID)
{
	var vlanArr = new Array();
	
	if("" == vlanID)
	{
		return vlanArr;
	}
		
	var vlanIDs = vlanID.split(",");
	
	var minNo = -1;
	var maxNo = -1;
	
	for(var i = 0, len = vlanIDs.length; i < len; i++)
	{
		if(0 < vlanIDs[i].indexOf("-") && (vlanIDs[i].length -1) > vlanIDs[i].indexOf("-") )
		{
			minNo = parseInt(vlanIDs[i].split("-")[0]);
			maxNo = parseInt(vlanIDs[i].split("-")[1]);
			
			if(minNo > maxNo)
			{
				maxNo = minNo - maxNo;
				minNo = minNo - maxNo;
				maxNo = minNo + maxNo;
			}
			
			while(minNo <= maxNo)
			{
				vlanArr[vlanArr.length] = minNo;
				minNo++; 
			}
		}
		else
		{
			vlanArr[vlanArr.length] = vlanIDs[i];
		}
		
	}
	
	return vlanArr;
}

/*
 * 1.                        
 * 2.                        
 * 3.                        
 * 4.           vlan     vlan     
 */
function validateCreateForm()
{
    var wspElement = $("workSource").firstChild;
    var workSrcPort = wspElement.options[wspElement.selectedIndex].value;
    
    var pspElement = $("protectSource").firstChild;
    var protectSrcPort = pspElement.options[pspElement.selectedIndex].value;
    
    var wsnpElement = $("workSink").firstChild;
    var workSnkPort = wsnpElement.options[wsnpElement.selectedIndex].value;
    if (srcPortsOfUse[workSrcPort] == snkPortsOfUse[workSnkPort])
    {
     	  alert(RESOURCE["worksrcsnkport"]);
     	  return false;
    }
    
    if(srcPortsOfUse[workSrcPort] == srcPortsOfUse[protectSrcPort])
    {
     	alert(RESOURCE["workprotectsrcport"]);
     	return false;
    }
    
    if(snkPortsOfUse[workSnkPort] == srcPortsOfUse[protectSrcPort])
    {
     	alert(RESOURCE["protectsrcsnkport"]);
     	return false;
    }
    
    var workSVlanId = $("workSVlanId").firstChild.value;
    
    var workSinkVlanId = $("workSinkVlanId").firstChild.value;
    
    var workSVlanIDs = splitVlanID(workSVlanId);
    var workSinkVlanIDs = splitVlanID(workSinkVlanId);
    
    if(workSVlanIDs.length != workSinkVlanIDs.length)
    {
    	alert(RESOURCE["srcsnkvlanunequal"]);
    	return false;
    }
    
    return true;
  
}    


/*
 *               
 *                vlanID     
 *                 
 */
function isValidateVlan(vlanID)
{         
    
    if(vlanID == "")
    {
       return false;
    }
    
    if(vlanID == "-")
    {
       return true;
    }
    
    var str=vlanID.split(",");
    var pattern1=new RegExp("^\\d+$","i");
    var pattern2=new RegExp("^\\d+-\\d+$","i");
 
    for(var i=0; i<str.length; i++)
    {        
        var b=str[i].indexOf("-")!=-1;
        if(b)
        {
            if( !pattern2.test(str[i]))
            {    
                return false;
            }
        }
        else
        {
            if(!pattern1.test(str[i]))
            {
                return false;
            }
         }
    }
    var limit = 4095;
    for(var i=0; i<str.length; i++)
    {
        var b=str[i].indexOf("-")!=-1;
        if(b)
        {
            var range=str[i].split("-");
            var rangeStart=parseInt(range[0]);
            var rangeEnd=parseInt(range[1]);

            if((rangeStart>limit) || (rangeEnd>limit)||(rangeEnd <rangeStart))
            {
       	 
                return false;
            }
        }
        else
        {
           if(parseInt(str[i])>limit)
           {
                return false;
           }
        }
    }
    return true;
}

/*
 *   evpl.html  
 */
function getEVPLPage(win)
{
	return getTabsPage(win, 0);
}

/*
 *   vlansncpmain.html  
 */
function getSNCPMainPage(win)
{
	return getTabsPage(win, 1);
}

/*
 *   tabs.html  iframe  
 * sncp             vlansncp        
 *          Vlansncp          tabs.html   
 *         iframe  
 * @param index    tabs.html     iframe                        
 */
function getTabsPage(win, index)
{
	if(win)
	{
		/*
		 *   ,       
		 * 1. getTable(funID)        funID   id   boardfunctiontree_zh.xml
		 *          funId              
		 * 2.                  iframe        iframe window  
		 */
		return win.parent.window.frames[index];
	}
}

/**
 *    
 * @param obj:     key:key 
 * @return String      
 */
function convertMsg(res, obj, key)
{
	
	if("function" == (typeof obj))	
	{
		return obj(key);
	}
	else //       
	{
		if(null == obj)
		{
			return null;
		}
		var resValue = obj[key];
		if(null == resValue)
		{
			resValue = key;
		}
		if(res[resValue])
		{
			return res[resValue];
		}		
		return resValue;
	}
}

/*
 *  ip           4   
 */
function convertIPStrToLong(ipstr)
{
	if (null == ipstr)
	{
	    return 0;
	}
	var result = 0;
	var sum = 0;
	var TCount = 0;
	var frontIsPoint = true;
	var firstConvert = 16777216;
	var secondConvert = 65536;
	var thirdConvert = 256;
	var firstMax = 223;
	var secondMax = 255;
	var thirdMax = 255;
	var fourthMax = 254;
	
	var T = new Array(firstConvert, secondConvert, thirdConvert);
	var nMax = new Array(firstMax, secondMax, thirdMax, fourthMax);
	for (i = 0; i < ipstr.length; i++)
	{
	   var ipchar = ipstr.charAt(i);
	   if ((ipchar>= '0') && (ipchar <= '9'))
	   {
	      sum = (sum * 10) + (ipchar - '0');
	      frontIsPoint = false;
	   }
	   else if (ipchar == '.')
	   {
	      if (frontIsPoint)
	      {
	          return 0;
	      }
	      frontIsPoint = true;
	      if ((sum == 0) && (TCount == 0)) // 1  0  
	      {
	          return 0;
	      }
	      if (TCount >= 3)
	      {
	          return 0;
	      }
	      if (sum > nMax[TCount])
	      {
	          return 0;
	      }
	      result = result + (sum * T[TCount++]);
	      sum = 0;
	   }
	   else if (ipchar != ' ') //    IP    
	   {
	       return 0; //   129.  9.  0.  1        
	   }
	}
	if (frontIsPoint)
	{
	    return 0;
	}
	if (TCount != 3)
	{
	    return 0;
	}
	if ((sum == 0) && (TCount == 3)) // 4  0  
	{
	    return 0;
	}
	if (sum > nMax[TCount])
	{
	    return 0;
	}
	return (result + sum);
}
