var win = getParentWindow();
var winurlobj = win.obj;
var mdSelectedRows = [];
document.title = RESOURCE["oamconfigbtn"];

function initPage()
{
	mdst = new SortTable();
    mdst.setImage("../../../../../images/");
    mdtc = window.tableconf[0];
    createTableHead(mdst, mdtc);
    $("uptablecomponent").appendChild(mdst.getTable());
    mdst.setBodyHeight(100);
    mdst.setOnRowSelectHandler(rowSelectHandler);
    
    mast = new SortTable();
    mast.setImage("../../../../../images/");
    matc = window.tableconf[1];
    createTableHead(mast, matc);
    $("downtablecomponent").appendChild(mast.getTable());
    mast.setBodyHeight(100);
    
    if(SYSTEMCONF.getLanguage() == "en")
    {
    	$("deletebtn").className = "buttonstyle5";
    }
    $("querybtn").value=RESOURCE["querybutton"];
    $("newbtn").value=RESOURCE["newbutton"];
	$("deletebtn").value=RESOURCE["deletebutton"];
	$("cancelbtn").value=RESOURCE["cancelbutton"];
		
		if(!win.btnRightArr.queryMDMA.right)
		{
			$("querybtn").disabled = true;
		}
		if(!win.btnRightArr.createMD.right && !win.btnRightArr.createMA.right)
		{
			$("newbtn").disabled = true;
		}
		if(!win.btnRightArr.delMD.right && !win.btnRightArr.delMA.right)
		{
			$("deletebtn").disabled = true;
		}
    doQuery()
}

/**
 *   MAMD
 */
function doQuery()
{
	win.queryMDMA();
	initMDTable();
}

/**
 *    MD  
 */
function initMDTable()
{
	mdst.clearTableData();
	
	var dinterface = new DataInterface();
	var row = new Object();
	addParam(row,"mdid","0");
	addParam(row,"mdName","NULL");
	addParam(row,"mdLevel","NULL");
	dinterface.rows[dinterface.rows.length] = row;
	
	var mdList = win.mdList;
	for(key in mdList)
	{
		row = new Object();
		if(null == mdList[key])
		{
			continue;
		}
		addParam(row,"mdid",mdList[key].mdid);
		addParam(row,"mdName",mdList[key].mdName);
		addParam(row,"mdLevel",RESOURCE["level"+mdList[key].mdLevel]);
		dinterface.rows[dinterface.rows.length] = row;
	} 
	
	createTableBody(mdst, mdtc, dinterface, RESOURCE);
	
	for(var i = 0; i < mdSelectedRows.length; i++)  
	{
		mdst.setRowSelect(mdSelectedRows[i]);
	}

	rowSelectHandler(mdSelectedRows);
}

/**
 *        
 */
function addParam(row,key,value)
{
	var ptag = new ParamTag();
	ptag.value = value;
	row[key] = ptag;
}


/**
 *              
 */
function rowSelectHandler(rows)
{
	mast.clearTableData();
	
	if(rows.length == 0 || rows.length>1)
	{
		return;
	}
	
	var mdid = mdst.getCellStoreValue(rows[0],"mdid","mdid");
	
	var dinterface = new DataInterface();
	var row = null;
	if(mdid == "0")
	{
		row = new Object();
		addParam(row,"maid","0");
		addParam(row,"maName","NULL");
		dinterface.rows[dinterface.rows.length] = row; 
	}
	else
	{
		var maList = win.mdList[mdid].maList;
		for(var i = 0, len = maList.length; i < len; i++)
		{
			row = new Object();
			addParam(row,"maid",maList[i].maid);
			addParam(row,"maName",maList[i].maName);
			dinterface.rows[dinterface.rows.length] = row;
		} 
	}
	createTableBody(mast, matc, dinterface, RESOURCE);
}

/**
 *        
 */        
function createjsDOMenu(elem)
{	
	removejsDOMmenu();
	  var menuWidth = 130;
    if(SYSTEMCONF.getLanguage() == "en")
    {
    	menuWidth = 220;
    }
    var cursorMenu = new jsDOMenu(menuWidth);
    
    if(elem.id == "newbtn")
    {
    	cursorMenu.addMenuItem(new menuItem(RESOURCE["createMD"], "", create, "MD",win.btnRightArr.createMD.right));
    	cursorMenu.addMenuItem(new menuItem(RESOURCE["createMA"], "", create, "MA",win.btnRightArr.createMA.right));
    }
    else
    {
    	cursorMenu.addMenuItem(new menuItem(RESOURCE["deleteMD"], "", del, "MD",getBtnEnable("MD")&&win.btnRightArr.delMD.right));
	    cursorMenu.addMenuItem(new menuItem(RESOURCE["deleteMA"], "", del, "MA",getBtnEnable("MA")&&win.btnRightArr.delMA.right));
    }   
   	
    setPopUpMenu(cursorMenu);
}


/**
 *   MD,MA
 */
function create(key)
{
	hideMenu();
  	var diaWidth = 350; 
  	var diaHeight = 200;
	
	if(key == "MD")
	{
		xshowModalDialog("createmd.html", RESOURCE["createMD"], diaWidth, diaHeight, "../../../../../images/");
	}
	else
	{
		xshowModalDialog("createma.html", RESOURCE["createMA"], diaWidth, diaHeight, "../../../../../images/");
	}
}

/**
 *   MD  
 */
function refreshMDTable(mdName,mdLevel)
{
	mdSelectedRows = mdst.getSelectedRows();	
	addMD(mdName,mdLevel);
	initMDTable();
}

/**
 *  MDList   md
 */
function addMD(mdName,mdLevel)
{
	var md = new Object();
	var mdid = mdst.getCellStoreValue(mdst.getDataRowLength()-1,"mdid","mdid");
	
	md.mdid = parseInt(mdid)+1;
	md.mdName = mdName;
	md.mdLevel = mdLevel;
	md.maList = [];
	win.mdList[md.mdid] = md;
}

/**
 *   
 */
function refreshMATable(mdid,maid,maName)
{
    var ma = new Object();
    ma.maid = maid;
    ma.maName = maName;
    
    win.mdList[mdid].maList.push(ma);
    
    for(var i=0,len=mdst.getDataRowLength();i<len;i++)
    {
    	var temp = mdst.getCellStoreValue(i,"mdid","mdid");
    	if(temp == mdid && mdst.getRowSelFlag(i))
    	{
    		mdst.setRowSelect(i);
			  rowSelectHandler(mdst.getSelectedRows());
			  break;
    	}
    }
}

/**
 *   MD,MA
 */
function del(key)
{	
	var xml;
	var sfid = TECMDCODE_IPPTN_ETH_OAM_DELETE_MD;
	if(key == "MD")
	{
		if(mdst.getSelectedRowCount() == 0)
		{
			alert(RESOURCE["PLEASE_SELECT_DATA"]);
			return;
		}
		xml = createDelXML("MD");
		sfid = TECMDCODE_IPPTN_ETH_OAM_DELETE_MD
	}
	else
	{
		if(mast.getSelectedRowCount() == 0)
		{
			alert(RESOURCE["PLEASE_SELECT_DATA"]);
			return;
		}
		xml = createDelXML("MA");
		sfid = TECMDCODE_IPPTN_ETH_OAM_DELETE_MA;
	}
	
	var urlreq ="../../../../../neExlorerServlet?sfid="+sfid+"&nmUser="+winurlobj["nmUser"];
	loadXMLdoc(urlreq, "POST", false, delCallBack, key, "inputdata="+xml);
}

/**
 *     xml
 */
function createDelXML(key)
{
    var selectedRows;
    if(key == "MD")
    {
    	selectedRows = mdst.getSelectedRows();
    }
    else
    {
    	selectedRows = mast.getSelectedRows();
    }
    
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var mdid;
    var maid;
    for(var i=0,len=selectedRows.length;i<len;i++)
    {
    	var row = new tagElement("row-params");
	    var param = new tagElement("param");
	    param.setAttribute("name","neid");
	    param.setAttribute("value",winurlobj["neid"]);
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name","slotid");
	    param.setAttribute("value",winurlobj["slotid"]);
	    row.appendChild(param);
	    
	    if(key == "MD")
	    {
	    	mdid = mdst.getCellStoreValue(selectedRows[i],"mdid","mdid");
		    if(mdid == 0)
		    {
		    	continue;
		    }
	    	param = new tagElement("param");
		    param.setAttribute("name","mdid");
		    param.setAttribute("value",mdid);
		    row.appendChild(param);
		    
	    	param = new tagElement("param");
		    param.setAttribute("name","mdName");
		    param.setAttribute("value",mdst.getCellStoreValue(selectedRows[i],"mdName","mdName"));
		    row.appendChild(param);
	    }
	    else
	    {		    
		    maid = mast.getCellStoreValue(selectedRows[i],"maid","maid");
		    if(maid == 0)
		    {
		    	continue;
		    }
	    	param = new tagElement("param");
		    param.setAttribute("name","maid");
		    param.setAttribute("value",maid);
		    row.appendChild(param);

	    	param = new tagElement("param");
		    param.setAttribute("name","maName");
		    param.setAttribute("value",mast.getCellStoreValue(mast.getSelectedRows()[0],"maName","maName"));
		    row.appendChild(param);

	    	param = new tagElement("param");
		    param.setAttribute("name","mdid");
		    param.setAttribute("value",mdst.getCellStoreValue(mdst.getSelectedRows()[0],"mdid","mdid"));
		    row.appendChild(param);

	    	param = new tagElement("param");
		    param.setAttribute("name","mdName");
		    param.setAttribute("value",mdst.getCellStoreValue(mdst.getSelectedRows()[0],"mdName","mdName"));
		    row.appendChild(param);
	    }
	    
	    bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
	return di.toString();
}

/**
 *        
 */
function delCallBack(doc,key)
{
	var data = EncapsulateData(doc);
		
	var error = [];
	var allError = data.getError();
	
	if(key == "MD")
	{
		var selectedRows = mdst.getSelectedRows()
		for(var i=0,len=data.getBErrLength();i<len;i++)
		{
			for(var j=0,rowlen=selectedRows.length;j<rowlen;j++)
			{
				if(mdst.getCellStoreValue(selectedRows[j],"mdid","mdid") == data.getBErrParam(i,"mdid"))
				{					
				  data.errObj.rowErrors[i].errorObj.mdName = RESOURCE["mdTitle"]+ ":"+ mdst.getCellStoreValue(selectedRows[j],"mdName","mdName");
					break;
				}
			}
			error[error.length] = data.getBErrParam(i,"mdid");
		}
		delMD(error);
	}
	else
	{
		var selectedRows = mast.getSelectedRows()
		for(var i=0,len=data.getBErrLength();i<len;i++)
		{
			for(var j=0,rowlen=selectedRows.length;j<rowlen;j++)
			{
				if(mast.getCellStoreValue(selectedRows[j],"maid","maid") == data.getBErrParam(i,"maid"))
				{					
				  data.errObj.rowErrors[i].errorObj.maName = RESOURCE["maTitle"]+ ":" + mast.getCellStoreValue(selectedRows[j],"maName","maName");
					break;
				}
			}
			error[error.length] = data.getBErrParam(i,"maid");
		}
		delMA(error);
	}
	openErrorDialog(data,key);
}

/**
 * 
 */
function delMD(error)
{
	var selectedRows = mdst.getSelectedRows()
	for(var i=0,len=selectedRows.length;i<len;i++)
	{
		var mdid = mdst.getCellStoreValue(selectedRows[i],"mdid","mdid");
		
		if(!error.contains(mdid) && 0 != mdid)
		{
			win.mdList[mdid] = null;
			mdst.deleteRow(selectedRows[i]);
			win.mdIDList.remove(mdid);
		}
	}
	mdst.adjustDataRows();
	rowSelectHandler(mdst.getSelectedRows());
}

/**
 * 
 */
function delMA(error)
{
	var mdid = mdst.getCellStoreValue(mdst.getSelectedRows()[0],"mdid","mdid");
	var selectedRows = mast.getSelectedRows();
	var maList = win.mdList[mdid].maList;
	var maid;
	for(var i=0,len=selectedRows.length;i<len;i++)
	{
		maid = mast.getCellStoreValue(selectedRows[i],"maid","maid");
		if(!error.contains(maid) && 0 != maid)
		{
			mast.deleteRow(selectedRows[i]);
			win.maIDList.remove(maid);
			
			for(var j = 0,size = maList.length; j < size; j++)
			{
				if(maList[j].maid == maid)
				{
					maList.removeAt(j);
					break;
				}
			}
		}
	}
	mast.adjustDataRows();
}

/**
 *        
 */
function openErrorDialog(data,key)
{
	var errArr = [];
	if(key == "MD")
	{
		errArr[0] = "mdName";
	}
	else
	{
		errArr[0] = "maName";
	}
    openErrPage("../../../../../page/", data.getError(), errArr);
}

/**
 *              
 */
function getBtnEnable(key)
{
	if(key == "MD")
	{
		if(mdst.getSelectedRowCount() == 0)
		{
			return false;
		}		
		if(mdst.getSelectedRowCount() == 1 && mdst.getCellStoreValue(mdst.getSelectedRows()[0],"mdid","mdid") == 0)
		{
			return false;
		}
	}
	else
	{
		if(mast.getSelectedRowCount() == 0)
		{
			return false;
		}		
		if(mast.getSelectedRowCount() == 1 && mast.getCellStoreValue(mast.getSelectedRows()[0],"maid","maid") == 0)
		{
			return false;
		}
		
	}	
	return true;
}
