var resources = [];
var ct;

var submitFlag = false;
var mpLevel = 4;
var ccStatus = 0;
var lbTestTime = 5000;
var ltTestTime = 5000;
var ccPeriod = 5000;

var win = getParentWindow(); 
var neid = win["neid"];
var nmUser = win["nmUser"];
var slotid = win["slotid"];

var obj = getNeProperty(self); 
var boardType = win.boardtype;

var mdList = win.mdList;

function initPage()
{
    SpecialAttrMgr.getCPFunInfo(neid, slotid, 'TE_FUNC_CFG_ETH_OAM');
    
	$("advancebtn").value = RESOURCE["advancebutton"];	
	$("enterbtn").value = RESOURCE["okbutton"];          
	$("cancelbtn").value = RESOURCE["cancelbutton"];
	$("applybtn").value = RESOURCE["applybutton"];
	
	initTable();

	initData();
}

function initTable()
{
	ct = new CTable();
	ct.addHead(RESOURCE["attribute"],RESOURCE["getvalue"]);
		
	var atom = new Atom("select");
	atom.element.style.width="100%";
	atom.element.onchange = linkageByNode;
	ct.addAttrRow("mdName", RESOURCE["mdName"], atom);
	
	atom = new Atom("select");
	atom.element.style.width="100%";
	atom.element.onchange = linkageByNode;
	ct.addAttrRow("maName", RESOURCE["maName"], atom);

	atom = new Atom("select");
	atom.element.style.width="100%";
	atom.element.onchange = linkageByNode;
	ct.addAttrRow("node", RESOURCE["node"], atom);

	atom = new Atom("select");
	atom.element.style.width="100%";
	ct.addAttrRow("vlanid", RESOURCE["vlanid"], atom);

	atom = new Atom("text");
	atom.element.setAttribute("maxLength", "10");
	atom.setValue("00-00-0000");
	checkFormat(atom.element);
	ct.addAttrRow("mpid", RESOURCE["mpid"], atom);

        atom = new Atom("select");
	atom.element.style.width="100%";
	atom.element.options[atom.element.options.length] = new Option(RESOURCE["mep"], 1);
	atom.element.options[atom.element.options.length] = new Option(RESOURCE["mip"], 2);
	atom.element.onchange = linkageByType;
	ct.addAttrRow("type", RESOURCE["type"], atom);

	atom = new Atom("select");
	atom.element.style.width="100%";
	ct.addAttrRow("direction", RESOURCE["direction"], atom);

        ct.changeColWidth('37%', '63%');
	$("tablecomponent").appendChild(ct.getTable());
}

/*function autoGetMPID()
{
	var autoMpId = 1;
	for (var i = 0, m = win.st.getDataRowLength(); i < m; i++)
	{
		var mpidStr = win.st.getCellStoreValue(i, "mpid", "mpid").split("-");
		var mpid = hexToTen(mpidStr[0] + mpidStr[1] + mpidStr[2]);
		if (autoMpId <= MAX_MP_ID && autoMpId == mpid)
		{
			autoMpId ++;
		}
	}
	var strMpId = tenToHex(autoMpId);
	if (strMpId.length < 8)
	{
		var str = "";
		for (var j = 0, n = 8 - strMpId.length; j < n; j++)
		{
			str += "0";
		}
		strMpId = str + strMpId;
	}
	strMpId = strMpId.substring(0, 2) + "-" + strMpId.substring(2, 4) + "-" + strMpId.substring(4);
	return strMpId;
}*/

/**
 *              
 */
function  UsableResource()
{
	this.subrackName = null;
	this.slotId = null;
	this.boardName = null;
	this.portId = null;
	this.portName = null;
	this.vlanId = null;
	this.isShare = false;
	this.sinkPort = null;
	this.sinkPortName = null;
}

function initData()
{
	var elm = ct.getAtom("mdName").element;
	elm.options.add(new Option("NULL","0"));
	for(var key in mdList)
	{
		elm.options.add(new Option(mdList[key].mdName,mdList[key].mdid));
	}
	elm.onchange = function()
	{
		mdOnchange(this.value);
	}
	
	mdOnchange(0);
	
	
	var data = win.createResource;
	var elm = ct.getAtom("node").element;
	for (var i = 0, m = data.getDataRowLength(); i < m; i++)
	{		
		var resource = new UsableResource();
		var subrackName = data.getDataRowParam(i, "subrackname");
		resource.subrackName = subrackName;
		var slotId = data.getDataRowParam(i, "slot");
		resource.slotId = slotId;
		var boardName = data.getDataRowParam(i, "boardname");
		resource.boardName = boardName;
		var portId = data.getDataRowParam(i, "port");
		resource.portId = portId;
		var portName = data.getDataRowParam(i, "portname");	
		resource.portName = portName;	
		
		if(data.getDataRowParam(i, "sinkPortName"))
		{
		    resource.sinkPortName = data.getDataRowParam(i, "sinkPortName");
		    resource.sinkPort = data.getDataRowParam(i, "sinkPort");
		}
		
		if(boardName == "N1EGSH" || boardName == "N3EAS2" || SpecialAttrMgr.isCPSupport(neid, slotid, 'TE_FUNC_CFG_ETH_OAM', 'ETHOAM_SUPPORTSPECIAL_ASEGSH') )
		{
			ct.getAtom("type").element.onchange = linkageByTypeSDH;
		}
		else
		{
			ct.getAtom("type").element.onchange = linkageByType;
  		}

		var vlanId = new Array();
		vlanId[vlanId.length] = data.getDataRowParam(i, "vlanid");
		mOption = data.getDataRowOptions(i, "vlanid");
		if (mOption != null)
		{
			for (var j = 0, n = mOption.length; j < n; j++)
			{
				vlanId[vlanId.length] = mOption[j];
			}
		}
		vlanId.sort(compareVlanID);		
		if (vlanId[vlanId.length - 1].indexOf("65535") > 0 && vlanId.length > 1)
		{
			resource.isShare = true;
		}
		
		resource.vlanId = vlanId;
		resources.push(resource);
		resources.sort(comparePortID);	
	}
	for (var j = 0, n = resources.length; j < n; j++)
	{
		var res = resources[j];
		var text = getSlotIDFromSlot(res.slotId) + "-" + res.boardName 
	
	        var optionValue;
		if(res.sinkPortName)
		{
		    text += "(" + res.portName + "-" + res.sinkPortName + ")";
		    optionValue = res.slotId + "-" + res.portId + "-" + res.sinkPort
		} else {
		    text += "-" + res.portName;
		    optionValue = res.slotId + "-" + res.portId
		}
		
		if ("" != res.subrackName)
		{
			text = subrackName + "-" + text;
		}
		
		elm.options[elm.options.length] = new Option(text, optionValue);		
	}
	linkageByNode(resources[0].boardName);
}

/**
 * md      
 */
function mdOnchange(mdid)
{
	var elm = ct.getAtom("maName").element;
	elm.options.length = 0;
	
	if(mdid == 0)
	{
		ccPeriod = 5000;
		elm.options.add(new Option("NULL","0"));
		
		mpLevel = 3;
	}
	else
	{
		ccPeriod = 4;
		var maList = mdList[mdid].maList;
		
		mpLevel = mdList[mdid].mdLevel;
		
		for(var i = 0, len = maList.length; i < len; i++)
		{
			elm.options.add(new Option(maList[i].maName,maList[i].maid));
		}
	}
}

function comparePortID(v1, v2)
{
        if(parseInt(v1.portId) - parseInt(v2.portId) == 0)
        {
        	if(v1.sinkPort == null || v2.sinkPort == null)
        	{
        		return 0;
        	}
            return parseInt(v1.sinkPort) - parseInt(v2.sinkPort);
        }
        else
        {
            return parseInt(v1.portId) - parseInt(v2.portId);
        }
}

function compareVlanID(v1, v2)
{
	var o1 = parseInt(v1.substring(v1.indexOf("-") + 1, v1.length));
	var o2 = parseInt(v2.substring(v2.indexOf("-") + 1, v2.length));
	return o1 - o2;
}

function linkageByNode(boardName)
{
	var mdvalue = ct.getAtom("mdName").element.options[ct.getAtom("mdName").element.selectedIndex].value;

	$("applybtn").diabled = false;
	var nodeStr = ct.getAtom("node").element.value;
	var arr = nodeStr.split("-");

	for (var i = 0, m = resources.length; i < m; i++)
	{
		if (resources[i].slotId == arr[0] && resources[i].portId == arr[1])
		{
		        /**
		         *                  
		         *             NODE         NODE                    
		         **/
		        if(resources[i].sinkPort && resources[i].sinkPort != arr[2] || arr.length == 3 && !resources[i].sinkPort)
		        {
		            continue;
		        }
		        
			if (resources[i].vlanId.length <= 1)
			{
				var v = resources[i].vlanId[0].split("-");
				var em = ct.getAtom("vlanid").element;
				if (parseInt(v[1]) == 65535)
				{
					if (em.type != "text")
					{
						var atom = new Atom("text");
						atom.setValue("/");
						em.parentElement.replaceChild(atom.element, em);
						ct.attrArray["vlanid"] = atom;
						
						validataInput(atom.element);
					}
					else
					{
						ct.getAtom("vlanid").setValue("/");
					}
					var atom = new Atom("hidden");
					atom.setValue(v[0]);
					ct.addAttrRow("serviceid", "", atom);
				}
				else
				{
					if (em.type != "select-one")
					{
						var atom = new Atom("select");
						atom.element.style.width="100%";				
						atom.element.options[atom.element.options.length] = new Option(v[1], resources[i].vlanId[0]);	
						em.parentElement.replaceChild(atom.element, em);
						ct.attrArray["vlanid"] = atom;
					}
					else
					{
						em.options.length = 0;					
						em.options[em.options.length] = new Option(v[1], resources[i].vlanId[0]);
					}
				}
			}
			else
			{
				var em = ct.getAtom("vlanid").element;
				if (!resources[i].isShare) 
				{
					if (em.type != "select-one") 
					{
						var atom = new Atom("select");
						atom.element.style.width = "100%";
						for (var j = 0, n = resources[i].vlanId.length; j < n; j++) 
						{
							var v = resources[i].vlanId[j].split("-");
							atom.element.options[atom.element.options.length] = new Option(v[1], resources[i].vlanId[j]);
						}
						em.parentElement.replaceChild(atom.element, em);
						ct.attrArray["vlanid"] = atom;
					}
					else 
					{
						em.options.length = 0;
						for (var j = 0, n = resources[i].vlanId.length; j < n; j++) 
						{
							var v = resources[i].vlanId[j].split("-");
							em.options[em.options.length] = new Option(v[1], resources[i].vlanId[j]);
						}
					}
				}
				else
				{
					var atom = new Atom("combobox");
					atom.element.style.width = "100%";
					var arr = new Array();
					for (var j = 0, n = resources[i].vlanId.length; j < n; j++) 
					{
						var v = resources[i].vlanId[j].split("-");
						if (v[1] == 0xFFFF) 
						{
							v[1] = "/";
						}
						arr[arr.length] = new Option(v[1], v[1]);
					}
					em.parentElement.replaceChild(atom.element, em);
					ct.attrArray["vlanid"] = atom;
					atom.element.parent.initComboBox(arr, "dm0", 0, true);
    				atom.element.parent.txtview.onkeypress = keypressHandler;
    				atom.element.parent.txtview.onkeyup = keyupHandler;
    				atom.element.parent.txtview.onblur = onblurHandler;
    				atom.element.parent.txtview.style.imeMode = "disabled";
    				atom.element.parent.txtview.onpaste = function()
    				{
        				return false;
    				};
				}
			}
		}
	}	
	
	if(boardType == 1557 || boardType == 2217 || SpecialAttrMgr.isCPSupport(neid, slotid, 'TE_FUNC_CFG_ETH_OAM', 'ETHOAM_SUPPORTSPECIAL_ASEGSH') )
	{
		linkageByTypeSDH();
	}
	else
	{
		linkageByType();
  }
}

function validataInput(element)
{
	element.onblur = function()
	{
		if(element.value == "/")
		{
			return;
		}
		blurValidate(element, "1", "4095", "1");
    }
	
	element.onkeypress = function()
    {
    	var code=(event.keyCode!=0?event.keyCode:event.charCode);
   		var ch = String.fromCharCode(code);
   		var pos=digitalTag_getPos(element);
   		
   		if(element.value.indexOf("/") != -1&& (selectionLen(element) == 0))
   		{
   			return false;
   		}
   		
   		if(ch == '/')
   		{
   			if(selectionLen(element) == element.value.length || element.value=="")
   			{
				return true;   				
   			}
   		}
        return digitalCheck(element, "1", "4095", "1");    	
    }
}

function linkageByType()
{
	var elm = ct.getAtom("direction").element;
	elm.options.length = 0;
	var type = ct.getAtom("type").element.value;
	switch(parseInt(type))
	{
		case 1:
			var portType = ct.getAtom("node").element.value.split("-")[1];
			if (parseInt(portType) < 32768)
			{
				elm.options[elm.options.length] = new Option(RESOURCE["ipdirection"], 2);
				elm.options[elm.options.length] = new Option(RESOURCE["wdmdirection"], 1);
			}
			else
			{
				elm.options[elm.options.length] = new Option(RESOURCE["ipdirection"], 1);
				elm.options[elm.options.length] = new Option(RESOURCE["wdmdirection"], 2);
			}
			break;
		case 2:
			elm.options[elm.options.length] = new Option(RESOURCE["doubledirection"], 0);
			break;
		default:
			break;
	}
}

function linkageByTypeSDH()
{
	var elm = ct.getAtom("direction").element;
	elm.options.length = 0;
	var type = ct.getAtom("type").element.value;

	switch(parseInt(type))
	{
		case 1:
			var portType = ct.getAtom("node").element.value.split("-")[1];
			if (parseInt(portType) < 32768)
			{
				elm.options[elm.options.length] = new Option(RESOURCE["ipdirection"], 1);
				elm.options[elm.options.length] = new Option(RESOURCE["wdmsdhdirection"], 2);
			}
			else
			{
				elm.options[elm.options.length] = new Option(RESOURCE["ipdirection"], 2);
				elm.options[elm.options.length] = new Option(RESOURCE["wdmsdhdirection"], 1);
			}
			break;
		case 2:
			elm.options[elm.options.length] = new Option(RESOURCE["doubledirection"], 0);
			break;
		default:
			break;
	}
}
function clickAdvance()
{
	xshowModalDialog("advanceconfigure.html", RESOURCE["advanceconfiguretitle"], 400, 260, "../../../../../images/");
}

function createNewXML()
{
	var root = new inputxml("datainterface");
	var firstlevel = new tagElement("bussiness-params");
	
	var secondlevel = new tagElement("row-params");	
	var	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "neid");
	thirdlevel.setAttribute("value", neid);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "mdid");
	thirdlevel.setAttribute("value", ct.getAttrValue("mdName"));
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "mdName");
  thirdlevel.setAttribute("value", ct.getAtom("mdName").element.options[ct.getAtom("mdName").element.selectedIndex].text);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "maid");
	thirdlevel.setAttribute("value", ct.getAttrValue("maName"));
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "maName");
  thirdlevel.setAttribute("value", ct.getAtom("maName").element.options[ct.getAtom("maName").element.selectedIndex].text);
	secondlevel.appendChild(thirdlevel);

	var slot_port = ct.getAtom("node").element.value.split("-");
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "slotid");
	thirdlevel.setAttribute("value", slot_port[0]);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "port");
	thirdlevel.setAttribute("value", slot_port[1]);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "servicetype");
	thirdlevel.setAttribute("value", 1);
	secondlevel.appendChild(thirdlevel);
	
	var mpid = ct.getAtom("mpid").element.value;
	var mpids = mpid.split("-");
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "mpid");
	thirdlevel.setAttribute("value", mpids[0] + mpids[1] + mpids[2]);
	secondlevel.appendChild(thirdlevel);
	
	var vlanId = 65535;
	var serviceId = 0;

	var vlan = ct.getAtom("vlanid").element;
	if (vlan.type == "text")
	{
		serviceId = ct.getAtom("serviceid").element.value;
		if (vlan.value != "/")
		{
			vlanId = vlan.value;
		}
	}
	else
	{
		var vlanValue = ct.getAtom("vlanid").getValue();
		if (vlanValue.indexOf("-") > 0) 
		{
			var v = vlanValue.split("-");
			serviceId = v[0];
			vlanId = v[1];
		}
		else
		{
			if (vlanValue != "/")
			{
				vlanId = vlanValue;
			}
			for (var i = 0, m = resources.length; i < m; i++)
			{
				var res = resources[i];
				if (res.slotId == slot_port[0] && res.portId == slot_port[1])
				{
					var isExist = false;
					for (var j = 0, n = res.vlanId.length; j < n; j++)
					{
						var tmp = res.vlanId[j].split("-");
						if (vlanId == tmp[1])
						{
							isExist = true;
							serviceId = tmp[0];
							break;
						}
					}
					if (!isExist)
					{
						serviceId = res.vlanId[res.vlanId.length - 1].split("-")[0];
					}
					break;
				}
			}
		}
	}
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "serviceid");
	thirdlevel.setAttribute("value", serviceId);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "vlanid");
	thirdlevel.setAttribute("value", vlanId);
	secondlevel.appendChild(thirdlevel);
	
	var mpType = ct.getAtom("type").element.value;
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "type");
	thirdlevel.setAttribute("value", mpType);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "direction");
	thirdlevel.setAttribute("value", ct.getAtom("direction").element.value);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "level");
	thirdlevel.setAttribute("value", mpLevel);
	secondlevel.appendChild(thirdlevel);
	
	if (parseInt(mpType) == 1)
	{
		thirdlevel = new tagElement("param");	
		thirdlevel.setAttribute("name", "ccstatus");
		thirdlevel.setAttribute("value", ccStatus);
		secondlevel.appendChild(thirdlevel);
	
		thirdlevel = new tagElement("param");	
		thirdlevel.setAttribute("name", "lbtesttime");
		thirdlevel.setAttribute("value", lbTestTime);
		secondlevel.appendChild(thirdlevel);
	
		thirdlevel = new tagElement("param");	
		thirdlevel.setAttribute("name", "lttesttime");
		thirdlevel.setAttribute("value", ltTestTime);
		secondlevel.appendChild(thirdlevel);
	
		thirdlevel = new tagElement("param");	
		thirdlevel.setAttribute("name", "ccperiod");
		thirdlevel.setAttribute("value", ccPeriod);
		secondlevel.appendChild(thirdlevel);
	}
		
	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);
	return root.toString();
}

function createOam()
{
	if ($("applybtn").disabled && submitFlag)
	{
		xcloseDialog();
	}
	if("" == ct.getAtom("maName").element.value)
	{
		alert(RESOURCE["PLEASE_CHOOSE_MA"]);
		return;
	}
	
	var isStandardMp = false;
	if(ct.getAtom("maName").element.value != 0)
	{
		isStandardMp = true;
	}
	
	if (checkSubmit(ct.getAtom("mpid").element.value,isStandardMp))
	{
		var xml = createNewXML();
		var url = "../../../../../neExlorerServlet?sfid="+TECMDCODE_CREATE_OAMMP+"&nmUser=" + nmUser; 
		loadXMLdoc(url, "POST", false, callBackHandler, null, "inputdata=" + xml);
	}
}

function callBackHandler(doc)
{
    var data = EncapsulateData(doc);	
    showErrorDialog(data);
    if (0 == data.getSErrorCode() || 1 == data.getSErrorCode())
    {   
    
        var root = document.createElement("datainterface");      
        var firstlevel = document.createElement("bussiness-params");
        
        var res = null;
        var node = ct.getAtom("node").getValue();
        for (var j = 0, n = resources.length; j < n; j++)
        {
            res = resources[j];
            if(res.sinkPortName && node == res.slotId + "-" + res.portId + "-" + res.sinkPort 
               || !res.sinkPortName && node == res.slotId + "-" + res.portId)
            {
                break;
            } 
        }
        
        var secondlevel = document.createElement("row-params");
        var thirdlevel = document.createElement("param");
        thirdlevel.setAttribute("name", "subrackname");
        thirdlevel.setAttribute("value", res.subrackName);
        secondlevel.appendChild(thirdlevel);
        
        thirdlevel = document.createElement("param");
        thirdlevel.setAttribute("name", "slotid");
        thirdlevel.setAttribute("value", res.slotId);
        secondlevel.appendChild(thirdlevel);
        	
        thirdlevel = document.createElement("param");
        thirdlevel.setAttribute("name", "boardname");
        thirdlevel.setAttribute("value", res.boardName);
        secondlevel.appendChild(thirdlevel);
        	
        thirdlevel = document.createElement("param");
        thirdlevel.setAttribute("name", "portname");
        thirdlevel.setAttribute("value", res.portName);
        secondlevel.appendChild(thirdlevel);
        
        if(res.sinkPortName)
        {
            thirdlevel = document.createElement("param");
            thirdlevel.setAttribute("name", "sinkPortName");
            thirdlevel.setAttribute("value", res.sinkPortName);
            secondlevel.appendChild(thirdlevel);
        }
        
        var vlanId = 65535;
        var vlan = ct.getAtom("vlanid").element;
        if (vlan.type == "text")
        {
            vlanId = vlan.value;			
        }
        else
        {
            var vlanId = ct.getAtom("vlanid").getValue();
            if (vlanId.indexOf("-") > 0) 
            {
            	var v = vlanId.split("-");
            	vlanId = v[1];
            }
        }
        
        thirdlevel = document.createElement("param");
        thirdlevel.setAttribute("name", "vlanid");
        thirdlevel.setAttribute("value", vlanId);
        secondlevel.appendChild(thirdlevel);
        
        thirdlevel = document.createElement("param");
        thirdlevel.setAttribute("name", "mpid");
        thirdlevel.setAttribute("value", ct.getAtom("mpid").element.value);
        secondlevel.appendChild(thirdlevel);
        	
        thirdlevel = document.createElement("param");
        thirdlevel.setAttribute("name", "type");
        thirdlevel.setAttribute("value", ct.getAtom("type").element.value);
        secondlevel.appendChild(thirdlevel);
        
        thirdlevel = document.createElement("param");
        thirdlevel.setAttribute("name", "level");
        thirdlevel.setAttribute("value", mpLevel);
        secondlevel.appendChild(thirdlevel);
        
        thirdlevel = document.createElement("param");
        thirdlevel.setAttribute("name", "direction");
        thirdlevel.setAttribute("value", ct.getAtom("direction").element.value);
        secondlevel.appendChild(thirdlevel);	  		 
        
        var oError = data.getError();
    	if(data.getBErrLength() > 0)
    	{
    		for(var i = 0; i < data.getBErrLength(); i++)
        	{
            	if(null != oError.getRowKey(i, "ccstatus") && "" != oError.getRowKey(i, "ccstatus"))
            	{
                	ccStatus = "0";
            	}
				if(null != oError.getRowKey(i, "lbtesttime") && "" != oError.getRowKey(i, "lbtesttime"))
            	{
            		lbTestTime = "5000";
            	}
            	if(null != oError.getRowKey(i, "lttesttime") && "" != oError.getRowKey(i, "lttesttime"))
            	{
            		ltTestTime = "5000";
            	}
            	if(null != oError.getRowKey(i, "ccperiod") && "" != oError.getRowKey(i, "ccperiod"))
            	{
            		var mdvalue = ct.getAtom("mdName").element.options[ct.getAtom("mdName").element.selectedIndex].value;
            		if(mdvalue <= 0)
            		{
            			ccPeriod = "5000";
            		}
            		else
            		{
            			ccPeriod = "4";
            		}
            	}				
			}
		}
		
		thirdlevel = document.createElement("param");
  		thirdlevel.setAttribute("name", "ccstatus");
   		thirdlevel.setAttribute("value", ccStatus);
   		secondlevel.appendChild(thirdlevel);
   			
   		thirdlevel = document.createElement("param");
  		thirdlevel.setAttribute("name", "lbtesttime");
   		thirdlevel.setAttribute("value", lbTestTime);
   		secondlevel.appendChild(thirdlevel);
   		
   		thirdlevel = document.createElement("param");
  		thirdlevel.setAttribute("name", "lttesttime");
   		thirdlevel.setAttribute("value", ltTestTime);
   		secondlevel.appendChild(thirdlevel);
   		
   		thirdlevel = document.createElement("param");
  		thirdlevel.setAttribute("name", "ccperiod");
   		thirdlevel.setAttribute("value", ccPeriod);
   		secondlevel.appendChild(thirdlevel);

   		thirdlevel = document.createElement("param");
  		thirdlevel.setAttribute("name", "mdid");
   		thirdlevel.setAttribute("value", ct.getAtom("mdName").element.value);
   		secondlevel.appendChild(thirdlevel);

   		thirdlevel = document.createElement("param");
  		thirdlevel.setAttribute("name", "mdName");
   		thirdlevel.setAttribute("value", ct.getAtom("mdName").element.options[ct.getAtom("mdName").element.selectedIndex].text);
   		secondlevel.appendChild(thirdlevel);

   		thirdlevel = document.createElement("param");
  		thirdlevel.setAttribute("name", "maid");
   		thirdlevel.setAttribute("value", ct.getAtom("maName").element.value);
   		secondlevel.appendChild(thirdlevel);

   		thirdlevel = document.createElement("param");
  		thirdlevel.setAttribute("name", "maName");
   		thirdlevel.setAttribute("value", ct.getAtom("maName").element.options[ct.getAtom("maName").element.selectedIndex].text);
   		secondlevel.appendChild(thirdlevel);
   		
		  thirdlevel = document.createElement("param");
  		thirdlevel.setAttribute("name", "aisStatus");
   		thirdlevel.setAttribute("value", "0");
   		secondlevel.appendChild(thirdlevel);
   			
   		thirdlevel = document.createElement("param");
  		thirdlevel.setAttribute("name", "clientLevel");
   		thirdlevel.setAttribute("value", "7");
   		secondlevel.appendChild(thirdlevel);
   		
   		thirdlevel = document.createElement("param");
  		thirdlevel.setAttribute("name", "aisPeriod");
   		thirdlevel.setAttribute("value", "60000");
   		secondlevel.appendChild(thirdlevel);
   		
   		thirdlevel = document.createElement("param");
  		thirdlevel.setAttribute("name", "ccMac");
   		thirdlevel.setAttribute("value", "01-80-c2-00-00-30");
   		secondlevel.appendChild(thirdlevel);
   		
   		/**
   		 * DM          
   		 */
   		if (SpecialAttrMgr.isCPSupport(neid, slotid, "TE_FUNC_CFG_ETH_OAM", "OTN_ATTR_SUPPORT_DM_RESPONSE_MODE"))
   		{
   			thirdlevel = document.createElement("param");
   	  		thirdlevel.setAttribute("name", "dmrspmode");
   	   		thirdlevel.setAttribute("value", "0");
   	   		secondlevel.appendChild(thirdlevel);
   		}
   		
		firstlevel.appendChild(secondlevel);
		root.appendChild(firstlevel);
		createTableBody(win.st, win.window.tableconf[0], win.constructtbXML(EncapsulateData(root)), RESOURCE);
   		win.addCellListener(); 
		if (win.st.getDataRowLength() == 1)
		{
			var tc = win.st.getHeadCell("vlanid").element;
			win.st.sortRows(tc, 1);
		}
   		
   		var selectedIndexes = win.st.getSelectedRows();
   		for (var i = 0, m = selectedIndexes.length; i < m; i++)
   		{
   			win.st.setRowNoneSelect(selectedIndexes[i]);
		}
   		win.st.setRowSelect(win.st.getDataRowLength() - 1);
   		win.rowSelectHandler();
                
   		/**
   		 * DTS2013082500628
   		 *     OAM                  IP   WDM  MEP           
   		 */
   		win.refreshNode(win.st.getDataRowLength() - 1);
   		if (submitFlag)
   		{
   			xcloseDialog();
   		}
   		else
   		{
   			$("applybtn").disabled = false;
   		}
	}	 
}

function showErrorDialog(data)
{
	var errArr = [];
	errArr[0] = "mpid";
	var oError = data.getError();
    if(data.getBErrLength() > 0)
    {
    	for(var i = 0; i < data.getBErrLength(); i++)
        {
            var tempErrObjStr = "";
            if(null != oError.getRowKey(i, "mpid") && "" != oError.getRowKey(i, "mpid"))
            {
            	var mpid = oError.getRowKey(i, "mpid");
            	
                tempErrObjStr = RESOURCE["mpid"] + ":" + mpid.substring(0, 2) + "-" + mpid.substring(2,4) + "-" + mpid.substring(4);
            }      
			oError.rowErrors[i].errorObj["mpid"] = tempErrObjStr;
		}
	}
	openErrPage("../../../../../page/", oError, errArr);
}

function onblurHandler(event)
{
    if (!event) 
    {
        event = window.event;
    }
    var numobj = event.target ? event.target : event.srcElement;
    if (numobj.value == "") 
    {
        numobj.value = 1;
        return;
    }
    else if ((isNaN(numobj.value) && numobj.value != RESOURCE["nolimit"]) || numobj.value < 1) 
    {
        alert(RESOURCE["wrong"]);
        numobj.value = 1;
        return;
    }
}

function keyupHandler(event)
{
    if (!event) 
    {
        event = window.event;
    }
    var numobj = event.target ? event.target : event.srcElement;
    if (numobj.value > 4095) 
    {
        alert(RESOURCE["wrong"]);
        numobj.value = 4095;
        return;
    }
}

function keypressHandler(event)
{
    var key, keychar;
    if (!event) 
    {
        event = window.event;
        key = window.event.keyCode;
    }
    var numobj = event.target ? event.target : event.srcElement;
    
    var code = (event.keyCode != 0 ? event.keyCode : event.charCode);
    
    if (event.keyCode == 13) 
    {
        if (numobj.value == "") 
        {
            alert(RESOURCE["wrong"]);
            return false;
        }
        event.srcElement.blur();
        return true;
    }
    
    if (code == 8 || code == 46 || code == 37 || code == 39) 
    {
        return true;
    }
    
    if (code < 48 || code > 57) 
    {
        return false;
    }
    window.status = "code:" + code + "; value:" + numobj.value;
    var position = digitalTag_getPos(numobj);
    if (position == 0 && numobj.value.length > 0 && (code == 48 || code == 96)) 
    {
        return false;
    }
    
    if (numobj.value == '0' && position > 0) 
    {
        return false;
    }
    
    keychar = String.fromCharCode(key);
    if (numobj.value + keychar > 4095) 
    {
        alert(RESOURCE["wrong"]);
        numobj.value = 4095;
        return false;
    }
}

/**
 *        
 */
function alertDialog(min, max, stepLength)
{
	var alertStr = RESOURCE["wrong1"] + min + RESOURCE["wrong2"] + max + RESOURCE["oamwrong2"];
	alertStr = alertStr + RESOURCE["oamwrong1"] + "/(0xffff)" + RESOURCE["oamwrong3"];
	if (parseInt(stepLength) > 1)
	 	alertStr += RESOURCE["steplength"] + stepLength;
	alert(alertStr);
    return false;
}

function resizeComponentWidth()
{
	var comboboxDiv = ct.getAtom("vlanid").element.parent;
	if (comboboxDiv && comboboxDiv.view.parentNode && comboboxDiv.view.parentNode.offsetWidth > 0) 
    {
        var wdt = comboboxDiv.view.parentNode.offsetWidth - 2;
        var clip = "rect(1px," + (wdt - 1) + "px,19px," + (wdt - 18) + "px)";
        
        comboboxDiv.txtview.style.width = wdt;
        comboboxDiv.selview.style.width = wdt;
        comboboxDiv.txtview.style.top = getPosY(comboboxDiv.view.parentNode);
        comboboxDiv.selview.style.top = getPosY(comboboxDiv.view.parentNode);
        comboboxDiv.selview.style.clip = clip;
    }
}

ComboBox.prototype.initComboBox = function(ops, str, index, flag)
{
    this.setOptions(ops);
    this.name = str;
    this.id = str;
    this.dispval = flag;
    this.setSelectedIndex(index);
    
    if (this.view.parentNode && this.view.parentNode.offsetWidth > 0) 
    {
        var wdt = this.view.parentNode.offsetWidth - 2;
        var clip = "rect(1px," + (wdt - 1) + "px,19px," + (wdt - 18) + "px)";
        
        this.txtview.style.width = wdt;
        this.selview.style.width = wdt;
        this.txtview.style.top = getPosY(this.view.parentNode);
        this.selview.style.top = getPosY(this.view.parentNode);
        this.selview.style.clip = clip;
    }
}

function getDestRowIndex(res, vlanId, winSt)
{
    var sinkPortName = res.sinkPortName;
    var srcPortName = res.portName;
    var srcVlanId = vlanId;
    
    for(var i = 0; i < winSt.getDataRowLength(); i++)
    {        
        var destSrcPortName = winSt.getCellStoreValue(i, 'node', 'portname');
        var destSinkPortName = winSt.getCellStoreValue(i, 'sinkPortName', 'sinkPortName');
        var destVlanId = winSt.getCellStoreValue(i, 'vlanid', 'vlanid');

        if(srcPortName == destSrcPortName && sinkPortName == destSinkPortName && srcVlanId == destVlanId)
        {
            return i;
        }
    }
}
