/**
 *             
 */
function numCellOnBlur(obj,min,max,stepLength)
{
	blurValidate(obj,min,max,stepLength);
	
    var hc = obj.parentNode.parent.getHeadCell(obj.parentNode.colid);
    
    var pnode = obj.parentNode;
    
	if(pnode.editElement.type	== "select")
	{
        if(obj.selectedIndex	>	-1)
        {        	
            if("span" == obj.parentNode.showElement.type)
            {
                pnode.showElement.setValue(obj.options[obj.selectedIndex].text);	
            }
            else
            {
                pnode.showElement.setValue(obj.options[obj.selectedIndex].value);	
            }
            
            obj.parentNode.parent.setTdCellValue(obj.parentNode,hc.element.keys[0], obj.options[obj.selectedIndex].value);
        }
	}
	else
	{
	    
	    
	    obj.style.position="static";
        obj.style.border="1px solid #999999";
        obj.style.width=obj.parentNode.offsetWidth;    
		var rows= obj.parentNode.parent.getSelectedRows();
		for(var j=0; j<rows.length; j++)
        {
          var cell=  pnode.parent.getCell(rows[j],pnode.colid);	
          if(null == cell.element.editElement || cell.element.isEdit == 0)
          {
          	continue;
          }
          cell.element.showElement.setValue(obj.value);
          
          cell.element.modify = true;
          cell.element.parentNode.modify = true;
          cell.element.style.backgroundColor="#d0f946";
          cell.element.parent.setTdCellValue(cell.element, pnode.colid, obj.value);          
          cell.element.showElement.element.style.display	=	"";
          
          handleCellEdit(cell.element,TABLE_CONSTANT.AFTEREDIT); 
       }  
	}
	
	
    pnode.removeChild(pnode.lastChild);
	
    pnode.showElement.element.style.display	=	"";
  
    handleCellEdit(pnode,TABLE_CONSTANT.AFTEREDIT); 
}

/**
 *            
 */
function blurValidate(obj, min, max, stepLength)
{
    var containInegalChar = false;
    var pattern = /^[-.0-9]{1,15}$/;
    if(!pattern.test(obj.value))   
    {   
    	containInegalChar = true;
    }    
    
    if(containInegalChar||obj.value == ""||obj.value == "-")
    {
    	obj.value = min;
    	return alertDialog(min, max, stepLength);
    }
	
	if((min.indexOf(".") != -1||max.indexOf(".")!= -1)&&obj.value.indexOf(".") == -1)
	{
	    obj.value = obj.value + ".0";	
	}

		
	if(obj.value.charAt(obj.value.length-1) == ".")
	{
		obj.value = obj.value + "0";
	}
	
	var objValue;
	var minValue;
	var maxValue;
	if(min.indexOf(".") != -1||max.indexOf(".") != -1)
	{
		objValue = parseFloat(obj.value);
		minValue = parseFloat(min);
		maxValue = parseFloat(max);
	}
	else
	{
		objValue = parseInt(obj.value);
		minValue = parseInt(min);
		maxValue = parseInt(max);
	}
	
	if(objValue < minValue)
	{
		obj.value = min;
		return alertDialog(min, max, stepLength);
	}
	else if(objValue > maxValue)
	{
		obj.value = max;
		return alertDialog(min, max, stepLength);
	}
	else if(objValue%parseInt(stepLength) != 0)
	{
		obj.value = objValue - objValue%parseInt(stepLength);
		return alertDialog(min, max, stepLength);
	}
}

function digitalCheck(obj, min, max, stepLength)
{
   var code=(event.keyCode!=0?event.keyCode:event.charCode);

   var ch = String.fromCharCode(code);
	
	if(code==13)
	{
		blurValidate(obj, min, max, stepLength);
		event.srcElement.blur();
		return false;
    }
    
    if(code == 8 || code == 127)
    {
    	return true;   //DEL   
    }
    
    if(event.ctrlKey)
    {
        if(ch == 'X' || ch == 'C' || ch == 'A')
        {  //X C A
            return true;
        }
        else
        {
            return false;
        }
    }
    if(event.shiftKey)
    {
        return false;
    }
    

    var value=obj.value;
    pos=digitalTag_getPos(obj);
    
    if(code == 46)//    
	{
		if(min.indexOf(".") == -1&&max.indexOf(".") == -1)//          ,         
		{
			return false;
		}
		
		if(pos == 0)//           
		{
			return false;
		}
		
		if(value.indexOf(".") == -1)//         ,       
		{
			return true;
		}
		else
		{
			return false;
		}
		
		if(pos == 1)
		{
			if(value.charAt(0) == "-")//      ,           
			{
				return false;
			}
			else
			{
				return true;
			}
		}
	
	}
	
    if((value.charAt(0) == "0")&&(pos == 1))//    0    ,          
	{
		if(code == 46)
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	
	if((value.charAt(0) == "-")&&(value.charAt(1) == "0")&&(pos == 2))//    -0,         
	{
		if(code == 46)
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	
	if(value.charAt(pos-2) == "."||(value.charAt(pos-1) == "."&&value.charAt(pos) != ""))//          
	{
		return false;
	}
	
	if(code == 45)//  
	{
		if(min>=0)
		{
			return false;
		}
		
		if(pos == 0)//           
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	if((code==48) && (pos==0))
	{
		if(min.indexOf(".") == -1 )
		{
			if( min > 0)
			{
				obj.value = min;
				return alertDialog(min,max,stepLength);
			}
			else
			{
				if (value != "")
				{
					return false;
				}
				else
				{
					return true;
				}
			}
			
		}
		else
		{
			if(min >=1 ||max<0)
			{
				return false;
			}
		}
		return true;
	}

	if(code < 48 || code > 57 )
	{
		return false;  //      
	}

	if(code < 58)
	{
	   ch = '' + code - 48
	}
	else
	{
		ch = '' + code - 96
	}
	
    var newVal = value.substring(0,pos) + ch + value.substring(pos+selectionLen(obj));

    var len;
    var newValLength = newVal.replace(".","").length;
    if(min > 0)
    {
    	len = max.replace(".","").length;
    }
    else if(max <0)
    {
    	len = min.replace(".","").length;
    }
    if(newValLength < len)
    {
    	return true;
    }

    var tempValue;
	if(newVal.indexOf(".") == -1)
	{
		tempValue = parseInt(newVal,10);
	}else
	{
		tempValue = parseFloat(newVal,10);
	}
	
	if(tempValue > max)
	{
		obj.value = max;
	}
	else if(tempValue<min)
	{
		obj.value = min;
	}
	else if(tempValue%parseInt(stepLength) != 0)
	{
		obj.value = tempValue - tempValue%parseInt(stepLength);
	}
	else
	{
		return true;
	}
	obj.blur();
	
	return alertDialog(min, max, stepLength);
}

/**
 *        
 */
function alertDialog(min, max, stepLength)
{
	var alertStr = RESOURCE["wrong5"] + min + RESOURCE["wrong2"] + max + RESOURCE["wrong4"];
	if (parseInt(stepLength) > 1)
	 	alertStr += RESOURCE["steplength"] + stepLength;
	alert(alertStr);
    return false;
}

/**
 *     ,           1          
 */
function checkText(obj, min, max, stepLength)
{	
	obj.style.imeMode = "disabled";
	
	obj.onpaste = function()
	{
		return false;
	}
	
    obj.onblur = function()
	{
		blurValidate(obj, min, max, stepLength);
    }
    
    obj.onkeypress = function()
    {
        return digitalCheck(obj, min, max, stepLength);    	
    }
}

/**
 *     ,           1 
 */
function textCheck(obj, min, max, stepLength)
{
	obj.style.imeMode = "disabled";
	
	obj.onpaste = function()
	{
		return false;
	}
	
	obj.onblur = function()
	{
		numCellOnBlur(obj, min, max, stepLength);
    }
    
    obj.onkeypress = function()
    {
        return digitalCheck(obj, min, max, stepLength);    	
    }
}


function validateFormat(obj)
{
	var code=(event.keyCode!=0?event.keyCode:event.charCode);

    var ch = String.fromCharCode(code);
	
	if(code==13)
	{
		blurFormat(obj);
		event.srcElement.blur();
		return false;
    }
    if (code==8 || code==127)
    {
    	return false;
    }
    
    if(event.ctrlKey)
    {
        if(ch == 'X' || ch == 'C' || ch == 'A')
        {
            return true;
        }
        else
        {
            return false;
        }
    }
    	
	if (code == 45)
	{
		return true;
	}
	
	if(code < 48 || (code > 57 && code < 65) || (code > 70 && code < 97) || code > 102)
	{
		return false;
	}    
	
    var value=obj.value;					
    pos=digitalTag_getPos(obj);
	if (pos <= 9)
	{
		var ach = value.substring(pos, pos + 1);
		if (ach == "-")
		{
			if(isIE)
			{
				var rng = document.selection.createRange();					
				if (selectionLen(obj) > 0)
				{
					rng.moveEnd('character', -(selectionLen(obj) - 2));
					rng.text = "-" + ch;
					rng.select();						
				}
				else
				{
	  				rng.moveEnd('character',1);
	  				rng.text = "-";
	  			}
			}
			else
			{
				obj.selectionStart = pos + 1;
			}
		}
		else
		{
			var newVal = "";
			newVal = value.substring(0,pos) + ch + value.substring(pos+1);
			var nv = newVal.substring(0, 8);
			if (nv.toLowerCase() == "ff-ff-ff")
			{
				if (newVal.charAt(8) != "0" || newVal.charAt(9) != "0")
				{
					return false;
				}
			}
			if (isIE)
			{
				var rng = document.selection.createRange();					
				if (selectionLen(obj) > 0)
				{
					rng.moveEnd('character', -(selectionLen(obj) - 1));
					rng.text = "";
					rng.select();						
				}
				else
				{
	  				rng.moveEnd('character',1);
	  				rng.text = "";
	  			}		
			}
			else
			{
				var newVal = value.substring(0,pos) + ch + value.substring(pos+1);
				obj.value = newVal;
				obj.selectionEnd = pos + 1;
			}
		}
	}
}

function blurFormat(obj)
{
	var pattern = /^[a-f,A-Z,0-9][a-f,A-Z,0-9]-[a-f,A-Z,0-9][a-f,A-Z,0-9]-[a-f,A-Z,0-9][a-f,A-Z,0-9][a-f,A-Z,0-9][a-f,A-Z,0-9]$/;
   	var checker = pattern.test(obj.value);
   	if(!checker)
   	{
       	alert(RESOURCE["format"]);
       	obj.value="00-00-0000";
       	obj.focus();
       	return false;
   	}
   	else
   	{
       	return true;
   	}
}

function checkFormat(obj)
{
	obj.style.imeMode = "disabled";
	obj.maxLength = "10";
	
	obj.onpaste = function()
	{
		return false;
	}
	
	obj.onblur = function()
	{
		blurFormat(obj);
    }
    obj.onkeypress = function()
    {
        return validateFormat(obj);    	
    }
    
    obj.onkeydown="";
    
}

function checkSubmit(mpid,isStandardMp)
{
	var mpArr = mpid.toUpperCase().split("-");
	var mpid = hexToTen(mpArr[0] + mpArr[1] + mpArr[2]);
	
	if(isStandardMp)
	{
		if(mpid < MIN_MP_ID || mpid > MAX_STANDARDMP_ID)
		{
			alert(RESOURCE["standmpidslopover"]);
			return false;
		}
	}
	
	if (mpid < MIN_MP_ID || mpid > MAX_MP_ID)
	{
		alert(RESOURCE["mpidslopover"]);
		return false;
	}
	
	return true;
}

var MAX_STANDARDMP_ID = 0x00001FFF;
var MAX_MP_ID = 0xFFFFFF00;
var MIN_MP_ID = 0x00000001;


function checkValidateMAC(macStr)
{
	var macArr = macStr.toUpperCase().split("-");
	var mac = hexToTen(macArr[0] + macArr[1] + macArr[2] + macArr[3] + macArr[4] + macArr[5]);
	if (mac < MIN_MAC_ID || mac > MAX_MAC_ID)
	{
		alert(RESOURCE["macslopover"]);
		return false;
	}	
	return true;
}

var MAX_MAC_ID = 0x0180c200003f;
var MIN_MAC_ID = 0x0180c2000030;
