var resources = [];
var ct;

var submitFlag = false;
var mpLevel = 4;
var ccStatus = 0;
var lbTestTime = 5000;
var ltTestTime = 5000;
var ccPeriod = 5000;

var win = getParentWindow(); 
var neid = win["neid"];
var nmUser = win["nmUser"];
var slotid = win["slotid"];

function initPage()
{
	$("advancebtn").value = RESOURCE["advancebutton"];	
	$("enterbtn").value = RESOURCE["okbutton"];          
	$("cancelbtn").value = RESOURCE["cancelbutton"];
	$("applybtn").value = RESOURCE["applybutton"];
	
	initTable();
	initData();
}

function initTable()
{
	ct = new CTable();
	ct.addHead(RESOURCE["attribute"],RESOURCE["getvalue"]);

	var atom = new Atom("select");
	atom.element.style.width="100%";
	atom.element.onchange = linkageByNode;
	ct.addAttrRow("node", RESOURCE["node"], atom);

	atom = new Atom("select");
	atom.element.style.width="100%";
	ct.addAttrRow("vlanid", RESOURCE["vlanid"], atom);

	atom = new Atom("text");
	atom.element.setAttribute("maxLength", "10");
	atom.setValue("00-00-0000");
	checkFormat(atom.element);
	ct.addAttrRow("mpid", RESOURCE["mpid"], atom);

    atom = new Atom("select");
	atom.element.style.width="100%";
	atom.element.options[atom.element.options.length] = new Option(RESOURCE["mep"], 1);
	atom.element.options[atom.element.options.length] = new Option(RESOURCE["mip"], 2);
	atom.element.onchange = linkageByType;
	ct.addAttrRow("type", RESOURCE["type"], atom);

	atom = new Atom("select");
	atom.element.style.width="100%";
	ct.addAttrRow("direction", RESOURCE["direction"], atom);

	$("tablecomponent").appendChild(ct.getTable());
}

/*function autoGetMPID()
{
	var autoMpId = 1;
	for (var i = 0, m = win.st.getDataRowLength(); i < m; i++)
	{
		var mpidStr = win.st.getCellStoreValue(i, "mpid", "mpid").split("-");
		var mpid = hexToTen(mpidStr[0] + mpidStr[1] + mpidStr[2]);
		if (autoMpId <= MAX_MP_ID && autoMpId == mpid)
		{
			autoMpId ++;
		}
	}
	var strMpId = tenToHex(autoMpId);
	if (strMpId.length < 8)
	{
		var str = "";
		for (var j = 0, n = 8 - strMpId.length; j < n; j++)
		{
			str += "0";
		}
		strMpId = str + strMpId;
	}
	strMpId = strMpId.substring(0, 2) + "-" + strMpId.substring(2, 4) + "-" + strMpId.substring(4);
	return strMpId;
}*/

/**
 *              
 */
function  UsableResource()
{
	this.subrackName = null;
	this.slotId = null;
	this.boardName = null;
	this.portId = null;
	this.portName = null;
	this.vlanId = null;
}

function initData()
{
	var data = win.createResource;
	var elm = ct.getAtom("node").element;
	for (var i = 0, m = data.getDataRowLength(); i < m; i++)
	{		
		var resource = new UsableResource();
		var subrackName = data.getDataRowParam(i, "subrackname");
		resource.subrackName = subrackName;
		var slotId = data.getDataRowParam(i, "slot");
		resource.slotId = slotId;
		var boardName = data.getDataRowParam(i, "boardname");
		resource.boardName = boardName;
		var portId = data.getDataRowParam(i, "port");
		resource.portId = portId;
		var portName = data.getDataRowParam(i, "portname");	
		resource.portName = portName;	
		
		var vlanId = new Array();
		vlanId[vlanId.length] = data.getDataRowParam(i, "vlanid");
		mOption = data.getDataRowOptions(i, "vlanid");
		if (mOption != null)
		{
			for (var j = 0, n = mOption.length; j < n; j++)
			{
				vlanId[vlanId.length] = mOption[j];
			}
		}
		vlanId.sort(compareVlanID);
		resource.vlanId = vlanId;
		resources.push(resource);
		resources.sort(comparePortID);		
	}
	for (var j = 0, n = resources.length; j < n; j++)
	{
		var res = resources[j];
		var text = getSlotIDFromSlot(res.slotId) + "-" + res.boardName + "-" + res.portName;
		if ("" != res.subrackName)
		{
			text = subrackName + "-" + text;
		}
		elm.options[elm.options.length] = new Option(text, res.slotId + "-" + res.portId);			
	}
	linkageByNode();
}

function comparePortID(v1, v2)
{
	return parseInt(v1.portId) - parseInt(v2.portId);
}

function compareVlanID(v1, v2)
{
	var o1 = parseInt(v1.substring(v1.indexOf("-") + 1, v1.length));
	var o2 = parseInt(v2.substring(v2.indexOf("-") + 1, v2.length));
	return o1 - o2;
}

function linkageByNode()
{
	$("applybtn").diabled = false;
	var nodeStr = ct.getAtom("node").element.value;
	var arr = nodeStr.split("-");
	for (var i = 0, m = resources.length; i < m; i++)
	{
		if (resources[i].slotId == arr[0] && resources[i].portId == arr[1])
		{
			if (resources[i].vlanId.length <= 1)
			{
				var v = resources[i].vlanId[0].split("-");
				var em = ct.getAtom("vlanid").element;
				if (parseInt(v[1]) == 65535)
				{
					if (em.type != "text")
					{
						var atom = new Atom("text");
						atom.setValue("/");
						em.parentElement.replaceChild(atom.element, em);
						ct.attrArray["vlanid"] = atom;
						validataInput(atom.element);
					}
					else
					{
						ct.getAtom("vlanid").setValue("/");
					}
					var atom = new Atom("hidden");
					atom.setValue(v[0]);
					ct.addAttrRow("serviceid", "", atom);
				}
				else
				{
					if (em.type != "select-one")
					{
						var atom = new Atom("select");
						atom.element.style.width="100%";				
						atom.element.options[atom.element.options.length] = new Option(v[1], resources[i].vlanId[0]);	
						em.parentElement.replaceChild(atom.element, em);
						ct.attrArray["vlanid"] = atom;
					}
					else
					{
						em.options.length = 0;					
						em.options[em.options.length] = new Option(v[1], resources[i].vlanId[0]);
					}
				}
			}
			else
			{
				var em = ct.getAtom("vlanid").element;
				if (em.type != "select-one")
				{
					var atom = new Atom("select");
					atom.element.style.width="100%";
					for (var j = 0, n = resources[i].vlanId.length; j < n; j++)
					{		
						var v = resources[i].vlanId[j].split("-");			
						atom.element.options[atom.element.options.length] = new Option(v[1], resources[i].vlanId[j]);
					}					
					em.parentElement.replaceChild(atom.element, em);
					ct.attrArray["vlanid"] = atom;
				}
				else
				{
					em.options.length = 0;
					for (var j = 0, n = resources[i].vlanId.length; j < n; j++)
					{		
						var v = resources[i].vlanId[j].split("-");			
						em.options[em.options.length] = new Option(v[1], resources[i].vlanId[j]);
					}
				}
			}
		}
	}	
	linkageByType();
}

function validataInput(element)
{
	element.onblur = function()
	{
		if(element.value == "/")
		{
			return;
		}
		blurValidate(element, "1", "4095", "1");
    }
	
	element.onkeypress = function()
    {
    	var code=(event.keyCode!=0?event.keyCode:event.charCode);
   		var ch = String.fromCharCode(code);
   		var pos=digitalTag_getPos(element);
   		
   		if(element.value.indexOf("/") != -1&& (selectionLen(element) == 0))
   		{
   			return false;
   		}
   		
   		if(ch == '/')
   		{
   			if(selectionLen(element) == element.value.length || element.value=="")
   			{
				return true;   				
   			}
   		}
        return digitalCheck(element, "1", "4095", "1");    	
    }
}

function linkageByType()
{
	var elm = ct.getAtom("direction").element;
	elm.options.length = 0;
	var type = ct.getAtom("type").element.value;
	switch(parseInt(type))
	{
		case 1:
			var portType = ct.getAtom("node").element.value.split("-")[1];
			if (parseInt(portType) < 32768)
			{
				elm.options[elm.options.length] = new Option(RESOURCE["wdmdirection"], 1);
				elm.options[elm.options.length] = new Option(RESOURCE["ipdirection"], 2);
			}
			else
			{
				elm.options[elm.options.length] = new Option(RESOURCE["wdmdirection"], 2);
				elm.options[elm.options.length] = new Option(RESOURCE["ipdirection"], 1);
			}
			break;
		case 2:
			elm.options[elm.options.length] = new Option(RESOURCE["doubledirection"], 0);
			break;
		default:
			break;
	}
}

function clickAdvance()
{
	xshowModalDialog("advanceconfigure.html", RESOURCE["advanceconfiguretitle"], 400, 260, "../../../../../images/");
}

function createNewXML()
{
	var root = new inputxml("datainterface");
	var firstlevel = new tagElement("bussiness-params");
	
	var secondlevel = new tagElement("row-params");	
	var	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "neid");
	thirdlevel.setAttribute("value", neid);
	secondlevel.appendChild(thirdlevel);

	var slot_port = ct.getAtom("node").element.value.split("-");
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "slotid");
	thirdlevel.setAttribute("value", slot_port[0]);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "port");
	thirdlevel.setAttribute("value", slot_port[1]);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "servicetype");
	thirdlevel.setAttribute("value", 1);
	secondlevel.appendChild(thirdlevel);
	
	var mpid = ct.getAtom("mpid").element.value;
	var mpids = mpid.split("-");
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "mpid");
	thirdlevel.setAttribute("value", mpids[0] + mpids[1] + mpids[2]);
	secondlevel.appendChild(thirdlevel);
	
	var vlanId = 65535;
	var serviceId = 0;
	var vlan = ct.getAtom("vlanid").element;
	if (vlan.type == "text")
	{
		serviceId = ct.getAtom("serviceid").element.value;
		if (vlan.value != "/")
		{
			vlanId = vlan.value;
		}
	}
	else
	{
		var v = vlan.value.split("-");
		serviceId = v[0];
		vlanId = v[1];
	}
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "serviceid");
	thirdlevel.setAttribute("value", serviceId);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "vlanid");
	thirdlevel.setAttribute("value", vlanId);
	secondlevel.appendChild(thirdlevel);
	
	var mpType = ct.getAtom("type").element.value;
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "type");
	thirdlevel.setAttribute("value", mpType);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "direction");
	thirdlevel.setAttribute("value", ct.getAtom("direction").element.value);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "level");
	thirdlevel.setAttribute("value", mpLevel);
	secondlevel.appendChild(thirdlevel);
	
	if (parseInt(mpType) == 1)
	{
		thirdlevel = new tagElement("param");	
		thirdlevel.setAttribute("name", "ccstatus");
		thirdlevel.setAttribute("value", ccStatus);
		secondlevel.appendChild(thirdlevel);
	
		thirdlevel = new tagElement("param");	
		thirdlevel.setAttribute("name", "lbtesttime");
		thirdlevel.setAttribute("value", lbTestTime);
		secondlevel.appendChild(thirdlevel);
	
		thirdlevel = new tagElement("param");	
		thirdlevel.setAttribute("name", "lttesttime");
		thirdlevel.setAttribute("value", ltTestTime);
		secondlevel.appendChild(thirdlevel);
	
		thirdlevel = new tagElement("param");	
		thirdlevel.setAttribute("name", "ccperiod");
		thirdlevel.setAttribute("value", ccPeriod);
		secondlevel.appendChild(thirdlevel);
	}
		
	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);
	return root.toString();
}

function createOam()
{
	if ($("applybtn").disabled && submitFlag)
	{
		xcloseDialog();
	}
	if (checkSubmit(ct.getAtom("mpid").element.value))
	{
		var xml = createNewXML();
		var url = "../../../../../neExlorerServlet?sfid="+TECMDCODE_CREATE_OAMMP+"&nmUser=" + nmUser; 
		loadXMLdoc(url, "POST", false, callBackHandler, null, "inputdata=" + xml);
	}
}

function callBackHandler(doc)
{
	var data = EncapsulateData(doc);	
    showErrorDialog(data);
    if (0 == data.getSErrorCode() || 1 == data.getSErrorCode())
    {    
		var root = document.createElement("datainterface");      
  		var firstlevel = document.createElement("bussiness-params");
  	
  		var res = null;
  		var node = ct.getAtom("node").getValue();
		for (var j = 0, n = resources.length; j < n; j++)
		{
			res = resources[j];
			if (node == res.slotId + "-" + res.portId)
			{
				break;
			}
		}
  		
  		var secondlevel = document.createElement("row-params");
		var thirdlevel = document.createElement("param");
  		thirdlevel.setAttribute("name", "subrackname");
   		thirdlevel.setAttribute("value", res.subrackName);
   		secondlevel.appendChild(thirdlevel);
		
		thirdlevel = document.createElement("param");
  		thirdlevel.setAttribute("name", "slotid");
   		thirdlevel.setAttribute("value", getSlotIDFromSlot(res.slotId));
   		secondlevel.appendChild(thirdlevel);
   			
		thirdlevel = document.createElement("param");
  		thirdlevel.setAttribute("name", "boardname");
   		thirdlevel.setAttribute("value", res.boardName);
   		secondlevel.appendChild(thirdlevel);
   			
   		thirdlevel = document.createElement("param");
  		thirdlevel.setAttribute("name", "portname");
   		thirdlevel.setAttribute("value", res.portName);
   		secondlevel.appendChild(thirdlevel);

		var vlanId = 65535;
		var vlan = ct.getAtom("vlanid").element;
		if (vlan.type == "text")
		{
			vlanId = vlan.value;			
		}
		else
		{
			var v = vlan.value.split("-");
			vlanId = v[1];
		}
		
   		thirdlevel = document.createElement("param");
  		thirdlevel.setAttribute("name", "vlanid");
   		thirdlevel.setAttribute("value", vlanId);
   		secondlevel.appendChild(thirdlevel);

   		thirdlevel = document.createElement("param");
  		thirdlevel.setAttribute("name", "mpid");
   		thirdlevel.setAttribute("value", ct.getAtom("mpid").element.value);
   		secondlevel.appendChild(thirdlevel);
   			
   		thirdlevel = document.createElement("param");
  		thirdlevel.setAttribute("name", "type");
   		thirdlevel.setAttribute("value", ct.getAtom("type").element.value);
   		secondlevel.appendChild(thirdlevel);
   		
   		thirdlevel = document.createElement("param");
  		thirdlevel.setAttribute("name", "level");
   		thirdlevel.setAttribute("value", mpLevel);
   		secondlevel.appendChild(thirdlevel);
   		
   		thirdlevel = document.createElement("param");
  		thirdlevel.setAttribute("name", "direction");
   		thirdlevel.setAttribute("value", ct.getAtom("direction").element.value);
   		secondlevel.appendChild(thirdlevel);	  		 
    
		var oError = data.getError();
    	if(data.getBErrLength() > 0)
    	{
    		for(var i = 0; i < data.getBErrLength(); i++)
        	{
            	if(null != oError.getRowKey(i, "ccstatus") && "" != oError.getRowKey(i, "ccstatus"))
            	{
                	ccStatus = "0";
            	}
				if(null != oError.getRowKey(i, "lbtesttime") && "" != oError.getRowKey(i, "lbtesttime"))
            	{
            		lbTestTime = "5000";
            	}
            	if(null != oError.getRowKey(i, "lttesttime") && "" != oError.getRowKey(i, "lttesttime"))
            	{
            		ltTestTime = "5000";
            	}
            	if(null != oError.getRowKey(i, "ccperiod") && "" != oError.getRowKey(i, "ccperiod"))
            	{
            		ccPeriod = "5000";
            	}				
			}
		}
		
		thirdlevel = document.createElement("param");
  		thirdlevel.setAttribute("name", "ccstatus");
   		thirdlevel.setAttribute("value", ccStatus);
   		secondlevel.appendChild(thirdlevel);
   			
   		thirdlevel = document.createElement("param");
  		thirdlevel.setAttribute("name", "lbtesttime");
   		thirdlevel.setAttribute("value", lbTestTime);
   		secondlevel.appendChild(thirdlevel);
   		
   		thirdlevel = document.createElement("param");
  		thirdlevel.setAttribute("name", "lttesttime");
   		thirdlevel.setAttribute("value", ltTestTime);
   		secondlevel.appendChild(thirdlevel);
   		
   		thirdlevel = document.createElement("param");
  		thirdlevel.setAttribute("name", "ccperiod");
   		thirdlevel.setAttribute("value", ccPeriod);
   		secondlevel.appendChild(thirdlevel);
   		
		firstlevel.appendChild(secondlevel);
		root.appendChild(firstlevel);
		
		createTableBody(win.st, window.tableconf[0], win.constructtbXML(EncapsulateData(root)), RESOURCE);
   		win.addCellListener(); 
		if (win.st.getDataRowLength() == 1)
		{
			var tc = win.st.getHeadCell("vlanid").element;
			win.st.sortRows(tc, 1);
		}
   		
   		var selectedIndexes = win.st.getSelectedRows();
   		for (var i = 0, m = selectedIndexes.length; i < m; i++)
   		{
   			win.st.setRowNoneSelect(selectedIndexes[i]);
		}
   		win.st.setRowSelect(win.st.getDataRowLength() - 1);
   		win.rowSelectHandler();
   		if (submitFlag)
   		{
   			xcloseDialog();
   		}
   		else
   		{
   			$("applybtn").disabled = false;
   		}
	}	 
}

function showErrorDialog(data)
{
	var errArr = [];
	errArr[0] = "mpid";
	var oError = data.getError();
    if(data.getBErrLength() > 0)
    {
    	for(var i = 0; i < data.getBErrLength(); i++)
        {
            var tempErrObjStr = "";
            if(null != oError.getRowKey(i, "mpid") && "" != oError.getRowKey(i, "mpid"))
            {
            	var mpid = oError.getRowKey(i, "mpid");
            	
                tempErrObjStr = RESOURCE["mpid"] + ":" + mpid.substring(0, 2) + "-" + mpid.substring(2,4) + "-" + mpid.substring(4);
            }      
			oError.rowErrors[i].errorObj["mpid"] = tempErrObjStr;
		}
	}
	openErrPage("../../../../../page/", oError, errArr);
}
