

language = SYSTEMCONF.getLanguage();
ifdemo = SYSTEMCONF.getDemo();

var keyToResource = [];
keyToResource[1] = RESOURCE["portflow"];
keyToResource[2] = RESOURCE["portvlanflow"];
keyToResource[3] = RESOURCE["portsvlan"];
keyToResource[4] = RESOURCE["portcsvlan"];
keyToResource[5] = RESOURCE["portvlanpri"];
keyToResource[6] = RESOURCE["labelflow"];
keyToResource[7] = RESOURCE["explabelflow"];
keyToResource[8] = RESOURCE["portsvlanpri"];

document.write("<title>"+RESOURCE["newflow"]+"</title>");

 var win = getParentWindow();
 var min=1;
 var max=4094;
 var max_tbe=4095;
 var addTable = new CTable(); 

 var obj = getNeProperty(getParentWindow().parent);
 var neid = obj["neid"];  
 var slotid = obj["slotid"];   
 var boardType = obj["boardType"]; 
 var subFlag = true;

 

 function checksubmit()
 {
   if(!win.checkPort(addTable.getAttrValue("port")))
   {
   	 alert(RESOURCE["changeport"]);
   	 return false;
   }
   return true;
 }
 

 function getLabel()
{
	var root = new inputxml("datainterface");//Create the root of a xml file
	var firstlevel = new tagElement("bussiness-params");
	var secondlevel = new tagElement("row-params");
	
	var thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","neid");
	thirdlevel.setAttribute("value",neid);
	secondlevel.appendChild(thirdlevel);
	
	var thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","slotid");
	thirdlevel.setAttribute("value",slotid);
	secondlevel.appendChild(thirdlevel);
	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);
	
	var xml = root.toString();
	var URL = "../../../../../neExlorerServlet?sfid="+TECMD_ETHN_QUERY_TUNNEL+"&flag=1"+"&nmUser="+obj["nmUser"];    
	loadXMLdoc(URL,"POST",false,getLabelHandleBack,null,"inputdata="+xml);
}

function getPort()
{
	var root = new inputxml("datainterface");//Create the root of a xml file
	var firstlevel = new tagElement("bussiness-params");
	var secondlevel = new tagElement("row-params");
	
	var thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","neid");
	thirdlevel.setAttribute("value",neid);
	secondlevel.appendChild(thirdlevel);
	
	var thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","slotid");
	thirdlevel.setAttribute("value",slotid);
	secondlevel.appendChild(thirdlevel);
	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);
	
	var xml = root.toString();
	var URL = "../../../../../neExlorerServlet?sfid="+TECMDCODE_NF_ETHER_TRAIL_GETPORTINFO+"&flag=1"+"&nmUser="+obj["nmUser"];    
	loadXMLdoc(URL,"POST",false,getPortHandleBack,null,"inputdata="+xml);
}

function getLabelHandleBack(doc)
{
	var data = EncapsulateData(doc);
	if(data.getSErrorCode() == 0)
	{
		var atom = addTable.getAtom("labelid");
		atom.removeAllOptions();
		for(var i = 0,size = data.getDataRowLength();i < size;i++)
		{
			var option = new Option(data.getDataRowParam(i,"inLabel"),data.getDataRowParam(i,"inLabel"));
			atom.element.options[atom.element.options.length]= option;
		}
	}
	else
	{
		
	}
}

var portList = new Array(); //       
function getPortHandleBack(doc)
{
	var data = EncapsulateData(doc);
	if(data.getSErrorCode() == 0)
	{
		var atom = addTable.getAtom("port");
		for(var i = 1,size = data.getDataRowLength();i < size;i++)
		{
			var option = new Option(data.getDataRowParam(i,"portName"),data.getDataRowParam(i,"portNO"));
			atom.element.options[atom.element.options.length]= option;
			portList.push(option);
		}
	}
	else
	{
		var errArr = [];
    errArr[0] = "slotID";
    openErrPage("../../../../../page/", data.getError(), errArr);
	}
}



function init()
{
    SpecialAttrMgr.getCPFunInfo(neid, slotid, 'TE_FUNC_CFG_ETH_QOS');
    
    addTable.addHead(RESOURCE["attribute"],RESOURCE["value"]);
    document.body.insertBefore(addTable.getTable(), document.getElementById("addtable"));
    var flowTypeAtom = new Atom("select");
   
    if(SpecialAttrMgr.isCPSupport(neid, slotid, 'TE_FUNC_CFG_ETH_QOS', 'FLOWMGR_FLOWTYPES_SUPPORT_CUSTOMRANGE'))
    {
        addOptionsByConfigModel(neid, slotid, 'TE_FUNC_CFG_ETH_QOS', 'FLOWMGR_FLOWTYPES_SUPPORT_CUSTOMRANGE', flowTypeAtom.element, keyToResource);
    } 
    else 
    {
        var flowTypeOptions = flowTypeAtom.element.options;
        flowTypeOptions[0] = new Option(RESOURCE["portflow"],1);
        flowTypeOptions[flowTypeOptions.length] = new Option(RESOURCE["portvlanflow"],2);
		flowTypeOptions[flowTypeOptions.length] = new Option(RESOURCE["portsvlan"],3);
		if(boardType == "2109" || boardType == "2110" )//EGSH/LEX4/LEM24  
        {
            flowTypeOptions[flowTypeOptions.length] = new Option(RESOURCE["portcsvlan"],4);
            flowTypeOptions[flowTypeOptions.length] = new Option(RESOURCE["portvlanpri"],5);
            flowTypeOptions[flowTypeOptions.length] = new Option(RESOURCE["labelflow"],6);
            flowTypeOptions[flowTypeOptions.length] = new Option(RESOURCE["explabelflow"],7);
        }
        else if(boardType == "1557" ||boardType == "2217")
        {
	  	    flowTypeOptions[flowTypeOptions.length] = new Option(RESOURCE["portcsvlan"],4);
	  	    flowTypeOptions[flowTypeOptions.length] = new Option(RESOURCE["portvlanpri"],5);
	  	    flowTypeOptions[flowTypeOptions.length] = new Option(RESOURCE["labelflow"],6);
	  	    flowTypeOptions[flowTypeOptions.length] = new Option(RESOURCE["explabelflow"],7);
        }
        else if(boardType == "2292") //LEM18,  R6   51TEM28          
        {
	  	    flowTypeOptions[flowTypeOptions.length] = new Option(RESOURCE["portcsvlan"],4);
	  	    flowTypeOptions[flowTypeOptions.length] = new Option(RESOURCE["portvlanpri"],5);
        }
    }
  
    if(isLagerBoard())
    {
    	max=max_tbe;
    }

    addTable.addAttrRow("flowType",RESOURCE["flowvalue"],flowTypeAtom);
	
    var vbidAtom = new Atom("text");
    addTable.addAttrRow("vbid",RESOURCE["vbid"],vbidAtom);
    vbidAtom.setValue("-");
    vbidAtom.element.disabled = true;

    var portAtom = new Atom("select");
    addTable.addAttrRow("port",RESOURCE["port"],portAtom);
    getPort();
    portAtom.element["onchange"] = function()
    {
    	document.getElementById("applybtn").disabled = false;
    }
  
    var labelAtom = new Atom("select");
    addTable.addAttrRow("labelid","Label ID",labelAtom);
    labelAtom.addOption("-");  
    labelAtom.element.disabled = true;

  var vlanIDAtom = new Atom("text");
  vlanIDAtom.element.onblur = isValidateSrcVlan;
  vlanIDAtom.element.onkeypress = vlanObject_onkeypress;
  
  vlanIDAtom.element["onchange"] = function()
  {
	  document.getElementById("applybtn").disabled = false;
  }
  addTable.addAttrRow("vlanID",RESOURCE["vlanid"],vlanIDAtom);
  vlanIDAtom.setValue("-");
  vlanIDAtom.element.disabled = true;

  var svlanIDAtom = new Atom("text");
  svlanIDAtom.element.onblur = isValidateSrcVlan;
  svlanIDAtom.element.onkeypress = vlanObject_onkeypress;  
  svlanIDAtom.element["onchange"] = function()
  {
	  document.getElementById("applybtn").disabled = false;
  }
  addTable.addAttrRow("svlanID",RESOURCE["svlanID"],svlanIDAtom);
  svlanIDAtom.setValue("-");
  svlanIDAtom.element.disabled = true;

  var priorityAtom = new Atom("select");
  addTable.addAttrRow("priority",RESOURCE["priority"],priorityAtom);
  priorityAtom.addOption("-");
  for(var j = 0 ;j<=7 ;j++)
  {
      priorityAtom.addOption(j,j);
  }
  priorityAtom.element.disabled = true;
  
   var expAtom = new Atom("select");
  addTable.addAttrRow("EXP","EXP",expAtom);
  expAtom.addOption("-");
  for(var j = 0 ;j<=7 ;j++)
  {
      expAtom.addOption(j,j);
  }
  expAtom.element.disabled = true;
  
  document.getElementById("confirmbtn").value=RESOURCE["okbutton"];
	document.getElementById("cancelbtn").value=RESOURCE["cancelbutton"];
	document.getElementById("applybtn").value=RESOURCE["applybutton"];
	
  flowTypeAtom.element["onchange"] = function()
  {
	  changeFlowType();
  }	
}

 function changeFlowType()
 {
 	 var flowType = addTable.getAttrValue("flowType");
 	 var vlanIDAtom = addTable.getAtom("vlanID");
 	 var sVlanIDAtom = addTable.getAtom("svlanID");
 	 var priorityAtom = addTable.getAtom("priority");
 	 var vlanidspan = addTable.getTable().childNodes[1].childNodes[4].firstChild.firstChild;
 	 var vbAtom = addTable.getAtom("vbid");
 	 var portAtom = addTable.getAtom("port");
 	 var labelAtom = addTable.getAtom("labelid");
 	 var expAtom = addTable.getAtom("EXP");
 	 
 	 switch(flowType)
 	 {
 	 	 case "1":
 	 	 {
 	 	 	 addTable.attrName["vlanID"] = RESOURCE["vlanid"];
 	 	 	 vlanidspan.innerHTML = RESOURCE["vlanid"];
 	 	 	 
 	 	 	 setTextAtomValue(vlanIDAtom);
 	 	 	 setTextAtomValue(sVlanIDAtom);
 	 	 	 setAtomInvalid(priorityAtom);
 	 	 	 setAtomInvalid(labelAtom);
 	 	 	 setAtomInvalid(expAtom);
 	 	 	 
	         handlePortAtomValue(portAtom);
 	 	 	 break;	 	 	 
 	 	 }
 	 	 
 	 	 case "2":
 	 	 {
	 	 	 addTable.attrName["vlanID"] = RESOURCE["vlanid"];
	 	 	 vlanidspan.innerHTML = RESOURCE["vlanid"];
	  	     vlanIDAtom.element.disabled = false;
	  	     vlanIDAtom.setValue("1"); 
	         handlePortAtomValue(portAtom);
	         
	         setTextAtomValue(sVlanIDAtom);
	         setAtomInvalid(labelAtom);
	 	 	 setAtomInvalid(priorityAtom);
	 	 	 setAtomInvalid(expAtom);
 	 	 	 break;		     	 	 	   
 	 	 }
 	 	 case "3":
 	 	 {	 	   
 	 	 	 addTable.attrName["vlanID"] = RESOURCE["cvlanID"];
 	 	 	 vlanidspan.innerHTML = RESOURCE["cvlanID"];
	         sVlanIDAtom.element.disabled = false;
	         sVlanIDAtom.setValue("1"); 
 	 	 	 
 	 	 	 handlePortAtomValue(portAtom);
 	 	 	 
 	 	 	 setTextAtomValue(vlanIDAtom);
	         setAtomInvalid(labelAtom);
	 	 	 setAtomInvalid(priorityAtom);
	 	 	 setAtomInvalid(expAtom);
 	 	 	 break;		 	 	    
 	 	 }
 	 	 
 	 	 case "4":
 	 	 {
 	 	 	 addTable.attrName["vlanID"] = RESOURCE["cvlanID"];
 	 	 	 vlanidspan.innerHTML = RESOURCE["cvlanID"];
 	 	 	 vlanIDAtom.element.disabled = false;
 	 	 	 vlanIDAtom.setValue("1");  	 	 	
 	 	 	 sVlanIDAtom.element.disabled = false;
 	 	 	 sVlanIDAtom.setValue("1"); 
 	 	 	 
 	 	 	 handlePortAtomValue(portAtom);
 	 	 	 
 	 	 	 setAtomInvalid(labelAtom);
	 	 	 setAtomInvalid(priorityAtom);
	 	 	 setAtomInvalid(expAtom);
 	 	 	
 	 	 	 break;	
 	 	 	 
 	 	 }
 	 	 
 	 	 case "5":
 	 	 {
 	 	 	 addTable.attrName["vlanID"] = RESOURCE["vlanid"];
 	 	 	 vlanidspan.innerHTML = RESOURCE["vlanid"];
 	 	 	 vlanIDAtom.element.disabled = false;
 	 	 	 vlanIDAtom.setValue("1");
 	 	 	 priorityAtom.element.disabled = false;
 		 	 priorityAtom.removeAllOptions();
 		 	 for(var j = 0 ;j<=7 ;j++)
	         {
	             priorityAtom.addOption(j,j);
	         }
 	 	 	 priorityAtom.element.options[0].selected = true; 
 	 	 	   
 	 	 	 handlePortAtomValue(portAtom);
 	 	 	 
 	 	 	 setTextAtomValue(sVlanIDAtom);
	 	 	 setAtomInvalid(labelAtom);
	 	 	 setAtomInvalid(expAtom);
 	 	 	 break;		 	 	      
 	 	 }
 	 	 
 	 	 case "6":
 	 	 {
 	 	 	 vbAtom.element.disabled = true;
 	 	 	 getLabel();
 	 	 	 labelAtom.element.disabled = false; 
 	 	 	 setTextAtomValue(vlanIDAtom);
 	 	 	 setTextAtomValue(sVlanIDAtom);
 	 	 	 setAtomInvalid(priorityAtom);
 	 	 	 setAtomInvalid(portAtom);
 	 	 	 setAtomInvalid(expAtom);
 	 	 	 break;		 		 	 	      
 	 	 }
 	 	 case "7":
 	 	 {
 	 	 	 vbAtom.element.disabled = true;
 	 	 	 setTextAtomValue(vlanIDAtom);
 	 	 	 setTextAtomValue(sVlanIDAtom);
 	 	 	 expAtom.element.disabled = false;	 	 	  
 	 	 	 expAtom.setValue("0");
			 expAtom.removeAllOptions();
 		 	 for(var j = 0 ;j<=7 ;j++)
	         {
	             expAtom.addOption(j,j);
	         }
			 expAtom.element.options[0].selected = true;
 	 	 	 getLabel();
 	 	 	 labelAtom.element.disabled = false; 
             setAtomInvalid(portAtom);
             setAtomInvalid(priorityAtom);
 	 	 	 break;		 		 	 	      
 	 	 }
 	 	 case "8":
 	 	 {
 	 		 addTable.attrName["vlanID"] = RESOURCE["cvlanID"];
 	 	 	 vlanidspan.innerHTML = RESOURCE["cvlanID"];
 	 	 	 vlanIDAtom.element.disabled = false;
 	 	 	 vlanIDAtom.setValue("1");	 	 	
 	 	 	 sVlanIDAtom.element.disabled = false;
 	 	 	 sVlanIDAtom.setValue("1"); 
	 	 	 handlePortAtomValue(portAtom);
	 	 	 
	 	 	 priorityAtom.element.disabled = false;
 		 	 priorityAtom.removeAllOptions();
 		 	 for(var j = 0 ;j<=7 ;j++)
	         {
	             priorityAtom.addOption(j,j);
	         }
 	 	 	 priorityAtom.element.options[0].selected = true; 
 	 	 	 
	 	 	 setAtomInvalid(labelAtom);
	 	 	 setAtomInvalid(expAtom);
	 	 	 break;	
 	 	 }
	 }

   document.getElementById("applybtn").disabled = false;
 }
 
function setTextAtomValue(invalidAtom)
{
	invalidAtom.element.disabled = true;
	invalidAtom.setValue("-");  
}
function setAtomInvalid(invalidAtom)
{
	invalidAtom.element.disabled = true;
	invalidAtom.element.options.length = 0;
	invalidAtom.element.options[0] = new Option("-", "-");
}
 
function handlePortAtomValue(portAtom)
{
	if (portAtom.getValue() == "-")
 	{
		portAtom.element.disabled = false;
		portAtom.element.options.length = 0;
		for (var i = 0, len = portList.length; i < len; i++)
		{
			portAtom.element.options[portAtom.element.options.length] = portList[i];
		}
 	}
}

function sendCreateInfo(ifdemo)
{
  if(checksubmit())
  {
      addFlow();//Send request
  }
}

function createNewFlowXML()
{
	var root = new inputxml("datainterface");//Create the root of a xml file
	var firstlevel = new tagElement("bussiness-params");
	var flowTypeValue=addTable.getAttrValue("flowType");
	var CVlans = [-1];
	var SVlans = [-1];
	if(flowTypeValue == "2" || flowTypeValue == "5" || flowTypeValue == "4")
	{
		var vlanIDValue = addTable.getAttrValue("vlanID");
		CVlans = getVlanRange(vlanIDValue);
		if(CVlans == null)
		{
			alert(RESOURCE["not_empty"]);
			return "";
		}
		if(!isValidateVlan(addTable.getAtom("vlanID").element))
		{
			return "";
		}
	}
	if (flowTypeValue == "8") // port+cvlan+svlan+pri
	{
		var vlanIDValue = addTable.getAttrValue("vlanID");
		CVlans = getVlanRange(vlanIDValue);
		if (CVlans == null)
		{
			CVlans = [65535];
		}
	}
	if(flowTypeValue == "3" || flowTypeValue == "4" || flowTypeValue == "8")
	{
		vlanIDValue = addTable.getAttrValue("svlanID");
		SVlans = getVlanRange(vlanIDValue);
		if(!isValidateVlan(addTable.getAtom("svlanID").element))
		{
			return "";
		}
		if(flowTypeValue == "3")
		{
			CVlans = SVlans;
		}
		if(CVlans == null)
		{
			alert(RESOURCE["not_empty"]);
			return "";
		}
		else if(CVlans.length != SVlans.length)
		{
			alert(RESOURCE["srcVlanSnk"]);
			return "";
		}
		
	}
	var flowid = win.getQosMinAvailableID(1,65535,"flowid","flowid");
	for(var i = 0,len = CVlans.length;i < len;i++)
	{
		var secondlevel = new tagElement("row-params");
		var thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name","neid");
		thirdlevel.setAttribute("value",neid);
		secondlevel.appendChild(thirdlevel);
		
		if (i == 0) //      CVLAN SVLAN    
		{
			var thirdlevel = new tagElement("param");
			thirdlevel.setAttribute("name","vlanIDLog");
			thirdlevel.setAttribute("value",addTable.getAttrValue("vlanID"));
			secondlevel.appendChild(thirdlevel);
			
			var thirdlevel = new tagElement("param");
			thirdlevel.setAttribute("name","svlanIDLog");
			thirdlevel.setAttribute("value",addTable.getAttrValue("svlanID"));
			secondlevel.appendChild(thirdlevel);
		}
		
		var thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name","slotid");
		thirdlevel.setAttribute("value",slotid);
		secondlevel.appendChild(thirdlevel);
		
		var thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name","flowid");
		
		thirdlevel.setAttribute("value",flowid + i);
		secondlevel.appendChild(thirdlevel);
		
		var thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name","flowType");
		
		thirdlevel.setAttribute("value",flowTypeValue);
		secondlevel.appendChild(thirdlevel);
		
		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name","portid");
		var portId = addTable.getAttrValue("port");
		thirdlevel.setAttribute("value",portId);
		secondlevel.appendChild(thirdlevel);
	
		if(flowTypeValue == "2" || flowTypeValue == "5")
		{
			thirdlevel = new tagElement("param");
			thirdlevel.setAttribute("name","vlanID");
			thirdlevel.setAttribute("value",CVlans[i]);
			secondlevel.appendChild(thirdlevel);	 	 
		}
		else if(flowTypeValue == "3" || flowTypeValue == "4" || flowTypeValue == "8")
		{
			thirdlevel = new tagElement("param");
			thirdlevel.setAttribute("name","cvlanid");
			thirdlevel.setAttribute("value",CVlans[i]);
			secondlevel.appendChild(thirdlevel);	
			
			thirdlevel = new tagElement("param");
			thirdlevel.setAttribute("name","svlanid");
			thirdlevel.setAttribute("value",SVlans[i]);
			secondlevel.appendChild(thirdlevel);       	  
		}
		else if(flowTypeValue == "6" || flowTypeValue == "7")
		{
			thirdlevel = new tagElement("param");
			thirdlevel.setAttribute("name","label");
			var labelId = addTable.getAttrValue("labelid");
			thirdlevel.setAttribute("value",labelId);
			secondlevel.appendChild(thirdlevel);
			
			if(labelId == null || labelId == "")
			{
				return "";
			}
		}

		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name","pri");
		var priorityValue = addTable.getAttrValue("priority");
		thirdlevel.setAttribute("value",priorityValue);
		secondlevel.appendChild(thirdlevel);
		
		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name","exp");
		var priorityValue = addTable.getAttrValue("EXP");
		thirdlevel.setAttribute("value",priorityValue);
		secondlevel.appendChild(thirdlevel);
	
		firstlevel.appendChild(secondlevel);
	}
	root.getRoot().appendChild(firstlevel);
	return root.toString();
}

function checkVlanIDValue(vlanIDValue)
{
	if(vlanIDValue=="")
	{
		var str = RESOURCE["not_empty"];
		alert(str);
		return false;
    }
	return true;
}

function sendCreateInfo()
{
    var labId = addTable.getAtom("labelid").element;
    if(!labId.disabled)
    {
        if(labId.selectedIndex == -1)
        {
            alert(RESOURCE["servicenotexist"]);
            return;
        }
    }

    document.getElementById("confirmbtn").disable = true;
    document.getElementById("applybtn").disable = true;
    var xml = createNewFlowXML();  
    
    if(xml == "")
    {
    	return;
    } 
    var aURL = "../../../../../neExlorerServlet?sfid="+TE_ETHER_CREATE_FLOW+"&flag=1"+"&nmUser="+obj["nmUser"];   
    if(subFlag)
    {
    	loadXMLdoc(aURL,"POST",false,addHandleBack,null,"inputdata="+xml);  
      document.getElementById("confirmbtn").disable = false;
    }
}

function addHandleBack(doc)
{
  var data = EncapsulateData(doc);
  if(data.getSErrorCode() != 0)
  {
  	document.getElementById("applybtn").disabled = false;
  	for(var i = 0,len = data.getError().rowErrors.length;i < len;i++)
  	{
	  	if(data.getError().rowErrors[i])
	  	{
	  		var tempObj = data.getError().rowErrors[i].errorObj;
	  		tempObj["slotid"] = RESOURCE["slot"] + tempObj["nename"] + "-" + getSlotIDFromSlot(tempObj["slotid"]);
			tempObj["slotid"] += "-" + tempObj["boardname"];
	  		tempObj["flowid"] = RESOURCE["flowid"] + tempObj["flowid"];
	  	}
  	}
    var errArr = [];
    errArr[0] = "slotid";
    errArr[1] = "flowid";
    openErrPage("../../../../../page/", data.getError(), errArr);
  }
  if(data.getSErrorCode() == 0 || data.getSErrorCode() == 1)
  {
  	win.query();
  	if(submitflag && data.getSErrorCode() == 0)
  	{
  		document.getElementById("applybtn").disabled = true;
  		xcloseDialog();
    }
  }
}

/**
 *       CTable
 *                
 * @param  
 * @return  
 */
function checkAtomNumEvent(atom,minvalue,maxvalue,defaultvalue)
{
	atom.style.imeMode = "disabled";
	if(null == defaultvalue)
	{
		defaultvalue = minvalue;
	}
	atom.onpaste = function()
	{
		return false;
	}

	atom["onblur"] = function()
	{	
		if(!checkDataRange(this,minvalue,maxvalue))
		{
			this.value = defaultvalue;
		}	
	}
	
	atom["onkeydown"] = function()
	{				
		return digitalTag_checkDown(this,minvalue,maxvalue,checkDataRange);
	}
}

/**
 *                      MAX      
 * submitfunc          ,      ,           ''
 */
function digitalTag_checkDown(obj,min, max, submitfunc, maxalertflag, resource, alertstr)
{
    var code=event.keyCode;
    var ch = String.fromCharCode(code);
    if(code==13){
        event.srcElement.blur();
    return true;	
    }
    
    if(code == 8 || code == 46 || code == 9){
    	return true;   //DEL   
    }
    if(code > 36 && code < 41){
        return true;        //   
    }
    if(event.ctrlKey){
        if(ch == 'X' || ch == 'C' || ch == 'V' || ch == 'A'){  //X C V A
            return true;
        }
        else{
            return false;
        }
    }
    if(event.shiftKey){
        return false;
    }
    if(code < 48 || (code > 57 && code < 96 ||code > 105)){
        return false;  //   
    }
    var value=obj.value;
    pos=digitalTag_getPos(obj);                 //        
    if((value.length == 0) && (pos==0) ){
        return true;
    }
    
    if(pos == 0 && value.length > 0 && (code == 48 || code == 96) ){ 
        return false;
    }
    if(value=='0' && pos>0){
        return false;
    }
    
    if(code < 58){
        ch = '' + code - 48
    }
    else{
        ch = '' + code - 96
    }
    var SelectChars=document.selection.createRange().text;
    var endleng=0
    if(SelectChars!=null&&SelectChars.length==null){
        endleng=1
    }
    if(SelectChars!=null&&SelectChars.length!=null){
        endleng=SelectChars.length
    }
    
    var newVal = value.substring(0,pos) + ch + value.substring(pos+endleng);
    if(parseInt(newVal,10) > max){
    	if(maxalertflag && resource && alertstr){
    	    alert(resource[alertstr]);
    	    return false;
        }else
      	{
      		  obj.value = max;
   	        var alertStr = RESOURCE["wrong1"] + min + RESOURCE["wrong2"] + max + RESOURCE["wrong3"];
		        alert(alertStr);
      			return false;        		
      	}        
    }    
    return true;
}
