

var language=SYSTEMCONF.getLanguage();


var funID = "flow";
var funName = "flowid";

var flowtype = new Object();
flowtype["1"] = "portflow";
flowtype["2"] = "portvlanflow";
flowtype["3"] = "portsvlan";
flowtype["4"] = "portcsvlan";
flowtype["5"] = "portvlanpri";
flowtype["6"] = "labelflow";
flowtype["7"] = "explabelflow";
flowtype["8"] = "portsvlanpri";

var convertStatenable = new Object();
convertStatenable["1"] =  RESOURCE["enabled"];
convertStatenable["0"] =  RESOURCE["disabled"];
convertStatenable["-1"] =  "-";

var obj = getNeProperty(top); 
var parentObj = getNeProperty(parent); 

var boundinfo;//       car/cos     
var boundInfoArr = new Array();

function convertPort(v)
{
	if (v == "-")
	{
		return v;
	}
	else if (v > 32768)
	{
		return "VCTRUNK" + (v - 32768);
	}
	else
	{
		return "PORT" + v;
	}
}

function clearStat()
{
	 var URL = "../../../../../neExlorerServlet?sfid="+654322+"&flag=1"+"&nmUser="+obj["nmUser"];//  JAVABEAN       TENEExplorerServlet web.xml   
  
  
  var root = new inputxml("datainterface");
  firstlevel = new tagElement("bussiness-params");
  selectedRows = st.getSelectedRows();
  for(var i = 0;i < selectedRows.length;i++)
  {
    var secondlevel = new tagElement("row-params");
    var thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","neid");
    thirdlevel.setAttribute("value",parent.neid);
    secondlevel.appendChild(thirdlevel);

    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","slotid");
    thirdlevel.setAttribute("value",parent.slotid);
    secondlevel.appendChild(thirdlevel);

    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","flowid");
    var flowid = st.getCellStoreValue(selectedRows[i],"flowid","flowid");//       id
    thirdlevel.setAttribute("value",flowid);//  id
    secondlevel.appendChild(thirdlevel);
    
    firstlevel.appendChild(secondlevel);
  }
  root.getRoot().appendChild(firstlevel);
  var xml = root.toString();
  
  loadXMLdoc(URL,"POST",false,clearHandleBack,null,"inputdata="+xml);
}


function clearHandleBack(doc)
{
  $("clearbtn").disabled = true; 
  var data = EncapsulateData(doc);//      
  if(data.getSErrorCode() != "0")
  {
 	 	showErrorDialog(data,funName,RESOURCE[funName]);//    
 	}
  query();//    
}


function init()
{
  st.setImage("../../../../../images/");
  var tc = window.tableconf[0];
	tc.colArray[tc.getIndexByid("vlanid")].width = 0;
	tc.colArray[tc.getIndexByid("boundShaping")].width = 0;

  createTableHead(st, window.tableconf[0]);

  st.setOnCellEditHandler(cellEditHandler);
  st.setOnRowSelectHandler(tableSelectHandler);
  document.getElementById("flowtable").appendChild(st.getTable());
  st.setBodyHeight(getComponetHeight($("flowtable"), 86)+"px");
  st.element.oncontextmenu=popupMenuHandl;	
  initBtn();
  
  btnRightArr.querybtn = new BtnRightObj("querybtn",TE_ETHER_QUERY_FLOW);    
  btnRightArr.newbtn = new BtnRightObj("newbtn",TE_ETHER_CREATE_FLOW);    
  btnRightArr.applybtn = new BtnRightObj("applybtn",TE_ETHER_SET_FLOW);    
  btnRightArr.deletebtn = new BtnRightObj("deletebtn",TE_ETHER_DEL_FLOW);    
  sendRightInfo(btnRightArr);  
    
  initBtnStatue(); 
  if(!$("querybtn").disabled)
  {
     query();
  }
  boundinfo = document.getElementById("boundinfo");
  
  $("clearbtn").value = RESOURCE["clearbtn"];
  $("clearbtn").disabled = true; 
}
/**
 *          ID      
 * @return
 */
function selectedURLServiceID()
{
	var objId = parentObj.objId;
    if(typeof(objId) != "undefined" && objId != "")
    {
        selectrowFlag = -1;
		for ( var j = 0 ; j < st.getDataRowLength(); j++)
  		{
  			var flowid = st.getCellStoreValue(j, "flowid", "flowid");
  			if(objId == flowid)
  			{
  				st.setRowSelect(j);
  				break;
  			}
  		}
		tableSelectHandler(st.getSelectedRows());
		return true;
    }
    return false;
}
/*
Add table popupmenu handler
*/

function popupMenuHandl(evt)
{
	if(!evt)
  	{
  	  	evt= window.event;	
  	}
    var elem = (evt.target) ? evt.target : evt.srcElement;   
    
	if(null == elem.editElement || elem.isEdit == null || elem.isEdit == 0)
	{
		var supportFlag = SpecialAttrMgr.isCPSupport(parent.neid, parent.slotid, 'TE_FUNC_CFG_ETH_QOS', 'FLOWMGR_FLOWTYPES_SUPPORT_PERFORMANCE')
		if(SYSTEMCONF.getStatus() == 1 && supportFlag)//       
		{
			 createPfmBrowsePopupMenu(evt); 
		}
		return;
	}    

    if(elem!= null && elem.blur)
    {
    	elem.blur();	  	
    }
   
    while(elem!=null)
    {
	    if(elem.tagName == 'TD')
	    {
	        break;	
	    }
	    else
	    {
		    elem =elem.parentNode;	  	
	    }	
    } 
  
	if(elem == null || elem.tagName != 'TD' || null == elem.parent)
	{
		  return;
	}  
	if(elem.colid == "statEnable")
	{
		return;
	}
	var rowid= elem.parentNode.rowIndex;
    var rows =elem.parent.getSelectedRows();
    var colid = elem.colid;
    var colAtom = st.getCellEdit(rowid,colid);
    var idObj;
	if(colid == "boundCAR")
	{
		idObj = parent.allData["car"];
	}
	if(colid == "boundCoS")
	{
		idObj = parent.allData["cos"];
	}
	if(colid == "boundShaping")
	{
		idObj = parent.allData["shaping"];
	}
    colAtom.clearOptions();
	colAtom.element.options[0] = new Option(RESOURCE["none"],-1);
	for(var i in idObj)
	{
		if(idObj[i] != null)
		{
			colAtom.element.options[colAtom.element.options.length] = new Option(i,i);
		}
	}
	registerEvent();
 
    if(rows.contains(rowid))
    {
    	for(var i = 0; i < rows.length; i++)
    	{
    		var tmpElem = elem.parent.getCellElement(rows[i],colid);
    		if(null != tmpElem.editElement && tmpElem.isEdit == 1)
    		{
    			createTablePopupMenu(elem,evt);
    			return;
    		}
    	}
    }   
}

function createPfmBrowsePopupMenu(evt)
{
	createjsDOMenu();
	showMenu(evt);
}

/*
 *        
 */
function createjsDOMenu()
{
	removejsDOMmenu();
	var isSelected = false;

	for ( var i = 0, len = st.getDataRowLength(); i < len; i++)
	{
		if (st.getRowSelFlag(i))
		{
			isSelected = true;
			break;
		}
	}
	var cursorMenu = new jsDOMenu(170); //    140

	cursorMenu.addMenuItem(new menuItem(RESOURCE["pfmbrowse"], "",
			goPfmBrowse, 6 , isSelected));

	setPopUpMenu(cursorMenu);
}

/**
 *         U2000    
 * @param paramArr          ID         
 * @return  
 */
function goPfmBrowse(paramArr)
{
    removejsDOMmenu();
    var funcid = paramArr;
    var urlstr = "../../../../../linkInterFuncServlet?neid=" + parent.neid + "&prohandler=0&switchtype=9";
    var xmlData = createLinkFunctionTreeXml(parent.neid,obj["sessionid"],funcid);
    loadXMLdoc(urlstr, "POST", true, linkFunctionTreeCallback, null, "inputdata="+xmlData);
}

function createLinkFunctionTreeXml(neid,sessionid,funcid)
{
	var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var indexes = st.getSelectedRows();
    for (var i = 0, len = indexes.length; i < len; i++)
    {
    	var row = new tagElement("row-params");
	    var param = new tagElement("param","neid", neid);
	    row.appendChild(param);
	    param = new tagElement("param","sessionid", sessionid);
	    row.appendChild(param);
	    param = new tagElement("param","funcid", funcid); 
	    row.appendChild(param);
	    param = new tagElement("param","slotid", parent.slotid); 
	    row.appendChild(param);
	    param = new tagElement("param","portid", st.getCellStoreValue(indexes[i], "portid", "portid")); 
	    row.appendChild(param);
	    param = new tagElement("param","flowid", st.getCellStoreValue(indexes[i], "flowid", "flowid")); 
	    row.appendChild(param);
	    business.appendChild(row);
    }
    root.getRoot().appendChild(business);
    return root.toString();
}

function linkFunctionTreeCallback()
{
	
}

function registerEvent()
{
  	var evt= window.event;	  	  	 
    var elem = (evt.target) ? evt.target : evt.srcElement;
    var colid = elem.colid;
	  var atom;
  for(var i = 0, len = st.getDataRowLength(); i < len; i++)
  { 	 
	if(colid == "boundCAR" || colid == "boundCoS" || colid == "boundShaping")
	{
	 	atom = st.getCellEdit(i, colid);
		atom.element.onchange = function()
		{
			$("applybtn").disabled = !btnRightArr.applybtn.right; 				
		}
	}
  }
}
    



/**
	           
*/
function cellEditHandler(param)
{
	if(param.colid == "statEnable")
	{
			return;
	}
	if(param.stage == TABLE_CONSTANT.BEFOREEDIT)
	{
		var colAtom = st.getCellEdit(param.rowindex,param.colid);
		var idObj;
		if(param.colid == "boundCAR")
		{
			idObj = parent.allData["car"];
		}
		if(param.colid == "boundCoS")
		{
			idObj = parent.allData["cos"];
		}
		if(param.colid == "boundShaping")
		{
			idObj = parent.allData["shaping"];
		}
		
		colAtom.clearOptions();
		colAtom.element.options[0] = new Option(RESOURCE["none"],-1);
		for(var i in idObj)
		{
			if(idObj[i] != null)
			{
				colAtom.element.options[colAtom.element.options.length] = new Option(i,i);
			}
		}
		$("applybtn").disabled = !btnRightArr.applybtn.right;
	}
}


/*
              
*/
function tableSelectHandler(param)
{
	var size = boundInfoArr.length;
	for(var i = 0;i < size; i++)
	{
		boundInfoArr.pop();
	}
	if(param.length > 0)
	{
		$("deletebtn").disabled = !btnRightArr.deletebtn.right;
		var carCellValue = st.getCellStoreValue(param[0],"boundCAR","boundCAR");
		boundInfoArr.push(parent.getInfoByID("car",carCellValue));
		var cosCellValue = st.getCellStoreValue(param[0],"boundCoS","boundCoS");
		boundInfoArr.push(parent.getInfoByID("cos",cosCellValue));
		var shapingCellValue = st.getCellStoreValue(param[0],"boundShaping","boundShaping");
		boundInfoArr.push(parent.getInfoByID("shaping",shapingCellValue));
		updateBoundInfo();
		
		
		
	}
	else
	{
		document.getElementById("deletebtn").disabled = true;
		updateBoundInfo();
	}
	
	var flag = false;
	for(var i =0,iLength = param.length;i<iLength;i++)
	{
		 var statEnable = st.getCellStoreValue(param[0],"statEnable","statEnable");
		 if(statEnable!=1)
		 {
		 	  flag = true;
		 	  break;
		 }
	}
	if(flag)
	{
		$("clearbtn").disabled = true; 
	}
	else
	{
		 $("clearbtn").disabled = !btnRightArr.deletebtn.right;
	}
	
	updateRowStat(st.getDataRowLength(),param.length);//          
}

function addCellListener()
{
	for(var i = 0;i < st.getDataRowLength();i++)
	{
		addListenerByCol(i,"boundCAR","boundCAR");
		addListenerByCol(i,"boundCoS","boundCoS");
		addListenerByCol(i,"boundShaping","boundShaping");
	}
}

function addListenerByCol(row,colId)
{
	var tableCell = st.getCell(row,colId);
	var colAtom = st.getCellEdit(row,colId);
	
	EventUtil.addEventHandler(colAtom.element,"change",changeHandler);
	function changeHandler()
	{
		var size = boundInfoArr.length;
		for(var i = 0;i < size; i++)
		{
			boundInfoArr.pop();
		}
		var carCellValue = st.getCellStoreValue(row,"boundCAR","boundCAR");
	
		var cosCellValue = st.getCellStoreValue(row,"boundCoS","boundCoS");
		
		var shapingCellValue = st.getCellStoreValue(row,"boundShaping","boundShaping");
		
		if(colId == "boundCAR")
		{
			carCellValue = colAtom.element.selectedIndex;
		}
		if(colId == "boundCoS")
		{
			cosCellValue = colAtom.element.selectedIndex;
		}
		if(colId == "boundShaping")
		{
			shapingCellValue = colAtom.element.selectedIndex;
		}
		boundInfoArr.push(parent.getInfoByID("car",carCellValue));
		boundInfoArr.push(parent.getInfoByID("cos",cosCellValue));
		boundInfoArr.push(parent.getInfoByID("shaping",shapingCellValue));
		updateBoundInfo();
	}
}

function updateBoundInfo()
{
	while(boundinfo.hasChildNodes())
	{
		boundinfo.removeChild(boundinfo.childNodes[0]);
	}

	for(var i = 0,arrLength = boundInfoArr.length;i < arrLength;i++)
	{
		if(boundInfoArr[i])
		{
			var textDiv = document.createElement("div");
			textDiv.appendChild(document.createTextNode(boundInfoArr[i]));
			boundinfo.appendChild(textDiv);
		}
	}
}

function query()
{
	if(btnRightArr.querybtn.right == false)
	{
		return;
	}
  var URL = "../../../../../neExlorerServlet?sfid="+TE_ETHER_QUERY_FLOW+"&flag=1"+"&nmUser="+obj["nmUser"];    //  JAVABEAN       TENEExplorerServlet web.xml    flag --1     0    
  sendQueryInfo(URL);
}

function changeCellStyle(cellElm, flg)
{
    if(null == cellElm)
    {
    	  return;
    }
    if(flg)
    {
        cellElm.style.backgroundColor = "#ffffff";
				cellElm.ondblclick = cellondbclick;
    }
    else
    {
        cellElm.style.backgroundColor = "";
        cellElm.modify = false;
				cellElm.ondblclick = null;
    }
}

function addCellEvent()
{
	  for(var rowindex = 0, stlen = st.getDataRowLength(); rowindex < stlen; rowindex++)
    {
    	var statEnable = st.getCellEdit(rowindex, "statEnable").element;
    	statEnable.onchange = function ()
      {
        	 var rowindex = this.parentNode.parentNode.rowIndex;
        	 changeWithStatEnable(this.value,rowindex);
        	 $("applybtn").disabled = !btnRightArr.applybtn.right;
       }
    }
	
}

function changeWithStatEnable(ttype,rowindex)
{
	 if(ttype==0)
	 {
	 	 st.setCellValue(st.getCell(rowindex,"correctPacs"),"correctPacs","-");
	 	  		st.setAtomValue(st.getCellShow(rowindex, "correctPacs"), "-");
	 	  		changeCellStyle(st.getCell(rowindex, "correctPacs").element, false);
	 	  		
	 	  		st.setCellValue(st.getCell(rowindex,"mistakePacs"),"mistakePacs","-");
	 	  		st.setAtomValue(st.getCellShow(rowindex, "mistakePacs"), "-");
	 	  		changeCellStyle(st.getCell(rowindex, "mistakePacs").element, false);
	 	  		
	 	  		st.setCellValue(st.getCell(rowindex,"totalPacs"),"totalPacs","-");
	 	  		st.setAtomValue(st.getCellShow(rowindex, "totalPacs"), "-");
	 	  		changeCellStyle(st.getCell(rowindex, "totalPacs").element, false);
	 	  		
	 	  		st.setCellValue(st.getCell(rowindex,"totalBytes"),"totalBytes","-");
	 	  		st.setAtomValue(st.getCellShow(rowindex, "totalBytes"), "-");
	 	  		changeCellStyle(st.getCell(rowindex, "totalBytes").element, false);
	 }
	
}

function dealWithData(returnData)
{
	if(returnData.getSErrorCode() != "0")
	{
		showErrorDialog(returnData,"flowid",RESOURCE["queryflow"]);//dispose err dialog
	}
	for(var i = 0,size = returnData.getDataRowLength();i < size;i++)
	{
		if(returnData.getDataRowParam(i,"boundCAR") == "-1")
		{
			returnData.rows[i]["boundCAR"].value = RESOURCE["none"];
		}
		if(returnData.getDataRowParam(i,"boundCoS") == "-1")
		{
			returnData.rows[i]["boundCoS"].value = RESOURCE["none"];
		}
		if(returnData.getDataRowParam(i,"boundShaping") == "-1")
		{
			returnData.rows[i]["boundShaping"].value = RESOURCE["none"];
		}
	}
	
	
	createTableBody(st,window.tableconf[0],returnData,RESOURCE);//put data to table	
	
	for(var rowindex = 0, stlen = st.getDataRowLength(); rowindex < stlen; rowindex++)
   {
    	var statEnable = st.getCellCurrentValue(rowindex, "statEnable", "statEnable");
    	if(statEnable==0)
	    {
	 	  		st.setCellValue(st.getCell(rowindex,"correctPacs"),"correctPacs","-");
	 	  		st.setAtomValue(st.getCellShow(rowindex, "correctPacs"), "-");
	 	  		changeCellStyle(st.getCell(rowindex, "correctPacs").element, false);
	 	  		
	 	  		st.setCellValue(st.getCell(rowindex,"mistakePacs"),"mistakePacs","-");
	 	  		st.setAtomValue(st.getCellShow(rowindex, "mistakePacs"), "-");
	 	  		changeCellStyle(st.getCell(rowindex, "mistakePacs").element, false);
	 	  		
	 	  		st.setCellValue(st.getCell(rowindex,"totalPacs"),"totalPacs","-");
	 	  		st.setAtomValue(st.getCellShow(rowindex, "totalPacs"), "-");
	 	  		changeCellStyle(st.getCell(rowindex, "totalPacs").element, false);
	 	  		
	 	  		st.setCellValue(st.getCell(rowindex,"totalBytes"),"totalBytes","-");
	 	  		st.setAtomValue(st.getCellShow(rowindex, "totalBytes"), "-");
	 	  		changeCellStyle(st.getCell(rowindex, "totalBytes").element, false);

	   }
	   
	
   }
   addCellEvent();
   
	if(!st.element.colsArray.selectedId)
	{
		st.element.colsArray.selectedId = "flowtype";
		st.element.colsArray.imgflag = 1;
	}
	selectedURLServiceID();
	var td=st.element.headRow.element.cols[st.element.colsArray.selectedId].element; 
	st.sortRows(td,st.element.colsArray.imgflag);

	if(boundinfo)
	{
		var size = boundInfoArr.length;
		for(var i = 0;i < size; i++)
		{
			boundInfoArr.pop();
		}
		updateBoundInfo();
	}
}

/*
       
*/
function deleteFlow()
{
  document.getElementById("clearbtn").disabled = true;
  var URL = "../../../../../neExlorerServlet?sfid="+TE_ETHER_DEL_FLOW+"&flag=1"+"&nmUser="+obj["nmUser"];//  JAVABEAN       TENEExplorerServlet web.xml   
  sendDeleteInfo(URL,"flowid","flowid");
}

function convertDataToArray(data)
{
  return null;
}

/*
    :
         XML        
      :
    qosType:QoS       (car,cos  shaping)
    row:  
    idCol:   id
    idColKey: key
*/
function createSecondLevel(qosType,row,idCol,idColKey)
{
  var secondlevel = new tagElement("row-params");//         
  thirdlevel = new tagElement("param");//      neid     
  thirdlevel.setAttribute("name","neid");//         
  thirdlevel.setAttribute("value",parent.neid);//        
  secondlevel.appendChild(thirdlevel);//                
      
  thirdlevel = new tagElement("param");
  thirdlevel.setAttribute("name","slotid");
  thirdlevel.setAttribute("value",parent.slotid);
  secondlevel.appendChild(thirdlevel);
  
  thirdlevel = new tagElement("param");
  thirdlevel.setAttribute("name","flowid");
  var flowid = st.getCellStoreValue(row,"flowid","flowid");
  thirdlevel.setAttribute("value",flowid);
  secondlevel.appendChild(thirdlevel);
  
  if(qosType == 99)
  {
  	thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name","statEnable");
  	thirdlevel.setAttribute("value",st.getCellStoreValue(row, "statEnable", "statEnable"));//QoS    
  	secondlevel.appendChild(thirdlevel);
  	
  	return secondlevel;
  }
      
  thirdlevel = new tagElement("param");
  thirdlevel.setAttribute("name","qostype");
  thirdlevel.setAttribute("value",qosType);//QoS    
  secondlevel.appendChild(thirdlevel);
  
  thirdlevel = new tagElement("param");
  thirdlevel.setAttribute("name","paraid");
  var paraid = st.getCellStoreValue(row,idCol,idColKey);//QoS      id
  if(paraid == RESOURCE["non"])
  {
  	paraid = -1;
  }
  thirdlevel.setAttribute("value",paraid);
  secondlevel.appendChild(thirdlevel);
  
  return secondlevel;
}

/*
    :
          xml
      :
     
*/
function createModifyXML()
{
  var root = new inputxml("datainterface");//     xml    
  var firstlevel = new tagElement("bussiness-params");//         
	for(var i = 0,length = st.getDataRowLength();i < length;i++)
	{
		var carModify = st.getCellModify(i,"boundCAR");
		var cosModify = st.getCellModify(i,"boundCoS");
		var shapingModify = st.getCellModify(i,"boundShaping");
		var statEnableModify = st.getCellModify(i,"statEnable");
		var secondlevel;
		if(carModify)//   car     
		{
			secondlevel = createSecondLevel("1",i,"boundCAR","boundCAR");
			firstlevel.appendChild(secondlevel);//                
		}
		if(cosModify)//   cos     
		{
			secondlevel = createSecondLevel("2",i,"boundCoS","boundCoS");
			firstlevel.appendChild(secondlevel);//                
	  }
	  if(shapingModify)//   shaping     
		{
			secondlevel = createSecondLevel("3",i,"boundShaping","boundShaping");
			firstlevel.appendChild(secondlevel);//                
	  }
	  if(statEnableModify)
		{
			secondlevel = createSecondLevel("99",i,"statEnable","statEnable");
			firstlevel.appendChild(secondlevel);//                
	  }
  }
  root.getRoot().appendChild(firstlevel);//        xml     
  var xml = root.toString();
  return xml;
}

/*
         
*/
function modifyFlow()
{
	var xml = createModifyXML();//       
	document.getElementById("applybtn").disabled = true;
	document.getElementById("clearbtn").disabled = true;
	var URL = "../../../../../neExlorerServlet?sfid="+TE_ETHER_SET_FLOW+"&flag=1"+"&nmUser="+obj["nmUser"];//  JAVABEAN  
	loadXMLdoc(URL,"POST",true,modifyHandleBack,null,"inputdata="+xml)
}

/*
            
*/
function modifyHandleBack(doc)
{
  var data = EncapsulateData(doc);//         
  for(var i = data.getBErrLength()-1; i >= 0; i--)
	{	
		var errorObj = data.getError().rowErrors[i].errorObj;
		var qosType = errorObj["qostype"];
		var paraid = "";
		if(qosType == 1)
		{
			 paraid = "boundCAR";
		}
		else if(qosType == 2)
		{
			paraid = "boundCoS";
		}
		else
		{
			paraid = "boundShaping";
		}		
		
		data.getError().rowErrors[i].errorObj[paraid] = errorObj["paraid"];
	}
  refreshTableState(st,window.tableconf[0],data);
  
  if(data.getSErrorCode() != "0")
	{
		  showErrorDialog(data,"flowid",RESOURCE["flowid"]);//    
  		document.getElementById("applybtn").disabled = !btnRightArr.applybtn.right;
  }
  query();
}

function checkPort(newPort)
{
	for(var i = 0,dataLength = st.getDataRowLength();i < dataLength; i++)
	{
		var usedPort = st.getCellStoreValue(i,"portid","portid");
		if(newPort == usedPort)
		{
			return false;
		}
	}
	return true;
}

document.write("<title>"+RESOURCE["flowMgr"]+"</title>");
window.onresize=function()
{
	st.setBodyHeight(getComponetHeight($("flowtable"), 86)+"px");
}

 /**
 *            
 * @param data: 
 * @return  
 */
function tabSelectHandler()
{
	window.parent.Tab.getTabWindow(3).query();
	tableSelectHandler(st.getSelectedRows());
	
}
