var FLAG_CREATE = 1;
var FLAG_MODIFY =0;


function getPortName(portId)
{
	var portName;
	if(portId < 32768)
	{
		portName = "PORT" + portId;
	}
	else
	{
		portName = "VCTRUNK" + (portId-32768);
	}
	
	return portName;
}

function getPortNameList(portIdList)
{
	if(portIdList == null || portIdList == "")
	{		
		return "";
	}
	var Ports = portIdList.split(",");	
	var portName = "";
	for(var i=0,len=Ports.length;i<len;i++)
	{
		portName = portName + getPortName(Ports[i]) + ",";
	}	
	return portName.substring(0, portName.length - 1);
}

function convertCosRemarkData(cosPriStr, userPriStr)
{     
	var dinterface = new DataInterface();	
	if((cosPriStr == null || cosPriStr == "") ||
	  (userPriStr == null || userPriStr == ""))	
	{		
		return dinterface;
	}
	var cosPriList = cosPriStr.split(",");	
	var userPriList = userPriStr.split(",");	
    for(var i = 0; i < cosPriList.length; i++)
    {       
    	var obj = new Object();
    	
    	var ptagCosPri = new ParamTag();
    	ptagCosPri.value = cosPriList[i];    
    	obj["cosPriority"] =ptagCosPri;
    	
    	var ptagUserPri = new ParamTag();
    	ptagUserPri.value = userPriList[i];    
    	obj["userPriority"] = ptagUserPri;    	
    
       dinterface.rows[dinterface.rows.length] = obj;
    }
    return dinterface;
}

function createCosRemarkData()
{     
    var cosPriStr = "0,1,2,3,4,5,6,7";
	var userPriStr = "0,1,2,3,4,5,6,7";	
    return convertCosRemarkData(cosPriStr, userPriStr);
}


/**
 *                    
 *                       4      
 * @param list
 * @returns {String}
 */
function linkPortId(list)
{
	var selectedPort = "";
    for (var i = 0, m = list.length; i < m; i++)
    {
    	var hex = tenToHex(parseInt(list[i]));
    	for (var j = 0, n = 4 - hex.length; j < n; j++)
    	{
    		hex = "0" + hex;
    	}
    	selectedPort += hex;
    }
    return selectedPort;
}






